/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.array.ArrayCopyOnWriteNode;
import org.truffleruby.core.array.ArrayDropTailNodeGen;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

@NodeChild(value="arrayNode", type=RubyNode.class)
@ImportStatic(value={ArrayGuards.class})
public abstract class ArrayDropTailNode
extends RubyContextSourceNode {
    final int index;

    public ArrayDropTailNode(int index) {
        this.index = index;
    }

    public abstract RubyNode getArrayNode();

    @Specialization
    RubyArray dropTail(RubyArray array, @Cached ArrayCopyOnWriteNode cowNode, @Cached ConditionProfile indexLargerThanSize) {
        int size = array.size;
        if (indexLargerThanSize.profile(this.index >= size)) {
            return this.createEmptyArray();
        }
        int newSize = size - this.index;
        Object withoutTail = cowNode.execute(array, 0, newSize);
        return this.createArray(withoutTail, newSize);
    }

    @Override
    public RubyNode cloneUninitialized() {
        ArrayDropTailNode copy = ArrayDropTailNodeGen.create(this.index, this.getArrayNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

