/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;

@ImportStatic(value={ArrayGuards.class})
public abstract class ArrayAppendManyNode
extends RubyBaseNode {
    public abstract RubyArray executeAppendMany(RubyArray var1, RubyArray var2);

    @Specialization(guards={"isEmptyArray(other)"})
    RubyArray appendZero(RubyArray array, RubyArray other) {
        return array;
    }

    @Specialization(guards={"!isEmptyArray(other)", "stores.acceptsAllValues(array.getStore(), other.getStore())"}, limit="storageStrategyLimit()")
    RubyArray appendManySameType(RubyArray array, RubyArray other, @Bind(value="array.getStore()") Object store, @Bind(value="other.getStore()") Object otherStore, @CachedLibrary(value="store") ArrayStoreLibrary stores, @CachedLibrary(value="otherStore") ArrayStoreLibrary otherStores, @Cached ConditionProfile extendProfile) {
        int oldSize = array.size;
        int otherSize = other.size;
        int newSize = oldSize + otherSize;
        int length = stores.capacity(store);
        if (extendProfile.profile(newSize > length)) {
            int capacity = ArrayUtils.capacity(this.getLanguage(), length, newSize);
            Object newStore = stores.expand(store, capacity);
            otherStores.copyContents(otherStore, 0, newStore, oldSize, otherSize);
            ArrayHelpers.setStoreAndSize(array, newStore, newSize);
        } else {
            otherStores.copyContents(otherStore, 0, store, oldSize, otherSize);
            ArrayHelpers.setSize(array, newSize);
        }
        return array;
    }

    @Specialization(guards={"!isEmptyArray(other)", "!stores.acceptsAllValues(array.getStore(), other.getStore())"}, limit="storageStrategyLimit()")
    RubyArray appendManyGeneralize(RubyArray array, RubyArray other, @Bind(value="array.getStore()") Object store, @Bind(value="other.getStore()") Object otherStore, @CachedLibrary(value="store") ArrayStoreLibrary stores, @CachedLibrary(value="otherStore") ArrayStoreLibrary otherStores) {
        int oldSize = array.size;
        int otherSize = other.size;
        int newSize = oldSize + otherSize;
        Object newStore = stores.allocateForNewStore(store, otherStore, newSize);
        stores.copyContents(store, 0, newStore, 0, oldSize);
        otherStores.copyContents(otherStore, 0, newStore, oldSize, otherSize);
        ArrayHelpers.setStoreAndSize(array, newStore, newSize);
        return array;
    }
}

