/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.sun.management.ThreadMXBean;
import java.io.IOException;
import java.lang.invoke.VarHandle;
import java.lang.management.ManagementFactory;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.util.Set;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.CoreMethodNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.interop.FromJavaStringNode;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.shared.Platform;

@CoreModule(value="Truffle::System")
public abstract class TruffleSystemNodes {

    @CoreMethod(names={"allocated_bytes_of_current_thread"}, onSingleton=true)
    public static abstract class AllocatedBytesNode
    extends CoreMethodArrayArgumentsNode {
        private static ThreadMXBean bean;

        @CompilerDirectives.TruffleBoundary
        @Specialization
        @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"})
        static long allocatedBytes() {
            if (bean == null) {
                ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
                threadMXBean.setThreadAllocatedMemoryEnabled(true);
                VarHandle.storeStoreFence();
                bean = threadMXBean;
            }
            return bean.getCurrentThreadAllocatedBytes();
        }
    }

    @CoreMethod(names={"available_processors"}, onSingleton=true)
    public static abstract class AvailableProcessorsNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int availableProcessors() {
            return Runtime.getRuntime().availableProcessors();
        }
    }

    @CoreMethod(names={"host_os"}, onSingleton=true)
    public static abstract class HostOSNode
    extends CoreMethodNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization
        RubyString hostOS() {
            return this.createString(this.fromJavaStringNode, Platform.getOSName(), Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"host_cpu"}, onSingleton=true)
    public static abstract class HostCPUNode
    extends CoreMethodNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization
        RubyString hostCPU() {
            return this.createString(this.fromJavaStringNode, Platform.getArchName(), Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"get_java_property"}, onSingleton=true, required=1)
    public static abstract class GetJavaPropertyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"strings.isRubyString(property)"}, limit="1")
        static Object getJavaProperty(Object property, @Cached RubyStringLibrary strings, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached ToJavaStringNode toJavaStringNode, @Bind(value="this") Node node) {
            String value = GetJavaPropertyNode.getProperty(toJavaStringNode.execute(node, property));
            if (value == null) {
                return nil;
            }
            return GetJavaPropertyNode.createString(node, fromJavaStringNode, value, Encodings.UTF_8);
        }

        @CompilerDirectives.TruffleBoundary
        private static String getProperty(String key) {
            return System.getProperty(key);
        }
    }

    @CoreMethod(names={"get_java_properties"}, onSingleton=true)
    public static abstract class GetJavaPropertiesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object getJavaProperties(@Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String[] properties = GetJavaPropertiesNode.getProperties();
            Object[] array = new Object[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                array[i] = this.createString(fromJavaStringNode, properties[i], Encodings.UTF_8);
            }
            return this.createArray(array);
        }

        @CompilerDirectives.TruffleBoundary
        private static String[] getProperties() {
            return System.getProperties().stringPropertyNames().toArray(StringUtils.EMPTY_STRING_ARRAY);
        }
    }

    @Primitive(name="working_directory")
    public static abstract class GetTruffleWorkingDirNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString getTruffleWorkingDir(@Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String cwd = this.getContext().getFeatureLoader().getWorkingDirectory();
            RubyEncoding externalRubyEncoding = this.getContext().getEncodingManager().getDefaultExternalEncoding();
            return this.createString(fromJavaStringNode, cwd, externalRubyEncoding);
        }
    }

    @Primitive(name="dir_set_truffle_working_directory")
    public static abstract class SetTruffleWorkingDirNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"stringsDir.isRubyString(dir)"}, limit="1")
        Object setTruffleWorkingDir(Object dir, @Cached RubyStringLibrary stringsDir) {
            TruffleFile canonicalFile;
            TruffleFile truffleFile = this.getContext().getEnv().getPublicTruffleFile(RubyGuards.getJavaString(dir));
            try {
                canonicalFile = truffleFile.getCanonicalFile(new LinkOption[0]);
            }
            catch (NoSuchFileException e) {
                return nil;
            }
            catch (IOException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().ioError(e, (Node)this));
            }
            this.getContext().getEnv().setCurrentWorkingDirectory(canonicalFile);
            this.getContext().getFeatureLoader().setWorkingDirectory(canonicalFile.getPath());
            return dir;
        }
    }

    @Primitive(name="java_get_env")
    public static abstract class JavaGetEnv
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"strings.isRubyString(name)"}, limit="1")
        static Object javaGetEnv(Object name, @Cached RubyStringLibrary strings, @Cached ToJavaStringNode toJavaStringNode, @Cached FromJavaStringNode fromJavaStringNode, @Cached InlinedConditionProfile nullValueProfile, @Bind(value="this") Node node) {
            String javaName = toJavaStringNode.execute(node, name);
            String value = JavaGetEnv.getEnv(javaName);
            if (nullValueProfile.profile(node, value == null)) {
                return nil;
            }
            return fromJavaStringNode.executeFromJavaString(node, value);
        }

        @CompilerDirectives.TruffleBoundary
        private static String getEnv(String name) {
            return System.getenv(name);
        }
    }

    @CoreMethod(names={"initial_environment_variables"}, onSingleton=true)
    public static abstract class InitEnvVarsNode
    extends CoreMethodNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray envVars() {
            Set<String> variables = System.getenv().keySet();
            int size = variables.size();
            RubyEncoding localeRubyEncoding = this.getContext().getEncodingManager().getLocaleEncoding();
            Object[] store = new Object[size];
            int i = 0;
            for (String variable : variables) {
                store[i++] = this.createString(this.fromJavaStringNode, variable, localeRubyEncoding);
            }
            return this.createArray(store);
        }
    }
}

