/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.module.ModuleNodes;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.UsingNode;

@CoreModule(value="main", isClass=true)
public abstract class MainNodes {

    @CoreMethod(names={"using"}, required=1, alwaysInlined=true)
    @GenerateUncached
    public static abstract class MainUsingNode
    extends UsingNode {
        @Specialization
        Object mainUsing(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached InlinedBranchProfile errorProfile) {
            this.needCallerFrame(callerFrame, target);
            Object refinementModule = RubyArguments.getArgument(rubyArgs, 0);
            InternalMethod callerMethod = RubyArguments.getMethod(callerFrame);
            if (!this.isCalledFromTopLevel(callerMethod)) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("main.using is permitted only at toplevel", this));
            }
            this.using(callerFrame, refinementModule, errorProfile);
            return nil;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean isCalledFromTopLevel(InternalMethod callerMethod) {
            String name = callerMethod.getOriginalName();
            return name.equals("<main>") || name.startsWith("<top ");
        }
    }

    @CoreMethod(names={"private"}, rest=true, visibility=Visibility.PRIVATE, alwaysInlined=true)
    @GenerateUncached
    public static abstract class PrivateNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object forward(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached ModuleNodes.PrivateNode privateNode) {
            return privateNode.execute(callerFrame, this.coreLibrary().objectClass, RubyArguments.repack(rubyArgs, this.coreLibrary().objectClass), null);
        }
    }

    @CoreMethod(names={"public"}, rest=true, visibility=Visibility.PRIVATE, alwaysInlined=true)
    @GenerateUncached
    public static abstract class PublicNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object forward(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached ModuleNodes.PublicNode publicNode) {
            return publicNode.execute(callerFrame, this.coreLibrary().objectClass, RubyArguments.repack(rubyArgs, this.coreLibrary().objectClass), null);
        }
    }
}

