/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;

public final class Hashing {
    public static final Hashing NO_SEED = new Hashing(0L);
    @CompilerDirectives.CompilationFinal
    private long seed;

    public Hashing(long seed) {
        this.seed = seed;
    }

    public void patchSeed(long seed) {
        this.seed = seed;
    }

    public int hash(int value) {
        return value + (int)this.seed;
    }

    public long hash(long salt, long value) {
        return Hashing.end(Hashing.update(this.start(salt), value));
    }

    public long start(long salt) {
        return salt + this.seed;
    }

    public static long update(long hash, long value) {
        return Hashing.murmur(Hashing.murmur(hash += value) + (hash >>> 32));
    }

    public static long end(long hash) {
        return Hashing.murmurStep(Hashing.murmurStep(hash, 10L), 17L);
    }

    public static int stringHash(byte[] bytes, int startingHashCode, int offset, int length) {
        assert (offset + length <= bytes.length);
        int hashCode = startingHashCode;
        int endIndex = offset + length;
        for (int i = offset; i < endIndex; ++i) {
            hashCode = 31 * hashCode + bytes[i];
        }
        return hashCode;
    }

    private static long murmur(long h) {
        return Hashing.murmurStep(h, 16L);
    }

    private static long murmurStep(long h, long k) {
        h += k;
        h *= 1540483477L;
        h ^= h >> 16;
        return h;
    }
}

