/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.time.Duration;
import java.util.Arrays;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.collections.WeakValueCache;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.language.control.RaiseException;

@CoreModule(value="GC")
public abstract class GCNodes {

    @Primitive(name="gc_heap_stats")
    public static abstract class GCHeapStatsNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray heapStats(@Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String[] memoryPoolNames = new String[]{};
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                if (bean.getMemoryPoolNames().length <= memoryPoolNames.length) continue;
                memoryPoolNames = bean.getMemoryPoolNames();
            }
            Object[] memoryPools = new Object[memoryPoolNames.length];
            Arrays.fill(memoryPools, nil);
            for (int i = 0; i < memoryPoolNames.length; ++i) {
                String memoryPoolName = memoryPoolNames[i];
                for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                    if (!bean.getName().equals(memoryPoolName)) continue;
                    memoryPools[i] = this.beanToArray(bean);
                }
            }
            Object[] memoryPoolNamesCast = new Object[memoryPoolNames.length];
            for (int i = 0; i < memoryPoolNames.length; ++i) {
                memoryPoolNamesCast[i] = this.createString(fromJavaStringNode, memoryPoolNames[i], Encodings.UTF_8);
            }
            return this.createArray(new Object[]{this.createArray(memoryPoolNamesCast), this.createArray(memoryPools)});
        }

        private RubyArray beanToArray(MemoryPoolMXBean bean) {
            MemoryUsage usage = bean.getUsage();
            MemoryUsage peak = bean.getPeakUsage();
            MemoryUsage last = bean.getCollectionUsage();
            return this.createArray(new long[]{usage.getUsed(), usage.getCommitted(), usage.getInit(), usage.getMax(), peak.getUsed(), peak.getCommitted(), peak.getInit(), peak.getMax(), last.getUsed(), last.getCommitted(), last.getInit(), last.getMax()});
        }
    }

    @Primitive(name="gc_stat")
    public static abstract class GCStatPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyArray stat() {
            long[] data = this.getGCData();
            return this.createArray(data);
        }

        @CompilerDirectives.TruffleBoundary
        private long[] getGCData() {
            long time = 0L;
            long count = 0L;
            long minorCount = 0L;
            long majorCount = 0L;
            long unknownCount = 0L;
            block12: for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                time += bean.getCollectionTime();
                count += bean.getCollectionCount();
                switch (bean.getName()) {
                    case "G1 Young Generation": 
                    case "PS Scavenge": 
                    case "young generation scavenger": {
                        minorCount += bean.getCollectionCount();
                        continue block12;
                    }
                    case "G1 Old Generation": 
                    case "PS MarkSweep": 
                    case "complete scavenger": {
                        majorCount += bean.getCollectionCount();
                        continue block12;
                    }
                }
                unknownCount += bean.getCollectionCount();
            }
            MemoryUsage total = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            return new long[]{time, count, minorCount, majorCount, unknownCount, total.getUsed(), total.getCommitted(), total.getInit(), total.getMax()};
        }
    }

    @Primitive(name="gc_time")
    public static abstract class TimeNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        long time() {
            long time = 0L;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                time += bean.getCollectionTime();
            }
            return time;
        }
    }

    @CoreMethod(names={"count"}, onSingleton=true)
    public static abstract class CountNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        long count() {
            long count = 0L;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                count += bean.getCollectionCount();
            }
            return count;
        }
    }

    @Primitive(name="gc_force")
    public static abstract class GCForce
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object force() {
            WeakValueCache<Object, Object> cache = new WeakValueCache<Object, Object>();
            Object key = new Object();
            this.initCache(cache, key);
            this.gcLoop(cache, key);
            return nil;
        }

        @SuppressFBWarnings(value={"DLS"})
        private void initCache(WeakValueCache<Object, Object> cache, Object key) {
            Object value = new Object();
            cache.put(key, value);
            value = null;
        }

        private void gcLoop(WeakValueCache<Object, Object> cache, Object key) {
            long duration = Duration.ofSeconds(60L).toNanos();
            long start = System.nanoTime();
            do {
                if (System.nanoTime() - start > duration) {
                    throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().runtimeError("gc_force exceeded its 60 seconds timeout", this));
                }
                System.gc();
                TruffleSafepoint.poll((Node)this);
            } while (cache.get(key) != null);
        }
    }

    @Primitive(name="gc_start")
    public static abstract class GCStartPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object vmGCStart() {
            System.gc();
            return nil;
        }
    }
}

