/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import org.truffleruby.core.FinalizationService;
import org.truffleruby.core.ReferenceProcessingService;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ObjectGraphNode;

public class FinalizerReference
extends ReferenceProcessingService.PhantomProcessingReference<FinalizerReference, Object>
implements ObjectGraphNode {
    private final Deque<FinalizationService.Finalizer> finalizers = new LinkedList<FinalizationService.Finalizer>();

    FinalizerReference(Object object, ReferenceQueue<? super Object> queue, FinalizationService service) {
        super(object, queue, service);
    }

    void addFinalizer(Class<?> owner, Runnable action, RubyDynamicObject root) {
        this.finalizers.addLast(new FinalizationService.Finalizer(owner, action, root));
    }

    FinalizerReference removeFinalizers(FinalizationService finalizationService, Class<?> owner) {
        this.finalizers.removeIf(f -> f.getOwner() == owner);
        if (this.finalizers.isEmpty()) {
            finalizationService.remove(this);
            return null;
        }
        return this;
    }

    FinalizationService.Finalizer getFirstFinalizer() {
        return this.finalizers.pollFirst();
    }

    public void collectRoots(Collection<Object> roots) {
        for (FinalizationService.Finalizer finalizer : this.finalizers) {
            RubyDynamicObject root = finalizer.getRoot();
            if (root == null) continue;
            roots.add((Object)root);
        }
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        this.collectRoots(reachable);
    }
}

