/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.collections;

import com.oracle.truffle.api.CompilerDirectives;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.truffleruby.collections.SimpleEntry;
import org.truffleruby.core.hash.ReHashable;

public class WeakValueCache<Key, Value>
implements ReHashable {
    private ConcurrentHashMap<Key, KeyedReference<Key, Value>> map;
    private final ReferenceQueue<Value> deadRefs = new ReferenceQueue();

    @CompilerDirectives.TruffleBoundary
    public WeakValueCache() {
        this.map = new ConcurrentHashMap();
    }

    @CompilerDirectives.TruffleBoundary
    public Value get(Key key) {
        this.removeStaleEntries();
        KeyedReference<Key, Value> reference = this.map.get(key);
        return reference == null ? null : (Value)reference.get();
    }

    @CompilerDirectives.TruffleBoundary
    public Value addInCacheIfAbsent(Key key, Value newValue) {
        KeyedReference<Key, Value> oldRef;
        this.removeStaleEntries();
        KeyedReference<Key, Value> newRef = new KeyedReference<Key, Value>(newValue, key, this.deadRefs);
        do {
            if ((oldRef = this.map.putIfAbsent(key, newRef)) == null) {
                return newValue;
            }
            Object oldValue = oldRef.get();
            if (oldValue == null) continue;
            return (Value)oldValue;
        } while (!this.map.replace(key, oldRef, newRef));
        return newValue;
    }

    @CompilerDirectives.TruffleBoundary
    public Value put(Key key, Value value) {
        this.removeStaleEntries();
        KeyedReference<Key, Value> ref = new KeyedReference<Key, Value>(value, key, this.deadRefs);
        KeyedReference<Key, Value> oldRef = this.map.put(key, ref);
        Value oldValue = oldRef != null ? (Value)oldRef.get() : null;
        return oldValue;
    }

    @CompilerDirectives.TruffleBoundary
    public int size() {
        int size = 0;
        this.removeStaleEntries();
        for (KeyedReference<Key, Value> ref : this.map.values()) {
            Object value = ref.get();
            if (value == null) continue;
            ++size;
        }
        return size;
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<Key> keys() {
        this.removeStaleEntries();
        ArrayList<Key> keys = new ArrayList<Key>(this.map.size());
        for (Map.Entry<Key, KeyedReference<Key, Value>> e : this.map.entrySet()) {
            Object value = e.getValue().get();
            if (value == null) continue;
            keys.add(e.getKey());
        }
        return keys;
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<Value> values() {
        this.removeStaleEntries();
        ArrayList values = new ArrayList(this.map.size());
        for (WeakReference weakReference : this.map.values()) {
            Object value = weakReference.get();
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<SimpleEntry<Key, Value>> entries() {
        this.removeStaleEntries();
        ArrayList<SimpleEntry<Key, Value>> entries = new ArrayList<SimpleEntry<Key, Value>>(this.map.size());
        for (Map.Entry<Key, KeyedReference<Key, Value>> e : this.map.entrySet()) {
            Object value = e.getValue().get();
            if (value == null) continue;
            entries.add(new SimpleEntry(e.getKey(), value));
        }
        return entries;
    }

    @Override
    public void rehash() {
        ConcurrentHashMap<Key, KeyedReference<Key, Value>> oldMap = this.map;
        this.map = new ConcurrentHashMap(oldMap.size());
        for (Map.Entry entry : oldMap.entrySet()) {
            this.map.put(entry.getKey(), (KeyedReference)entry.getValue());
        }
    }

    private void removeStaleEntries() {
        KeyedReference ref;
        while ((ref = (KeyedReference)this.deadRefs.poll()) != null) {
            this.map.remove(ref.key, ref);
        }
    }

    protected static final class KeyedReference<Key, Value>
    extends WeakReference<Value> {
        private final Key key;

        public KeyedReference(Value object, Key key, ReferenceQueue<? super Value> queue) {
            super(object, queue);
            this.key = key;
        }
    }
}

