/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.collections;

import org.truffleruby.core.array.ArrayUtils;

public final class SimpleStack<T> {
    Object[] storage;
    int index = -1;

    public SimpleStack() {
        this(16);
    }

    public SimpleStack(int length) {
        this.storage = new Object[length];
    }

    public boolean isEmpty() {
        return this.index == -1;
    }

    public void push(T value) {
        if (++this.index == this.storage.length) {
            this.storage = ArrayUtils.grow(this.storage, this.storage.length * 2);
        }
        this.storage[this.index] = value;
    }

    public T peek() {
        return (T)this.storage[this.index];
    }

    public T pop() {
        Object out = this.storage[this.index];
        this.storage[this.index] = null;
        --this.index;
        return (T)out;
    }

    public int size() {
        return this.index + 1;
    }
}

