/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.collections;

import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.TStringWithEncoding;

public class ByteArrayBuilder {
    private static final byte[] EMPTY_BYTES = ArrayUtils.EMPTY_BYTES;
    private byte[] bytes = EMPTY_BYTES;
    private int length;

    public ByteArrayBuilder() {
    }

    public ByteArrayBuilder(int size) {
        this.bytes = new byte[size];
    }

    public static ByteArrayBuilder create(InternalByteArray bytes) {
        ByteArrayBuilder builder = new ByteArrayBuilder(bytes.getLength());
        builder.append(bytes.getArray(), bytes.getOffset(), bytes.getLength());
        return builder;
    }

    public static ByteArrayBuilder createUnsafeBuilder(byte[] wrap) {
        ByteArrayBuilder builder = new ByteArrayBuilder();
        builder.unsafeReplace(wrap, wrap.length);
        return builder;
    }

    public int getLength() {
        return this.length;
    }

    public void append(int b) {
        this.append((byte)b);
    }

    public void append(byte b) {
        this.ensureSpace(1);
        this.bytes[this.length] = b;
        ++this.length;
    }

    public void append(byte b, int count) {
        if (count > 0) {
            this.ensureSpace(count);
            Arrays.fill(this.bytes, this.length, this.length + count, b);
            this.length += count;
        }
    }

    public void append(int b, int count) {
        this.append((byte)b, count);
    }

    public void append(byte[] appendBytes) {
        this.append(appendBytes, 0, appendBytes.length);
    }

    public void append(byte[] appendBytes, int appendStart, int appendLength) {
        this.ensureSpace(appendLength);
        System.arraycopy(appendBytes, appendStart, this.bytes, this.length, appendLength);
        this.length += appendLength;
    }

    public void append(InternalByteArray bytes) {
        this.append(bytes.getArray(), bytes.getOffset(), bytes.getLength());
    }

    public void append(InternalByteArray bytes, int appendStart, int appendLength) {
        this.append(bytes.getArray(), bytes.getOffset() + appendStart, appendLength);
    }

    public void append(TStringWithEncoding other) {
        this.append(other.getInternalByteArray());
    }

    public void append(TStringWithEncoding other, int appendStart, int appendLength) {
        this.append(other.getInternalByteArray(), appendStart, appendLength);
    }

    public void append(TruffleString other, RubyEncoding enc) {
        this.append(other.getInternalByteArrayUncached(enc.tencoding));
    }

    public void unsafeReplace(byte[] bytes, int size) {
        this.bytes = bytes;
        this.length = size;
    }

    private void ensureSpace(int space) {
        if (this.length + space > this.bytes.length) {
            this.bytes = Arrays.copyOf(this.bytes, (this.bytes.length + space) * 2);
        }
    }

    public byte get(int n) {
        return this.bytes[n];
    }

    public void set(int n, int b) {
        this.bytes[n] = (byte)b;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.length);
    }

    public void clear() {
        this.bytes = EMPTY_BYTES;
        this.length = 0;
    }

    public String toString() {
        return new String(this.bytes, 0, this.length, StandardCharsets.ISO_8859_1);
    }

    public TruffleString toTString(RubyEncoding encoding) {
        return TStringUtils.fromByteArray(this.getBytes(), encoding);
    }

    public TStringWithEncoding toTStringWithEnc(RubyEncoding encoding) {
        return new TStringWithEncoding(TStringUtils.fromByteArray(this.getBytes(), encoding), encoding);
    }

    public byte[] getUnsafeBytes() {
        return this.bytes;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void unsafeEnsureSpace(int space) {
        this.ensureSpace(space);
    }
}

