/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.builtins;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.NodeFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.BuiltinsClasses;
import org.truffleruby.builtins.CoreMethodNodeManager;
import org.truffleruby.builtins.PrimitiveNodeConstructor;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.options.LanguageOptions;

public final class PrimitiveManager {
    private final Map<String, String> lazyPrimitiveClasses = new ConcurrentHashMap<String, String>();
    private final Map<String, PrimitiveNodeConstructor> primitives = new ConcurrentHashMap<String, PrimitiveNodeConstructor>();

    public PrimitiveNodeConstructor getPrimitive(String name) {
        String lazyPrimitive;
        PrimitiveNodeConstructor constructor = this.primitives.get(name);
        if (constructor != null) {
            return constructor;
        }
        if (!TruffleOptions.AOT && (lazyPrimitive = this.lazyPrimitiveClasses.get(name)) != null) {
            return this.loadLazyPrimitive(lazyPrimitive);
        }
        throw new Error("Primitive :" + name + " not found");
    }

    public void addLazyPrimitive(String primitive, String nodeFactoryClass) {
        this.lazyPrimitiveClasses.put(primitive, nodeFactoryClass);
    }

    private PrimitiveNodeConstructor loadLazyPrimitive(String lazyPrimitive) {
        NodeFactory<? extends RubyBaseNode> nodeFactory = CoreMethodNodeManager.loadNodeFactory(lazyPrimitive);
        Primitive annotation = nodeFactory.getNodeClass().getAnnotation(Primitive.class);
        return this.addPrimitive(nodeFactory, annotation);
    }

    private PrimitiveNodeConstructor addPrimitive(NodeFactory<? extends RubyBaseNode> nodeFactory, Primitive annotation) {
        return ConcurrentOperations.getOrCompute(this.primitives, annotation.name(), k -> new PrimitiveNodeConstructor(annotation, nodeFactory));
    }

    public void loadCoreMethodNodes(LanguageOptions languageOptions) {
        if (!TruffleOptions.AOT && languageOptions.LAZY_BUILTINS) {
            BuiltinsClasses.setupBuiltinsLazyPrimitives(this);
        } else {
            for (List<? extends NodeFactory<? extends RubyBaseNode>> factory : BuiltinsClasses.getCoreNodeFactories()) {
                this.registerPrimitives(factory);
            }
        }
    }

    private void registerPrimitives(List<? extends NodeFactory<? extends RubyBaseNode>> nodeFactories) {
        for (NodeFactory<? extends RubyBaseNode> nodeFactory : nodeFactories) {
            Class nodeClass = nodeFactory.getNodeClass();
            Primitive primitiveAnnotation = nodeClass.getAnnotation(Primitive.class);
            if (primitiveAnnotation == null) continue;
            this.addPrimitive(nodeFactory, primitiveAnnotation);
        }
    }

    public Set<String> getPrimitiveNames() {
        HashSet<String> allPrimitives = new HashSet<String>(this.primitives.keySet());
        allPrimitives.addAll(this.lazyPrimitiveClasses.keySet());
        return allPrimitives;
    }
}

