/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.dispatch.DispatchNode;

public final class EnumeratorSizeNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode method;
    @Node.Child
    private DispatchNode toEnumWithSize;
    private final ConditionProfile noBlockProfile = ConditionProfile.create();
    private final RubySymbol methodName;
    private final RubySymbol sizeMethodName;

    public EnumeratorSizeNode(RubySymbol sizeMethodName, RubySymbol methodName, RubyNode method) {
        this.method = method;
        this.methodName = methodName;
        this.sizeMethodName = sizeMethodName;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object block = RubyArguments.getBlock((Frame)frame);
        if (this.noBlockProfile.profile(block == nil)) {
            if (this.toEnumWithSize == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toEnumWithSize = (DispatchNode)this.insert(DispatchNode.create());
            }
            Object self = RubyArguments.getSelf((Frame)frame);
            return this.toEnumWithSize.call(this.coreLibrary().truffleKernelOperationsModule, "to_enum_with_size", self, (Object)this.methodName, (Object)this.sizeMethodName);
        }
        return this.method.execute(frame);
    }

    @Override
    public RubyNode cloneUninitialized() {
        EnumeratorSizeNode copy = new EnumeratorSizeNode(this.sizeMethodName, this.methodName, this.method.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

