/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;
import org.prism.Parser;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyFileTypeDetector;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.builtins.PrimitiveManager;
import org.truffleruby.cext.ValueWrapperManager;
import org.truffleruby.collections.SharedIndicesMap;
import org.truffleruby.core.RubyHandle;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.basicobject.RubyBasicObject;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.RubyEncodingConverter;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.exception.RubyFrozenError;
import org.truffleruby.core.exception.RubyNameError;
import org.truffleruby.core.exception.RubyNoMethodError;
import org.truffleruby.core.exception.RubySyntaxError;
import org.truffleruby.core.exception.RubySystemCallError;
import org.truffleruby.core.exception.RubySystemExit;
import org.truffleruby.core.fiber.RubyFiber;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.inlined.CoreMethodAssumptions;
import org.truffleruby.core.kernel.TraceManager;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.method.RubyMethod;
import org.truffleruby.core.method.RubyUnboundMethod;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.mutex.RubyConditionVariable;
import org.truffleruby.core.mutex.RubyMutex;
import org.truffleruby.core.objectspace.RubyWeakMap;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.queue.RubyQueue;
import org.truffleruby.core.queue.RubySizedQueue;
import org.truffleruby.core.range.RubyObjectRange;
import org.truffleruby.core.regexp.RegexpCacheKey;
import org.truffleruby.core.regexp.RegexpTable;
import org.truffleruby.core.regexp.RubyMatchData;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.string.CoreStrings;
import org.truffleruby.core.string.FrozenStringLiterals;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.PathToTStringCache;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringCache;
import org.truffleruby.core.support.RubyByteArray;
import org.truffleruby.core.support.RubyCustomRandomizer;
import org.truffleruby.core.support.RubyIO;
import org.truffleruby.core.support.RubyPRNGRandomizer;
import org.truffleruby.core.support.RubySecureRandomizer;
import org.truffleruby.core.symbol.CoreSymbols;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.symbol.SymbolTable;
import org.truffleruby.core.thread.RubyBacktraceLocation;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.core.time.RubyTime;
import org.truffleruby.core.tracepoint.RubyTracePoint;
import org.truffleruby.extra.RubyAtomicReference;
import org.truffleruby.extra.RubyConcurrentMap;
import org.truffleruby.extra.ffi.RubyPointer;
import org.truffleruby.interop.RubyInnerContext;
import org.truffleruby.interop.RubySourceLocation;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyBaseRootNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyEvalInteractiveRootNode;
import org.truffleruby.language.RubyInlineParsingRequestNode;
import org.truffleruby.language.RubyParsingRequestNode;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptorManager;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.objects.RubyObjectType;
import org.truffleruby.language.objects.classvariables.ClassVariableStorage;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;
import org.truffleruby.options.LanguageOptions;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.ParsingParameters;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.shared.Metrics;
import org.truffleruby.shared.Platform;
import org.truffleruby.shared.options.OptionsCatalog;
import org.truffleruby.signal.LibRubySignal;
import org.truffleruby.stdlib.CoverageManager;
import org.truffleruby.stdlib.digest.RubyDigest;

@TruffleLanguage.Registration(name="Ruby", website="https://www.graalvm.org/ruby/", contextPolicy=TruffleLanguage.ContextPolicy.SHARED, id="ruby", implementationName="TruffleRuby", version="3.2.4", characterMimeTypes={"application/x-ruby", "application/x-ruby;coverage=true", "application/x-ruby;main-script=true"}, defaultMimeType="application/x-ruby", dependentLanguages={"nfi", "llvm", "regex"}, fileTypeDetectors={RubyFileTypeDetector.class})
@ProvidedTags(value={CoverageManager.LineTag.class, TraceManager.CallTag.class, TraceManager.ClassTag.class, TraceManager.LineTag.class, TraceManager.NeverTag.class, StandardTags.RootTag.class, StandardTags.StatementTag.class, StandardTags.ReadVariableTag.class, StandardTags.WriteVariableTag.class})
public final class RubyLanguage
extends TruffleLanguage<RubyContext> {
    static final String MIME_TYPE = "application/x-ruby";
    public static final String MIME_TYPE_COVERAGE = "application/x-ruby;coverage=true";
    public static final String MIME_TYPE_MAIN_SCRIPT = "application/x-ruby;main-script=true";
    public static final String[] MIME_TYPES = new String[]{"application/x-ruby", "application/x-ruby;coverage=true", "application/x-ruby;main-script=true"};
    public static final String LLVM_BITCODE_MIME_TYPE = "application/x-llvm-ir-bitcode";
    public static final String CEXT_EXTENSION = Platform.CEXT_SUFFIX;
    public static final String RESOURCE_SCHEME = "resource:";
    public static final TruffleLogger LOGGER = TruffleLogger.getLogger((String)"ruby");
    public static final FrameDescriptor EMPTY_FRAME_DESCRIPTOR = new FrameDescriptor((Object)RubyBaseNode.nil);
    public final Map<Thread, RubyThread> rubyThreadInitMap = new ConcurrentHashMap<Thread, RubyThread>();
    private final ContextThreadLocal<RubyThread> rubyThread = this.locals.createContextThreadLocal((context, thread) -> {
        if (thread == context.getThreadManager().getOrInitializeRootJavaThread()) {
            return context.getThreadManager().getRootThread();
        }
        if (context.getThreadManager().isRubyManagedThread(thread)) {
            return Objects.requireNonNull(this.rubyThreadInitMap.remove(thread));
        }
        return this.getOrCreateForeignThread((RubyContext)context, thread);
    });
    public final Map<Thread, RubyFiber> rubyFiberInitMap = new ConcurrentHashMap<Thread, RubyFiber>();
    private final ContextThreadLocal<RubyFiber> rubyFiber = this.locals.createContextThreadLocal((context, thread) -> {
        if (thread == context.getThreadManager().getOrInitializeRootJavaThread()) {
            return context.getThreadManager().getRootThread().getRootFiber();
        }
        if (context.getThreadManager().isRubyManagedThread(thread)) {
            return Objects.requireNonNull(this.rubyFiberInitMap.remove(thread));
        }
        return this.getOrCreateForeignThread((RubyContext)context, thread).getRootFiber();
    });
    private final CyclicAssumption tracingCyclicAssumption = new CyclicAssumption("object-space-tracing");
    @CompilerDirectives.CompilationFinal
    private volatile Assumption tracingAssumption = this.tracingCyclicAssumption.getAssumption();
    @CompilerDirectives.CompilationFinal
    public boolean singleContext = true;
    @CompilerDirectives.CompilationFinal
    public Optional<RubyContext> contextIfSingleContext;
    private int numberOfContexts = 0;
    public final CyclicAssumption traceFuncUnusedAssumption = new CyclicAssumption("set_trace_func is not used");
    @CompilerDirectives.CompilationFinal
    public String coreLoadPath;
    @CompilerDirectives.CompilationFinal
    public String corePath;
    public final CoreMethodAssumptions coreMethodAssumptions;
    public final CoreStrings coreStrings;
    public final CoreSymbols coreSymbols;
    public final PrimitiveManager primitiveManager;
    public final TStringCache tstringCache;
    public final RegexpTable regexpTable;
    public final SymbolTable symbolTable;
    public final KeywordArgumentsDescriptorManager keywordArgumentsDescriptorManager = new KeywordArgumentsDescriptorManager();
    public final FrozenStringLiterals frozenStringLiterals;
    public Thread cleanerThread = null;
    @CompilerDirectives.CompilationFinal
    public Cleaner cleaner = null;
    @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"})
    public volatile ValueWrapperManager.HandleBlockWeakReference[] handleBlockSharedMap = new ValueWrapperManager.HandleBlockWeakReference[0];
    public final ValueWrapperManager.HandleBlockAllocator handleBlockAllocator = new ValueWrapperManager.HandleBlockAllocator();
    @CompilerDirectives.CompilationFinal
    public LanguageOptions options;
    @CompilerDirectives.CompilationFinal
    private String rubyHome;
    @CompilerDirectives.CompilationFinal
    public String cextPath;
    private TruffleFile rubyHomeTruffleFile;
    @CompilerDirectives.CompilationFinal
    private AllocationReporter allocationReporter;
    @CompilerDirectives.CompilationFinal
    public CoverageManager coverageManager;
    private final AtomicLong nextObjectID = new AtomicLong(16L);
    private final PathToTStringCache pathToTStringCache = new PathToTStringCache(this);
    public final SharedIndicesMap globalVariablesMap = new SharedIndicesMap();
    private final SharedIndicesMap.LanguageArray<Assumption> globalVariableNeverAliasedAssumptions = new SharedIndicesMap.LanguageArray<Assumption>(this.globalVariablesMap, Assumption[]::new, () -> Assumption.create((String)"global variable was never aliased: "));
    private static final RubyObjectType objectType = new RubyObjectType();
    public final Shape basicObjectShape = RubyLanguage.createShape(RubyBasicObject.class);
    public final Shape moduleShape = RubyLanguage.createShape(RubyModule.class);
    public final Shape classShape = RubyLanguage.createShape(RubyClass.class);
    public final Shape arrayShape = RubyLanguage.createShape(RubyArray.class);
    public final Shape atomicReferenceShape = RubyLanguage.createShape(RubyAtomicReference.class);
    public final Shape bindingShape = RubyLanguage.createShape(RubyBinding.class);
    public final Shape byteArrayShape = RubyLanguage.createShape(RubyByteArray.class);
    public final Shape concurrentMapShape = RubyLanguage.createShape(RubyConcurrentMap.class);
    public final Shape conditionVariableShape = RubyLanguage.createShape(RubyConditionVariable.class);
    public final Shape customRandomizerShape = RubyLanguage.createShape(RubyCustomRandomizer.class);
    public final Shape digestShape = RubyLanguage.createShape(RubyDigest.class);
    public final Shape encodingConverterShape = RubyLanguage.createShape(RubyEncodingConverter.class);
    public final Shape exceptionShape = RubyLanguage.createShape(RubyException.class);
    public final Shape fiberShape = RubyLanguage.createShape(RubyFiber.class);
    public final Shape frozenErrorShape = RubyLanguage.createShape(RubyFrozenError.class);
    public final Shape handleShape = RubyLanguage.createShape(RubyHandle.class);
    public final Shape hashShape = RubyLanguage.createShape(RubyHash.class);
    public final Shape innerContextShape = RubyLanguage.createShape(RubyInnerContext.class);
    public final Shape ioShape = RubyLanguage.createShape(RubyIO.class);
    public final Shape matchDataShape = RubyLanguage.createShape(RubyMatchData.class);
    public final Shape methodShape = RubyLanguage.createShape(RubyMethod.class);
    public final Shape mutexShape = RubyLanguage.createShape(RubyMutex.class);
    public final Shape nameErrorShape = RubyLanguage.createShape(RubyNameError.class);
    public final Shape noMethodErrorShape = RubyLanguage.createShape(RubyNoMethodError.class);
    public final Shape objectRangeShape = RubyLanguage.createShape(RubyObjectRange.class);
    public final Shape procShape = RubyLanguage.createShape(RubyProc.class);
    public final Shape queueShape = RubyLanguage.createShape(RubyQueue.class);
    public final Shape prngRandomizerShape = RubyLanguage.createShape(RubyPRNGRandomizer.class);
    public final Shape secureRandomizerShape = RubyLanguage.createShape(RubySecureRandomizer.class);
    public final Shape sizedQueueShape = RubyLanguage.createShape(RubySizedQueue.class);
    public final Shape sourceLocationShape = RubyLanguage.createShape(RubySourceLocation.class);
    public final Shape stringShape = RubyLanguage.createShape(RubyString.class);
    public final Shape syntaxErrorShape = RubyLanguage.createShape(RubySyntaxError.class);
    public final Shape systemCallErrorShape = RubyLanguage.createShape(RubySystemCallError.class);
    public final Shape systemExitShape = RubyLanguage.createShape(RubySystemExit.class);
    public final Shape threadBacktraceLocationShape = RubyLanguage.createShape(RubyBacktraceLocation.class);
    public final Shape threadShape = RubyLanguage.createShape(RubyThread.class);
    public final Shape timeShape = RubyLanguage.createShape(RubyTime.class);
    public final Shape tracePointShape = RubyLanguage.createShape(RubyTracePoint.class);
    public final Shape truffleFFIPointerShape = RubyLanguage.createShape(RubyPointer.class);
    public final Shape unboundMethodShape = RubyLanguage.createShape(RubyUnboundMethod.class);
    public final Shape weakMapShape = RubyLanguage.createShape(RubyWeakMap.class);
    public final Shape classVariableShape = Shape.newBuilder().allowImplicitCastIntToLong(true).layout(ClassVariableStorage.class).build();
    public final ThreadLocal<ParsingParameters> parsingRequestParams = new ThreadLocal();
    public final FrameDescriptor emptyDeclarationDescriptor = TranslatorEnvironment.newFrameDescriptorBuilderForMethod().build();
    private static final TruffleLanguage.LanguageReference<RubyLanguage> REFERENCE = TruffleLanguage.LanguageReference.create(RubyLanguage.class);
    private boolean multiThreading = false;

    private RubyThread getOrCreateForeignThread(RubyContext context, Thread thread) {
        RubyThread foreignThread = this.rubyThreadInitMap.remove(thread);
        if (foreignThread == null) {
            foreignThread = context.getThreadManager().createForeignThread();
            this.rubyThreadInitMap.put(thread, foreignThread);
        }
        return foreignThread;
    }

    public MaterializedFrame createEmptyDeclarationFrame(Object[] packedArgs, SpecialVariableStorage variables) {
        MaterializedFrame declarationFrame = Truffle.getRuntime().createVirtualFrame(packedArgs, this.emptyDeclarationDescriptor).materialize();
        SpecialVariableStorage.set((Frame)declarationFrame, variables);
        return declarationFrame;
    }

    public static RubyLanguage get(Node node) {
        return (RubyLanguage)REFERENCE.get(node);
    }

    public static String getMimeType(boolean coverageEnabled) {
        return coverageEnabled ? MIME_TYPE_COVERAGE : MIME_TYPE;
    }

    public RubyLanguage() {
        this.coreMethodAssumptions = new CoreMethodAssumptions(this);
        this.coreStrings = new CoreStrings(this);
        this.coreSymbols = new CoreSymbols();
        this.primitiveManager = new PrimitiveManager();
        this.tstringCache = new TStringCache(this.coreSymbols);
        this.symbolTable = new SymbolTable(this.tstringCache, this.coreSymbols);
        this.regexpTable = new RegexpTable();
        this.frozenStringLiterals = new FrozenStringLiterals(this.tstringCache);
    }

    public RubyThread getCurrentThread() {
        return (RubyThread)this.rubyThread.get();
    }

    public RubyFiber getCurrentFiber() {
        return (RubyFiber)this.rubyFiber.get();
    }

    @CompilerDirectives.TruffleBoundary
    public RubyRegexp getRegexp(RegexpCacheKey regexp) {
        return this.regexpTable.getRegexpIfExists(regexp);
    }

    @CompilerDirectives.TruffleBoundary
    public void addRegexp(RegexpCacheKey key, RubyRegexp regexp) {
        this.regexpTable.addRegexp(key, regexp);
    }

    @CompilerDirectives.TruffleBoundary
    public RubySymbol getSymbol(String string) {
        return this.symbolTable.getSymbol(string);
    }

    @CompilerDirectives.TruffleBoundary
    public RubySymbol getSymbol(AbstractTruffleString name, RubyEncoding encoding) {
        return this.symbolTable.getSymbol(name, encoding, false);
    }

    @CompilerDirectives.TruffleBoundary
    public RubySymbol getSymbol(AbstractTruffleString name, RubyEncoding encoding, boolean preserveSymbol) {
        return this.symbolTable.getSymbol(name, encoding, preserveSymbol);
    }

    public Assumption getTracingAssumption() {
        return this.tracingAssumption;
    }

    public void invalidateTracingAssumption() {
        this.tracingCyclicAssumption.invalidate();
        this.tracingAssumption = this.tracingCyclicAssumption.getAssumption();
    }

    public boolean isMultiThreaded() {
        return this.multiThreading;
    }

    protected void initializeMultiThreading(RubyContext context) {
        this.multiThreading = true;
    }

    protected void initializeMultipleContexts() {
        LOGGER.fine("initializeMultipleContexts()");
        if (this.contextIfSingleContext != null) {
            throw CompilerDirectives.shouldNotReachHere((String)"#initializeMultipleContexts() called after a context was created");
        }
        this.singleContext = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyContext createContext(TruffleLanguage.Env env) {
        boolean firstContext;
        Metrics.initializeOption();
        RubyLanguage rubyLanguage = this;
        synchronized (rubyLanguage) {
            ++this.numberOfContexts;
            this.setupCleaner();
            boolean bl = firstContext = this.options == null;
            if (firstContext) {
                this.allocationReporter = (AllocationReporter)env.lookup(AllocationReporter.class);
                this.options = new LanguageOptions(env, env.getOptions(), this.singleContext);
                this.setRubyHome(this.findRubyHome(env));
                this.setupLocale(env, this.rubyHome);
                this.loadLibYARPBindings();
                this.coreLoadPath = RubyLanguage.buildCoreLoadPath(this.options.CORE_LOAD_PATH);
                this.corePath = this.coreLoadPath + File.separator + "core" + File.separator;
                Instrumenter instrumenter = Objects.requireNonNull((Instrumenter)env.lookup(Instrumenter.class));
                this.coverageManager = new CoverageManager(this.options, instrumenter);
                if (this.options.INSTRUMENT_ALL_NODES) {
                    RubyLanguage.instrumentAllNodes(instrumenter);
                }
                this.primitiveManager.loadCoreMethodNodes(this.options);
            }
        }
        if (!firstContext) {
            String oldHome = this.rubyHome;
            TruffleFile newHome = this.findRubyHome(env);
            if (!Objects.equals(newHome.getPath(), oldHome)) {
                throw CompilerDirectives.shouldNotReachHere((String)("home changed for the same RubyLanguage instance: " + oldHome + " vs " + String.valueOf(newHome)));
            }
            this.rubyHomeTruffleFile = newHome;
        }
        LOGGER.fine("createContext() on " + String.valueOf(Thread.currentThread()));
        Metrics.printTime((String)"before-create-context");
        RubyContext context = new RubyContext(this, env);
        Metrics.printTime((String)"after-create-context");
        this.contextIfSingleContext = this.singleContext ? Optional.of(context) : Optional.empty();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeContext(RubyContext context) {
        LOGGER.fine("initializeContext() on " + String.valueOf(Thread.currentThread()));
        try {
            Metrics.printTime((String)"before-initialize-context");
            context.initialize();
            if (context.isPreInitializing()) {
                RubyLanguage rubyLanguage = this;
                synchronized (rubyLanguage) {
                    this.resetRubyHome();
                    this.resetCleaner();
                }
            }
            Metrics.printTime((String)"after-initialize-context");
        }
        catch (Throwable e) {
            if (context.getOptions().EXCEPTIONS_PRINT_JAVA || context.getOptions().EXCEPTIONS_PRINT_UNCAUGHT_JAVA) {
                e.printStackTrace();
            }
            throw e;
        }
        this.applicationStarts();
    }

    private void applicationStarts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean patchContext(RubyContext context, TruffleLanguage.Env newEnv) {
        Metrics.initializeOption();
        LOGGER.fine("patchContext() on " + String.valueOf(Thread.currentThread()) + ")");
        Metrics.printTime((String)"before-patch-context");
        LanguageOptions oldOptions = Objects.requireNonNull(this.options);
        LanguageOptions newOptions = new LanguageOptions(newEnv, newEnv.getOptions(), this.singleContext);
        if (!LanguageOptions.areOptionsCompatibleOrLog(LOGGER, oldOptions, newOptions)) {
            return false;
        }
        RubyLanguage rubyLanguage = this;
        synchronized (rubyLanguage) {
            this.setRubyHome(this.findRubyHome(newEnv));
            this.setupLocale(newEnv, this.rubyHome);
            this.loadLibYARPBindings();
            this.setupCleaner();
        }
        boolean patched = context.patchContext(newEnv);
        Metrics.printTime((String)"after-patch-context");
        return patched;
    }

    protected void finalizeContext(RubyContext context) {
        LOGGER.fine("finalizeContext() on " + String.valueOf(Thread.currentThread()));
        context.finalizeContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeContext(RubyContext context) {
        LOGGER.fine("disposeContext() on " + String.valueOf(Thread.currentThread()));
        context.disposeContext();
        if (this.options.COVERAGE_GLOBAL) {
            this.coverageManager.print(this, System.out);
        }
        RubyLanguage rubyLanguage = this;
        synchronized (rubyLanguage) {
            --this.numberOfContexts;
            if (this.numberOfContexts == 0 && !this.singleContext) {
                this.resetCleaner();
            }
        }
    }

    public static RubyContext getCurrentContext() {
        CompilerAsserts.neverPartOfCompilation((String)"Use getContext() or RubyContext.get(Node) instead in PE code");
        return RubyContext.get(null);
    }

    public static RubyLanguage getCurrentLanguage() {
        CompilerAsserts.neverPartOfCompilation((String)"Use getLanguage() or RubyLanguage.get(Node) instead in PE code");
        return RubyLanguage.get(null);
    }

    protected RootCallTarget parse(TruffleLanguage.ParsingRequest request) {
        RubyBaseRootNode root;
        Source source = request.getSource();
        ParsingParameters parsingParameters = this.parsingRequestParams.get();
        if (parsingParameters != null) {
            assert (parsingParameters.rubySource.getSource().equals((Object)source));
            ParserContext parserContext = MIME_TYPE_MAIN_SCRIPT.equals(source.getMimeType()) ? ParserContext.TOP_LEVEL_FIRST : ParserContext.TOP_LEVEL;
            LexicalScope lexicalScope = this.contextIfSingleContext.map(RubyContext::getRootLexicalScope).orElse(null);
            return RubyLanguage.getCurrentContext().getCodeLoader().parse(parsingParameters.rubySource, parserContext, null, lexicalScope, parsingParameters.currentNode);
        }
        if (source.isInteractive()) {
            root = new RubyEvalInteractiveRootNode(this, source);
        } else {
            RubyContext context = Objects.requireNonNull(RubyLanguage.getCurrentContext());
            root = new RubyParsingRequestNode(this, context, source, request.getArgumentNames().toArray(StringUtils.EMPTY_STRING_ARRAY));
        }
        return root.getCallTarget();
    }

    protected ExecutableNode parse(TruffleLanguage.InlineParsingRequest request) {
        RubyContext context = Objects.requireNonNull(RubyLanguage.getCurrentContext());
        return new RubyInlineParsingRequestNode(this, context, request.getSource(), request.getFrame());
    }

    protected OptionDescriptors getOptionDescriptors() {
        return OptionDescriptors.create(Arrays.asList(OptionsCatalog.allDescriptors()));
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    public void initializeThread(RubyContext context, Thread thread) {
        LOGGER.fine(() -> "initializeThread(" + this.showThread(thread) + ") on " + String.valueOf(Thread.currentThread()));
        if (thread == context.getThreadManager().getOrInitializeRootJavaThread()) {
            return;
        }
        if (context.getThreadManager().isRubyManagedThread(thread)) {
            RubyThread rubyThread = (RubyThread)this.rubyThread.get(thread);
            if (rubyThread.thread == thread) {
                if (thread != Thread.currentThread()) {
                    throw CompilerDirectives.shouldNotReachHere((String)"Ruby threads should be initialized on their Java thread");
                }
                context.getThreadManager().start(rubyThread, thread);
            } else {
                RubyFiber fiber = (RubyFiber)this.rubyFiber.get(thread);
                rubyThread.setCurrentFiber(fiber);
            }
            return;
        }
        RubyThread foreignThread = (RubyThread)this.rubyThread.get(thread);
        context.getThreadManager().startForeignThread(foreignThread, thread);
    }

    public void disposeThread(RubyContext context, Thread thread) {
        LOGGER.fine(() -> "disposeThread(" + this.showThread(thread) + ") on " + String.valueOf(Thread.currentThread()));
        if (thread == context.getThreadManager().getRootJavaThread()) {
            if (context.getEnv().isPreInitialization()) {
                context.getThreadManager().resetMainThread();
                context.getThreadManager().dispose();
                return;
            }
            if (!context.isInitialized()) {
                return;
            }
            context.getThreadManager().cleanupThreadState(context.getThreadManager().getRootThread(), thread);
            return;
        }
        if (context.getThreadManager().isRubyManagedThread(thread)) {
            RubyThread rubyThread = (RubyThread)this.rubyThread.get(thread);
            if (rubyThread.thread == thread) {
                if (thread != Thread.currentThread()) {
                    throw CompilerDirectives.shouldNotReachHere((String)"Ruby threads should be disposed on their Java thread");
                }
                context.getThreadManager().cleanupThreadState(rubyThread, thread);
            } else {
                RubyFiber fiber = (RubyFiber)this.rubyFiber.get(thread);
                context.fiberManager.cleanup(fiber, thread);
            }
            return;
        }
        RubyThread foreignThread = (RubyThread)this.rubyThread.get(thread);
        context.getThreadManager().cleanup(foreignThread, thread);
    }

    private String showThread(Thread thread) {
        return "#" + RubyLanguage.getThreadId(thread) + " " + String.valueOf(thread) + " = " + String.valueOf(this.rubyThread.get(thread));
    }

    protected Object getScope(RubyContext context) {
        return context.getTopScopeObject();
    }

    private static void instrumentAllNodes(Instrumenter instrumenter) {
        instrumenter.attachExecutionEventListener(SourceSectionFilter.ANY, new ExecutionEventListener(){

            public void onEnter(EventContext context, VirtualFrame frame) {
            }

            public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
            }

            public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
            }
        });
    }

    private void setupCleaner() {
        assert (Thread.holdsLock((Object)this));
        if (this.cleaner == null) {
            this.cleaner = Cleaner.create(runnable -> {
                this.cleanerThread = new Thread(runnable, "Ruby-Cleaner");
                return this.cleanerThread;
            });
        }
    }

    private void resetCleaner() {
        assert (Thread.holdsLock((Object)this));
        this.cleanerThread = null;
        this.cleaner = null;
    }

    public String getRubyHome() {
        return this.rubyHome;
    }

    public TruffleFile getRubyHomeTruffleFile() {
        return this.rubyHomeTruffleFile;
    }

    public String getPathRelativeToHome(String path) {
        if (path.startsWith(this.rubyHome) && path.length() > this.rubyHome.length()) {
            return path.substring(this.rubyHome.length() + 1);
        }
        return path;
    }

    private void setRubyHome(TruffleFile home) {
        assert (Thread.holdsLock((Object)this));
        this.rubyHomeTruffleFile = home;
        this.rubyHome = home.getPath();
        this.cextPath = this.rubyHome + "/lib/truffle/truffle/cext_ruby.rb";
    }

    private void resetRubyHome() {
        assert (Thread.holdsLock((Object)this));
        this.rubyHomeTruffleFile = null;
        this.rubyHome = null;
        this.cextPath = null;
    }

    private TruffleFile findRubyHome(TruffleLanguage.Env env) {
        TruffleFile home = this.searchRubyHome(env);
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("home: " + String.valueOf(home));
        }
        return home;
    }

    private TruffleFile searchRubyHome(TruffleLanguage.Env env) {
        TruffleFile homeResource;
        String truffleReported = this.getLanguageHome();
        if (truffleReported != null) {
            TruffleFile truffleReportedFile = env.getInternalTruffleFile(truffleReported);
            try {
                if (truffleReportedFile.exists(new LinkOption[0])) {
                    truffleReportedFile = truffleReportedFile.getCanonicalFile(new LinkOption[0]);
                }
            }
            catch (IOException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            if (this.isRubyHome(truffleReportedFile)) {
                LOGGER.config(() -> String.format("Using Truffle-reported home %s as the Ruby home", truffleReported));
                return truffleReportedFile;
            }
        }
        try {
            TruffleFile homeResourceRelative = env.getInternalResource("ruby-home");
            homeResource = homeResourceRelative == null ? null : homeResourceRelative.getCanonicalFile(new LinkOption[0]);
        }
        catch (IOException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        if (homeResource != null && this.isRubyHome(homeResource)) {
            LOGGER.config(() -> String.format("Using the internal resource %s as the Ruby home", homeResource));
            return homeResource;
        }
        throw new Error("Could not find TruffleRuby's home - not possible to parse Ruby code" + String.format(" (Truffle-reported home %s and internal resource %s do not look like TruffleRuby's home).", truffleReported, homeResource));
    }

    private boolean isRubyHome(TruffleFile path) {
        TruffleFile lib = path.resolve("lib");
        return lib.resolve("truffle").isDirectory(new LinkOption[0]) && (this.options.BUILDING_CORE_CEXTS || lib.resolve("gems").isDirectory(new LinkOption[0])) && lib.resolve("patches").isDirectory(new LinkOption[0]);
    }

    private void setupLocale(TruffleLanguage.Env env, String rubyHome) {
        if (((Boolean)env.getOptions().get(OptionsCatalog.EMBEDDED_KEY)).booleanValue()) {
            if (ImageInfo.inImageRuntimeCode()) {
                ProcessProperties.setLocale((String)"LC_CTYPE", (String)"");
            }
        } else {
            LibRubySignal.loadLibrary((String)rubyHome, (String)Platform.LIB_SUFFIX);
            LibRubySignal.setupLocale();
        }
    }

    private void loadLibYARPBindings() {
        String libyarpbindings = this.getRubyHome() + "/lib/libyarpbindings" + Platform.LIB_SUFFIX;
        Parser.loadLibrary(libyarpbindings);
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public AllocationReporter getAllocationReporter() {
        return this.allocationReporter;
    }

    public ImmutableRubyString getFrozenStringLiteral(TruffleString tstring, RubyEncoding encoding) {
        return this.frozenStringLiterals.getFrozenStringLiteral(tstring, encoding);
    }

    public ImmutableRubyString getFrozenStringLiteral(InternalByteArray byteArray, boolean isImmutable, RubyEncoding encoding) {
        return this.frozenStringLiterals.getFrozenStringLiteral(byteArray, isImmutable, encoding);
    }

    public long getNextObjectID() {
        long id = this.nextObjectID.getAndAdd(16L);
        if (id == 0L) {
            throw CompilerDirectives.shouldNotReachHere((String)"Language Object IDs exhausted");
        }
        return id;
    }

    public PathToTStringCache getPathToTStringCache() {
        return this.pathToTStringCache;
    }

    private static Shape createShape(Class<? extends RubyDynamicObject> layoutClass) {
        return Shape.newBuilder().allowImplicitCastIntToLong(true).layout(layoutClass).dynamicType((Object)objectType).build();
    }

    protected boolean areOptionsCompatible(OptionValues firstOptions, OptionValues newOptions) {
        boolean compatible = this.checkAreOptionsCompatible(firstOptions, newOptions);
        LOGGER.fine(compatible ? "areOptionsCompatible() -> true" : "areOptionsCompatible() -> false");
        return compatible;
    }

    private boolean checkAreOptionsCompatible(OptionValues firstOptions, OptionValues newOptions) {
        if (((Boolean)firstOptions.get(OptionsCatalog.RUN_TWICE_KEY)).booleanValue() || ((Boolean)firstOptions.get(OptionsCatalog.EXPERIMENTAL_ENGINE_CACHING_KEY)).booleanValue()) {
            return LanguageOptions.areOptionsCompatible(firstOptions, newOptions);
        }
        return false;
    }

    public static String getPath(Source source) {
        String path = source.getPath();
        if (path != null) {
            return path;
        }
        String name = source.getName();
        assert (name != null);
        return name;
    }

    @CompilerDirectives.TruffleBoundary
    public String getSourcePath(Source source) {
        String path = RubyLanguage.getPath(source);
        if (path.startsWith(this.coreLoadPath)) {
            return "<internal:core> " + path.substring(this.coreLoadPath.length() + 1);
        }
        return path;
    }

    @CompilerDirectives.TruffleBoundary
    public static String getCorePath(Source source) {
        String coreLoadPath;
        String path = RubyLanguage.getPath(source);
        if (path.startsWith(coreLoadPath = (String)OptionsCatalog.CORE_LOAD_PATH_KEY.getDefaultValue())) {
            return "<internal:core> " + path.substring(coreLoadPath.length() + 1);
        }
        throw CompilerDirectives.shouldNotReachHere((String)(path + " is not a core path starting with " + coreLoadPath));
    }

    @CompilerDirectives.TruffleBoundary
    public static String fileLineRange(SourceSection section) {
        if (section == null) {
            return "no source section";
        }
        String path = RubyLanguage.getPath(section.getSource());
        if (section.isAvailable()) {
            if (section.getStartLine() != section.getEndLine()) {
                return path + ":" + section.getStartLine() + "-" + section.getEndLine();
            }
            return path + ":" + section.getStartLine();
        }
        return path;
    }

    @CompilerDirectives.TruffleBoundary
    String fileLine(RubyContext context, SourceSection section) {
        if (section == null) {
            return "no source section";
        }
        String path = this.getSourcePath(section.getSource());
        if (section.isAvailable()) {
            return path + ":" + RubySource.getStartLineAdjusted(context, section);
        }
        return path;
    }

    @CompilerDirectives.TruffleBoundary
    public static String filenameLine(SourceSection section) {
        if (section == null) {
            return "no source section";
        }
        String path = RubyLanguage.getPath(section.getSource());
        String filename = new File(path).getName();
        if (section.isAvailable()) {
            return filename + ":" + section.getStartLine();
        }
        return filename;
    }

    public Object rubySourceLocation(RubyContext context, SourceSection section, TruffleString.FromJavaStringNode fromJavaStringNode, Node node) {
        if (!BacktraceFormatter.isAvailable(section)) {
            return RubyBaseNode.nil;
        }
        RubyString file = RubyBaseNode.createString(node, fromJavaStringNode, this.getSourcePath(section.getSource()), Encodings.UTF_8);
        Object[] objects = new Object[]{file, RubySource.getStartLineAdjusted(context, section)};
        return RubyBaseNode.createArray(node, objects);
    }

    public int getGlobalVariableIndex(String name) {
        return this.globalVariablesMap.lookup(name);
    }

    @CompilerDirectives.TruffleBoundary
    public Assumption getGlobalVariableNeverAliasedAssumption(int index) {
        return this.globalVariableNeverAliasedAssumptions.get(index);
    }

    private static String buildCoreLoadPath(String coreLoadPath) {
        while (coreLoadPath.endsWith("/")) {
            coreLoadPath = coreLoadPath.substring(0, coreLoadPath.length() - 1);
        }
        if (coreLoadPath.startsWith(RESOURCE_SCHEME)) {
            return coreLoadPath;
        }
        try {
            return new File(coreLoadPath).getCanonicalPath();
        }
        catch (IOException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    public static long getThreadId(Thread thread) {
        return thread.getId();
    }
}

