/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby;

import com.oracle.truffle.api.TruffleFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Pattern;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.parser.MagicCommentParser;

public final class RubyFileTypeDetector
implements TruffleFile.FileTypeDetector {
    private static final String[] KNOWN_RUBY_FILES = new String[]{"Gemfile", "Rakefile"};
    private static final String[] KNOWN_RUBY_SUFFIXES = new String[]{".rb", ".rake", ".gemspec"};
    private static final Pattern SHEBANG_REGEXP = Pattern.compile("^#! ?/usr/bin/(env +ruby|ruby).*");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String findMimeType(TruffleFile file) throws IOException {
        String fileName = file.getName();
        if (fileName == null) {
            return null;
        }
        String lowerCaseFileName = fileName.toLowerCase(Locale.ROOT);
        for (String candidate : KNOWN_RUBY_SUFFIXES) {
            if (!lowerCaseFileName.endsWith(candidate)) continue;
            return RubyLanguage.getMimeType(false);
        }
        for (String candidate : KNOWN_RUBY_FILES) {
            if (!fileName.equals(candidate)) continue;
            return RubyLanguage.getMimeType(false);
        }
        try (BufferedReader fileContent = file.newBufferedReader(StandardCharsets.ISO_8859_1);){
            String firstLine = fileContent.readLine();
            if (firstLine == null) return null;
            if (!SHEBANG_REGEXP.matcher(firstLine).matches()) return null;
            String string = RubyLanguage.getMimeType(false);
            return string;
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Charset findEncoding(TruffleFile file) {
        try (BufferedReader fileContent = file.newBufferedReader(StandardCharsets.ISO_8859_1);){
            RubyEncoding encoding = RubyFileTypeDetector.findEncoding(fileContent);
            if (encoding == null) return null;
            Charset charset = encoding.jcoding.getCharset();
            return charset;
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return null;
    }

    public static RubyEncoding findEncoding(BufferedReader reader) {
        try {
            TStringWithEncoding encodingComment;
            RubyEncoding encoding;
            String encodingCommentLine;
            String firstLine = reader.readLine();
            if (firstLine != null && (encodingCommentLine = SHEBANG_REGEXP.matcher(firstLine).matches() ? reader.readLine() : firstLine) != null && (encoding = MagicCommentParser.parseMagicEncodingComment(encodingComment = new TStringWithEncoding(TStringUtils.fromJavaString(encodingCommentLine, Encodings.BINARY), Encodings.BINARY))) != null) {
                return encoding;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

