/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.AssumedValue;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.graalvm.collections.Pair;
import org.graalvm.options.OptionDescriptor;
import org.truffleruby.RubyLanguage;
import org.truffleruby.cext.ValueWrapperManager;
import org.truffleruby.collections.ConcurrentWeakKeysMap;
import org.truffleruby.collections.SharedIndicesMap;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.DataObjectFinalizationService;
import org.truffleruby.core.FinalizationService;
import org.truffleruby.core.Hashing;
import org.truffleruby.core.MarkingService;
import org.truffleruby.core.ReferenceProcessingService;
import org.truffleruby.core.array.ArrayOperations;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.EncodingManager;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.exception.CoreExceptions;
import org.truffleruby.core.fiber.FiberManager;
import org.truffleruby.core.hash.PreInitializationManager;
import org.truffleruby.core.hash.ReHashable;
import org.truffleruby.core.inlined.CoreMethods;
import org.truffleruby.core.kernel.AtExitManager;
import org.truffleruby.core.kernel.TraceManager;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.objectspace.ObjectSpaceManager;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.thread.ThreadManager;
import org.truffleruby.core.time.GetTimeZoneNode;
import org.truffleruby.debug.MetricsProfiler;
import org.truffleruby.language.CallStackManager;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.SafepointManager;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.globals.GlobalVariableStorage;
import org.truffleruby.language.loader.CodeLoader;
import org.truffleruby.language.loader.FeatureLoader;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.options.LanguageOptions;
import org.truffleruby.options.Options;
import org.truffleruby.parser.YARPTranslatorDriver;
import org.truffleruby.platform.NativeConfiguration;
import org.truffleruby.platform.Signals;
import org.truffleruby.platform.TruffleNFIPlatform;
import org.truffleruby.shared.Metrics;
import org.truffleruby.shared.options.OptionsCatalog;
import org.truffleruby.shared.options.RubyOptionTypes;
import org.truffleruby.stdlib.readline.ConsoleHolder;
import sun.misc.SignalHandler;

public final class RubyContext {
    private final RubyLanguage language;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.Env env;
    @CompilerDirectives.CompilationFinal
    private PrintStream outStream;
    @CompilerDirectives.CompilationFinal
    private PrintStream errStream;
    @CompilerDirectives.CompilationFinal
    private boolean hasOtherPublicLanguages;
    @CompilerDirectives.CompilationFinal
    public TruffleLogger logger;
    @CompilerDirectives.CompilationFinal
    private Options options;
    private final SafepointManager safepointManager;
    private final CodeLoader codeLoader;
    private final FeatureLoader featureLoader;
    private final TraceManager traceManager;
    private final ReferenceProcessingService.ReferenceProcessor referenceProcessor;
    private final FinalizationService finalizationService;
    private final DataObjectFinalizationService dataObjectFinalizationService;
    private final MarkingService markingService;
    private final ObjectSpaceManager objectSpaceManager = new ObjectSpaceManager();
    private final SharedObjects sharedObjects = new SharedObjects(this);
    private final AtExitManager atExitManager;
    private final CallStackManager callStack;
    private final CoreExceptions coreExceptions;
    private final EncodingManager encodingManager;
    private final MetricsProfiler metricsProfiler;
    private final PreInitializationManager preInitializationManager;
    private final NativeConfiguration nativeConfiguration;
    private final ValueWrapperManager valueWrapperManager;
    private final ConcurrentWeakKeysMap<Source, Integer> sourceLineOffsets = new ConcurrentWeakKeysMap();
    public final Map<Pair<RubySymbol, Map<RubyModule, RubyModule[]>>, RootCallTarget> cachedSymbolToProcTargetsWithRefinements = new ConcurrentHashMap<Pair<RubySymbol, Map<RubyModule, RubyModule[]>>, RootCallTarget>();
    public final ConcurrentMap<String, SignalHandler> defaultRubySignalHandlers = new ConcurrentHashMap<String, SignalHandler>();
    @CompilerDirectives.CompilationFinal
    private SecureRandom random;
    private final Hashing hashing;
    @CompilerDirectives.CompilationFinal
    private BacktraceFormatter defaultBacktraceFormatter;
    private final BacktraceFormatter userBacktraceFormatter;
    @CompilerDirectives.CompilationFinal
    private TruffleNFIPlatform truffleNFIPlatform;
    private final CoreLibrary coreLibrary;
    @CompilerDirectives.CompilationFinal
    private CoreMethods coreMethods;
    private final ThreadManager threadManager;
    public final FiberManager fiberManager;
    private final LexicalScope rootLexicalScope;
    private volatile ConsoleHolder consoleHolder;
    public final SharedIndicesMap.ContextArray<GlobalVariableStorage> globalVariablesArray;
    private final Object classVariableDefinitionLock = new Object();
    private final ReentrantLock cExtensionsLock = new ReentrantLock();
    private final boolean preInitialized;
    @CompilerDirectives.CompilationFinal
    private boolean preInitializing;
    private boolean initialized;
    private volatile boolean finalizing;
    public int nativeArgc = 0;
    public long nativeArgv = 0L;
    public long nativeArgvLength = -1L;
    private volatile boolean constAddedDefined = false;
    private final AssumedValue<Boolean> warningCategoryDeprecated;
    private final AssumedValue<Boolean> warningCategoryExperimental;
    private final AssumedValue<Boolean> warningCategoryPerformance;
    private ImmutableRubyString mainScriptName;
    private static final TruffleLanguage.ContextReference<RubyContext> REFERENCE = TruffleLanguage.ContextReference.create(RubyLanguage.class);
    private final ReentrantLock disposeLock = new ReentrantLock();
    private boolean disposed = false;

    public static RubyContext get(Node node) {
        return (RubyContext)REFERENCE.get(node);
    }

    public RubyContext(RubyLanguage language, TruffleLanguage.Env env) {
        Metrics.printTime((String)"before-context-constructor");
        this.language = language;
        this.callStack = new CallStackManager(language, this);
        this.setEnv(env);
        this.preInitialized = this.preInitializing;
        this.preInitializationManager = this.preInitializing ? new PreInitializationManager() : null;
        this.options = this.createOptions(env, language.options);
        this.warningCategoryDeprecated = new AssumedValue((Object)this.options.WARN_DEPRECATED);
        this.warningCategoryExperimental = new AssumedValue((Object)this.options.WARN_EXPERIMENTAL);
        this.warningCategoryPerformance = new AssumedValue((Object)this.options.WARN_PERFORMANCE);
        this.safepointManager = new SafepointManager(this);
        this.coreExceptions = new CoreExceptions(this, language);
        this.encodingManager = new EncodingManager(this, language);
        this.metricsProfiler = new MetricsProfiler(language, this);
        this.codeLoader = new CodeLoader(language, this);
        this.featureLoader = new FeatureLoader(this, language);
        this.referenceProcessor = new ReferenceProcessingService.ReferenceProcessor(this);
        this.finalizationService = new FinalizationService(this.referenceProcessor);
        this.markingService = new MarkingService();
        this.dataObjectFinalizationService = new DataObjectFinalizationService(language, this.referenceProcessor);
        this.atExitManager = new AtExitManager(this, language);
        this.random = RubyContext.createRandomInstance();
        this.hashing = new Hashing(this.generateHashingSeed());
        this.defaultBacktraceFormatter = BacktraceFormatter.createDefaultFormatter(this, language);
        this.userBacktraceFormatter = new BacktraceFormatter(this, language, BacktraceFormatter.USER_BACKTRACE_FLAGS);
        Metrics.printTime((String)"before-create-core-library");
        this.globalVariablesArray = new SharedIndicesMap.ContextArray<GlobalVariableStorage>(language.globalVariablesMap, GlobalVariableStorage[]::new, () -> new GlobalVariableStorage(null, null, null));
        this.coreLibrary = new CoreLibrary(this, language);
        this.nativeConfiguration = NativeConfiguration.loadNativeConfiguration(this);
        this.coreLibrary.initialize();
        language.coreMethodAssumptions.registerAssumptions(this.coreLibrary);
        this.valueWrapperManager = new ValueWrapperManager();
        Metrics.printTime((String)"after-create-core-library");
        this.rootLexicalScope = new LexicalScope(null, this.coreLibrary.objectClass);
        this.truffleNFIPlatform = this.isPreInitializing() ? null : this.createNativePlatform();
        Metrics.printTime((String)"before-initialize-encodings");
        this.encodingManager.defineEncodings();
        this.encodingManager.initializeDefaultEncodings(this.truffleNFIPlatform, this.nativeConfiguration);
        Metrics.printTime((String)"after-initialize-encodings");
        Metrics.printTime((String)"before-thread-manager");
        this.threadManager = new ThreadManager(this, language);
        this.fiberManager = new FiberManager(language, this);
        this.threadManager.initialize();
        this.threadManager.initializeMainThread(Thread.currentThread());
        Metrics.printTime((String)"after-thread-manager");
        Metrics.printTime((String)"before-instruments");
        Instrumenter instrumenter = (Instrumenter)env.lookup(Instrumenter.class);
        this.traceManager = new TraceManager(language, this, instrumenter);
        Metrics.printTime((String)"after-instruments");
        Metrics.printTime((String)"after-context-constructor");
    }

    public void initialize() {
        assert (!this.initialized) : "Already initialized";
        Metrics.printTime((String)"before-load-nodes");
        this.coreLibrary.loadCoreNodes();
        Metrics.printTime((String)"after-load-nodes");
        this.coreMethods = new CoreMethods(this.language, this);
        Metrics.printTime((String)"before-load-core");
        this.coreLibrary.loadRubyCoreLibraryAndPostBoot();
        Metrics.printTime((String)"after-load-core");
        if (this.language.options.SHARED_OBJECTS_ENABLED && this.language.options.SHARED_OBJECTS_FORCE) {
            this.sharedObjects.startSharing(this.language, OptionsCatalog.SHARED_OBJECTS_FORCE.getName() + " being true");
        }
        if (this.isPreInitializing()) {
            this.random = null;
            this.featureLoader.setWorkingDirectory(null);
        } else {
            this.initialized = true;
        }
    }

    protected boolean patch(TruffleLanguage.Env newEnv) {
        this.setEnv(newEnv);
        if (this.preInitializing) {
            throw CompilerDirectives.shouldNotReachHere((String)"Expected patch Env#isPreInitialization() to be false");
        }
        Options oldOptions = this.options;
        Options newOptions = this.createOptions(newEnv, this.language.options);
        if (!this.compatibleOptions(oldOptions, newOptions)) {
            return false;
        }
        this.options = newOptions;
        if (newOptions.WARN_DEPRECATED != oldOptions.WARN_DEPRECATED) {
            this.warningCategoryDeprecated.set((Object)newOptions.WARN_DEPRECATED);
        }
        if (newOptions.WARN_EXPERIMENTAL != oldOptions.WARN_EXPERIMENTAL) {
            this.warningCategoryExperimental.set((Object)newOptions.WARN_EXPERIMENTAL);
        }
        if (newOptions.WARN_PERFORMANCE != oldOptions.WARN_PERFORMANCE) {
            this.warningCategoryPerformance.set((Object)newOptions.WARN_PERFORMANCE);
        }
        GetTimeZoneNode.invalidateTZ();
        this.random = RubyContext.createRandomInstance();
        this.hashing.patchSeed(this.generateHashingSeed());
        this.defaultBacktraceFormatter = BacktraceFormatter.createDefaultFormatter(this, this.language);
        this.truffleNFIPlatform = this.createNativePlatform();
        this.encodingManager.initializeDefaultEncodings(this.truffleNFIPlatform, this.nativeConfiguration);
        this.threadManager.initialize();
        this.threadManager.restartMainThread(Thread.currentThread());
        Metrics.printTime((String)"before-rehash");
        this.preInitializationManager.rehash();
        Metrics.printTime((String)"after-rehash");
        Metrics.printTime((String)"before-run-delayed-initialization");
        Object toRunAtInit = this.coreLibrary.truffleBootModule.fields.getConstant("TO_RUN_AT_INIT").getValue();
        for (Object proc : ArrayOperations.toIterable((RubyArray)toRunAtInit)) {
            Source source = ((RubyProc)proc).declaringMethod.getSharedMethodInfo().getSourceSection().getSource();
            YARPTranslatorDriver.printParseTranslateExecuteMetric("before-run-delayed-initialization", this, source);
            ProcOperations.rootCall((RubyProc)proc, NoKeywordArgumentsDescriptor.INSTANCE, RubyBaseNode.EMPTY_ARGUMENTS);
            YARPTranslatorDriver.printParseTranslateExecuteMetric("after-run-delayed-initialization", this, source);
        }
        Metrics.printTime((String)"after-run-delayed-initialization");
        this.initialized = true;
        return true;
    }

    protected boolean patchContext(TruffleLanguage.Env newEnv) {
        try {
            return this.patch(newEnv);
        }
        catch (AbstractTruffleException e) {
            this.getDefaultBacktraceFormatter().printRubyExceptionOnEnvStderr("Exception during RubyContext.patch():\n", e);
            throw e;
        }
        catch (Throwable e) {
            System.err.println("Exception during RubyContext.patch():");
            e.printStackTrace();
            throw e;
        }
    }

    private boolean compatibleOptions(Options oldOptions, Options newOptions) {
        String notReusingContext = "not reusing pre-initialized context: ";
        if (newOptions.PATCHING != oldOptions.PATCHING) {
            RubyLanguage.LOGGER.fine("not reusing pre-initialized context: loading patching is " + newOptions.PATCHING);
            return false;
        }
        if (newOptions.DID_YOU_MEAN != oldOptions.DID_YOU_MEAN) {
            RubyLanguage.LOGGER.fine("not reusing pre-initialized context: loading did_you_mean is " + newOptions.DID_YOU_MEAN);
            return false;
        }
        return true;
    }

    private Options createOptions(TruffleLanguage.Env env, LanguageOptions languageOptions) {
        Metrics.printTime((String)"before-options");
        Options options = new Options(env, env.getOptions(), languageOptions);
        if (options.OPTIONS_LOG && RubyLanguage.LOGGER.isLoggable(Level.CONFIG)) {
            for (OptionDescriptor descriptor : OptionsCatalog.allDescriptors()) {
                assert (descriptor.getName().startsWith("ruby"));
                String optionName = descriptor.getName().substring("ruby".length() + 1);
                RubyLanguage.LOGGER.config("option " + optionName + "=" + RubyOptionTypes.valueToString((Object)options.fromDescriptor(descriptor)));
            }
        }
        Metrics.printTime((String)"after-options");
        return options;
    }

    private void setEnv(TruffleLanguage.Env env) {
        this.env = env;
        this.outStream = RubyContext.printStreamFor(env.out());
        this.errStream = RubyContext.printStreamFor(env.err());
        this.logger = env.getLogger("");
        this.hasOtherPublicLanguages = RubyContext.computeHasOtherPublicLanguages(env);
        this.preInitializing = env.isPreInitialization();
    }

    private static PrintStream printStreamFor(OutputStream outputStream) {
        try {
            return new PrintStream(outputStream, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    private static boolean computeHasOtherPublicLanguages(TruffleLanguage.Env env) {
        for (String language : env.getPublicLanguages().keySet()) {
            if (language.equals("ruby")) continue;
            return true;
        }
        return false;
    }

    public boolean hasOtherPublicLanguages() {
        return this.hasOtherPublicLanguages;
    }

    private long generateHashingSeed() {
        if (this.options.HASHING_DETERMINISTIC) {
            RubyLanguage.LOGGER.severe("deterministic hashing is enabled - this may make you vulnerable to denial of service attacks");
            return 7114160726623585955L;
        }
        byte[] bytes = this.getRandomSeedBytes(8);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return buffer.getLong();
    }

    private TruffleNFIPlatform createNativePlatform() {
        Metrics.printTime((String)"before-create-native-platform");
        TruffleNFIPlatform truffleNFIPlatform = this.options.NATIVE_PLATFORM ? new TruffleNFIPlatform(this) : null;
        this.featureLoader.initialize(this.nativeConfiguration, truffleNFIPlatform);
        Metrics.printTime((String)"after-create-native-platform");
        return truffleNFIPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static Object send(Node currentNode, Object receiver, String methodName, Object ... arguments) {
        if (currentNode != null && currentNode.isAdoptable()) {
            EncapsulatingNodeReference callNodeRef = EncapsulatingNodeReference.getCurrent();
            Node prev = callNodeRef.set(currentNode);
            try {
                Object object = DispatchNode.getUncached().call(receiver, methodName, arguments);
                return object;
            }
            finally {
                callNodeRef.set(prev);
            }
        }
        return DispatchNode.getUncached().call(receiver, methodName, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static Object indirectCallWithCallNode(Node currentNode, RootCallTarget callTarget, Object ... frameArguments) {
        if (currentNode.isAdoptable()) {
            EncapsulatingNodeReference callNodeRef = EncapsulatingNodeReference.getCurrent();
            Node prev = callNodeRef.set(currentNode);
            try {
                Object object = IndirectCallNode.getUncached().call((CallTarget)callTarget, frameArguments);
                return object;
            }
            finally {
                callNodeRef.set(prev);
            }
        }
        return IndirectCallNode.getUncached().call((CallTarget)callTarget, frameArguments);
    }

    public void finalizeContext() {
        if (!this.initialized) {
            return;
        }
        this.finalizing = true;
        this.atExitManager.runSystemExitHooks();
        this.threadManager.killAndWaitOtherThreads();
    }

    public void disposeContext() {
        this.disposeLock.lock();
        try {
            if (!this.disposed) {
                this.dispose();
                this.disposed = true;
            }
        }
        finally {
            this.disposeLock.unlock();
        }
    }

    private void dispose() {
        if (!this.initialized) {
            return;
        }
        if (this.consoleHolder != null) {
            this.consoleHolder.close();
        }
        this.threadManager.dispose();
        this.threadManager.checkNoRunningThreads();
        Signals.restoreDefaultHandlers();
        if (this.options.PRINT_INTERNED_TSTRING_STATS) {
            RubyLanguage.LOGGER.info("tstrings re-used: " + this.language.tstringCache.getTStringsReusedCount());
            RubyLanguage.LOGGER.info("tstring byte arrays re-used: " + this.language.tstringCache.getByteArrayReusedCount());
            RubyLanguage.LOGGER.info("tstring bytes saved: " + this.language.tstringCache.getTStringBytesSaved());
            RubyLanguage.LOGGER.info("total tstrings interned: " + this.language.tstringCache.totalTStrings());
        }
        if (this.options.CEXTS_TO_NATIVE_STATS) {
            RubyLanguage.LOGGER.info("Total VALUE object to native conversions: " + this.getValueWrapperManager().totalHandleAllocations());
        }
        this.valueWrapperManager.freeAllBlocksInMap();
    }

    public boolean isPreInitializing() {
        return this.preInitializing;
    }

    public boolean wasPreInitialized() {
        return this.preInitialized;
    }

    public Hashing getHashing() {
        return this.hashing;
    }

    public RubyLanguage getLanguageSlow() {
        CompilerAsserts.neverPartOfCompilation((String)"Use getLanguage() or RubyLanguage.get(Node) instead, so the RubyLanguage instance is constant in PE code");
        return this.language;
    }

    public Options getOptions() {
        return this.options;
    }

    public TruffleLanguage.Env getEnv() {
        return this.env;
    }

    public Hashing getHashing(Node node) {
        return this.hashing;
    }

    public Hashing getHashing(ReHashable reHashable) {
        if (this.isPreInitializing()) {
            this.preInitializationManager.addReHashable(reHashable);
        }
        return this.hashing;
    }

    public BacktraceFormatter getDefaultBacktraceFormatter() {
        return this.defaultBacktraceFormatter;
    }

    public BacktraceFormatter getUserBacktraceFormatter() {
        return this.userBacktraceFormatter;
    }

    public CoreLibrary getCoreLibrary() {
        return this.coreLibrary;
    }

    public CoreMethods getCoreMethods() {
        return this.coreMethods;
    }

    public FeatureLoader getFeatureLoader() {
        return this.featureLoader;
    }

    public ReferenceProcessingService.ReferenceProcessor getReferenceProcessor() {
        return this.referenceProcessor;
    }

    public FinalizationService getFinalizationService() {
        return this.finalizationService;
    }

    public DataObjectFinalizationService getDataObjectFinalizationService() {
        return this.dataObjectFinalizationService;
    }

    public MarkingService getMarkingService() {
        return this.markingService;
    }

    public ObjectSpaceManager getObjectSpaceManager() {
        return this.objectSpaceManager;
    }

    public SharedObjects getSharedObjects() {
        return this.sharedObjects;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public AtExitManager getAtExitManager() {
        return this.atExitManager;
    }

    public TraceManager getTraceManager() {
        return this.traceManager;
    }

    public SafepointManager getSafepointManager() {
        return this.safepointManager;
    }

    public LexicalScope getRootLexicalScope() {
        return this.rootLexicalScope;
    }

    public CodeLoader getCodeLoader() {
        return this.codeLoader;
    }

    public CallStackManager getCallStack() {
        return this.callStack;
    }

    public Object getClassVariableDefinitionLock() {
        return this.classVariableDefinitionLock;
    }

    public ReentrantLock getCExtensionsLock() {
        return this.cExtensionsLock;
    }

    public Instrumenter getInstrumenter() {
        return (Instrumenter)this.env.lookup(Instrumenter.class);
    }

    public CoreExceptions getCoreExceptions() {
        return this.coreExceptions;
    }

    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    public MetricsProfiler getMetricsProfiler() {
        return this.metricsProfiler;
    }

    public PreInitializationManager getPreInitializationManager() {
        return this.preInitializationManager;
    }

    public TruffleLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public ConsoleHolder getConsoleHolder() {
        if (this.consoleHolder == null) {
            RubyContext rubyContext = this;
            synchronized (rubyContext) {
                if (this.consoleHolder == null) {
                    this.consoleHolder = ConsoleHolder.create(this, this.language);
                }
            }
        }
        return this.consoleHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsoleHolder(ConsoleHolder consoleHolder) {
        RubyContext rubyContext = this;
        synchronized (rubyContext) {
            ConsoleHolder previous = Objects.requireNonNull(this.consoleHolder);
            previous.close();
            this.consoleHolder = consoleHolder;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isFinalizing() {
        return this.finalizing;
    }

    public TruffleNFIPlatform getTruffleNFI() {
        return this.truffleNFIPlatform;
    }

    public NativeConfiguration getNativeConfiguration() {
        return this.nativeConfiguration;
    }

    public ValueWrapperManager getValueWrapperManager() {
        return this.valueWrapperManager;
    }

    public ConcurrentWeakKeysMap<Source, Integer> getSourceLineOffsets() {
        return this.sourceLineOffsets;
    }

    @CompilerDirectives.TruffleBoundary
    public String fileLine(SourceSection section) {
        return this.language.fileLine(this, section);
    }

    private static SecureRandom createRandomInstance() {
        try {
            return SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public byte[] getRandomSeedBytes(int numBytes) {
        byte[] bytes = new byte[numBytes];
        this.random.nextBytes(bytes);
        return bytes;
    }

    public Object getTopScopeObject() {
        return this.coreLibrary.topScopeObject;
    }

    public AssumedValue<Boolean> getWarningCategoryDeprecated() {
        return this.warningCategoryDeprecated;
    }

    public AssumedValue<Boolean> getWarningCategoryExperimental() {
        return this.warningCategoryExperimental;
    }

    public AssumedValue<Boolean> getWarningCategoryPerformance() {
        return this.warningCategoryPerformance;
    }

    public PrintStream getEnvOutStream() {
        return this.outStream;
    }

    public PrintStream getEnvErrStream() {
        return this.errStream;
    }

    @NeverDefault
    public GlobalVariableStorage getGlobalVariableStorage(int index) {
        return (GlobalVariableStorage)this.globalVariablesArray.get(index);
    }

    public void initializeMainScriptName(String mainScriptName) {
        ImmutableRubyString mainScriptString = this.language.getFrozenStringLiteral(TStringUtils.utf8TString(mainScriptName), Encodings.UTF_8);
        int index = this.language.getGlobalVariableIndex("$0");
        this.getGlobalVariableStorage(index).setValueInternal(mainScriptString);
        this.mainScriptName = mainScriptString;
    }

    public ImmutableRubyString getMainScriptName() {
        return this.mainScriptName;
    }

    public boolean isConstAddedEverDefined() {
        return this.constAddedDefined;
    }

    public void constAddedIsDefined() {
        this.constAddedDefined = true;
    }
}

