/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.lexer;

import org.jcodings.Encoding;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.string.KCode;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.parser.ast.RegexpParseNode;
import org.truffleruby.parser.lexer.RubyLexer;
import org.truffleruby.parser.lexer.StrTerm;
import org.truffleruby.parser.lexer.SyntaxException;

public final class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private final int startLine;
    private int nest;

    public StringTerm(int flags, int begin, int end, int startLine) {
        this.flags = flags;
        this.begin = (char)begin;
        this.end = (char)end;
        this.nest = 0;
        this.startLine = startLine;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    protected TStringBuilder createRopeBuilder(RubyLexer lexer) {
        TStringBuilder builder = new TStringBuilder();
        builder.setEncoding(lexer.encoding);
        return builder;
    }

    private int endFound(RubyLexer lexer) {
        if ((this.flags & 8) != 0) {
            this.flags |= 0x8000;
            lexer.pushback(0);
            lexer.getPosition();
            return 32;
        }
        lexer.setStrTerm(null);
        if ((this.flags & 4) != 0) {
            RegexpOptions options = this.parseRegexpFlags(lexer);
            lexer.setState(6);
            lexer.setValue(new RegexpParseNode(lexer.getPosition(), new TStringWithEncoding(TStringConstants.EMPTY_US_ASCII, Encodings.US_ASCII), options));
            return 384;
        }
        if ((this.flags & 0x40) != 0 && lexer.isLabelSuffix()) {
            lexer.nextc();
            lexer.setState(1025);
            return 389;
        }
        lexer.setState(6);
        lexer.setValue("" + this.end);
        return 374;
    }

    @Override
    public int parseString(RubyLexer lexer) {
        boolean spaceSeen = false;
        if ((this.flags & 0x8000) != 0) {
            if ((this.flags & 8) != 0) {
                lexer.nextc();
            }
            lexer.setState(6);
            lexer.setValue("" + this.end);
            lexer.setStrTerm(null);
            return (this.flags & 4) != 0 ? 384 : 374;
        }
        int c = lexer.nextc();
        if ((this.flags & 8) != 0 && Character.isWhitespace(c)) {
            while (Character.isWhitespace(c = lexer.nextc())) {
            }
            spaceSeen = true;
        }
        if ((this.flags & 0x4000) != 0) {
            this.flags &= 0xFFFFBFFF;
            spaceSeen = true;
        }
        if (c == this.end && this.nest == 0) {
            return this.endFound(lexer);
        }
        if (spaceSeen) {
            lexer.pushback(c);
            lexer.getPosition();
            return 32;
        }
        TStringBuilder buffer = this.createRopeBuilder(lexer);
        lexer.newtok(true);
        if ((this.flags & 2) != 0 && c == 35) {
            int token = lexer.peekVariableName(373, 372);
            if (token != 0) {
                return token;
            }
            buffer.append(35);
        }
        lexer.pushback(c);
        Encoding[] enc = new Encoding[]{lexer.getEncoding()};
        if (this.parseStringIntoBuffer(lexer, buffer, enc) == -1) {
            lexer.ruby_sourceline = this.startLine;
            lexer.updateLineOffset();
            lexer.compile_error("unterminated " + ((this.flags & 4) != 0 ? "regexp" : "string") + " meets end of file");
        }
        lexer.setValue(lexer.createStr(buffer, this.flags));
        return 379;
    }

    private RegexpOptions parseRegexpFlags(RubyLexer lexer) {
        RegexpOptions options = new RegexpOptions();
        StringBuilder unknownFlags = new StringBuilder(10);
        lexer.newtok(true);
        int c = lexer.nextc();
        while (c != -1 && Character.isLetter(c)) {
            switch (c) {
                case 105: {
                    options = options.setIgnorecase(true);
                    break;
                }
                case 120: {
                    options = options.setExtended(true);
                    break;
                }
                case 109: {
                    options = options.setMultiline(true);
                    break;
                }
                case 111: {
                    options = options.setOnce(true);
                    break;
                }
                case 110: {
                    options = options.setExplicitKCode(KCode.NONE);
                    break;
                }
                case 101: {
                    options = options.setExplicitKCode(KCode.EUC);
                    break;
                }
                case 115: {
                    options = options.setExplicitKCode(KCode.SJIS);
                    break;
                }
                case 117: {
                    options = options.setExplicitKCode(KCode.UTF8);
                    break;
                }
                case 106: {
                    options = options.setJava(true);
                    break;
                }
                default: {
                    unknownFlags.append((char)c);
                }
            }
            c = lexer.nextc();
        }
        lexer.pushback(c);
        if (unknownFlags.length() != 0) {
            lexer.compile_error(SyntaxException.PID.REGEXP_UNKNOWN_OPTION, "unknown regexp option" + (unknownFlags.length() > 1 ? "s" : "") + " - " + unknownFlags);
        }
        return options;
    }

    private void mixedEscape(RubyLexer lexer, Encoding foundEncoding, Encoding parserEncoding) {
        lexer.compile_error(SyntaxException.PID.MIXED_ENCODING, foundEncoding + " mixed within " + parserEncoding);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int parseStringIntoBuffer(RubyLexer lexer, TStringBuilder buffer, Encoding[] enc) {
        int c;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape = (this.flags & 1) != 0;
        boolean regexp = (this.flags & 4) != 0;
        boolean symbol = (this.flags & 0x10) != 0;
        boolean indent = (this.flags & 0x20) != 0;
        boolean hasNonAscii = false;
        block5: while ((c = lexer.nextc()) != -1) {
            block30: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                if (lexer.getHeredocIndent() > 0) {
                                    lexer.update_heredoc_indent(c);
                                }
                                if (this.begin == '\u0000' || c != this.begin) break block31;
                                ++this.nest;
                                break block30;
                            }
                            if (c != this.end) break block32;
                            if (this.nest == 0) {
                                lexer.pushback(c);
                                break;
                            }
                            --this.nest;
                            break block30;
                        }
                        if (!expand || c != 35 || lexer.peek(10)) break block33;
                        int c2 = lexer.nextc();
                        if (c2 == 36 || c2 == 64 || c2 == 123) {
                            lexer.pushback(c2);
                            lexer.pushback(c);
                            break;
                        }
                        lexer.pushback(c2);
                        break block30;
                    }
                    if (c != 92) break block34;
                    c = lexer.nextc();
                    switch (c) {
                        case 10: {
                            if (qwords) break block30;
                            if (expand) {
                                if (!indent && lexer.getHeredocIndent() < 0) break;
                                if (c != this.end) continue block5;
                                c = 92;
                                if (enc != null) {
                                    buffer.setEncoding(lexer.encoding);
                                }
                                return c;
                            }
                            buffer.append(92);
                            break block30;
                        }
                        case 92: {
                            if (!escape) break block30;
                            buffer.append(c);
                            break block30;
                        }
                        case 117: {
                            if (!expand) {
                                buffer.append(92);
                                break block30;
                            } else {
                                if (regexp) {
                                    lexer.readUTFEscapeRegexpLiteral(buffer);
                                } else {
                                    lexer.readUTFEscape(buffer, true, symbol);
                                }
                                if (!hasNonAscii || buffer.getEncoding() == enc[0]) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                                break;
                            }
                        }
                        default: {
                            if (c == -1) {
                                return -1;
                            }
                            if (!lexer.isASCII(c)) {
                                if (!expand) {
                                    buffer.append(92);
                                }
                                hasNonAscii = true;
                                if (buffer.getEncoding() != enc[0]) {
                                    this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                                    break;
                                }
                                if (lexer.tokadd_mbchar(c, buffer)) continue block5;
                                lexer.compile_error(SyntaxException.PID.INVALID_MULTIBYTE_CHAR, "invalid multibyte char (" + enc[0] + ")");
                                break;
                            }
                            if (regexp) {
                                if (c == this.end && !this.simple_re_meta(c)) {
                                    buffer.append(c);
                                    break;
                                }
                                lexer.pushback(c);
                                this.parseEscapeIntoBuffer(lexer, buffer);
                                if (!hasNonAscii || buffer.getEncoding() == enc[0]) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                                break;
                            }
                            if (expand) {
                                lexer.pushback(c);
                                if (escape) {
                                    buffer.append(92);
                                }
                                c = lexer.readEscape();
                                break block30;
                            } else if (!(qwords && Character.isWhitespace(c) || c == this.end || this.begin != '\u0000' && c == this.begin)) {
                                buffer.append(92);
                                lexer.pushback(c);
                                break;
                            }
                            break block30;
                        }
                    }
                    continue;
                }
                if (!lexer.isASCII(c)) {
                    hasNonAscii = true;
                    if (buffer.getEncoding() != enc[0]) {
                        this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                        continue;
                    }
                    if (lexer.tokadd_mbchar(c, buffer)) continue;
                    lexer.compile_error(SyntaxException.PID.INVALID_MULTIBYTE_CHAR, "invalid multibyte char (" + enc[0] + ")");
                    continue;
                }
                if (qwords && Character.isWhitespace(c)) {
                    lexer.pushback(c);
                    break;
                }
            }
            if ((c & 0x80) != 0) {
                hasNonAscii = true;
                if (buffer.getEncoding() != enc[0]) {
                    this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                    continue;
                }
            }
            buffer.append(c);
        }
        enc[0] = buffer.getEncoding();
        return c;
    }

    private boolean simple_re_meta(int c) {
        switch (c) {
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 62: 
            case 63: 
            case 93: 
            case 94: 
            case 124: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private void escaped(RubyLexer lexer, TStringBuilder buffer) {
        int c = lexer.nextc();
        switch (c) {
            case 92: {
                this.parseEscapeIntoBuffer(lexer, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private void parseEscapeIntoBuffer(RubyLexer lexer, TStringBuilder buffer) {
        int c = lexer.nextc();
        block0 : switch (c) {
            case 10: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                buffer.append(92);
                buffer.append(c);
                for (int i = 0; i < 2; ++i) {
                    c = lexer.nextc();
                    if (c == -1) {
                        lexer.compile_error("Invalid escape character syntax");
                    }
                    if (!RubyLexer.isOctChar(c)) {
                        lexer.pushback(c);
                        break block0;
                    }
                    buffer.append(c);
                }
                break;
            }
            case 120: {
                buffer.append(92);
                buffer.append(c);
                c = lexer.nextc();
                if (!RubyLexer.isHexChar(c)) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(c);
                c = lexer.nextc();
                if (RubyLexer.isHexChar(c)) {
                    buffer.append(c);
                    break;
                }
                lexer.pushback(c);
                break;
            }
            case 77: {
                if (lexer.nextc() != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 77, 45});
                this.escaped(lexer, buffer);
                break;
            }
            case 67: {
                if (lexer.nextc() != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 67, 45});
                this.escaped(lexer, buffer);
                break;
            }
            case 99: {
                buffer.append(new byte[]{92, 99});
                this.escaped(lexer, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                buffer.append(92);
                buffer.append(c);
            }
        }
    }
}

