/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.lexer;

import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.DummyNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.encoding.EncodingManager;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.BytesKey;
import org.truffleruby.core.string.StringSupport;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.parser.SafeDoubleParser;
import org.truffleruby.parser.ast.BackRefParseNode;
import org.truffleruby.parser.ast.BigRationalParseNode;
import org.truffleruby.parser.ast.BignumParseNode;
import org.truffleruby.parser.ast.ComplexParseNode;
import org.truffleruby.parser.ast.FixnumParseNode;
import org.truffleruby.parser.ast.FloatParseNode;
import org.truffleruby.parser.ast.ListParseNode;
import org.truffleruby.parser.ast.NthRefParseNode;
import org.truffleruby.parser.ast.NumericParseNode;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.RationalParseNode;
import org.truffleruby.parser.ast.StrParseNode;
import org.truffleruby.parser.lexer.HeredocTerm;
import org.truffleruby.parser.lexer.LexerSource;
import org.truffleruby.parser.lexer.MagicCommentHandler;
import org.truffleruby.parser.lexer.StackState;
import org.truffleruby.parser.lexer.StrTerm;
import org.truffleruby.parser.lexer.StringTerm;
import org.truffleruby.parser.lexer.SyntaxException;
import org.truffleruby.parser.parser.ParserRopeOperations;
import org.truffleruby.parser.parser.ParserSupport;

public final class RubyLexer
implements MagicCommentHandler {
    private ParserSupport parserSupport = null;
    private RubyDeferredWarnings warnings;
    private StrTerm lex_strterm;
    private ByteArrayBuilder numberBuffer = new ByteArrayBuilder();
    public static final int EXPR_BEG = 1;
    public static final int EXPR_END = 2;
    public static final int EXPR_ENDARG = 4;
    public static final int EXPR_ENDFN = 8;
    public static final int EXPR_ARG = 16;
    public static final int EXPR_CMDARG = 32;
    public static final int EXPR_MID = 64;
    public static final int EXPR_FNAME = 128;
    public static final int EXPR_DOT = 256;
    public static final int EXPR_CLASS = 512;
    public static final int EXPR_LABEL = 1024;
    public static final int EXPR_LABELED = 2048;
    public static final int EXPR_FITEM = 4096;
    public static final int EXPR_VALUE = 1;
    public static final int EXPR_BEG_ANY = 577;
    public static final int EXPR_ARG_ANY = 48;
    public static final int EXPR_END_ANY = 14;
    private int lex_state;
    private int last_state;
    TruffleString lexb = null;
    public RubyEncoding encoding = null;
    public TruffleString.Encoding tencoding = null;
    private int lex_pbeg = 0;
    private int lex_p = 0;
    int lex_pend = 0;
    private int line_count = 0;
    int ruby_sourceline = 1;
    private int ruby_sourceline_char_offset = 0;
    private int ruby_sourceline_char_length = 0;
    private final LexerSource src;
    private boolean tokenSeen = false;
    private boolean has_shebang = false;
    private int endPosition = -1;
    private int token;
    private int tokp = 0;
    private Object yaccValue;
    private int ruby_sourceline_when_tokline_created;
    public SourceIndexLength tokline;
    private int heredoc_indent = 0;
    private int heredoc_line_indent = 0;
    private int heredoc_end = 0;
    public boolean eofp = false;
    private int parenNest = 0;
    private int braceNest = 0;
    public boolean commandStart;
    private StackState conditionState = new StackState();
    private StackState cmdArgumentState = new StackState();
    private TruffleString current_arg;
    public boolean inKwarg = false;
    private int last_cr_line;
    private int leftParenBegin = 0;
    public static final int TAB_WIDTH = 8;
    public static final int STR_FUNC_ESCAPE = 1;
    public static final int STR_FUNC_EXPAND = 2;
    public static final int STR_FUNC_REGEXP = 4;
    public static final int STR_FUNC_QWORDS = 8;
    public static final int STR_FUNC_SYMBOL = 16;
    public static final int STR_FUNC_INDENT = 32;
    public static final int STR_FUNC_LABEL = 64;
    public static final int STR_FUNC_LIST = 16384;
    public static final int STR_FUNC_TERM = 32768;
    public static final int str_label = 64;
    public static final int str_squote = 0;
    public static final int str_dquote = 2;
    public static final int str_xquote = 2;
    public static final int str_regexp = 7;
    public static final int str_sword = 16392;
    public static final int str_dword = 16394;
    public static final int str_ssym = 16;
    public static final int str_dsym = 18;
    public static final int EOF = -1;
    public static final TruffleString END_MARKER = TruffleString.fromByteArrayUncached((byte[])new byte[]{95, 95, 69, 78, 68, 95, 95}, (TruffleString.Encoding)TruffleString.Encoding.BYTES, (boolean)false);
    public static final TruffleString BEGIN_DOC_MARKER = TruffleString.fromByteArrayUncached((byte[])new byte[]{98, 101, 103, 105, 110}, (TruffleString.Encoding)TruffleString.Encoding.BYTES, (boolean)false);
    public static final TruffleString END_DOC_MARKER = TruffleString.fromByteArrayUncached((byte[])new byte[]{101, 110, 100}, (TruffleString.Encoding)TruffleString.Encoding.BYTES, (boolean)false);
    public static final TruffleString CODING = TruffleString.fromByteArrayUncached((byte[])new byte[]{99, 111, 100, 105, 110, 103}, (TruffleString.Encoding)TruffleString.Encoding.BYTES, (boolean)false);
    public static final int SUFFIX_R = 1;
    public static final int SUFFIX_I = 2;
    public static final int SUFFIX_ALL = 3;

    private BignumParseNode newBignumNode(String value, int radix) {
        return new BignumParseNode(this.getPosition(), new BigInteger(value, radix));
    }

    private FixnumParseNode newFixnumNode(String value, int radix) throws NumberFormatException {
        return new FixnumParseNode(this.getPosition(), Long.parseLong(value, radix));
    }

    private ParseNode newRationalNode(String value, int radix) throws NumberFormatException {
        try {
            return new RationalParseNode(this.getPosition(), Long.parseLong(value, radix), 1L);
        }
        catch (NumberFormatException e) {
            return new BigRationalParseNode(this.getPosition(), new BigInteger(value, radix), BigInteger.ONE);
        }
    }

    private ComplexParseNode newComplexNode(NumericParseNode number) {
        return new ComplexParseNode(this.getPosition(), number);
    }

    protected void ambiguousOperator(String op, String syn) {
        this.warnings.warning(this.getFile(), this.getPosition().toSourceSection(this.src.getSource()).getStartLine(), "`" + op + "' after local variable or literal is interpreted as binary operator");
        this.warnings.warning(this.getFile(), this.getPosition().toSourceSection(this.src.getSource()).getStartLine(), "even though it seems like " + syn);
    }

    public Source getSource() {
        return this.src.getSource();
    }

    public static Keyword getKeyword(String str) {
        return Keyword.Maps.FROM_STRING.get(str);
    }

    public static Keyword getKeyword(TruffleString tstring, RubyEncoding encoding) {
        return Keyword.Maps.FROM_BYTES.get(new BytesKey(TStringUtils.getBytesOrCopy((AbstractTruffleString)tstring, encoding), null));
    }

    public int tokenize_ident(int result) {
        TruffleString value = this.createTokenRope();
        if (RubyLexer.isLexState(this.last_state, 384) && this.parserSupport.getCurrentScope().isDefined(value.toJavaStringUncached().intern()) >= 0) {
            this.setState(2);
        }
        this.yaccValue = value;
        return result;
    }

    public RubyLexer(ParserSupport support, LexerSource source, RubyDeferredWarnings warnings) {
        this.src = source;
        this.parserSupport = support;
        this.warnings = warnings;
        this.reset();
    }

    public void reset() {
        this.superReset();
        this.lex_strterm = null;
        this.ruby_sourceline = 1;
        this.updateLineOffset();
        --this.ruby_sourceline;
        this.encoding = this.src.getRubyEncoding();
        this.tencoding = this.encoding.tencoding;
        this.parser_prepare();
    }

    public int nextc() {
        if (this.lex_p == this.lex_pend) {
            if (this.eofp) {
                return -1;
            }
            TruffleString line = this.src.gets();
            if (line == null) {
                this.eofp = true;
                this.lex_goto_eol();
                return -1;
            }
            if (this.heredoc_end > 0) {
                this.ruby_sourceline = this.heredoc_end;
                this.updateLineOffset();
                this.heredoc_end = 0;
            }
            ++this.ruby_sourceline;
            this.updateLineOffset();
            ++this.line_count;
            this.lex_p = 0;
            this.lex_pbeg = 0;
            this.lex_pend = this.lex_p + line.byteLength(this.tencoding);
            this.lexb = line;
            this.flush();
        }
        int c = this.p(this.lex_p);
        ++this.lex_p;
        if (c == 13) {
            if (this.peek(10)) {
                ++this.lex_p;
                c = 10;
            } else if (this.ruby_sourceline > this.last_cr_line) {
                this.last_cr_line = this.ruby_sourceline;
                this.warnings.warn(this.getFile(), this.ruby_sourceline, "encountered \\r in middle of line, treated as a mere space");
                c = 32;
            }
        }
        return c;
    }

    public void heredoc_dedent(ParseNode root) {
        int indent = this.heredoc_indent;
        if (indent <= 0 || root == null) {
            return;
        }
        if (root instanceof StrParseNode) {
            StrParseNode str = (StrParseNode)root;
            str.setValue(this.dedent_string(str.getTStringWithEncoding(), indent));
        } else if (root instanceof ListParseNode) {
            ListParseNode list = (ListParseNode)root;
            int length = list.size();
            int currentLine = 0;
            for (int i = 0; i < length; ++i) {
                ParseNode child = list.get(i);
                int line = child.getPosition().toSourceSection(this.src.getSource()).getStartLine();
                if (currentLine == line) continue;
                currentLine = line;
                if (!(child instanceof StrParseNode)) continue;
                StrParseNode childStrNode = (StrParseNode)child;
                childStrNode.setValue(this.dedent_string(childStrNode.getTStringWithEncoding(), indent));
            }
        }
    }

    public void compile_error(String message) {
        throw new SyntaxException(SyntaxException.PID.BAD_HEX_NUMBER, this.getFile(), this.ruby_sourceline, message);
    }

    public void compile_error(SyntaxException.PID pid, String message) {
        throw new SyntaxException(pid, this.getFile(), this.ruby_sourceline, message);
    }

    void heredoc_restore(HeredocTerm here) {
        TruffleString line;
        this.lexb = line = here.lastLine;
        this.lex_pbeg = 0;
        this.lex_pend = this.lex_pbeg + line.byteLength(this.tencoding);
        this.lex_p = this.lex_pbeg + here.nth;
        this.heredoc_end = this.ruby_sourceline;
        this.ruby_sourceline = here.line;
        this.updateLineOffset();
        this.flush();
    }

    public int nextToken() {
        this.token = this.yylex();
        return this.token == -1 ? 0 : this.token;
    }

    public SourceIndexLength getPosition() {
        if (this.tokline != null && this.ruby_sourceline == this.ruby_sourceline_when_tokline_created) {
            return this.tokline;
        }
        assert (this.sourceSectionsMatch());
        return new SourceIndexLength(this.ruby_sourceline_char_offset, this.ruby_sourceline_char_length);
    }

    private boolean sourceSectionsMatch() {
        int line = this.ruby_sourceline;
        if (line == 0) {
            line = 1;
        }
        SourceSection sectionFromOffsets = this.src.getSource().createSection(this.ruby_sourceline_char_offset, this.ruby_sourceline_char_length);
        SourceSection sectionFromLine = this.src.getSource().createSection(line);
        assert (sectionFromLine.getStartLine() == line);
        assert (sectionFromOffsets.getStartLine() == line);
        assert (sectionFromLine.getCharIndex() == sectionFromOffsets.getCharIndex());
        assert (sectionFromLine.getCharLength() == sectionFromOffsets.getCharLength());
        return true;
    }

    public void updateLineOffset() {
        if (this.ruby_sourceline != 0) {
            this.ruby_sourceline_char_offset = this.src.getSource().getLineStartOffset(this.ruby_sourceline);
            this.ruby_sourceline_char_length = this.src.getSource().getLineLength(this.ruby_sourceline);
        }
    }

    protected void setCompileOptionFlag(String name, TruffleString value) {
        if (this.tokenSeen) {
            this.warnings.warning(this.getFile(), this.getPosition().toSourceSection(this.src.getSource()).getStartLine(), "`" + name + "' is ignored after any tokens");
            return;
        }
        int b = this.asTruth(name, value);
        if (b < 0) {
            return;
        }
        if (name.equals("frozen_string_literal")) {
            this.parserSupport.getConfiguration().setFrozenStringLiteral(b == 1);
        } else if (name.equals("truffleruby_primitives")) {
            this.parserSupport.getConfiguration().allowTruffleRubyPrimitives = b == 1;
        } else {
            this.compile_error("Unknown compile option flag: " + name);
        }
    }

    protected int asTruth(String name, TruffleString value) {
        if (value.toJavaStringUncached().equalsIgnoreCase("true")) {
            return 1;
        }
        if (value.toJavaStringUncached().equalsIgnoreCase("false")) {
            return 0;
        }
        this.warnings.warn("invalid value for " + name + ": " + value);
        return -1;
    }

    protected void setTokenInfo(String name, TruffleString value) {
    }

    protected void setEncoding(TruffleString name) {
        RubyContext context = this.parserSupport.getConfiguration().getContext();
        String nameString = name.toJavaStringUncached();
        Encoding newEncoding = EncodingManager.getEncoding(nameString);
        if (newEncoding == null) {
            throw this.argumentError(context, "unknown encoding name: " + nameString);
        }
        if (!newEncoding.isAsciiCompatible()) {
            throw this.argumentError(context, nameString + " is not ASCII compatible");
        }
        if (!this.src.isFromTruffleString() && !this.isUTF8Subset(newEncoding)) {
            String description = this.src.getSourcePath().equals("-e") ? "program from an -e argument" : "Polyglot API Source";
            throw this.argumentError(context, String.format("%s cannot be used as an encoding for a %s as it is not UTF-8 or a subset of UTF-8", nameString, description));
        }
        this.setEncoding(newEncoding);
    }

    private boolean isUTF8Subset(Encoding encoding) {
        return encoding == UTF8Encoding.INSTANCE || encoding == USASCIIEncoding.INSTANCE;
    }

    private RuntimeException argumentError(RubyContext context, String message) {
        if (context != null) {
            return new RaiseException(context, context.getCoreExceptions().argumentError(message, null));
        }
        return new UnsupportedOperationException(message);
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strterm) {
        this.lex_strterm = strterm;
    }

    public void setWarnings(RubyDeferredWarnings warnings) {
        this.warnings = warnings;
    }

    private int considerComplex(int token, int suffix) {
        if ((suffix & 2) == 0) {
            return token;
        }
        this.yaccValue = this.newComplexNode((NumericParseNode)this.yaccValue);
        return 381;
    }

    private int getFloatToken(String number, int suffix) {
        double d;
        if ((suffix & 1) != 0) {
            BigDecimal bd = new BigDecimal(number);
            BigDecimal denominator = BigDecimal.ONE.scaleByPowerOfTen(bd.scale());
            BigDecimal numerator = bd.multiply(denominator);
            try {
                this.yaccValue = new RationalParseNode(this.getPosition(), numerator.longValueExact(), denominator.longValueExact());
            }
            catch (ArithmeticException ae) {
                this.compile_error(SyntaxException.PID.RATIONAL_OUT_OF_RANGE, "Rational (" + numerator + "/" + denominator + ") out of range.");
            }
            return this.considerComplex(383, suffix);
        }
        try {
            d = SafeDoubleParser.parseDouble(number);
        }
        catch (NumberFormatException e) {
            this.warnings.warn(this.getFile(), this.getPosition().toSourceSection(this.src.getSource()).getStartLine(), "Float " + number + " out of range.");
            d = number.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        this.yaccValue = new FloatParseNode(this.getPosition(), d);
        return this.considerComplex(382, suffix);
    }

    private int getIntegerToken(String value, int radix, int suffix) {
        ParseNode literalValue;
        if ((suffix & 1) != 0) {
            literalValue = this.newRationalNode(value, radix);
        } else {
            try {
                literalValue = this.newFixnumNode(value, radix);
            }
            catch (NumberFormatException e) {
                literalValue = this.newBignumNode(value, radix);
            }
        }
        this.yaccValue = literalValue;
        return this.considerComplex(380, suffix);
    }

    public StrParseNode createStr(TStringBuilder buffer, int flags) {
        return this.createStr(buffer.toTString(), buffer.getRubyEncoding(), flags);
    }

    public StrParseNode createStr(TruffleString bufferTString, RubyEncoding bufferEncoding, int flags) {
        TStringWithEncoding buffer = new TStringWithEncoding(bufferTString, bufferEncoding);
        if ((flags & 4) == 0 && bufferEncoding.isAsciiCompatible && !buffer.isAsciiOnly() && this.encoding == Encodings.US_ASCII && bufferEncoding != Encodings.UTF_8) {
            assert (!buffer.isAsciiOnly());
            buffer = buffer.forceEncoding(Encodings.BINARY);
        }
        StrParseNode newStr = new StrParseNode(this.getPosition(), buffer);
        if (this.parserSupport.getConfiguration().isFrozenStringLiteral()) {
            newStr.setFrozen(true);
        }
        return newStr;
    }

    private int parseQuote(int c) {
        int end;
        boolean shortHand;
        int begin;
        if (!Character.isLetterOrDigit(c)) {
            begin = c;
            c = 81;
            shortHand = true;
        } else {
            shortHand = false;
            begin = this.nextc();
            if (Character.isLetterOrDigit(begin)) {
                this.compile_error(SyntaxException.PID.STRING_UNKNOWN_TYPE, "unknown type of %string");
            }
        }
        if (c == -1 || begin == -1) {
            this.compile_error(SyntaxException.PID.STRING_HITS_EOF, "unterminated quoted string meets end of file");
        }
        switch (begin) {
            case 40: {
                end = 41;
                break;
            }
            case 91: {
                end = 93;
                break;
            }
            case 123: {
                end = 125;
                break;
            }
            case 60: {
                end = 62;
                break;
            }
            default: {
                end = begin;
                begin = 0;
            }
        }
        switch (c) {
            case 81: {
                this.lex_strterm = new StringTerm(2, begin, end, this.ruby_sourceline);
                this.yaccValue = "%" + (shortHand ? "" + end : "" + c + begin);
                return 367;
            }
            case 113: {
                this.lex_strterm = new StringTerm(0, begin, end, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin;
                return 367;
            }
            case 87: {
                this.lex_strterm = new StringTerm(16394, begin, end, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin;
                return 370;
            }
            case 119: {
                this.lex_strterm = new StringTerm(16392, begin, end, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin;
                return 371;
            }
            case 120: {
                this.lex_strterm = new StringTerm(2, begin, end, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin;
                return 368;
            }
            case 114: {
                this.lex_strterm = new StringTerm(7, begin, end, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin;
                return 369;
            }
            case 115: {
                this.lex_strterm = new StringTerm(16, begin, end, this.ruby_sourceline);
                this.setState(4224);
                this.yaccValue = "%" + c + begin;
                return 366;
            }
            case 73: {
                this.lex_strterm = new StringTerm(16394, begin, end, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin;
                return 385;
            }
            case 105: {
                this.lex_strterm = new StringTerm(16392, begin, end, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin;
                return 386;
            }
        }
        this.compile_error(SyntaxException.PID.STRING_UNKNOWN_TYPE, "unknown type of %string");
        return -1;
    }

    @SuppressFBWarnings(value={"INT", "DB"})
    private int hereDocumentIdentifier() {
        TruffleString markerValue;
        int term;
        int c = this.nextc();
        int indent = 0;
        int func = 0;
        if (c == 45) {
            c = this.nextc();
            func = 32;
        } else if (c == 126) {
            c = this.nextc();
            func = 32;
            indent = Integer.MAX_VALUE;
        }
        if (c == 39 || c == 34 || c == 96) {
            func = c == 39 ? (func |= 0) : (c == 34 ? (func |= 2) : (func |= 2));
            this.newtok(false);
            term = c;
            while ((c = this.nextc()) != -1 && c != term) {
                if (this.tokadd_mbchar(c)) continue;
                return -1;
            }
            if (c == -1) {
                this.compile_error("unterminated here document identifier");
            }
            assert (c == term);
            this.pushback(term);
            markerValue = this.createTokenByteArrayView();
            this.nextc();
        } else {
            if (!this.isIdentifierChar(c)) {
                this.pushback(c);
                if ((func & 0x20) != 0) {
                    this.pushback(this.heredoc_indent > 0 ? 126 : 45);
                }
                return 0;
            }
            this.newtok(true);
            term = 34;
            func |= 2;
            do {
                if (this.tokadd_mbchar(c)) continue;
                return -1;
            } while ((c = this.nextc()) != -1 && this.isIdentifierChar(c));
            this.pushback(c);
            markerValue = this.createTokenByteArrayView();
        }
        int len = this.lex_p - this.lex_pbeg;
        this.lex_goto_eol();
        this.lex_strterm = new HeredocTerm(markerValue, func, len, this.ruby_sourceline, this.lexb);
        if (term == 96) {
            this.yaccValue = TStringConstants.BACKTICK;
            this.flush();
            return 368;
        }
        this.yaccValue = TStringConstants.QQ;
        this.heredoc_indent = indent;
        this.heredoc_line_indent = 0;
        this.flush();
        return 367;
    }

    private boolean arg_ambiguous() {
        this.warnings.warning(this.getFile(), this.getPosition().toSourceSection(this.src.getSource()).getStartLine(), "Ambiguous first argument; make sure.");
        return true;
    }

    @SuppressFBWarnings(value={"SF"})
    private int yylex() {
        int c;
        TruffleSafepoint.poll((Node)DummyNode.INSTANCE);
        boolean spaceSeen = false;
        boolean tokenSeen = this.tokenSeen;
        if (this.lex_strterm != null) {
            return this.lex_strterm.parseString(this);
        }
        boolean commandState = this.commandStart;
        this.commandStart = false;
        this.tokenSeen = true;
        block43: while (true) {
            this.last_state = this.lex_state;
            c = this.nextc();
            switch (c) {
                case -1: 
                case 0: 
                case 4: 
                case 26: {
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    this.getPosition();
                    spaceSeen = true;
                    continue block43;
                }
                case 35: {
                    this.tokenSeen = tokenSeen;
                    if (!tokenSeen && !RubyLexer.parser_magic_comment(new TStringWithEncoding(this.lexb, this.encoding), this.lex_p, this.lex_pend - this.lex_p, this.src.parserRopeOperations, this) && this.comment_at_top()) {
                        this.set_file_encoding(this.lex_p, this.lex_pend);
                    }
                    this.lex_p = this.lex_pend;
                }
                case 10: {
                    boolean normalArg;
                    this.tokenSeen = tokenSeen;
                    boolean bl = normalArg = RubyLexer.isLexState(this.lex_state, 897) && !RubyLexer.isLexState(this.lex_state, 2048);
                    if (normalArg || this.isLexStateAll(this.lex_state, 2064)) {
                        if (normalArg || !this.inKwarg) continue block43;
                        this.commandStart = true;
                        this.setState(1);
                        return 10;
                    }
                    boolean done = false;
                    block44: while (!done) {
                        c = this.nextc();
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                spaceSeen = true;
                                continue block44;
                            }
                            case 35: {
                                this.pushback(c);
                                continue block43;
                            }
                            case 38: 
                            case 46: {
                                if (this.peek(46) != (c == 38)) break;
                                this.pushback(c);
                                continue block43;
                            }
                        }
                        done = true;
                    }
                    if (c == -1) {
                        return -1;
                    }
                    this.pushback(c);
                    this.getPosition();
                    this.commandStart = true;
                    this.setState(1);
                    return 10;
                }
                case 42: {
                    return this.star(spaceSeen);
                }
                case 33: {
                    return this.bang();
                }
                case 61: {
                    if (this.was_bol() && this.strncmp(this.src.parserRopeOperations.makeShared((AbstractTruffleString)this.lexb, this.lex_p, this.lex_pend - this.lex_p), BEGIN_DOC_MARKER, BEGIN_DOC_MARKER.byteLength(TruffleString.Encoding.BYTES)) && Character.isWhitespace(this.p(this.lex_p + 5))) {
                        do {
                            this.lex_goto_eol();
                            c = this.nextc();
                            if (c != -1) continue;
                            this.compile_error("embedded document meets end of file");
                            return -1;
                        } while (c != 61 || !this.strncmp(this.src.parserRopeOperations.makeShared((AbstractTruffleString)this.lexb, this.lex_p, this.lex_pend - this.lex_p), END_DOC_MARKER, END_DOC_MARKER.byteLength(TruffleString.Encoding.BYTES)) || this.lex_p + 3 != this.lex_pend && !Character.isWhitespace(this.p(this.lex_p + 3)));
                        this.lex_goto_eol();
                        continue block43;
                    }
                    this.setState(this.isAfterOperator() ? 16 : 1);
                    c = this.nextc();
                    if (c == 61) {
                        c = this.nextc();
                        if (c == 61) {
                            this.yaccValue = TStringConstants.EQ_EQ_EQ;
                            return 319;
                        }
                        this.pushback(c);
                        this.yaccValue = TStringConstants.EQ_EQ;
                        return 318;
                    }
                    if (c == 126) {
                        this.yaccValue = TStringConstants.EQ_TILDE;
                        return 325;
                    }
                    if (c == 62) {
                        this.yaccValue = TStringConstants.EQ_GT;
                        return 340;
                    }
                    this.pushback(c);
                    this.yaccValue = TStringConstants.EQ;
                    return 61;
                }
                case 60: {
                    return this.lessThan(spaceSeen);
                }
                case 62: {
                    return this.greaterThan();
                }
                case 34: {
                    return this.doubleQuote(commandState);
                }
                case 96: {
                    return this.backtick(commandState);
                }
                case 39: {
                    return this.singleQuote(commandState);
                }
                case 63: {
                    return this.questionMark();
                }
                case 38: {
                    return this.ampersand(spaceSeen);
                }
                case 124: {
                    return this.pipe();
                }
                case 43: {
                    return this.plus(spaceSeen);
                }
                case 45: {
                    return this.minus(spaceSeen);
                }
                case 46: {
                    return this.dot();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(c);
                }
                case 41: {
                    return this.rightParen();
                }
                case 93: {
                    return this.rightBracket();
                }
                case 125: {
                    return this.rightCurly();
                }
                case 58: {
                    return this.colon(spaceSeen);
                }
                case 47: {
                    return this.slash(spaceSeen);
                }
                case 94: {
                    return this.caret();
                }
                case 59: {
                    this.commandStart = true;
                    this.setState(1);
                    this.yaccValue = TStringConstants.SEMICOLON;
                    return 59;
                }
                case 44: {
                    return this.comma(c);
                }
                case 126: {
                    return this.tilde();
                }
                case 40: {
                    return this.leftParen(spaceSeen);
                }
                case 91: {
                    return this.leftBracket(spaceSeen);
                }
                case 123: {
                    return this.leftCurly();
                }
                case 92: {
                    c = this.nextc();
                    if (c == 10) {
                        spaceSeen = true;
                        continue block43;
                    }
                    this.pushback(c);
                    this.yaccValue = TStringConstants.BACKSLASH;
                    return 92;
                }
                case 37: {
                    return this.percent(spaceSeen);
                }
                case 36: {
                    return this.dollar();
                }
                case 64: {
                    return this.at();
                }
                case 95: {
                    if (this.was_bol() && this.whole_match_p(END_MARKER, TruffleString.Encoding.BYTES, false)) {
                        this.endPosition = this.src.getOffset();
                        this.eofp = true;
                        this.lex_goto_eol();
                        return -1;
                    }
                    return this.identifier(c, commandState);
                }
            }
            break;
        }
        return this.identifier(c, commandState);
    }

    private int identifierToken(int result, TruffleString value) {
        if (result == 305 && !RubyLexer.isLexState(this.last_state, 384) && this.parserSupport.getCurrentScope().isDefined(value.toJavaStringUncached().intern()) >= 0) {
            this.setState(1026);
        }
        this.yaccValue = value;
        return result;
    }

    private int ampersand(boolean spaceSeen) {
        int c = this.nextc();
        switch (c) {
            case 38: {
                this.setState(1);
                c = this.nextc();
                if (c == 61) {
                    this.yaccValue = TStringConstants.AMPERSAND_AMPERSAND;
                    this.setState(1);
                    return 339;
                }
                this.pushback(c);
                this.yaccValue = TStringConstants.AMPERSAND_AMPERSAND;
                return 323;
            }
            case 61: {
                this.yaccValue = TStringConstants.AMPERSAND;
                this.setState(1);
                return 339;
            }
            case 46: {
                this.setState(256);
                this.yaccValue = TStringConstants.AMPERSAND_DOT;
                return 336;
            }
        }
        this.pushback(c);
        SourceIndexLength tmpPosition = this.getPosition();
        if (this.isSpaceArg(c, spaceSeen)) {
            this.warnings.warning(this.getFile(), tmpPosition.toSourceSection(this.src.getSource()).getStartLine(), "`&' interpreted as argument prefix");
            c = 351;
        } else if (this.isBEG()) {
            c = 351;
        } else {
            this.warn_balanced(c, spaceSeen, "&", "argument prefix");
            c = 352;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.yaccValue = TStringConstants.AMPERSAND;
        return c;
    }

    private static boolean hasShebangLine(InternalByteArray bytes) {
        return bytes.getLength() > 2 && bytes.get(0) == 35 && bytes.get(1) == 33;
    }

    private static int newLineIndex(InternalByteArray bytes, int start) {
        int index = com.oracle.truffle.api.ArrayUtils.indexOf((byte[])bytes.getArray(), (int)(bytes.getOffset() + start), (int)bytes.getEnd(), (byte[])new byte[]{10});
        if (index < 0) {
            return bytes.getLength();
        }
        return index - bytes.getOffset();
    }

    public static void parseMagicComment(TStringWithEncoding source, BiConsumer<String, String> magicCommentHandler) {
        InternalByteArray bytes = source.getInternalByteArray();
        int length = bytes.getLength();
        int start = 0;
        if (RubyLexer.hasShebangLine(bytes)) {
            start = RubyLexer.newLineIndex(bytes, 2) + 1;
        }
        while (start < length && StringSupport.isAsciiSpace(bytes.get(start)) && bytes.get(start) != 10) {
            ++start;
        }
        if (start < length && bytes.get(start) == 35) {
            int magicLineStart;
            int endOfMagicLine;
            if ((endOfMagicLine = RubyLexer.newLineIndex(bytes, magicLineStart = ++start)) < length) {
                ++endOfMagicLine;
            }
            int magicLineLength = endOfMagicLine - magicLineStart;
            RubyEncoding rubyEncoding = source.getEncoding();
            RubyLexer.parser_magic_comment(source, magicLineStart, magicLineLength, new ParserRopeOperations(rubyEncoding), (name, value) -> {
                magicCommentHandler.accept(name, value.toJavaStringUncached());
                return RubyLexer.isKnownMagicComment(name);
            });
        }
    }

    private static boolean parser_magic_comment(TStringWithEncoding magicLine, int magicLineOffset, int magicLineLength, ParserRopeOperations parserRopeOperations, MagicCommentHandler magicCommentHandler) {
        boolean emacsStyle = false;
        int i = magicLineOffset;
        int end = magicLineOffset + magicLineLength;
        if (magicLineLength <= 7) {
            return false;
        }
        int emacsBegin = RubyLexer.findEmacsStyleMarker(magicLine, 0, end);
        if (emacsBegin >= 0) {
            int emacsEnd = RubyLexer.findEmacsStyleMarker(magicLine, emacsBegin, end);
            if (emacsEnd < 0) {
                return false;
            }
            emacsStyle = true;
            i = emacsBegin;
            end = emacsEnd - 3;
        }
        while (i < end) {
            TruffleString value;
            String name;
            int valueEnd;
            int valueBegin;
            int c;
            int c2;
            while (i < end && (RubyLexer.isIgnoredMagicLineCharacter(c2 = magicLine.get(i)) || StringSupport.isAsciiSpace(c2))) {
                ++i;
            }
            int nameBegin = i;
            while (i < end && !RubyLexer.isIgnoredMagicLineCharacter(c = magicLine.get(i)) && !StringSupport.isAsciiSpace(c)) {
                ++i;
            }
            int nameEnd = i;
            while (i < end && StringSupport.isAsciiSpace(magicLine.get(i))) {
                ++i;
            }
            if (i == end) break;
            int sep = magicLine.get(i);
            if (sep == 58) {
                ++i;
            } else {
                if (emacsStyle) continue;
                return false;
            }
            while (i < end && StringSupport.isAsciiSpace(magicLine.get(i))) {
                ++i;
            }
            if (i == end) break;
            if (magicLine.get(i) == 34) {
                valueBegin = ++i;
                while (i < end && magicLine.get(i) != 34) {
                    if (magicLine.get(i) == 92) {
                        i += 2;
                        continue;
                    }
                    ++i;
                }
                valueEnd = i;
                if (i < end) {
                    ++i;
                }
            } else {
                int c3;
                valueBegin = i;
                while (i < end && (c3 = magicLine.get(i)) != 34 && c3 != 59 && !StringSupport.isAsciiSpace(c3)) {
                    ++i;
                }
                valueEnd = i;
            }
            if (emacsStyle) {
                while (i < end && (magicLine.get(i) == 59 || StringSupport.isAsciiSpace(magicLine.get(i)))) {
                    ++i;
                }
            } else {
                while (i < end && StringSupport.isAsciiSpace(magicLine.get(i))) {
                    ++i;
                }
                if (i < end) {
                    return false;
                }
            }
            if (magicCommentHandler.onMagicComment(name = magicLine.substring(nameBegin, nameEnd - nameBegin).toJavaString().replace('-', '_'), value = magicLine.substringAsTString(valueBegin, valueEnd - valueBegin))) continue;
            return false;
        }
        return true;
    }

    private static boolean isIgnoredMagicLineCharacter(int c) {
        switch (c) {
            case 34: 
            case 39: 
            case 58: 
            case 59: {
                return true;
            }
        }
        return false;
    }

    private static int findEmacsStyleMarker(TStringWithEncoding str, int begin, int end) {
        InternalByteArray bytes = str.getInternalByteArray();
        int i = begin;
        block4: while (i < end) {
            switch (bytes.get(i)) {
                case 45: {
                    if (i >= 2 && bytes.get(i - 1) == 42 && bytes.get(i - 2) == 45) {
                        return i + 1;
                    }
                    i += 2;
                    continue block4;
                }
                case 42: {
                    if (i + 1 >= end) {
                        return -1;
                    }
                    if (bytes.get(i + 1) != 45) {
                        i += 4;
                        continue block4;
                    }
                    if (bytes.get(i - 1) != 45) {
                        i += 2;
                        continue block4;
                    }
                    return i + 2;
                }
            }
            i += 3;
        }
        return -1;
    }

    @Override
    public boolean onMagicComment(String name, TruffleString value) {
        if (RubyLexer.isMagicEncodingComment(name)) {
            this.magicCommentEncoding(value);
            return true;
        }
        if ("frozen_string_literal".equalsIgnoreCase(name)) {
            this.setCompileOptionFlag("frozen_string_literal", value);
            return true;
        }
        if ("truffleruby_primitives".equalsIgnoreCase(name)) {
            this.setCompileOptionFlag("truffleruby_primitives", value);
            return true;
        }
        if ("warn_indent".equalsIgnoreCase(name)) {
            this.setTokenInfo(name, value);
            return true;
        }
        return false;
    }

    private static boolean isKnownMagicComment(String name) {
        if (RubyLexer.isMagicEncodingComment(name)) {
            return true;
        }
        if ("frozen_string_literal".equalsIgnoreCase(name)) {
            return true;
        }
        if ("warn_indent".equalsIgnoreCase(name)) {
            return true;
        }
        return "truffleruby_primitives".equalsIgnoreCase(name);
    }

    public static boolean isMagicEncodingComment(String name) {
        return "coding".equalsIgnoreCase(name) || "encoding".equalsIgnoreCase(name);
    }

    private int at() {
        int result;
        this.newtok(true);
        int c = this.nextc();
        if (c == 64) {
            c = this.nextc();
            result = 310;
        } else {
            result = 308;
        }
        if (c == -1 || RubyLexer.isSpace(c)) {
            if (result == 308) {
                this.compile_error("`@' without identifiers is not allowed as an instance variable name");
            }
            this.compile_error("`@@' without identifiers is not allowed as a class variable name");
        } else if (Character.isDigit(c) || !this.isIdentifierChar(c)) {
            this.pushback(c);
            if (result == 308) {
                this.compile_error(SyntaxException.PID.IVAR_BAD_NAME, "`@" + (char)c + "' is not allowed as an instance variable name");
            }
            this.compile_error(SyntaxException.PID.CVAR_BAD_NAME, "`@@" + (char)c + "' is not allowed as a class variable name");
        }
        if (!this.tokadd_ident(c)) {
            return -1;
        }
        this.last_state = this.lex_state;
        this.setState(2);
        return this.tokenize_ident(result);
    }

    private int backtick(boolean commandState) {
        this.yaccValue = TStringConstants.BACKTICK;
        if (RubyLexer.isLexState(this.lex_state, 128)) {
            this.setState(8);
            return 365;
        }
        if (RubyLexer.isLexState(this.lex_state, 256)) {
            this.setState(commandState ? 32 : 16);
            return 365;
        }
        this.lex_strterm = new StringTerm(2, 0, 96, this.ruby_sourceline);
        return 368;
    }

    private int bang() {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = TStringConstants.BANG;
                return 361;
            }
        } else {
            this.setState(1);
        }
        switch (c) {
            case 61: {
                this.yaccValue = TStringConstants.BANG_EQ;
                return 320;
            }
            case 126: {
                this.yaccValue = TStringConstants.BANG_TILDE;
                return 326;
            }
        }
        this.pushback(c);
        this.yaccValue = TStringConstants.BANG;
        return 361;
    }

    private int caret() {
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.yaccValue = TStringConstants.CARET;
            return 339;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.pushback(c);
        this.yaccValue = TStringConstants.CARET;
        return 362;
    }

    private int colon(boolean spaceSeen) {
        int c = this.nextc();
        if (c == 58) {
            if (this.isBEG() || RubyLexer.isLexState(this.lex_state, 512) || this.isARG() && spaceSeen) {
                this.setState(1);
                this.yaccValue = TStringConstants.COLON_COLON;
                return 338;
            }
            this.setState(256);
            this.yaccValue = TStringConstants.COLON_COLON;
            return 337;
        }
        if (this.isEND() || Character.isWhitespace(c) || c == 35) {
            this.pushback(c);
            this.setState(1);
            this.yaccValue = TStringConstants.COLON;
            this.warn_balanced(c, spaceSeen, ":", "symbol literal");
            return 58;
        }
        switch (c) {
            case 39: {
                this.lex_strterm = new StringTerm(16, 0, c, this.ruby_sourceline);
                break;
            }
            case 34: {
                this.lex_strterm = new StringTerm(18, 0, c, this.ruby_sourceline);
                break;
            }
            default: {
                this.pushback(c);
            }
        }
        this.setState(128);
        this.yaccValue = TStringConstants.COLON;
        return 366;
    }

    private int comma(int c) {
        this.setState(1025);
        this.yaccValue = TStringConstants.COMMA;
        return c;
    }

    private int doKeyword(int state) {
        int leftParenBegin = this.getLeftParenBegin();
        if (leftParenBegin > 0 && leftParenBegin == this.parenNest) {
            this.setLeftParenBegin(0);
            --this.parenNest;
            return 304;
        }
        if (this.conditionState.isInState()) {
            return 280;
        }
        if (this.cmdArgumentState.isInState() && !RubyLexer.isLexState(state, 32)) {
            return 281;
        }
        if (RubyLexer.isLexState(state, 5)) {
            return 281;
        }
        return 279;
    }

    @SuppressFBWarnings(value={"SF"})
    private int dollar() {
        this.setState(2);
        this.newtok(true);
        int c = this.nextc();
        switch (c) {
            case 95: {
                c = this.nextc();
                if (this.isIdentifierChar(c)) {
                    if (!this.tokadd_ident(c)) {
                        return -1;
                    }
                    this.last_state = this.lex_state;
                    this.yaccValue = this.createTokenRope();
                    return 307;
                }
                this.pushback(c);
                c = 95;
            }
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 126: {
                this.yaccValue = TruffleString.fromByteArrayUncached((byte[])new byte[]{36, (byte)c}, (TruffleString.Encoding)TruffleString.Encoding.US_ASCII, (boolean)false);
                return 307;
            }
            case 45: {
                c = this.nextc();
                if (this.isIdentifierChar(c)) {
                    if (!this.tokadd_mbchar(c)) {
                        return -1;
                    }
                } else {
                    this.pushback(c);
                    this.pushback(45);
                    return 36;
                }
                this.yaccValue = this.createTokenRope();
                return 307;
            }
            case 38: 
            case 39: 
            case 43: 
            case 96: {
                if (RubyLexer.isLexState(this.last_state, 128)) {
                    this.yaccValue = TruffleString.fromByteArrayUncached((byte[])new byte[]{36, (byte)c}, (TruffleString.Encoding)TruffleString.Encoding.US_ASCII, (boolean)false);
                    return 307;
                }
                this.yaccValue = new BackRefParseNode(this.getPosition(), c);
                return 378;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int ref;
                while (Character.isDigit(c = this.nextc())) {
                }
                this.pushback(c);
                if (RubyLexer.isLexState(this.last_state, 128)) {
                    this.yaccValue = this.createTokenRope();
                    return 307;
                }
                String refAsString = this.createTokenRope().toJavaStringUncached();
                try {
                    ref = Integer.parseInt(refAsString.substring(1).intern());
                }
                catch (NumberFormatException e) {
                    this.warnings.warn("`" + refAsString + "' is too big for a number variable, always nil");
                    ref = 0;
                }
                this.yaccValue = new NthRefParseNode(this.getPosition(), ref);
                return 377;
            }
            case 48: {
                return this.identifierToken(307, TStringConstants.DOLLAR_ZERO);
            }
        }
        if (!this.isIdentifierChar(c)) {
            if (c == -1 || RubyLexer.isSpace(c)) {
                this.compile_error(SyntaxException.PID.CVAR_BAD_NAME, "`$' without identifiers is not allowed as a global variable name");
            } else {
                this.pushback(c);
                this.compile_error(SyntaxException.PID.CVAR_BAD_NAME, "`$" + (char)c + "' is not allowed as a global variable name");
            }
        }
        this.last_state = this.lex_state;
        this.setState(2);
        this.tokadd_ident(c);
        return this.identifierToken(307, this.createTokenRope());
    }

    private int dot() {
        boolean isBeg = this.isBEG();
        this.setState(1);
        int c = this.nextc();
        if (c == 46) {
            c = this.nextc();
            if (c == 46) {
                this.yaccValue = TStringConstants.DOT_DOT_DOT;
                return isBeg ? 331 : 329;
            }
            this.pushback(c);
            this.yaccValue = TStringConstants.DOT_DOT;
            return isBeg ? 330 : 328;
        }
        this.pushback(c);
        if (Character.isDigit(c)) {
            this.compile_error(SyntaxException.PID.FLOAT_MISSING_ZERO, "no .<digit> floating literal anymore; put 0 before dot");
        }
        this.setState(256);
        this.yaccValue = TStringConstants.DOT;
        return 327;
    }

    private int doubleQuote(boolean commandState) {
        int label = this.isLabelPossible(commandState) ? 64 : 0;
        this.lex_strterm = new StringTerm(2 | label, 0, 34, this.ruby_sourceline);
        this.yaccValue = TStringConstants.QQ;
        return 367;
    }

    private int greaterThan() {
        this.setState(this.isAfterOperator() ? 16 : 1);
        int c = this.nextc();
        switch (c) {
            case 61: {
                this.yaccValue = TStringConstants.GT_EQ;
                return 321;
            }
            case 62: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = TStringConstants.GT_GT;
                    return 339;
                }
                this.pushback(c);
                this.yaccValue = TStringConstants.GT_GT;
                return 335;
            }
        }
        this.pushback(c);
        this.yaccValue = TStringConstants.GT;
        return 359;
    }

    private int identifier(int c, boolean commandState) {
        Keyword keyword;
        TruffleString tempVal;
        if (!this.isIdentifierChar(c)) {
            String badChar = "\\" + Integer.toOctalString(c & 0xFF);
            this.compile_error(SyntaxException.PID.CHARACTER_BAD, "Invalid char `" + badChar + "' ('" + (char)c + "') in expression");
        }
        this.newtok(true);
        do {
            if (this.tokadd_mbchar(c)) continue;
            return -1;
        } while (this.isIdentifierChar(c = this.nextc()));
        boolean lastBangOrPredicate = false;
        if (c == 33 || c == 63) {
            if (!this.peek(61)) {
                lastBangOrPredicate = true;
            } else {
                this.pushback(c);
            }
        } else {
            this.pushback(c);
        }
        int result = 0;
        this.last_state = this.lex_state;
        if (lastBangOrPredicate) {
            result = 306;
            tempVal = this.createTokenRope();
        } else {
            if (RubyLexer.isLexState(this.lex_state, 128)) {
                c = this.nextc();
                if (c == 61) {
                    int c2 = this.nextc();
                    if (c2 != 126 && c2 != 62 && (c2 != 61 || this.peek(62))) {
                        result = 305;
                        this.pushback(c2);
                    } else {
                        this.pushback(c2);
                        this.pushback(c);
                    }
                } else {
                    this.pushback(c);
                }
            }
            tempVal = this.createTokenRope();
            result = result == 0 && this.isFirstCodepointUppercase(tempVal) ? 309 : 305;
        }
        if (this.isLabelPossible(commandState) && this.isLabelSuffix()) {
            this.setState(2064);
            this.nextc();
            this.yaccValue = tempVal;
            return 311;
        }
        if (this.lex_state != 256 && (keyword = RubyLexer.getKeyword(tempVal, this.encoding)) != null) {
            int state = this.lex_state;
            this.setState(keyword.state);
            if (RubyLexer.isLexState(state, 128)) {
                this.yaccValue = keyword.bytes;
                return keyword.id0;
            }
            this.yaccValue = this.getPosition();
            if (RubyLexer.isLexState(this.lex_state, 1)) {
                this.commandStart = true;
            }
            if (keyword.id0 == 279) {
                return this.doKeyword(state);
            }
            if (RubyLexer.isLexState(state, 2049)) {
                return keyword.id0;
            }
            if (keyword.id0 != keyword.id1) {
                this.setState(1025);
            }
            return keyword.id1;
        }
        if (RubyLexer.isLexState(this.lex_state, 881)) {
            this.setState(commandState ? 32 : 16);
        } else if (this.lex_state == 128) {
            this.setState(8);
        } else {
            this.setState(2);
        }
        return this.identifierToken(result, tempVal);
    }

    private int leftBracket(boolean spaceSeen) {
        ++this.parenNest;
        int c = 91;
        if (this.isAfterOperator()) {
            this.setState(16);
            c = this.nextc();
            if (c == 93) {
                if (this.peek(61)) {
                    this.nextc();
                    this.yaccValue = TStringConstants.LBRACKET_RBRACKET_EQ;
                    return 333;
                }
                this.yaccValue = TStringConstants.LBRACKET_RBRACKET;
                return 332;
            }
            this.pushback(c);
            this.setState(this.getState() | 0x400);
            this.yaccValue = TStringConstants.LBRACKET;
            return 91;
        }
        if (this.isBEG() || this.isARG() && (spaceSeen || RubyLexer.isLexState(this.lex_state, 2048))) {
            c = 345;
        }
        this.setState(1025);
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.yaccValue = TStringConstants.LBRACKET;
        return c;
    }

    private int leftCurly() {
        ++this.braceNest;
        int leftParenBegin = this.getLeftParenBegin();
        if (leftParenBegin > 0 && leftParenBegin == this.parenNest) {
            this.setState(1);
            this.setLeftParenBegin(0);
            --this.parenNest;
            this.conditionState.stop();
            this.cmdArgumentState.stop();
            this.yaccValue = TStringConstants.LCURLY;
            return 376;
        }
        int c = RubyLexer.isLexState(this.lex_state, 2048) ? 347 : (RubyLexer.isLexState(this.lex_state, 58) ? 363 : (RubyLexer.isLexState(this.lex_state, 4) ? 348 : 347));
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.setState(1);
        if (c != 348) {
            this.setState(this.getState() | 0x400);
        }
        if (c != 347) {
            this.commandStart = true;
        }
        this.yaccValue = this.getPosition();
        return c;
    }

    private int leftParen(boolean spaceSeen) {
        int result = this.isBEG() ? 341 : (this.isSpaceArg(40, spaceSeen) ? 344 : 342);
        ++this.parenNest;
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.setState(1025);
        this.yaccValue = this.getPosition();
        return result;
    }

    private int lessThan(boolean spaceSeen) {
        int tok;
        this.last_state = this.lex_state;
        int c = this.nextc();
        if (!(c != 60 || RubyLexer.isLexState(this.lex_state, 768) || this.isEND() || this.isARG() && !RubyLexer.isLexState(this.lex_state, 2048) && !spaceSeen || (tok = this.hereDocumentIdentifier()) == 0)) {
            return tok;
        }
        if (this.isAfterOperator()) {
            this.setState(16);
        } else {
            if (RubyLexer.isLexState(this.lex_state, 512)) {
                this.commandStart = true;
            }
            this.setState(1);
        }
        switch (c) {
            case 61: {
                c = this.nextc();
                if (c == 62) {
                    this.yaccValue = TStringConstants.LT_EQ_GT;
                    return 317;
                }
                this.pushback(c);
                this.yaccValue = TStringConstants.LT_EQ;
                return 322;
            }
            case 60: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = TStringConstants.LT_LT;
                    return 339;
                }
                this.pushback(c);
                this.yaccValue = TStringConstants.LT_LT;
                this.warn_balanced(c, spaceSeen, "<<", "here document");
                return 334;
            }
        }
        this.yaccValue = TStringConstants.LT;
        this.pushback(c);
        return 358;
    }

    private int minus(boolean spaceSeen) {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = TStringConstants.MINUS_AT;
                return 314;
            }
            this.pushback(c);
            this.yaccValue = TStringConstants.MINUS;
            return 357;
        }
        if (c == 61) {
            this.setState(1);
            this.yaccValue = TStringConstants.MINUS;
            return 339;
        }
        if (c == 62) {
            this.setState(8);
            this.yaccValue = TStringConstants.MINUS_GT;
            return 375;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen) && this.arg_ambiguous()) {
            this.setState(1);
            this.pushback(c);
            this.yaccValue = TStringConstants.MINUS_AT;
            if (Character.isDigit(c)) {
                return 315;
            }
            return 314;
        }
        this.setState(1);
        this.pushback(c);
        this.yaccValue = TStringConstants.MINUS;
        this.warn_balanced(c, spaceSeen, "-", "unary operator");
        return 357;
    }

    private int percent(boolean spaceSeen) {
        if (this.isBEG()) {
            return this.parseQuote(this.nextc());
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.yaccValue = TStringConstants.PERCENT;
            return 339;
        }
        if (this.isSpaceArg(c, spaceSeen)) {
            return this.parseQuote(c);
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.pushback(c);
        this.yaccValue = TStringConstants.PERCENT;
        this.warn_balanced(c, spaceSeen, "%", "string literal");
        return 354;
    }

    private int pipe() {
        int c = this.nextc();
        switch (c) {
            case 124: {
                this.setState(1);
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = TStringConstants.OR_OR;
                    return 339;
                }
                this.pushback(c);
                this.yaccValue = TStringConstants.OR_OR;
                return 324;
            }
            case 61: {
                this.setState(1);
                this.yaccValue = TStringConstants.OR;
                return 339;
            }
        }
        this.setState(this.isAfterOperator() ? 16 : 1025);
        this.pushback(c);
        this.yaccValue = TStringConstants.OR;
        return 360;
    }

    private int plus(boolean spaceSeen) {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = TStringConstants.PLUS_AT;
                return 313;
            }
            this.pushback(c);
            this.yaccValue = TStringConstants.PLUS;
            return 356;
        }
        if (c == 61) {
            this.setState(1);
            this.yaccValue = TStringConstants.PLUS;
            return 339;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen) && this.arg_ambiguous()) {
            this.setState(1);
            this.pushback(c);
            if (Character.isDigit(c)) {
                c = 43;
                return this.parseNumber(c);
            }
            this.yaccValue = TStringConstants.PLUS_AT;
            return 313;
        }
        this.setState(1);
        this.pushback(c);
        this.yaccValue = TStringConstants.PLUS;
        this.warn_balanced(c, spaceSeen, "+", "unary operator");
        return 356;
    }

    private int questionMark() {
        if (this.isEND()) {
            this.setState(1);
            this.yaccValue = TStringConstants.QUESTION;
            return 63;
        }
        int c = this.nextc();
        if (c == -1) {
            this.compile_error(SyntaxException.PID.INCOMPLETE_CHAR_SYNTAX, "incomplete character syntax");
        }
        if (Character.isWhitespace(c)) {
            if (!this.isARG()) {
                int c2 = 0;
                switch (c) {
                    case 32: {
                        c2 = 115;
                        break;
                    }
                    case 10: {
                        c2 = 110;
                        break;
                    }
                    case 9: {
                        c2 = 116;
                        break;
                    }
                    case 13: {
                        c2 = 114;
                        break;
                    }
                    case 12: {
                        c2 = 102;
                    }
                }
                if (c2 != 0) {
                    this.warnings.warn(this.getFile(), this.getPosition().toSourceSection(this.src.getSource()).getStartLine(), "invalid character syntax; use ?\\" + c2);
                }
            }
            this.pushback(c);
            this.setState(1);
            this.yaccValue = TStringConstants.QUESTION;
            return 63;
        }
        if (!this.isASCII(c)) {
            if (!this.tokadd_mbchar(c)) {
                return -1;
            }
        } else {
            if (this.isIdentifierChar(c) && !this.peek(10) && this.isNext_identchar()) {
                this.newtok(true);
                this.pushback(c);
                this.setState(1);
                this.yaccValue = TStringConstants.QUESTION;
                return 63;
            }
            if (c == 92) {
                if (this.peek(117)) {
                    this.nextc();
                    TStringBuilder oneCharBL = new TStringBuilder();
                    oneCharBL.setEncoding(this.encoding);
                    c = this.readUTFEscape(oneCharBL, false, false);
                    if (c >= 128) {
                        this.tokaddmbc(c, oneCharBL);
                    } else {
                        oneCharBL.append(c);
                    }
                    this.setState(2);
                    this.yaccValue = new StrParseNode(this.getPosition(), oneCharBL.toTStringWithEnc());
                    return 312;
                }
                c = this.readEscape();
            } else {
                this.newtok(true);
            }
        }
        this.yaccValue = new StrParseNode(this.getPosition(), TStringConstants.BINARY_SINGLE_BYTE[c], Encodings.BINARY);
        this.setState(2);
        return 312;
    }

    private int rightBracket() {
        --this.parenNest;
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(2);
        this.yaccValue = TStringConstants.RBRACKET;
        return 346;
    }

    private int rightCurly() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(2);
        this.yaccValue = TStringConstants.RCURLY;
        int tok = this.braceNest == 0 ? 388 : 364;
        --this.braceNest;
        return tok;
    }

    private int rightParen() {
        --this.parenNest;
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(8);
        this.yaccValue = TStringConstants.RPAREN;
        return 343;
    }

    private int singleQuote(boolean commandState) {
        int label = this.isLabelPossible(commandState) ? 64 : 0;
        this.lex_strterm = new StringTerm(0 | label, 0, 39, this.ruby_sourceline);
        this.yaccValue = TStringConstants.Q;
        return 367;
    }

    private int slash(boolean spaceSeen) {
        if (this.isBEG()) {
            this.lex_strterm = new StringTerm(7, 0, 47, this.ruby_sourceline);
            this.yaccValue = TStringConstants.SLASH;
            return 369;
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.yaccValue = TStringConstants.SLASH;
            return 339;
        }
        this.pushback(c);
        if (this.isSpaceArg(c, spaceSeen)) {
            this.arg_ambiguous();
            this.lex_strterm = new StringTerm(7, 0, 47, this.ruby_sourceline);
            this.yaccValue = TStringConstants.SLASH;
            return 369;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.yaccValue = TStringConstants.SLASH;
        this.warn_balanced(c, spaceSeen, "/", "regexp literal");
        return 355;
    }

    private int star(boolean spaceSeen) {
        int c = this.nextc();
        switch (c) {
            case 42: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = TStringConstants.STAR_STAR;
                    return 339;
                }
                this.pushback(c);
                this.yaccValue = TStringConstants.STAR_STAR;
                if (this.isSpaceArg(c, spaceSeen)) {
                    this.warnings.warning(this.getFile(), this.getPosition().toSourceSection(this.src.getSource()).getStartLine(), "`**' interpreted as argument prefix");
                    c = 387;
                    break;
                }
                if (this.isBEG()) {
                    c = 387;
                    break;
                }
                this.warn_balanced(c, spaceSeen, "**", "argument prefix");
                c = 316;
                break;
            }
            case 61: {
                this.setState(1);
                this.yaccValue = TStringConstants.STAR;
                return 339;
            }
            default: {
                this.pushback(c);
                if (this.isSpaceArg(c, spaceSeen)) {
                    this.warnings.warning(this.getFile(), this.getPosition().toSourceSection(this.src.getSource()).getStartLine(), "`*' interpreted as argument prefix");
                    c = 349;
                } else if (this.isBEG()) {
                    c = 349;
                } else {
                    this.warn_balanced(c, spaceSeen, "*", "argument prefix");
                    c = 350;
                }
                this.yaccValue = TStringConstants.STAR;
            }
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        return c;
    }

    private int tilde() {
        if (this.isAfterOperator()) {
            int c = this.nextc();
            if (c != 64) {
                this.pushback(c);
            }
            this.setState(16);
        } else {
            this.setState(1);
        }
        this.yaccValue = TStringConstants.TILDE;
        return 353;
    }

    @SuppressFBWarnings(value={"SF"})
    private int parseNumber(int c) {
        this.setState(2);
        this.newtok(true);
        this.numberBuffer.clear();
        if (c == 45) {
            this.numberBuffer.append((char)c);
            c = this.nextc();
        } else if (c == 43) {
            c = this.nextc();
        }
        int nondigit = 0;
        if (c == 48) {
            int startLen = this.numberBuffer.getLength();
            c = this.nextc();
            switch (c) {
                case 88: 
                case 120: {
                    c = this.nextc();
                    if (RubyLexer.isHexChar(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!RubyLexer.isHexChar(c)) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.getLength() == startLen) {
                        this.compile_error(SyntaxException.PID.BAD_HEX_NUMBER, "Hexadecimal number without hex-digits.");
                    } else if (nondigit != 0) {
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                    }
                    return this.getIntegerToken(this.numberBuffer.toString(), 16, this.numberLiteralSuffix(3));
                }
                case 66: 
                case 98: {
                    c = this.nextc();
                    if (c == 48 || c == 49) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (c != 48 && c != 49) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.getLength() == startLen) {
                        this.compile_error(SyntaxException.PID.EMPTY_BINARY_NUMBER, "Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                    }
                    return this.getIntegerToken(this.numberBuffer.toString(), 2, this.numberLiteralSuffix(3));
                }
                case 68: 
                case 100: {
                    c = this.nextc();
                    if (Character.isDigit(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!Character.isDigit(c)) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.getLength() == startLen) {
                        this.compile_error(SyntaxException.PID.EMPTY_BINARY_NUMBER, "Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                    }
                    return this.getIntegerToken(this.numberBuffer.toString(), 10, this.numberLiteralSuffix(3));
                }
                case 79: 
                case 111: {
                    c = this.nextc();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 95: {
                    while (true) {
                        if (c == 95) {
                            if (nondigit != 0) break;
                            nondigit = c;
                        } else {
                            if (c < 48 || c > 55) break;
                            nondigit = 0;
                            this.numberBuffer.append((char)c);
                        }
                        c = this.nextc();
                    }
                    if (this.numberBuffer.getLength() > startLen) {
                        this.pushback(c);
                        if (nondigit != 0) {
                            this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                        }
                        return this.getIntegerToken(this.numberBuffer.toString(), 8, this.numberLiteralSuffix(3));
                    }
                }
                case 56: 
                case 57: {
                    this.compile_error(SyntaxException.PID.BAD_OCTAL_DIGIT, "Illegal octal digit.");
                }
                case 46: 
                case 69: 
                case 101: {
                    this.numberBuffer.append(48);
                    break;
                }
                default: {
                    this.pushback(c);
                    this.numberBuffer.append(48);
                    return this.getIntegerToken(this.numberBuffer.toString(), 10, this.numberLiteralSuffix(3));
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    nondigit = 0;
                    this.numberBuffer.append((char)c);
                    break;
                }
                case 46: {
                    if (nondigit != 0) {
                        this.pushback(c);
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                        break;
                    }
                    if (seen_point || seen_e) {
                        this.pushback(c);
                        return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    int c2 = this.nextc();
                    if (!Character.isDigit(c2)) {
                        this.pushback(c2);
                        this.pushback(46);
                        if (c == 95) break;
                        return this.getIntegerToken(this.numberBuffer.toString(), 10, this.numberLiteralSuffix(3));
                    }
                    this.numberBuffer.append(46);
                    this.numberBuffer.append((char)c2);
                    seen_point = true;
                    nondigit = 0;
                    break;
                }
                case 69: 
                case 101: {
                    if (nondigit != 0) {
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                        break;
                    }
                    if (seen_e) {
                        this.pushback(c);
                        return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    this.numberBuffer.append((char)c);
                    seen_e = true;
                    nondigit = c;
                    c = this.nextc();
                    if (c == 45 || c == 43) {
                        this.numberBuffer.append((char)c);
                        nondigit = c;
                        break;
                    }
                    this.pushback(c);
                    break;
                }
                case 95: {
                    if (nondigit != 0) {
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.pushback(c);
                    return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                }
            }
            c = this.nextc();
        }
    }

    private int getNumberToken(String number, boolean seen_e, boolean seen_point, int nondigit) {
        boolean isFloat;
        boolean bl = isFloat = seen_e || seen_point;
        if (nondigit != 0) {
            this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
        } else if (isFloat) {
            int suffix = this.numberLiteralSuffix(seen_e ? 2 : 3);
            return this.getFloatToken(number, suffix);
        }
        return this.getIntegerToken(number, 10, this.numberLiteralSuffix(3));
    }

    public void readUTFEscapeRegexpLiteral(TStringBuilder buffer) {
        buffer.append(92);
        buffer.append(117);
        if (this.peek(123)) {
            do {
                buffer.append(this.nextc());
                if (this.scanHexLiteral(buffer, 6, false, "invalid Unicode escape") <= 0x10FFFF) continue;
                this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "invalid Unicode codepoint (too large)");
            } while (this.peek(32) || this.peek(9));
            int c = this.nextc();
            if (c != 125) {
                this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "unterminated Unicode escape");
            }
            buffer.append((char)c);
        } else {
            this.scanHexLiteral(buffer, 4, true, "Invalid Unicode escape");
        }
    }

    public int readUTFEscape(TStringBuilder buffer, boolean stringLiteral, boolean symbolLiteral) {
        int codepoint;
        if (this.peek(123)) {
            do {
                this.nextc();
                codepoint = this.scanHex(6, false, "invalid Unicode escape");
                if (codepoint > 0x10FFFF) {
                    this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "invalid Unicode codepoint (too large)");
                }
                if (buffer == null) continue;
                this.readUTF8EscapeIntoBuffer(codepoint, buffer, stringLiteral);
            } while (this.peek(32) || this.peek(9));
            int c = this.nextc();
            if (c != 125) {
                this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "unterminated Unicode escape");
            }
        } else {
            codepoint = this.scanHex(4, true, "Invalid Unicode escape");
            if (buffer != null) {
                this.readUTF8EscapeIntoBuffer(codepoint, buffer, stringLiteral);
            }
        }
        return codepoint;
    }

    private void readUTF8EscapeIntoBuffer(int codepoint, TStringBuilder buffer, boolean stringLiteral) {
        if (codepoint >= 128) {
            buffer.setEncoding(Encodings.UTF_8);
            if (stringLiteral) {
                this.tokaddmbc(codepoint, buffer);
            }
        } else if (stringLiteral) {
            buffer.append((char)codepoint);
        }
    }

    @SuppressFBWarnings(value={"SF"})
    public int readEscape() {
        int c = this.nextc();
        switch (c) {
            case 92: {
                return c;
            }
            case 110: {
                return 10;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 102: {
                return 12;
            }
            case 118: {
                return 11;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.pushback(c);
                return this.scanOct(3);
            }
            case 120: {
                return this.scanHex(2, false, "Invalid escape character syntax");
            }
            case 98: {
                return 8;
            }
            case 115: {
                return 32;
            }
            case 77: {
                c = this.nextc();
                if (c != 45) {
                    this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "Invalid escape character syntax");
                } else {
                    c = this.nextc();
                    if (c == 92) {
                        return (char)(this.readEscape() | 0x80);
                    }
                    if (c == -1) {
                        this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "Invalid escape character syntax");
                    }
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 67: {
                if (this.nextc() != 45) {
                    this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "Invalid escape character syntax");
                }
            }
            case 99: {
                c = this.nextc();
                if (c == 92) {
                    c = this.readEscape();
                } else {
                    if (c == 63) {
                        return 127;
                    }
                    if (c == -1) {
                        this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "Invalid escape character syntax");
                    }
                }
                return (char)(c & 0x9F);
            }
            case -1: {
                this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "Invalid escape character syntax");
            }
        }
        return c;
    }

    private int scanHexLiteral(TStringBuilder buffer, int count, boolean strict, String errorMessage) {
        int i;
        int hexValue = 0;
        for (i = 0; i < count; ++i) {
            int h1 = this.nextc();
            if (!RubyLexer.isHexChar(h1)) {
                this.pushback(h1);
                break;
            }
            buffer.append(h1);
            hexValue <<= 4;
            hexValue |= Integer.parseInt(String.valueOf((char)h1), 16) & 0xF;
        }
        if (i == 0 || strict && count != i) {
            this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, errorMessage);
        }
        return hexValue;
    }

    private int scanHex(int count, boolean strict, String errorMessage) {
        int i;
        int hexValue = 0;
        for (i = 0; i < count; ++i) {
            int h1 = this.nextc();
            if (!RubyLexer.isHexChar(h1)) {
                this.pushback(h1);
                break;
            }
            hexValue <<= 4;
            hexValue |= Integer.parseInt("" + (char)h1, 16) & 0xF;
        }
        if (i == 0 || strict && count != i) {
            this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, errorMessage);
        }
        return hexValue;
    }

    private boolean comment_at_top() {
        int pend = this.lex_p - 1;
        if (this.line_count != (this.has_shebang ? 2 : 1)) {
            return false;
        }
        for (int p = this.lex_pbeg; p < pend; ++p) {
            if (StringSupport.isAsciiSpace(this.p(p))) continue;
            return false;
        }
        return true;
    }

    public TruffleString createTokenByteArrayView() {
        return this.src.parserRopeOperations.makeShared((AbstractTruffleString)this.lexb, this.tokp, this.lex_p - this.tokp);
    }

    public TruffleString createTokenRope(int start) {
        return this.lexb.substringByteIndexUncached(start, this.lex_p - start, this.tencoding, true);
    }

    public TruffleString createTokenRope() {
        return this.createTokenRope(this.tokp);
    }

    private TruffleString dedent_string(TStringWithEncoding string, int width) {
        int i;
        int len = string.byteLength();
        int col = 0;
        for (i = 0; i < len && col < width; ++i) {
            int n;
            if (string.get(i) == 32) {
                ++col;
                continue;
            }
            if (string.get(i) != 9 || (n = 8 * (col / 8 + 1)) > width) break;
            col = n;
        }
        return string.substringAsTString(i, len - i);
    }

    private void flush() {
        this.tokp = this.lex_p;
    }

    public int getBraceNest() {
        return this.braceNest;
    }

    public StackState getCmdArgumentState() {
        return this.cmdArgumentState;
    }

    public StackState getConditionState() {
        return this.conditionState;
    }

    public TruffleString getCurrentArg() {
        return this.current_arg;
    }

    public String getCurrentLine() {
        return this.lexb.toJavaStringUncached();
    }

    public Encoding getEncoding() {
        assert (this.encoding.jcoding == this.src.getEncoding());
        return this.encoding.jcoding;
    }

    public TruffleString.Encoding getTEncoding() {
        return this.tencoding;
    }

    public String getFile() {
        return this.src.getSourcePath();
    }

    public int getLineOffset() {
        return this.src.getLineOffset();
    }

    public int getHeredocIndent() {
        return this.heredoc_indent;
    }

    public int getLeftParenBegin() {
        return this.leftParenBegin;
    }

    public int getState() {
        return this.lex_state;
    }

    public int incrementParenNest() {
        ++this.parenNest;
        return this.parenNest;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public boolean isASCII(int c) {
        return c < 128;
    }

    public int peekVariableName(int tSTRING_DVAR, int tSTRING_DBEG) {
        int c = this.nextc();
        int significant = -1;
        switch (c) {
            case 36: {
                int c2 = this.nextc();
                if (c2 == 45) {
                    int c3 = this.nextc();
                    if (c3 == -1) {
                        this.pushback(c3);
                        this.pushback(c2);
                        return 0;
                    }
                    significant = c3;
                    this.pushback(c3);
                    this.pushback(c2);
                    break;
                }
                if (this.isGlobalCharPunct(c2)) {
                    this.setValue("#" + (char)c2);
                    this.pushback(c2);
                    this.pushback(c);
                    return tSTRING_DVAR;
                }
                significant = c2;
                this.pushback(c2);
                break;
            }
            case 64: {
                int c2 = this.nextc();
                if (c2 == 64) {
                    int c3 = this.nextc();
                    if (c3 == -1) {
                        this.pushback(c3);
                        this.pushback(c2);
                        return 0;
                    }
                    significant = c3;
                    this.pushback(c3);
                    this.pushback(c2);
                    break;
                }
                significant = c2;
                this.pushback(c2);
                break;
            }
            case 123: {
                this.setValue("#" + (char)c);
                this.commandStart = true;
                return tSTRING_DBEG;
            }
            default: {
                return 0;
            }
        }
        if (significant != -1 && Character.isAlphabetic(significant) || significant == 95) {
            this.pushback(c);
            this.setValue("#" + significant);
            return tSTRING_DVAR;
        }
        return 0;
    }

    public boolean isGlobalCharPunct(int c) {
        switch (c) {
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 95: 
            case 96: 
            case 126: {
                return true;
            }
        }
        return this.isIdentifierChar(c);
    }

    public boolean isIdentifierChar(int c) {
        return c != -1 && (Character.isLetterOrDigit(c) || c == 95 || !this.isASCII(c));
    }

    public void lex_goto_eol() {
        this.lex_p = this.lex_pend;
    }

    protected void magicCommentEncoding(TruffleString encoding) {
        if (!this.comment_at_top()) {
            return;
        }
        this.setEncoding(encoding);
    }

    public void newtok(boolean unreadOnce) {
        this.tokline = this.getPosition();
        this.ruby_sourceline_when_tokline_created = this.ruby_sourceline;
        this.tokp = this.lex_p - (unreadOnce ? 1 : 0);
    }

    protected int numberLiteralSuffix(int mask) {
        int c = this.nextc();
        if (c == 105) {
            return (mask & 2) != 0 ? mask & 2 : 0;
        }
        if (c == 114) {
            int result = 0;
            if ((mask & 1) != 0) {
                result |= mask & 1;
            }
            if (this.peek(105) && (mask & 2) != 0) {
                c = this.nextc();
                result |= mask & 2;
            }
            return result;
        }
        if (c == 46) {
            int c2 = this.nextc();
            if (Character.isDigit(c2)) {
                this.compile_error("unexpected fraction part after numeric literal");
                while (this.isIdentifierChar(c2 = this.nextc())) {
                }
            } else {
                this.pushback(c2);
            }
        }
        this.pushback(c);
        return 0;
    }

    public void parser_prepare() {
        int c = this.nextc();
        switch (c) {
            case 35: {
                if (!this.peek(33)) break;
                this.has_shebang = true;
                break;
            }
            case 239: {
                if (this.lex_pend - this.lex_p < 2 || this.p(this.lex_p) != 187 || this.p(this.lex_p + 1) != 191) break;
                this.setEncoding((Encoding)UTF8Encoding.INSTANCE);
                this.lex_p += 2;
                this.lex_pbeg = this.lex_p;
                return;
            }
            case -1: {
                return;
            }
        }
        this.pushback(c);
    }

    public int p(int offset) {
        return this.lexb.readByteUncached(offset, this.tencoding);
    }

    public boolean peek(int c) {
        return this.peek(c, 0);
    }

    protected boolean peek(int c, int n) {
        return this.lex_p + n < this.lex_pend && this.p(this.lex_p + n) == c;
    }

    public int precise_mbclen() {
        if (!this.lexb.isValidUncached(this.tencoding)) {
            this.compile_error("invalid multibyte char (" + this.getEncoding() + ")");
        }
        if (TStringUtils.isSingleByteOptimizable((AbstractTruffleString)this.lexb, this.encoding)) {
            return 1;
        }
        int start = this.lex_p - 1;
        return this.lexb.byteLengthOfCodePointUncached(start, this.tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
    }

    public void pushback(int c) {
        if (c == -1) {
            return;
        }
        --this.lex_p;
        if (this.lex_p > this.lex_pbeg && this.p(this.lex_p) == 10 && this.p(this.lex_p - 1) == 13) {
            --this.lex_p;
        }
    }

    public void superReset() {
        this.braceNest = 0;
        this.commandStart = true;
        this.heredoc_indent = 0;
        this.heredoc_line_indent = 0;
        this.last_cr_line = -1;
        this.parenNest = 0;
        this.ruby_sourceline = 1;
        this.token = 0;
        this.tokenSeen = false;
        this.tokp = 0;
        this.yaccValue = null;
        this.setState(0);
        this.resetStacks();
    }

    public void resetStacks() {
        this.conditionState.reset();
        this.cmdArgumentState.reset();
    }

    protected int scanOct(int count) {
        int value = 0;
        for (int i = 0; i < count; ++i) {
            int c = this.nextc();
            if (!RubyLexer.isOctChar(c)) {
                this.pushback(c);
                break;
            }
            value <<= 3;
            value |= Integer.parseInt(String.valueOf((char)c), 8);
        }
        return value;
    }

    public void setCurrentArg(TruffleString current_arg) {
        this.current_arg = current_arg;
    }

    public void setEncoding(Encoding jcoding) {
        this.src.setEncoding(jcoding);
        RubyEncoding prevEncoding = this.encoding;
        this.encoding = Encodings.getBuiltInEncoding(jcoding);
        this.tencoding = this.encoding.tencoding;
        this.lexb = this.lexb.forceEncodingUncached(prevEncoding.tencoding, this.tencoding);
    }

    protected void set_file_encoding(int str, int send) {
        boolean sep = false;
        block9: while (true) {
            if (send - str <= 6) {
                return;
            }
            switch (this.p(str + 6)) {
                case 67: 
                case 99: {
                    str += 6;
                    continue block9;
                }
                case 79: 
                case 111: {
                    str += 5;
                    continue block9;
                }
                case 68: 
                case 100: {
                    str += 4;
                    continue block9;
                }
                case 73: 
                case 105: {
                    str += 3;
                    continue block9;
                }
                case 78: 
                case 110: {
                    str += 2;
                    continue block9;
                }
                case 71: 
                case 103: {
                    ++str;
                    continue block9;
                }
                case 58: 
                case 61: {
                    sep = true;
                    str += 6;
                    break;
                }
                default: {
                    if (!Character.isSpaceChar(this.p(str += 6))) continue block9;
                }
            }
            if (this.src.parserRopeOperations.makeShared((AbstractTruffleString)this.lexb, str - 6, 6).toJavaStringUncached().equalsIgnoreCase("coding")) break;
        }
        while (true) {
            if (++str >= send) {
                return;
            }
            if (Character.isSpaceChar(this.p(str))) continue;
            if (sep) break;
            if (this.p(str) != 61 && this.p(str) != 58) {
                return;
            }
            sep = true;
            ++str;
        }
        int beg = str;
        while ((this.p(str) == 45 || this.p(str) == 95 || Character.isLetterOrDigit(this.p(str))) && ++str < send) {
        }
        this.setEncoding(this.src.parserRopeOperations.makeShared((AbstractTruffleString)this.lexb, beg, str - beg));
    }

    public void setHeredocLineIndent(int heredoc_line_indent) {
        this.heredoc_line_indent = heredoc_line_indent;
    }

    public void setHeredocIndent(int heredoc_indent) {
        this.heredoc_indent = heredoc_indent;
    }

    public void setBraceNest(int nest) {
        this.braceNest = nest;
    }

    public void setLeftParenBegin(int value) {
        this.leftParenBegin = value;
    }

    public void setState(int state) {
        this.lex_state = state;
    }

    public void setValue(Object yaccValue) {
        this.yaccValue = yaccValue;
    }

    protected boolean strncmp(TruffleString one, TruffleString two, int length) {
        return one.regionEqualByteIndexUncached(0, (AbstractTruffleString)two, 0, length, this.tencoding);
    }

    public void tokAdd(int first_byte, TStringBuilder buffer) {
        buffer.append((byte)first_byte);
    }

    public void tokCopy(int length, TStringBuilder buffer) {
        InternalByteArray bytes = this.lexb.getInternalByteArrayUncached(this.tencoding);
        buffer.append(ArrayUtils.extractRange(bytes.getArray(), bytes.getOffset() + this.lex_p - length, bytes.getOffset() + this.lex_p));
    }

    public boolean tokadd_ident(int c) {
        do {
            if (this.tokadd_mbchar(c)) continue;
            return false;
        } while (this.isIdentifierChar(c = this.nextc()));
        this.pushback(c);
        return true;
    }

    public boolean tokadd_mbchar(int firstByte) {
        int length = this.precise_mbclen();
        if (length <= 0) {
            this.compile_error("invalid multibyte char (" + this.getEncoding() + ")");
        }
        this.lex_p += length - 1;
        return true;
    }

    public boolean tokadd_mbchar(int firstByte, TStringBuilder buffer) {
        int length = this.precise_mbclen();
        if (length <= 0) {
            this.compile_error("invalid multibyte char (" + this.getEncoding() + ")");
        }
        this.tokAdd(firstByte, buffer);
        this.lex_p += length - 1;
        if (length > 1) {
            this.tokCopy(length - 1, buffer);
        }
        return true;
    }

    public void tokaddmbc(int codepoint, TStringBuilder buffer) {
        Encoding encoding = buffer.getEncoding();
        int length = encoding.codeToMbcLength(codepoint);
        byte[] bytes = Arrays.copyOf(buffer.getBytes(), buffer.getLength() + length);
        encoding.codeToMbc(codepoint, bytes, buffer.getLength());
        buffer.clear();
        buffer.append(bytes);
    }

    public boolean update_heredoc_indent(int c) {
        if (this.heredoc_line_indent == -1) {
            if (c == 10) {
                this.heredoc_line_indent = 0;
            }
            return false;
        }
        if (c == 32) {
            ++this.heredoc_line_indent;
            return true;
        }
        if (c == 9) {
            int w = this.heredoc_line_indent / 8 + 1;
            this.heredoc_line_indent = w * 8;
            return true;
        }
        if (c == 10) {
            return false;
        }
        if (this.heredoc_indent > this.heredoc_line_indent) {
            this.heredoc_indent = this.heredoc_line_indent;
        }
        this.heredoc_line_indent = -1;
        return false;
    }

    public void validateFormalIdentifier(TruffleString identifier) {
        if (this.isFirstCodepointUppercase(identifier)) {
            this.compile_error("formal argument cannot be a constant");
        }
        int first = identifier.readByteUncached(0, this.tencoding);
        switch (first) {
            case 64: {
                if (identifier.readByteUncached(1, this.tencoding) == 64) {
                    this.compile_error("formal argument cannot be a class variable");
                    break;
                }
                this.compile_error("formal argument cannot be an instance variable");
                break;
            }
            case 36: {
                this.compile_error("formal argument cannot be a global variable");
                break;
            }
            default: {
                int last = identifier.readByteUncached(identifier.byteLength(this.tencoding) - 1, this.tencoding);
                if (last != 61 && last != 63 && last != 33) break;
                this.compile_error("formal argument must be local variable");
            }
        }
    }

    public Object value() {
        return this.yaccValue;
    }

    protected void warn_balanced(int c, boolean spaceSeen, String op, String syn) {
        if (!RubyLexer.isLexState(this.last_state, 908) && spaceSeen && !StringSupport.isAsciiSpace(c)) {
            this.ambiguousOperator(op, syn);
        }
    }

    public boolean was_bol() {
        return this.lex_p == this.lex_pbeg + 1;
    }

    boolean whole_match_p(TruffleString eos, TruffleString.Encoding enc, boolean indent) {
        int n;
        int len = eos.byteLength(enc);
        int p = this.lex_pbeg;
        if (indent) {
            for (int i = 0; i < this.lex_pend; ++i) {
                if (Character.isWhitespace(this.p(i + p))) continue;
                p += i;
                break;
            }
        }
        if ((n = this.lex_pend - (p + len)) < 0) {
            return false;
        }
        if (n > 0 && this.p(p + len) != 10) {
            if (this.p(p + len) != 13) {
                return false;
            }
            if (n == 1 || this.p(p + len + 1) != 10) {
                return false;
            }
        }
        return this.strncmp(eos, this.src.parserRopeOperations.makeShared((AbstractTruffleString)this.lexb, p, len), len);
    }

    public static boolean isHexChar(int c) {
        return Character.isDigit(c) || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    public static boolean isLexState(int state, int mask) {
        return (mask & state) != 0;
    }

    protected boolean isLexStateAll(int state, int mask) {
        return (mask & state) == mask;
    }

    protected boolean isARG() {
        return RubyLexer.isLexState(this.lex_state, 48);
    }

    protected boolean isBEG() {
        return RubyLexer.isLexState(this.lex_state, 577) || this.isLexStateAll(this.lex_state, 2064);
    }

    protected boolean isEND() {
        return RubyLexer.isLexState(this.lex_state, 14);
    }

    protected boolean isLabelPossible(boolean commandState) {
        return RubyLexer.isLexState(this.lex_state, 1032) && !commandState || this.isARG();
    }

    protected boolean isLabelSuffix() {
        return this.peek(58) && !this.peek(58, 1);
    }

    protected boolean isAfterOperator() {
        return RubyLexer.isLexState(this.lex_state, 384);
    }

    protected boolean isNext_identchar() {
        int c = this.nextc();
        this.pushback(c);
        return c != -1 && (Character.isLetterOrDigit(c) || c == 95);
    }

    public static boolean isOctChar(int c) {
        return 48 <= c && c <= 55;
    }

    public static boolean isSpace(int c) {
        return c == 32 || 9 <= c && c <= 13;
    }

    protected boolean isSpaceArg(int c, boolean spaceSeen) {
        return this.isARG() && spaceSeen && !Character.isWhitespace(c);
    }

    private boolean isFirstCodepointUppercase(TruffleString tstring) {
        Encoding ropeEncoding = this.encoding.jcoding;
        int firstByte = tstring.readByteUncached(0, this.tencoding);
        if (ropeEncoding.isAsciiCompatible() && this.isASCII(firstByte)) {
            return StringSupport.isAsciiUppercase((byte)firstByte);
        }
        int firstCharacter = tstring.codePointAtByteIndexUncached(0, this.tencoding, TruffleString.ErrorHandling.BEST_EFFORT);
        return ropeEncoding.isUpper(firstCharacter);
    }

    public String getLocation() {
        return this.getFile() + ":" + this.ruby_sourceline;
    }

    public String toString() {
        return super.toString() + " @ " + this.getLocation();
    }

    public int getRubySourceLine() {
        return this.ruby_sourceline;
    }

    public static enum Keyword {
        END("end", 264, 2),
        ELSE("else", 269, 1),
        CASE("case", 270, 1),
        ENSURE("ensure", 263, 1),
        MODULE("module", 258, 1),
        ELSIF("elsif", 268, 1),
        DEF("def", 259, 128),
        RESCUE("rescue", 262, 296, 64),
        NOT("not", 291, 16),
        THEN("then", 267, 1),
        YIELD("yield", 283, 16),
        FOR("for", 274, 1),
        SELF("self", 285, 2),
        FALSE("false", 288, 2),
        RETRY("retry", 278, 2),
        RETURN("return", 282, 64),
        TRUE("true", 287, 2),
        IF("if", 265, 292, 1),
        DEFINED_P("defined?", 298, 16),
        SUPER("super", 284, 16),
        UNDEF("undef", 260, 128),
        BREAK("break", 275, 64),
        IN("in", 390, 1),
        DO("do", 279, 1),
        NIL("nil", 286, 2),
        UNTIL("until", 273, 295, 1),
        UNLESS("unless", 266, 293, 1),
        OR("or", 290, 1),
        NEXT("next", 276, 64),
        WHEN("when", 271, 1),
        REDO("redo", 277, 2),
        AND("and", 289, 1),
        BEGIN("begin", 261, 1),
        __LINE__("__LINE__", 301, 2),
        CLASS("class", 257, 512),
        __FILE__("__FILE__", 302, 2),
        LEND("END", 300, 2),
        LBEGIN("BEGIN", 299, 2),
        WHILE("while", 272, 294, 1),
        ALIAS("alias", 297, 128),
        __ENCODING__("__ENCODING__", 303, 2);

        public final String name;
        public final TruffleString bytes;
        public final int id0;
        public final int id1;
        public final int state;

        private Keyword(String name, int id, int state) {
            this(name, id, id, state);
        }

        private Keyword(String name, int id, int modifier, int state) {
            this.name = name;
            this.bytes = TStringUtils.usAsciiString(name);
            this.id0 = id;
            this.id1 = modifier;
            this.state = state;
        }

        private static abstract class Maps {
            private static final Map<String, Keyword> FROM_STRING;
            private static final Map<BytesKey, Keyword> FROM_BYTES;

            private Maps() {
            }

            static {
                HashMap<String, Keyword> fromString = new HashMap<String, Keyword>();
                HashMap<BytesKey, Keyword> fromBytes = new HashMap<BytesKey, Keyword>();
                for (Keyword keyword : Keyword.values()) {
                    fromString.put(keyword.name, keyword);
                    fromBytes.put(new BytesKey(TStringUtils.getBytesOrFail((AbstractTruffleString)keyword.bytes, Encodings.US_ASCII), null), keyword);
                }
                FROM_STRING = Collections.unmodifiableMap(fromString);
                FROM_BYTES = Collections.unmodifiableMap(fromBytes);
            }
        }
    }
}

