/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.lexer;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.jcodings.Encoding;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.parser.ParserRopeOperations;

public final class LexerSource {
    public ParserRopeOperations parserRopeOperations;
    private final Source source;
    private final String sourcePath;
    private final boolean fromTruffleString;
    private TruffleString sourceBytes;
    private final int sourceByteLength;
    private RubyEncoding encoding;
    private int byteOffset;
    private final int lineOffset;

    public LexerSource(RubySource rubySource) {
        RubyEncoding rubyEncoding;
        this.source = rubySource.getSource();
        this.sourcePath = rubySource.getSourcePath();
        this.fromTruffleString = rubySource.hasTruffleString();
        if (this.fromTruffleString) {
            rubyEncoding = rubySource.getEncoding();
            this.sourceBytes = rubySource.getTruffleString();
        } else {
            rubyEncoding = Encodings.UTF_8;
            String sourceString = this.source.getCharacters().toString();
            this.sourceBytes = TStringUtils.utf8TString(sourceString);
        }
        this.sourceByteLength = this.sourceBytes.byteLength(rubyEncoding.tencoding);
        this.encoding = rubyEncoding;
        this.parserRopeOperations = new ParserRopeOperations(this.encoding);
        this.lineOffset = rubySource.getLineOffset();
    }

    public Source getSource() {
        return this.source;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public Encoding getEncoding() {
        return this.encoding.jcoding;
    }

    public RubyEncoding getRubyEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding jcoding) {
        RubyEncoding rubyEncoding = Encodings.getBuiltInEncoding(jcoding);
        this.sourceBytes = this.sourceBytes.forceEncodingUncached(this.encoding.tencoding, rubyEncoding.tencoding);
        this.encoding = rubyEncoding;
        this.parserRopeOperations = new ParserRopeOperations(this.encoding);
    }

    public int getOffset() {
        return this.byteOffset;
    }

    public TruffleString gets() {
        if (this.byteOffset >= this.sourceByteLength) {
            return null;
        }
        int lineEnd = this.nextNewLine() + 1;
        if (lineEnd == 0) {
            lineEnd = this.sourceByteLength;
        }
        int start = this.byteOffset;
        int length = lineEnd - this.byteOffset;
        this.byteOffset = lineEnd;
        return this.parserRopeOperations.makeShared((AbstractTruffleString)this.sourceBytes, start, length);
    }

    private int nextNewLine() {
        int index = this.sourceBytes.byteIndexOfAnyByteUncached(this.byteOffset, this.sourceByteLength, TStringConstants.NEWLINE_BYTE_ARRAY, this.encoding.tencoding);
        if (index < 0) {
            return -1;
        }
        return index;
    }

    public boolean isFromTruffleString() {
        return this.fromTruffleString;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }
}

