/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public class WhenParseNode
extends ParseNode {
    protected final ParseNode expressionNodes;
    protected final ParseNode bodyNode;
    private final ParseNode nextCase;

    public WhenParseNode(SourceIndexLength position, ParseNode expressionNodes, ParseNode bodyNode, ParseNode nextCase) {
        super(position);
        this.expressionNodes = expressionNodes;
        this.bodyNode = bodyNode;
        this.nextCase = nextCase;
        assert (bodyNode != null) : "bodyNode is not null";
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.WHENNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitWhenNode(this);
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public ParseNode getNextCase() {
        return this.nextCase;
    }

    public ParseNode getExpressionNodes() {
        return this.expressionNodes;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.expressionNodes, this.bodyNode, this.nextCase);
    }
}

