/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.StringGuards;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.SideEffectFree;
import org.truffleruby.parser.ast.types.ILiteralNode;
import org.truffleruby.parser.ast.types.INameNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public final class SymbolParseNode
extends ParseNode
implements ILiteralNode,
INameNode,
SideEffectFree {
    private final String name;
    private final TruffleString tstring;
    private final Encoding encoding;

    public SymbolParseNode(SourceIndexLength position, String name, Encoding encoding) {
        super(position);
        this.name = name;
        RubyEncoding rubyEncoding = Encodings.getBuiltInEncoding(encoding);
        this.tstring = TStringUtils.fromJavaString(name, rubyEncoding);
        if (StringGuards.is7BitUncached((AbstractTruffleString)this.tstring, rubyEncoding)) {
            encoding = USASCIIEncoding.INSTANCE;
        }
        this.encoding = encoding;
    }

    public SymbolParseNode(SourceIndexLength position, TruffleString value, RubyEncoding rubyEncoding) {
        super(position);
        if (StringGuards.is7BitUncached((AbstractTruffleString)value, rubyEncoding)) {
            this.tstring = value.switchEncodingUncached(Encodings.US_ASCII.tencoding);
            rubyEncoding = Encodings.US_ASCII;
        } else {
            this.tstring = value;
        }
        this.encoding = rubyEncoding.jcoding;
        this.name = this.tstring.toJavaStringUncached().intern();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SYMBOLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSymbolNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TruffleString getTString() {
        return this.tstring;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public RubyEncoding getRubyEncoding() {
        return Encodings.getBuiltInEncoding(this.encoding);
    }

    public boolean valueEquals(ILiteralNode o) {
        if (!(o instanceof SymbolParseNode)) {
            return false;
        }
        SymbolParseNode other = (SymbolParseNode)o;
        return this.tstring.equals((Object)other.tstring) && this.encoding == other.encoding;
    }

    @Override
    public List<ParseNode> childNodes() {
        return EMPTY_LIST;
    }
}

