/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.SideEffectFree;
import org.truffleruby.parser.ast.types.ILiteralNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public class StrParseNode
extends ParseNode
implements ILiteralNode,
SideEffectFree {
    private TruffleString value;
    public final RubyEncoding encoding;
    private boolean frozen;

    public StrParseNode(SourceIndexLength position, TStringWithEncoding tStringWithEnc) {
        this(position, tStringWithEnc.tstring, tStringWithEnc.encoding);
    }

    public StrParseNode(SourceIndexLength position, TruffleString value, RubyEncoding encoding) {
        super(position);
        this.value = value;
        this.encoding = encoding;
    }

    public StrParseNode(SourceIndexLength position, StrParseNode head, StrParseNode tail) {
        super(position);
        TStringBuilder myValue = new TStringBuilder();
        myValue.setEncoding(head.encoding);
        myValue.append(head.value, head.encoding);
        myValue.append(tail.value, tail.encoding);
        this.frozen = head.isFrozen() && tail.isFrozen();
        this.value = myValue.toTString();
        this.encoding = head.encoding;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.STRNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitStrNode(this);
    }

    public TruffleString getValue() {
        return this.value;
    }

    public TStringWithEncoding getTStringWithEncoding() {
        return new TStringWithEncoding(this.value, this.encoding);
    }

    @Override
    public List<ParseNode> childNodes() {
        return EMPTY_LIST;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public void setValue(TruffleString value) {
        assert (value.isCompatibleToUncached(this.encoding.tencoding));
        this.value = value;
    }
}

