/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.ArrayParseNode;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public final class InParseNode
extends ParseNode {
    private final ParseNode expressionNodes;
    private final ParseNode bodyNode;
    private final ParseNode nextCase;

    public InParseNode(SourceIndexLength position, ParseNode expressionNodes, ParseNode bodyNode, ParseNode nextCase) {
        super(position);
        if (expressionNodes instanceof ArrayParseNode) {
            ArrayParseNode arrayParseNode = (ArrayParseNode)expressionNodes;
            if (arrayParseNode.size() != 1) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            expressionNodes = arrayParseNode.get(0);
        }
        this.expressionNodes = expressionNodes;
        this.bodyNode = bodyNode;
        this.nextCase = nextCase;
        assert (bodyNode != null) : "bodyNode is not null";
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.INNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitInNode(this);
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public ParseNode getNextCase() {
        return this.nextCase;
    }

    public ParseNode getExpressionNodes() {
        return this.expressionNodes;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.expressionNodes, this.bodyNode, this.nextCase);
    }
}

