/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.types.ILiteralNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;
import org.truffleruby.parser.parser.ParseNodeTuple;

public final class HashParseNode
extends ParseNode
implements ILiteralNode {
    private final List<ParseNodeTuple> pairs = new ArrayList<ParseNodeTuple>();
    private boolean keywordArguments = false;

    public HashParseNode(SourceIndexLength position) {
        super(position);
    }

    public HashParseNode(SourceIndexLength position, ParseNodeTuple pair) {
        this(position);
        this.pairs.add(pair);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHNODE;
    }

    public HashParseNode add(ParseNodeTuple pair) {
        this.pairs.add(pair);
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public List<ParseNodeTuple> getPairs() {
        return this.pairs;
    }

    @Override
    public List<ParseNode> childNodes() {
        ArrayList<ParseNode> children = new ArrayList<ParseNode>();
        for (ParseNodeTuple pair : this.pairs) {
            children.add(pair.getKey());
            children.add(pair.getValue());
        }
        return children;
    }

    public boolean isKeywordArguments() {
        return this.keywordArguments;
    }

    public void setKeywordArguments(boolean keywordArguments) {
        this.keywordArguments = keywordArguments;
    }
}

