/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.ArgsParseNode;
import org.truffleruby.parser.ast.IterParseNode;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;
import org.truffleruby.parser.scope.StaticScope;

public final class ForParseNode
extends IterParseNode {
    private ParseNode iterNode;

    public ForParseNode(SourceIndexLength position, ParseNode varNode, ParseNode bodyNode, ParseNode iterNode, StaticScope scope) {
        super(position, varNode, scope, bodyNode);
        assert (iterNode != null) : "iterNode is not null";
        this.iterNode = iterNode;
    }

    @Override
    public ArgsParseNode getArgsNode() {
        throw CompilerDirectives.shouldNotReachHere((String)"For nodes are not technically def nodes so they do not have args");
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FORNODE;
    }

    public ParseNode getIterNode() {
        return this.iterNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitForNode(this);
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.getVarNode(), this.getBodyNode(), this.iterNode);
    }
}

