/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.parser.Helpers;
import org.truffleruby.parser.ast.ArgumentParseNode;
import org.truffleruby.parser.ast.ArrayParseNode;
import org.truffleruby.parser.ast.AssignableParseNode;
import org.truffleruby.parser.ast.BlockArgParseNode;
import org.truffleruby.parser.ast.DAsgnParseNode;
import org.truffleruby.parser.ast.KeywordArgParseNode;
import org.truffleruby.parser.ast.KeywordRestArgParseNode;
import org.truffleruby.parser.ast.ListParseNode;
import org.truffleruby.parser.ast.LocalAsgnParseNode;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.RestArgParseNode;
import org.truffleruby.parser.ast.types.INameNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;
import org.truffleruby.parser.parser.ParserSupport;

public final class ArgsParseNode
extends ParseNode {
    private ParseNode[] args;
    private short optIndex;
    private short postIndex;
    private short keywordsIndex;
    private boolean isNumbered = false;
    private final ArgumentParseNode restArgNode;
    private final KeywordRestArgParseNode keyRest;
    private final BlockArgParseNode blockArgNode;
    private Arity arity;
    private static final ParseNode[] NO_ARGS = ParseNode.EMPTY_ARRAY;

    public ArgsParseNode(SourceIndexLength position, ListParseNode pre, ListParseNode optionalArguments, RestArgParseNode rest, ListParseNode post, BlockArgParseNode blockArgNode) {
        this(position, pre, optionalArguments, rest, post, null, null, blockArgNode);
    }

    public ArgsParseNode(SourceIndexLength position, ListParseNode pre, ListParseNode optionalArguments, RestArgParseNode rest, ListParseNode post, ListParseNode keywords, KeywordRestArgParseNode keyRest, BlockArgParseNode blockArgNode) {
        super(position);
        int preSize = pre != null ? pre.size() : 0;
        int optSize = optionalArguments != null ? optionalArguments.size() : 0;
        int postSize = post != null ? post.size() : 0;
        int keywordsSize = keywords != null ? keywords.size() : 0;
        int size = preSize + optSize + postSize + keywordsSize;
        this.args = size > 0 ? new ParseNode[size] : NO_ARGS;
        this.optIndex = (short)preSize;
        this.postIndex = (short)(optSize != 0 ? this.optIndex + optSize : this.optIndex);
        this.keywordsIndex = (short)(postSize != 0 ? this.postIndex + postSize : this.postIndex);
        if (preSize > 0) {
            System.arraycopy(pre.children(), 0, this.args, 0, preSize);
        }
        if (optSize > 0) {
            System.arraycopy(optionalArguments.children(), 0, this.args, this.optIndex, optSize);
        }
        if (postSize > 0) {
            System.arraycopy(post.children(), 0, this.args, this.postIndex, postSize);
        }
        if (keywordsSize > 0) {
            System.arraycopy(keywords.children(), 0, this.args, this.keywordsIndex, keywordsSize);
        }
        this.restArgNode = rest;
        this.blockArgNode = blockArgNode;
        this.keyRest = keyRest;
        this.arity = this.createArity();
    }

    private Arity createArity() {
        int requiredKeywordArgumentsCount;
        String[] keywordArguments;
        if (this.getKeywordCount() > 0) {
            ArrayList<String> requiredKeywords = new ArrayList<String>();
            ArrayList<String> optionalKeywords = new ArrayList<String>();
            ParseNode[] keywordNodes = this.getKeywords().children();
            int keywordsCount = keywordNodes.length;
            for (int i = 0; i < keywordsCount; ++i) {
                KeywordArgParseNode kwarg = (KeywordArgParseNode)keywordNodes[i];
                AssignableParseNode assignableNode = kwarg.getAssignable();
                if (!(assignableNode instanceof LocalAsgnParseNode) && !(assignableNode instanceof DAsgnParseNode)) {
                    throw new UnsupportedOperationException("unsupported keyword arg " + kwarg);
                }
                String keyword = ((INameNode)((Object)assignableNode)).getName();
                if (Helpers.isRequiredKeywordArgumentValueNode(assignableNode)) {
                    requiredKeywords.add(keyword);
                    continue;
                }
                optionalKeywords.add(keyword);
            }
            ArrayList<String> keywords = new ArrayList<String>(requiredKeywords);
            keywords.addAll(optionalKeywords);
            keywordArguments = keywords.toArray(StringUtils.EMPTY_STRING_ARRAY);
            requiredKeywordArgumentsCount = requiredKeywords.size();
        } else {
            keywordArguments = Arity.NO_KEYWORDS;
            requiredKeywordArgumentsCount = 0;
        }
        return new Arity(this.getPreCount(), this.getOptionalArgsCount(), this.hasRestArg(), this.getPostCount(), keywordArguments, requiredKeywordArgumentsCount, this.hasKeyRest());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public Arity getArity() {
        return this.arity.getPreRequired() == this.getPreCount() ? this.arity : (this.arity = this.createArity());
    }

    public ParseNode[] getArgs() {
        return this.args;
    }

    public int getOptArgIndex() {
        return this.optIndex;
    }

    public int getPostIndex() {
        return this.postIndex;
    }

    public int getKeywordsIndex() {
        return this.keywordsIndex;
    }

    public int getPreCount() {
        return this.isNumbered() ? this.args.length : this.optIndex;
    }

    public int getOptionalArgsCount() {
        return this.postIndex - this.optIndex;
    }

    public int getPostCount() {
        return this.keywordsIndex - this.postIndex;
    }

    public int getKeywordCount() {
        return this.args.length - this.keywordsIndex;
    }

    public int getRequiredCount() {
        return this.getPreCount() + this.getPostCount();
    }

    public ListParseNode getPre() {
        return new ArrayParseNode(this.getPosition()).addAll(this.args, 0, this.getPreCount());
    }

    public ListParseNode getOptArgs() {
        return new ArrayParseNode(this.getPosition()).addAll(this.args, this.optIndex, this.getOptionalArgsCount());
    }

    public ListParseNode getPost() {
        return new ArrayParseNode(this.getPosition()).addAll(this.args, this.postIndex, this.getPostCount());
    }

    public ListParseNode getKeywords() {
        return new ArrayParseNode(this.getPosition()).addAll(this.args, this.keywordsIndex, this.getKeywordCount());
    }

    public boolean hasRestArg() {
        return this.restArgNode != null;
    }

    public ArgumentParseNode getRestArgNode() {
        return this.restArgNode;
    }

    public boolean hasKeyRest() {
        return this.keyRest != null;
    }

    public KeywordRestArgParseNode getKeyRest() {
        return this.keyRest;
    }

    public boolean hasKwargs() {
        boolean keywords = this.getKeywordCount() > 0;
        return keywords || this.keyRest != null;
    }

    public BlockArgParseNode getBlock() {
        return this.blockArgNode;
    }

    public boolean isNumbered() {
        return this.isNumbered;
    }

    public void addNumberedParameter(String name, SourceIndexLength position) {
        int ordinal;
        assert (ParserSupport.isNumberedParameter(name));
        if (!this.isNumbered) {
            this.isNumbered = true;
        }
        if (this.args.length < (ordinal = name.charAt(1) - 48)) {
            int oldLength = this.args.length;
            this.args = Arrays.copyOf(this.args, ordinal);
            for (int i = oldLength; i < ordinal; ++i) {
                this.args[i] = new ArgumentParseNode(position, ("_" + (char)(48 + ordinal)).intern());
                this.postIndex = this.keywordsIndex = (short)ordinal;
                this.optIndex = this.keywordsIndex;
            }
        }
        this.args[this.args.length - 1] = new ArgumentParseNode(position, name);
    }

    @Override
    public List<ParseNode> childNodes() {
        ListParseNode pre = this.getPre();
        ListParseNode optArgs = this.getOptArgs();
        ListParseNode post = this.getPost();
        ListParseNode keywords = this.getKeywords();
        return ParseNode.createList(pre, optArgs, this.restArgNode, post, keywords, this.keyRest, this.blockArgNode);
    }
}

