/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Arrays;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.collections.Memo;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.DummyNode;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.core.binding.SetBindingFrameForEvalNode;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.kernel.AutoSplitNode;
import org.truffleruby.core.kernel.ChompLoopNode;
import org.truffleruby.core.kernel.KernelGetsNode;
import org.truffleruby.core.kernel.KernelPrintLastLineNode;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.EmitWarningsNode;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyEvalRootNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.RubyTopLevelRootNode;
import org.truffleruby.language.SetTopLevelBindingNode;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.arguments.MissingArgumentBehavior;
import org.truffleruby.language.arguments.ReadPreArgumentNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.WhileNode;
import org.truffleruby.language.control.WhileNodeFactory;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.loader.ByteBasedCharSequence;
import org.truffleruby.language.locals.FrameDescriptorNamesIterator;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.parser.BodyTranslator;
import org.truffleruby.parser.ParseEnvironment;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.Translator;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.YARPTranslator;
import org.truffleruby.parser.parser.ParserConfiguration;
import org.truffleruby.parser.scope.StaticScope;
import org.truffleruby.platform.Platform;
import org.truffleruby.shared.Metrics;
import org.yarp.Loader;
import org.yarp.Nodes;
import org.yarp.ParseResult;
import org.yarp.Parser;

public final class YARPTranslatorDriver {
    private final RubyContext context;
    private final RubyLanguage language;
    private final ParseEnvironment parseEnvironment;

    public YARPTranslatorDriver(RubyContext context, RubySource rubySource) {
        this.context = context;
        this.language = context.getLanguageSlow();
        this.parseEnvironment = new ParseEnvironment(this.language, rubySource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootCallTarget parse(RubySource rubySource, ParserContext parserContext, String[] argumentNames, MaterializedFrame parentFrame, LexicalScope staticLexicalScope, Node currentNode) {
        RubyNode truffleNode;
        boolean topLevel;
        TranslatorEnvironment parentEnvironment;
        if (rubySource.getSource() != this.parseEnvironment.source) {
            throw CompilerDirectives.shouldNotReachHere((String)"TranslatorDriver used with a different Source");
        }
        if (parserContext.isTopLevel() != (parentFrame == null)) {
            throw CompilerDirectives.shouldNotReachHere((String)("A frame should be given iff the context is not toplevel: " + parserContext + " " + parentFrame));
        }
        Source source = rubySource.getSource();
        StaticScope staticScope = new StaticScope(StaticScope.Type.LOCAL, null);
        int blockDepth = 0;
        if (parentFrame != null) {
            MaterializedFrame frame = parentFrame;
            while (frame != null) {
                for (Object identifier : FrameDescriptorNamesIterator.iterate(frame.getFrameDescriptor())) {
                    if (BindingNodes.isHiddenVariable(identifier)) continue;
                    Object name = (String)identifier;
                    staticScope.addVariableThisScope(((String)name).intern());
                }
                frame = RubyArguments.getDeclarationFrame((Frame)frame);
                ++blockDepth;
            }
            parentEnvironment = this.environmentForFrame(this.context, parentFrame, blockDepth - 1);
        } else {
            parentEnvironment = null;
        }
        if (argumentNames != null) {
            for (Object name : argumentNames) {
                staticScope.addVariableThisScope(((String)name).intern());
            }
        }
        boolean isInlineSource = rubySource.getSourcePath().equals("-e");
        boolean isEvalParse = parserContext.isEval();
        ParserConfiguration parserConfiguration = new ParserConfiguration(this.context, isInlineSource, !isEvalParse, false);
        if (this.language.options.FROZEN_STRING_LITERALS) {
            parserConfiguration.setFrozenStringLiteral(true);
        }
        RubyDeferredWarnings rubyWarnings = new RubyDeferredWarnings();
        YARPTranslatorDriver.printParseTranslateExecuteMetric("before-parsing", this.context, source);
        Nodes.Node node = this.context.getMetricsProfiler().callWithMetrics("parsing", source.getName(), () -> YARPTranslatorDriver.parseToYARPAST(this.context, this.language, rubySource, staticScope, parserConfiguration, rubyWarnings));
        YARPTranslatorDriver.printParseTranslateExecuteMetric("after-parsing", this.context, source);
        this.parseEnvironment.allowTruffleRubyPrimitives = parserConfiguration.allowTruffleRubyPrimitives;
        SourceSection sourceSection = source.createSection(0, rubySource.getBytes().length);
        SourceIndexLength sourceIndexLength = SourceIndexLength.fromSourceSection(sourceSection);
        String modulePath = staticLexicalScope == null || staticLexicalScope == this.context.getRootLexicalScope() ? null : staticLexicalScope.getLiveModule().getName();
        String methodName = this.getMethodName(parserContext, parentFrame);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.language.singleContext ? staticLexicalScope : null, Arity.NO_ARGUMENTS, methodName, 0, methodName, null, null);
        boolean isModuleBody = topLevel = parserContext.isTopLevel();
        TranslatorEnvironment environment = new TranslatorEnvironment(parentEnvironment, this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, isModuleBody, sharedMethodInfo, sharedMethodInfo.getMethodNameForNotBlock(), blockDepth, null, null, modulePath);
        if (argumentNames != null) {
            for (MaterializedFrame name : argumentNames) {
                environment.declareVar(name);
            }
        }
        byte[] sourceBytes = rubySource.getBytes();
        YARPTranslator translator = new YARPTranslator(this.language, null, environment, sourceBytes, source, parserContext, currentNode, rubyWarnings);
        Memo<Object> beginNodeMemo = new Memo<Object>(null);
        YARPTranslatorDriver.printParseTranslateExecuteMetric("before-translate", this.context, source);
        try {
            truffleNode = this.context.getMetricsProfiler().callWithMetrics("translating", source.getName(), () -> node.accept(translator));
        }
        finally {
            YARPTranslatorDriver.printParseTranslateExecuteMetric("after-translate", this.context, source);
        }
        RubyNode beginNode = beginNodeMemo.get();
        if (argumentNames != null && ((MaterializedFrame)argumentNames).length > 0) {
            ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
            for (int n = 0; n < ((MaterializedFrame)argumentNames).length; ++n) {
                MaterializedFrame name = argumentNames[n];
                RubyNode readNode = Translator.profileArgument(this.language, new ReadPreArgumentNode(n, false, MissingArgumentBehavior.NIL));
                int slot = environment.findFrameSlot(name);
                sequence.add(new WriteLocalVariableNode(slot, readNode));
            }
            sequence.add(truffleNode);
            truffleNode = Translator.sequence(sourceIndexLength, sequence);
        }
        if (environment.getFlipFlopStates().size() > 0) {
            truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(BodyTranslator.initFlipFlopStates(environment, sourceIndexLength), truffleNode));
        }
        if (parserContext == ParserContext.TOP_LEVEL_FIRST && this.context.getOptions().GETS_LOOP) {
            if (this.context.getOptions().PRINT_LOOP) {
                truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(new RubyNode[]{truffleNode, new KernelPrintLastLineNode()}));
            }
            if (this.context.getOptions().SPLIT_LOOP) {
                truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(new RubyNode[]{new AutoSplitNode(), truffleNode}));
            }
            if (this.context.getOptions().CHOMP_LOOP) {
                truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(new RubyNode[]{new ChompLoopNode(), truffleNode}));
            }
            truffleNode = new WhileNode(WhileNodeFactory.WhileRepeatingNodeGen.create(new KernelGetsNode(), truffleNode));
        }
        if (beginNode != null) {
            truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(beginNode, truffleNode));
        }
        RubyNode writeSelfNode = Translator.loadSelf(this.language);
        truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(writeSelfNode, truffleNode));
        if (!rubyWarnings.warnings.isEmpty()) {
            truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(new RubyNode[]{new EmitWarningsNode(rubyWarnings), truffleNode}));
        }
        if (parserContext == ParserContext.TOP_LEVEL_FIRST) {
            truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(new RubyNode[]{new SetTopLevelBindingNode(), truffleNode}));
        }
        FrameDescriptor frameDescriptor = environment.computeFrameDescriptor();
        if (parserContext == ParserContext.EVAL && BindingNodes.assignsNewUserVariables(frameDescriptor)) {
            truffleNode = new SetBindingFrameForEvalNode(frameDescriptor, truffleNode);
        }
        RubyRootNode rootNode = parserContext.isTopLevel() ? new RubyTopLevelRootNode(this.language, sourceIndexLength.toSourceSection(source), frameDescriptor, sharedMethodInfo, truffleNode, Split.HEURISTIC, environment.getReturnID(), Arity.ANY_ARGUMENTS) : new RubyEvalRootNode(this.language, sourceIndexLength.toSourceSection(source), frameDescriptor, sharedMethodInfo, truffleNode, Split.HEURISTIC, environment.getReturnID());
        return rootNode.getCallTarget();
    }

    private String getMethodName(ParserContext parserContext, MaterializedFrame parentFrame) {
        if (parserContext.isTopLevel()) {
            return parserContext.getTopLevelName();
        }
        if (parentFrame != null) {
            return RubyArguments.getMethod((Frame)parentFrame).getName();
        }
        throw new UnsupportedOperationException("Could not determine the method name for parser context " + parserContext);
    }

    public static Nodes.Node parseToYARPAST(RubyContext context, RubyLanguage language, RubySource rubySource, StaticScope blockScope, ParserConfiguration configuration, RubyDeferredWarnings rubyWarnings) {
        if (blockScope != null) {
            configuration.parseAsBlock(blockScope);
        }
        TruffleSafepoint.poll((Node)DummyNode.INSTANCE);
        byte[] sourceBytes = rubySource.getBytes();
        Parser.loadLibrary(language.getRubyHome() + "/lib/libyarp" + Platform.LIB_SUFFIX);
        byte[] serializedBytes = Parser.parseAndSerialize(sourceBytes);
        Nodes.Source yarpSource = YARPTranslatorDriver.createYARPSource(sourceBytes, rubySource);
        ParseResult parseResult = Loader.load(serializedBytes, yarpSource);
        String filename = rubySource.getSourcePath();
        ParseResult.Error[] errors = parseResult.errors;
        for (ParseResult.Warning warning : parseResult.warnings) {
            Nodes.Location location = warning.location;
            SourceSection section = rubySource.getSource().createSection(location.startOffset, location.length);
            int lineNumber = RubySource.getStartLineAdjusted(context, section);
            rubyWarnings.warn(filename, lineNumber, warning.message);
        }
        if (errors.length != 0) {
            if (!rubyWarnings.warnings.isEmpty()) {
                EmitWarningsNode.printWarnings(context, rubyWarnings);
            }
            ParseResult.Error error = errors[0];
            Nodes.Location location = error.location;
            SourceSection section = rubySource.getSource().createSection(location.startOffset, location.length);
            String message = context.fileLine(section) + ": " + error.message;
            if (context != null) {
                int lineNumber = RubySource.getStartLineAdjusted(context, section);
                throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxErrorAlreadyWithFileLine(message, null, rubySource.getSource().createSection(lineNumber)));
            }
            throw new UnsupportedOperationException(message);
        }
        return parseResult.value;
    }

    public static RubySource createRubySource(Object code) {
        TStringWithEncoding tstringWithEnc = new TStringWithEncoding(RubyGuards.asTruffleStringUncached(code), RubyStringLibrary.getUncached().getEncoding(code));
        ByteBasedCharSequence charSequence = new ByteBasedCharSequence(tstringWithEnc);
        Source source = Source.newBuilder((String)"ruby", (CharSequence)charSequence, (String)"<parse_ast>").build();
        return new RubySource(source, source.getName(), tstringWithEnc);
    }

    public static Nodes.Source createYARPSource(byte[] sourceBytes, RubySource rubySource) {
        Source source = rubySource.getSource();
        int[] lineOffsets = new int[source.getLineCount()];
        for (int line = 1; line <= source.getLineCount(); ++line) {
            lineOffsets[line - 1] = source.getLineStartOffset(line);
        }
        return new Nodes.Source(sourceBytes, lineOffsets);
    }

    private TranslatorEnvironment environmentForFrame(RubyContext context, MaterializedFrame frame, int blockDepth) {
        if (frame == null) {
            return null;
        }
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(CoreLibrary.JAVA_CORE_SOURCE_SECTION, this.language.singleContext ? context.getRootLexicalScope() : null, Arity.NO_ARGUMENTS, "<unused>", 0, "<unused>", "external", null);
        MaterializedFrame parent = RubyArguments.getDeclarationFrame((Frame)frame);
        assert (blockDepth == 0 == (parent == null));
        boolean isModuleBody = blockDepth == 0 && RubyArguments.getMethod((Frame)frame).getSharedMethodInfo().isModuleBody();
        return new TranslatorEnvironment(this.environmentForFrame(context, parent, blockDepth - 1), this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, isModuleBody, sharedMethodInfo, sharedMethodInfo.getMethodName(), blockDepth, null, frame.getFrameDescriptor(), "<unused>");
    }

    public static void printParseTranslateExecuteMetric(String id, RubyContext context, Source source) {
        if (Metrics.getMetricsTime()) {
            if (context.getOptions().METRICS_TIME_PARSING_FILE) {
                String name = context.getLanguageSlow().getSourcePath(source);
                int lastSlash = name.lastIndexOf(47);
                int lastDot = name.lastIndexOf(46);
                if (lastSlash >= 0 && lastDot >= 0 && lastSlash + 1 < lastDot) {
                    name = name.substring(lastSlash + 1, lastDot);
                }
                Metrics.printTime((String)(id + "-" + name));
            } else if (context.getCoreLibrary().isLoadingRubyCore()) {
                Metrics.printTime((String)(id + "-core"));
            }
        }
    }
}

