/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.array.ArrayLiteralNode;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.cast.HashCastNodeGen;
import org.truffleruby.core.cast.SplatCastNode;
import org.truffleruby.core.cast.SplatCastNodeGen;
import org.truffleruby.core.cast.StringToSymbolNode;
import org.truffleruby.core.cast.StringToSymbolNodeGen;
import org.truffleruby.core.cast.ToSNode;
import org.truffleruby.core.cast.ToSNodeGen;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.hash.ConcatHashLiteralNode;
import org.truffleruby.core.hash.HashLiteralNode;
import org.truffleruby.core.module.ModuleNodes;
import org.truffleruby.core.rescue.AssignRescueVariableNode;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.InterpolatedStringNode;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.debug.ChaosNode;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.RubyTopLevelRootNode;
import org.truffleruby.language.arguments.EmptyArgumentsDescriptor;
import org.truffleruby.language.arguments.ProfileArgumentNodeGen;
import org.truffleruby.language.arguments.ReadSelfNode;
import org.truffleruby.language.constants.ReadConstantNode;
import org.truffleruby.language.constants.ReadConstantWithDynamicScopeNode;
import org.truffleruby.language.constants.ReadConstantWithLexicalScopeNode;
import org.truffleruby.language.constants.WriteConstantNode;
import org.truffleruby.language.control.AndNode;
import org.truffleruby.language.control.AndNodeGen;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.BreakNode;
import org.truffleruby.language.control.IfElseNodeGen;
import org.truffleruby.language.control.IfNodeGen;
import org.truffleruby.language.control.NextNode;
import org.truffleruby.language.control.NotNodeGen;
import org.truffleruby.language.control.OrNode;
import org.truffleruby.language.control.OrNodeGen;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.RedoNode;
import org.truffleruby.language.control.RetryNode;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.control.SequenceNode;
import org.truffleruby.language.control.UnlessNodeGen;
import org.truffleruby.language.control.WhileNode;
import org.truffleruby.language.control.WhileNodeFactory;
import org.truffleruby.language.defined.DefinedNode;
import org.truffleruby.language.dispatch.RubyCallNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.exceptions.EnsureNodeGen;
import org.truffleruby.language.exceptions.RescueClassesNode;
import org.truffleruby.language.exceptions.RescueNode;
import org.truffleruby.language.exceptions.RescueSplatNode;
import org.truffleruby.language.exceptions.RescueStandardErrorNode;
import org.truffleruby.language.exceptions.TryNode;
import org.truffleruby.language.exceptions.TryNodeGen;
import org.truffleruby.language.globals.AliasGlobalVarNode;
import org.truffleruby.language.globals.ReadGlobalVariableNode;
import org.truffleruby.language.globals.ReadGlobalVariableNodeGen;
import org.truffleruby.language.globals.ReadMatchReferenceNodes;
import org.truffleruby.language.globals.WriteGlobalVariableNode;
import org.truffleruby.language.globals.WriteGlobalVariableNodeGen;
import org.truffleruby.language.literal.BooleanLiteralNode;
import org.truffleruby.language.literal.FloatLiteralNode;
import org.truffleruby.language.literal.FrozenStringLiteralNode;
import org.truffleruby.language.literal.IntegerFixnumLiteralNode;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.language.literal.ObjectClassLiteralNode;
import org.truffleruby.language.literal.ObjectLiteralNode;
import org.truffleruby.language.literal.StringLiteralNode;
import org.truffleruby.language.locals.InitFlipFlopSlotNode;
import org.truffleruby.language.locals.ReadLocalNode;
import org.truffleruby.language.locals.WriteLocalNode;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.CatchBreakNode;
import org.truffleruby.language.methods.ModuleBodyDefinition;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.DefineClassNode;
import org.truffleruby.language.objects.DefineModuleNode;
import org.truffleruby.language.objects.DefineModuleNodeGen;
import org.truffleruby.language.objects.DynamicLexicalScopeNode;
import org.truffleruby.language.objects.GetDynamicLexicalScopeNode;
import org.truffleruby.language.objects.InsideModuleDefinitionNode;
import org.truffleruby.language.objects.LexicalScopeNode;
import org.truffleruby.language.objects.ReadInstanceVariableNode;
import org.truffleruby.language.objects.RunModuleDefinitionNode;
import org.truffleruby.language.objects.SelfNode;
import org.truffleruby.language.objects.WriteInstanceVariableNode;
import org.truffleruby.language.objects.WriteInstanceVariableNodeGen;
import org.truffleruby.language.objects.classvariables.ReadClassVariableNode;
import org.truffleruby.language.objects.classvariables.WriteClassVariableNode;
import org.truffleruby.parser.DeadNode;
import org.truffleruby.parser.OpenModule;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.parser.SafeDoubleParser;
import org.truffleruby.parser.Translator;
import org.truffleruby.parser.TranslatorEnvironment;
import org.yarp.AbstractNodeVisitor;
import org.yarp.Nodes;

public final class YARPTranslator
extends AbstractNodeVisitor<RubyNode> {
    private final RubyLanguage language;
    private final YARPTranslator parent;
    private final TranslatorEnvironment environment;
    private final byte[] sourceBytes;
    private final Source source;
    private final ParserContext parserContext;
    private final Node currentNode;
    private final RubyDeferredWarnings rubyWarnings;
    private final RubyEncoding sourceEncoding;
    public Deque<Integer> frameOnStackMarkerSlotStack = new ArrayDeque<Integer>();
    public static final int NO_FRAME_ON_STACK_MARKER = -1;
    public static final RescueNode[] EMPTY_RESCUE_NODE_ARRAY = new RescueNode[0];
    private boolean translatingWhile = false;
    private boolean translatingNextExpression = false;

    public YARPTranslator(RubyLanguage language, YARPTranslator parent, TranslatorEnvironment environment, byte[] sourceBytes, Source source, ParserContext parserContext, Node currentNode, RubyDeferredWarnings rubyWarnings) {
        this.language = language;
        this.parent = parent;
        this.environment = environment;
        this.sourceBytes = sourceBytes;
        this.source = source;
        this.parserContext = parserContext;
        this.currentNode = currentNode;
        this.rubyWarnings = rubyWarnings;
        this.sourceEncoding = Encodings.UTF_8;
    }

    public RubyRootNode translate(Nodes.Node node) {
        RubyNode body = node.accept(this);
        FrameDescriptor frameDescriptor = TranslatorEnvironment.newFrameDescriptorBuilderForMethod().build();
        SourceSection sourceSection = CoreLibrary.JAVA_CORE_SOURCE_SECTION;
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, null, Arity.NO_ARGUMENTS, "<main>", 0, "<main>", null, null);
        return new RubyTopLevelRootNode(this.language, sourceSection, frameDescriptor, sharedMethodInfo, body, Split.HEURISTIC, null, Arity.NO_ARGUMENTS);
    }

    @Override
    public RubyNode visitAliasNode(Nodes.AliasNode node) {
        RubyContextSourceNode rubyNode = node.new_name instanceof Nodes.GlobalVariableReadNode && node.old_name instanceof Nodes.GlobalVariableReadNode ? new AliasGlobalVarNode(this.toString(node.old_name), this.toString(node.new_name)) : new ModuleNodes.AliasKeywordNode(node.new_name.accept(this), node.old_name.accept(this));
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitAlternationPatternNode(Nodes.AlternationPatternNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitAndNode(Nodes.AndNode node) {
        RubyNode left = node.left.accept(this);
        RubyNode right = node.right.accept(this);
        AndNode rubyNode = AndNodeGen.create(left, right);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitArgumentsNode(Nodes.ArgumentsNode node) {
        Nodes.Node[] values = node.arguments;
        if (values.length == 1) {
            return values[0].accept(this);
        }
        RubyNode[] translatedValues = YARPTranslator.createArray(values.length);
        for (int n = 0; n < values.length; ++n) {
            translatedValues[n] = values[n].accept(this);
        }
        ArrayLiteralNode rubyNode = ArrayLiteralNode.create(this.language, translatedValues);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitArrayNode(Nodes.ArrayNode node) {
        RubyNode[] elements = new RubyNode[node.elements.length];
        for (int i = 0; i < node.elements.length; ++i) {
            elements[i] = node.elements[i].accept(this);
        }
        ArrayLiteralNode rubyNode = ArrayLiteralNode.create(this.language, elements);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitArrayPatternNode(Nodes.ArrayPatternNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitAssocNode(Nodes.AssocNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitAssocSplatNode(Nodes.AssocSplatNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitBackReferenceReadNode(Nodes.BackReferenceReadNode node) {
        ReadGlobalVariableNode rubyNode = ReadGlobalVariableNodeGen.create(this.toString(node));
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitBeginNode(Nodes.BeginNode node) {
        if (node.statements == null) {
            return new NilLiteralNode(true);
        }
        RubyNode rubyNode = node.statements.accept(this);
        if (node.rescue_clause == null && node.ensure_clause == null) {
            return rubyNode;
        }
        if (node.rescue_clause != null) {
            ArrayList<RescueNode> rescueNodes = new ArrayList<RescueNode>();
            Nodes.RescueNode rescueClause = node.rescue_clause;
            while (rescueClause != null) {
                if (rescueClause.exceptions.length != 0) {
                    ArrayList<Nodes.Node> exceptionNodes = new ArrayList<Nodes.Node>();
                    for (Nodes.Node exceptionNode : rescueClause.exceptions) {
                        if (exceptionNode instanceof Nodes.SplatNode) {
                            Nodes.SplatNode splatNode = (Nodes.SplatNode)exceptionNode;
                            if (!exceptionNodes.isEmpty()) {
                                RescueNode rescueNode = this.translateExceptionNodes(exceptionNodes, rescueClause);
                                rescueNodes.add(rescueNode);
                                exceptionNodes.clear();
                            }
                            RubyNode splatTranslated = this.translateNodeOrNil(splatNode.expression);
                            RubyNode translatedBody = this.translateNodeOrNil(rescueClause.statements);
                            if (rescueClause.reference != null) {
                                RubyNode exceptionWriteNode = this.translateRescueException(rescueClause.reference);
                                translatedBody = YARPTranslator.sequence(rescueClause, Arrays.asList(exceptionWriteNode, translatedBody));
                            }
                            RescueSplatNode rescueNode = new RescueSplatNode(this.language, splatTranslated, translatedBody);
                            YARPTranslator.assignNodePositionInSource(splatNode, rescueNode);
                            rescueNodes.add(rescueNode);
                            continue;
                        }
                        exceptionNodes.add(exceptionNode);
                    }
                    if (!exceptionNodes.isEmpty()) {
                        rescueNode = this.translateExceptionNodes(exceptionNodes, rescueClause);
                        rescueNodes.add(rescueNode);
                    }
                } else {
                    RubyNode translatedBody = this.translateNodeOrNil(rescueClause.statements);
                    if (rescueClause.reference != null) {
                        RubyNode exceptionWriteNode = this.translateRescueException(rescueClause.reference);
                        translatedBody = YARPTranslator.sequence(rescueClause, Arrays.asList(exceptionWriteNode, translatedBody));
                    }
                    rescueNode = new RescueStandardErrorNode(translatedBody);
                    YARPTranslator.assignNodePositionInSource(rescueClause, rescueNode);
                    rescueNodes.add(rescueNode);
                }
                rescueClause = rescueClause.consequent;
            }
            RubyNode elsePart = node.else_clause == null ? null : node.else_clause.accept(this);
            rescueClause = node.rescue_clause;
            boolean canOmitBacktrace = this.language.options.BACKTRACES_OMIT_UNUSED && rescueClause.reference == null && rescueClause.consequent == null && (rescueClause.statements == null || rescueClause.statements.body.length == 1 && this.isSideEffectFreeRescueExpression(rescueClause.statements.body[0]));
            rubyNode = TryNodeGen.create(rubyNode, rescueNodes.toArray(EMPTY_RESCUE_NODE_ARRAY), elsePart, canOmitBacktrace);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
        }
        if (node.ensure_clause != null && node.ensure_clause.statements != null) {
            RubyNode ensureBlock = node.ensure_clause.accept(this);
            rubyNode = EnsureNodeGen.create(rubyNode, ensureBlock);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
        }
        return rubyNode;
    }

    private RescueNode translateExceptionNodes(ArrayList<Nodes.Node> exceptionNodes, Nodes.RescueNode rescueClause) {
        RubyNode translatedBody = this.translateNodeOrNil(rescueClause.statements);
        Nodes.Node[] exceptionNodesArray = exceptionNodes.toArray(Nodes.Node.EMPTY_ARRAY);
        RubyNode[] handlingClasses = new RubyNode[exceptionNodesArray.length];
        for (int i = 0; i < exceptionNodesArray.length; ++i) {
            handlingClasses[i] = exceptionNodesArray[i].accept(this);
        }
        if (rescueClause.reference != null) {
            RubyNode exceptionWriteNode = this.translateRescueException(rescueClause.reference);
            translatedBody = YARPTranslator.sequence(rescueClause, Arrays.asList(exceptionWriteNode, translatedBody));
        }
        RescueClassesNode rescueNode = new RescueClassesNode(handlingClasses, translatedBody);
        this.assignNodePositionInSource(exceptionNodesArray, rescueNode);
        return rescueNode;
    }

    @Override
    public RubyNode visitBlockArgumentNode(Nodes.BlockArgumentNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitBlockNode(Nodes.BlockNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitBreakNode(Nodes.BreakNode node) {
        if (!this.environment.isBlock() && !this.translatingWhile) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("Invalid break", this.currentNode, this.getSourceSection(node)));
        }
        RubyNode argumentsNode = this.translateControlFlowArguments(node.arguments);
        BreakNode rubyNode = new BreakNode(this.environment.getBreakID(), this.translatingWhile, argumentsNode);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitCallNode(Nodes.CallNode node) {
        String methodName = TStringUtils.toJavaStringOrThrow(node.name, this.sourceEncoding);
        SelfNode receiver = node.receiver == null ? new SelfNode() : node.receiver.accept(this);
        Nodes.Node[] arguments = node.arguments == null ? Nodes.Node.EMPTY_ARRAY : node.arguments.arguments;
        RubyNode[] translatedArguments = new RubyNode[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            translatedArguments[i] = arguments[i].accept(this);
        }
        boolean ignoreVisibility = node.receiver == null;
        boolean isVCall = node.isVariableCall();
        boolean isAttrAssign = methodName.endsWith("=");
        RubyCallNode rubyCallNode = new RubyCallNode(new RubyCallNodeParameters(receiver, methodName, null, EmptyArgumentsDescriptor.INSTANCE, translatedArguments, false, ignoreVisibility, isVCall, false, isAttrAssign));
        YARPTranslator.assignNodePositionInSource(node, rubyCallNode);
        return rubyCallNode;
    }

    @Override
    public RubyNode visitCallOperatorAndWriteNode(Nodes.CallOperatorAndWriteNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitCallOperatorOrWriteNode(Nodes.CallOperatorOrWriteNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitCallOperatorWriteNode(Nodes.CallOperatorWriteNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitCapturePatternNode(Nodes.CapturePatternNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitCaseNode(Nodes.CaseNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitClassNode(Nodes.ClassNode node) {
        String name;
        RubyNode lexicalParent = this.translateCPath(node.constant_path);
        Nodes.Node node2 = node.constant_path;
        if (node2 instanceof Nodes.ConstantReadNode) {
            Nodes.ConstantReadNode constantNode = (Nodes.ConstantReadNode)node2;
            name = this.toString(constantNode);
        } else {
            node2 = node.constant_path;
            if (node2 instanceof Nodes.ConstantPathNode) {
                Nodes.ConstantPathNode pathNode = (Nodes.ConstantPathNode)node2;
                name = this.toString(pathNode.child);
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        RubyNode superClass = node.superclass != null ? node.superclass.accept(this) : null;
        DefineClassNode defineOrGetClass = new DefineClassNode(name, lexicalParent, superClass);
        RubyNode rubyNode = this.openModule(node, defineOrGetClass, name, node.body, OpenModule.CLASS, this.shouldUseDynamicConstantLookupForModuleBody(node));
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitClassVariableReadNode(Nodes.ClassVariableReadNode node) {
        ReadClassVariableNode rubyNode = new ReadClassVariableNode(this.getLexicalScopeNode("class variable lookup", node), this.toString(node));
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitClassVariableWriteNode(Nodes.ClassVariableWriteNode node) {
        RubyNode rhs = this.translateNodeOrDeadNode(node.value, "YARPTranslator#visitClassVariableWriteNode");
        WriteClassVariableNode rubyNode = new WriteClassVariableNode(this.getLexicalScopeNode("set dynamic class variable", node), this.toString(node.name_loc), rhs);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitConstantPathNode(Nodes.ConstantPathNode node) {
        assert (node.child instanceof Nodes.ConstantReadNode);
        String name = this.toString(node.child);
        RubyNode moduleNode = node.parent != null ? node.parent.accept(this) : new ObjectClassLiteralNode();
        ReadConstantNode rubyNode = new ReadConstantNode(moduleNode, name);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitConstantPathWriteNode(Nodes.ConstantPathWriteNode node) {
        Nodes.ConstantPathNode constantPathNode = node.target;
        RubyNode moduleNode = constantPathNode.parent != null ? constantPathNode.parent.accept(this) : new ObjectClassLiteralNode();
        String name = this.toString(constantPathNode.child);
        RubyNode value = this.translateNodeOrDeadNode(node.value, "YARPTranslator#visitConstantPathWriteNode");
        WriteConstantNode rubyNode = new WriteConstantNode(name, moduleNode, value);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitConstantReadNode(Nodes.ConstantReadNode node) {
        RubyContextSourceNode rubyNode;
        String name = this.toString(node);
        if (this.environment.isDynamicConstantLookup()) {
            if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                RubyLanguage.LOGGER.info(() -> "dynamic constant lookup at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(node)));
            }
            rubyNode = new ReadConstantWithDynamicScopeNode(name);
        } else {
            LexicalScope lexicalScope = this.environment.getStaticLexicalScope();
            rubyNode = new ReadConstantWithLexicalScopeNode(lexicalScope, name);
        }
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitConstantWriteNode(Nodes.ConstantWriteNode node) {
        RubyContextSourceNode moduleNode;
        String name = this.toString(node.name_loc);
        RubyNode value = this.translateNodeOrDeadNode(node.value, "YARPTranslator#visitConstantWriteNode");
        if (this.environment.isDynamicConstantLookup()) {
            if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                RubyLanguage.LOGGER.info(() -> "set dynamic constant at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(node)));
            }
            moduleNode = new DynamicLexicalScopeNode();
        } else {
            moduleNode = new LexicalScopeNode(this.environment.getStaticLexicalScope());
        }
        WriteConstantNode rubyNode = new WriteConstantNode(name, moduleNode, value);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitDefNode(Nodes.DefNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitDefinedNode(Nodes.DefinedNode node) {
        if (node.value instanceof Nodes.YieldNode && this.isInvalidYield()) {
            NilLiteralNode nilNode = new NilLiteralNode(false);
            YARPTranslator.assignNodePositionInSource(node, nilNode);
            return nilNode;
        }
        RubyNode value = node.value.accept(this);
        DefinedNode rubyNode = new DefinedNode(value);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitElseNode(Nodes.ElseNode node) {
        if (node.statements == null) {
            NilLiteralNode rubyNode = new NilLiteralNode(true);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
            return rubyNode;
        }
        return node.statements.accept(this);
    }

    @Override
    public RubyNode visitEmbeddedStatementsNode(Nodes.EmbeddedStatementsNode node) {
        if (node.statements == null) {
            ObjectLiteralNode rubyNode = new ObjectLiteralNode(this.language.getFrozenStringLiteral(this.sourceEncoding.tencoding.getEmpty(), this.sourceEncoding));
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
            return rubyNode;
        }
        return node.statements.accept(this);
    }

    @Override
    public RubyNode visitEmbeddedVariableNode(Nodes.EmbeddedVariableNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitEnsureNode(Nodes.EnsureNode node) {
        if (node.statements == null) {
            NilLiteralNode rubyNode = new NilLiteralNode(true);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
            return rubyNode;
        }
        return node.statements.accept(this);
    }

    @Override
    public RubyNode visitFalseNode(Nodes.FalseNode node) {
        BooleanLiteralNode rubyNode = new BooleanLiteralNode(false);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitFindPatternNode(Nodes.FindPatternNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitFloatNode(Nodes.FloatNode node) {
        double value;
        String string = this.toString(node).replaceAll("_", "");
        try {
            value = SafeDoubleParser.parseDouble(string);
        }
        catch (NumberFormatException e) {
            value = string.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        FloatLiteralNode rubyNode = new FloatLiteralNode(value);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitForNode(Nodes.ForNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitForwardingArgumentsNode(Nodes.ForwardingArgumentsNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitForwardingSuperNode(Nodes.ForwardingSuperNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitGlobalVariableReadNode(Nodes.GlobalVariableReadNode node) {
        ReadGlobalVariableNode rubyNode = ReadGlobalVariableNodeGen.create(this.toString(node));
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitGlobalVariableWriteNode(Nodes.GlobalVariableWriteNode node) {
        String name = this.toString(node.name_loc);
        RubyNode value = this.translateNodeOrDeadNode(node.value, "YARPTranslator#visitGlobalVariableWriteNode");
        WriteGlobalVariableNode rubyNode = WriteGlobalVariableNodeGen.create(name, value);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitHashNode(Nodes.HashNode node) {
        RubyNode rubyNode;
        if (node.elements.length == 0) {
            HashLiteralNode rubyNode2 = HashLiteralNode.create(RubyNode.EMPTY_ARRAY);
            YARPTranslator.assignNodePositionInSource(node, rubyNode2);
            return rubyNode2;
        }
        ArrayList<RubyContextSourceNode> hashConcats = new ArrayList<RubyContextSourceNode>();
        ArrayList<RubyNode> keyValues = new ArrayList<RubyNode>();
        for (Nodes.Node pair : node.elements) {
            if (pair instanceof Nodes.AssocSplatNode) {
                Nodes.AssocSplatNode assocSplatNode = (Nodes.AssocSplatNode)pair;
                if (!keyValues.isEmpty()) {
                    HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(keyValues.toArray(RubyNode.EMPTY_ARRAY));
                    hashConcats.add(hashLiteralSoFar);
                }
                hashConcats.add(HashCastNodeGen.HashCastASTNodeGen.create(assocSplatNode.value.accept(this)));
                keyValues.clear();
                continue;
            }
            if (pair instanceof Nodes.AssocNode) {
                Nodes.AssocNode assocNode = (Nodes.AssocNode)pair;
                RubyNode keyNode = assocNode.key.accept(this);
                if (keyNode instanceof StringLiteralNode) {
                    StringLiteralNode stringNode = (StringLiteralNode)keyNode;
                    ImmutableRubyString frozenString = this.language.getFrozenStringLiteral(stringNode.getTString(), stringNode.getEncoding());
                    keyNode = new FrozenStringLiteralNode(frozenString, FrozenStrings.EXPRESSION);
                }
                keyValues.add(keyNode);
                keyValues.add(assocNode.value.accept(this));
                continue;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (!keyValues.isEmpty()) {
            HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(keyValues.toArray(RubyNode.EMPTY_ARRAY));
            hashConcats.add(hashLiteralSoFar);
        }
        if (hashConcats.size() == 1) {
            rubyNode = (RubyNode)((Object)hashConcats.get(0));
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
            return rubyNode;
        }
        rubyNode = new ConcatHashLiteralNode(hashConcats.toArray(RubyNode.EMPTY_ARRAY));
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitHashPatternNode(Nodes.HashPatternNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitIfNode(Nodes.IfNode node) {
        RubyNode rubyNode;
        RubyNode elseNode;
        RubyNode conditionNode = node.predicate.accept(this);
        RubyNode thenNode = node.statements == null ? null : node.statements.accept(this);
        RubyNode rubyNode2 = elseNode = node.consequent == null ? null : node.consequent.accept(this);
        if (thenNode != null && elseNode != null) {
            rubyNode = IfElseNodeGen.create(conditionNode, thenNode, elseNode);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
        } else if (thenNode != null) {
            rubyNode = IfNodeGen.create(conditionNode, thenNode);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
        } else if (elseNode != null) {
            rubyNode = UnlessNodeGen.create(conditionNode, elseNode);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
        } else {
            rubyNode = YARPTranslator.sequence(node, Arrays.asList(new RubyNode[]{conditionNode, new NilLiteralNode(true)}));
        }
        return rubyNode;
    }

    @Override
    public RubyNode visitImaginaryNode(Nodes.ImaginaryNode node) {
        ObjectClassLiteralNode objectClassNode = new ObjectClassLiteralNode();
        ReadConstantNode complexModuleNode = new ReadConstantNode(objectClassNode, "Complex");
        IntegerFixnumLiteralNode realComponentNode = new IntegerFixnumLiteralNode(0);
        RubyNode imaginaryComponentNode = node.numeric.accept(this);
        RubyNode[] arguments = new RubyNode[]{realComponentNode, imaginaryComponentNode};
        RubyContextSourceNode rubyNode = this.createCallNode(complexModuleNode, "convert", arguments);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitInNode(Nodes.InNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitInstanceVariableReadNode(Nodes.InstanceVariableReadNode node) {
        String name = this.toString(node);
        ReadInstanceVariableNode rubyNode = new ReadInstanceVariableNode(name);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitInstanceVariableWriteNode(Nodes.InstanceVariableWriteNode node) {
        String name = this.toString(node.name_loc);
        RubyNode value = this.translateNodeOrDeadNode(node.value, "YARPTranslator#visitInstanceVariableWriteNode");
        WriteInstanceVariableNode rubyNode = WriteInstanceVariableNodeGen.create(name, value);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitIntegerNode(Nodes.IntegerNode node) {
        int offset;
        int radix;
        String string = this.toString(node).replaceAll("_", "");
        if (string.startsWith("0b") || string.startsWith("0B")) {
            radix = 2;
            offset = 2;
        } else if (string.startsWith("0x") || string.startsWith("0X")) {
            radix = 16;
            offset = 2;
        } else if (string.startsWith("0d") || string.startsWith("0D")) {
            radix = 10;
            offset = 2;
        } else if (string.startsWith("0o") || string.startsWith("0O")) {
            radix = 8;
            offset = 2;
        } else if (string.startsWith("0")) {
            radix = 8;
            offset = 1;
        } else {
            radix = 10;
            offset = 0;
        }
        long value = Long.parseLong(string.substring(offset), radix);
        RubyNode rubyNode = Translator.integerOrLongLiteralNode(value);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitInterpolatedRegularExpressionNode(Nodes.InterpolatedRegularExpressionNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitInterpolatedStringNode(Nodes.InterpolatedStringNode node) {
        Nodes.Node node2;
        ToSNode[] children = new ToSNode[node.parts.length];
        if (node.parts.length == 1 && (node2 = node.parts[0]) instanceof Nodes.StringNode) {
            Nodes.StringNode s = (Nodes.StringNode)node2;
            TruffleString tstring = TStringUtils.fromByteArray(s.unescaped, this.sourceEncoding);
            TruffleString cachedTString = this.language.tstringCache.getTString(tstring, this.sourceEncoding);
            StringLiteralNode rubyNode = new StringLiteralNode(cachedTString, this.sourceEncoding);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
            YARPTranslator.copyNewlineFlag(s, rubyNode);
            return rubyNode;
        }
        for (int i = 0; i < node.parts.length; ++i) {
            Nodes.Node part = node.parts[i];
            children[i] = ToSNodeGen.create(part.accept(this));
        }
        InterpolatedStringNode rubyNode = new InterpolatedStringNode(children, this.sourceEncoding.jcoding);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitInterpolatedSymbolNode(Nodes.InterpolatedSymbolNode node) {
        ToSNode[] children = new ToSNode[node.parts.length];
        for (int i = 0; i < node.parts.length; ++i) {
            RubyNode expression = node.parts[i].accept(this);
            children[i] = ToSNodeGen.create(expression);
        }
        InterpolatedStringNode stringNode = new InterpolatedStringNode(children, this.sourceEncoding.jcoding);
        StringToSymbolNode rubyNode = StringToSymbolNodeGen.create(stringNode);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitInterpolatedXStringNode(Nodes.InterpolatedXStringNode node) {
        Nodes.InterpolatedStringNode stringNode = new Nodes.InterpolatedStringNode(node.opening_loc, node.parts, node.closing_loc, node.startOffset, node.length);
        RubyNode string = stringNode.accept(this);
        RubyContextSourceNode rubyNode = this.createCallNode(new SelfNode(), "`", string);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitKeywordHashNode(Nodes.KeywordHashNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitLambdaNode(Nodes.LambdaNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitLocalVariableReadNode(Nodes.LocalVariableReadNode node) {
        String name = this.toString(node);
        ReadLocalNode rubyNode = this.environment.findLocalVarNode(name, null);
        assert (rubyNode != null) : name;
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitLocalVariableWriteNode(Nodes.LocalVariableWriteNode node) {
        ReadLocalNode lhs;
        String name = this.toString(node.name_loc);
        if (this.environment.getNeverAssignInParentScope()) {
            this.environment.declareVar(name);
        }
        if ((lhs = this.environment.findLocalVarNode(name, null)) == null) {
            TranslatorEnvironment environmentToDeclareIn = this.environment;
            while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                environmentToDeclareIn = environmentToDeclareIn.getParent();
            }
            environmentToDeclareIn.declareVar(name);
            lhs = this.environment.findLocalVarNode(name, null);
            if (lhs == null) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        RubyNode rhs = this.translateNodeOrDeadNode(node.value, "YARPTranslator#visitLocalVariableWriteNode");
        WriteLocalNode rubyNode = lhs.makeWriteNode(rhs);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitMatchPredicateNode(Nodes.MatchPredicateNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitMatchRequiredNode(Nodes.MatchRequiredNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitMissingNode(Nodes.MissingNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitModuleNode(Nodes.ModuleNode node) {
        String name;
        RubyNode lexicalParent = this.translateCPath(node.constant_path);
        Nodes.Node node2 = node.constant_path;
        if (node2 instanceof Nodes.ConstantReadNode) {
            Nodes.ConstantReadNode constantNode = (Nodes.ConstantReadNode)node2;
            name = this.toString(constantNode);
        } else {
            node2 = node.constant_path;
            if (node2 instanceof Nodes.ConstantPathNode) {
                Nodes.ConstantPathNode pathNode = (Nodes.ConstantPathNode)node2;
                name = this.toString(pathNode.child);
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        DefineModuleNode defineModuleNode = DefineModuleNodeGen.create(name, lexicalParent);
        RubyNode rubyNode = this.openModule(node, defineModuleNode, name, node.body, OpenModule.MODULE, this.shouldUseDynamicConstantLookupForModuleBody(node));
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitMultiWriteNode(Nodes.MultiWriteNode node) {
        return this.defaultVisit(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitNextNode(Nodes.NextNode node) {
        RubyNode argumentsNode;
        if (!this.environment.isBlock() && !this.translatingWhile) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("Invalid next", this.currentNode, this.getSourceSection(node)));
        }
        boolean t = this.translatingNextExpression;
        this.translatingNextExpression = true;
        try {
            argumentsNode = this.translateControlFlowArguments(node.arguments);
        }
        finally {
            this.translatingNextExpression = t;
        }
        NextNode rubyNode = new NextNode(argumentsNode);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitNilNode(Nodes.NilNode node) {
        NilLiteralNode rubyNode = new NilLiteralNode(false);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitNumberedReferenceReadNode(Nodes.NumberedReferenceReadNode node) {
        String name = this.toString(node);
        int index = Integer.parseInt(name.substring(1));
        ReadGlobalVariableNode lastMatchNode = ReadGlobalVariableNodeGen.create("$~");
        ReadMatchReferenceNodes.ReadNthMatchNode rubyNode = new ReadMatchReferenceNodes.ReadNthMatchNode(lastMatchNode, index);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitOrNode(Nodes.OrNode node) {
        RubyNode left = node.left.accept(this);
        RubyNode right = node.right.accept(this);
        OrNode rubyNode = OrNodeGen.create(left, right);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitParenthesesNode(Nodes.ParenthesesNode node) {
        if (node.body == null) {
            NilLiteralNode rubyNode = new NilLiteralNode(true);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
            return rubyNode;
        }
        return node.body.accept(this);
    }

    @Override
    public RubyNode visitPinnedExpressionNode(Nodes.PinnedExpressionNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitPinnedVariableNode(Nodes.PinnedVariableNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitPostExecutionNode(Nodes.PostExecutionNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitPreExecutionNode(Nodes.PreExecutionNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitProgramNode(Nodes.ProgramNode node) {
        return node.statements.accept(this);
    }

    @Override
    public RubyNode visitRangeNode(Nodes.RangeNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitRationalNode(Nodes.RationalNode node) {
        ObjectClassLiteralNode objectClassNode = new ObjectClassLiteralNode();
        ReadConstantNode rationalModuleNode = new ReadConstantNode(objectClassNode, "Rational");
        RubyNode numeratorNode = node.numeric.accept(this);
        IntegerFixnumLiteralNode denominatorNode = new IntegerFixnumLiteralNode(1);
        RubyNode[] arguments = new RubyNode[]{numeratorNode, denominatorNode};
        RubyContextSourceNode rubyNode = this.createCallNode(rationalModuleNode, "convert", arguments);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitRedoNode(Nodes.RedoNode node) {
        if (!this.environment.isBlock() && !this.translatingWhile) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("Invalid redo", this.currentNode, this.getSourceSection(node)));
        }
        RedoNode rubyNode = new RedoNode();
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitRegularExpressionNode(Nodes.RegularExpressionNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitRescueModifierNode(Nodes.RescueModifierNode node) {
        RubyNode tryNode = node.expression.accept(this);
        RubyNode rescueExpressionNode = node.rescue_expression.accept(this);
        RescueStandardErrorNode rescueNode = new RescueStandardErrorNode(rescueExpressionNode);
        boolean canOmitBacktrace = this.language.options.BACKTRACES_OMIT_UNUSED && this.isSideEffectFreeRescueExpression(node.rescue_expression);
        TryNode rubyNode = TryNodeGen.create(tryNode, new RescueNode[]{rescueNode}, null, canOmitBacktrace);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitRescueNode(Nodes.RescueNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitRetryNode(Nodes.RetryNode node) {
        RetryNode rubyNode = new RetryNode();
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitReturnNode(Nodes.ReturnNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitSelfNode(Nodes.SelfNode node) {
        SelfNode rubyNode = new SelfNode();
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitSingletonClassNode(Nodes.SingletonClassNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitSourceEncodingNode(Nodes.SourceEncodingNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitSourceFileNode(Nodes.SourceFileNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitSourceLineNode(Nodes.SourceLineNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitSplatNode(Nodes.SplatNode node) {
        RubyNode value = this.translateNodeOrNil(node.expression);
        SplatCastNode rubyNode = SplatCastNodeGen.create(this.language, SplatCastNode.NilBehavior.CONVERT, false, value);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitStatementsNode(Nodes.StatementsNode node) {
        Nodes.Node[] body = node.body;
        RubyNode[] translated = new RubyNode[body.length];
        for (int i = 0; i < body.length; ++i) {
            translated[i] = body[i].accept(this);
        }
        return YARPTranslator.sequence(node, Arrays.asList(translated));
    }

    @Override
    public RubyNode visitStringConcatNode(Nodes.StringConcatNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitStringNode(Nodes.StringNode node) {
        TruffleString tstring = TStringUtils.fromByteArray(node.unescaped, this.sourceEncoding);
        TruffleString cachedTString = this.language.tstringCache.getTString(tstring, this.sourceEncoding);
        StringLiteralNode rubyNode = new StringLiteralNode(cachedTString, this.sourceEncoding);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitSuperNode(Nodes.SuperNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitSymbolNode(Nodes.SymbolNode node) {
        TruffleString tstring = TStringUtils.fromByteArray(node.unescaped, this.sourceEncoding);
        RubySymbol symbol = this.language.getSymbol((AbstractTruffleString)tstring, this.sourceEncoding);
        ObjectLiteralNode rubyNode = new ObjectLiteralNode(symbol);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitTrueNode(Nodes.TrueNode node) {
        BooleanLiteralNode rubyNode = new BooleanLiteralNode(true);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitUndefNode(Nodes.UndefNode node) {
        RubyNode[] names = new RubyNode[node.names.length];
        for (int i = 0; i < node.names.length; ++i) {
            names[i] = node.names[i].accept(this);
        }
        ModuleNodes.UndefNode rubyNode = new ModuleNodes.UndefNode(names);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitUnlessNode(Nodes.UnlessNode node) {
        RubyNode rubyNode;
        RubyNode elseNode;
        RubyNode conditionNode = node.predicate.accept(this);
        RubyNode thenNode = node.statements == null ? null : node.statements.accept(this);
        RubyNode rubyNode2 = elseNode = node.consequent == null ? null : node.consequent.accept(this);
        if (thenNode != null && elseNode != null) {
            rubyNode = IfElseNodeGen.create(conditionNode, elseNode, thenNode);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
        } else if (thenNode != null) {
            rubyNode = UnlessNodeGen.create(conditionNode, thenNode);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
        } else if (elseNode != null) {
            rubyNode = IfNodeGen.create(conditionNode, elseNode);
            YARPTranslator.assignNodePositionInSource(node, rubyNode);
        } else {
            rubyNode = YARPTranslator.sequence(node, Arrays.asList(new RubyNode[]{conditionNode, new NilLiteralNode(true)}));
        }
        return rubyNode;
    }

    @Override
    public RubyNode visitUntilNode(Nodes.UntilNode node) {
        RubyNode rubyNode = this.translateWhileNode(node, node.predicate, node.statements, true);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitWhenNode(Nodes.WhenNode node) {
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitWhileNode(Nodes.WhileNode node) {
        RubyNode rubyNode = this.translateWhileNode(node, node.predicate, node.statements, false);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitXStringNode(Nodes.XStringNode node) {
        Nodes.StringNode stringNode = new Nodes.StringNode(node.opening_loc, node.content_loc, node.closing_loc, node.unescaped, node.startOffset, node.length);
        RubyNode string = stringNode.accept(this);
        RubyContextSourceNode rubyNode = this.createCallNode(new SelfNode(), "`", string);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitYieldNode(Nodes.YieldNode node) {
        return this.defaultVisit(node);
    }

    @Override
    protected RubyNode defaultVisit(Nodes.Node node) {
        throw new Error("Unknown node: " + node);
    }

    private RubyNode getLexicalScopeNode(String kind, Nodes.Node yarpNode) {
        if (this.environment.isDynamicConstantLookup()) {
            if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                RubyLanguage.LOGGER.info(() -> kind + " at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(yarpNode)));
            }
            return new GetDynamicLexicalScopeNode();
        }
        return new ObjectLiteralNode(this.environment.getStaticLexicalScope());
    }

    private RubyNode openModule(Nodes.Node moduleNode, RubyNode defineOrGetNode, String moduleName, Nodes.Node bodyNode, OpenModule type, boolean dynamicConstantLookup) {
        String methodName = type.format(moduleName);
        LexicalScope newLexicalScope = dynamicConstantLookup ? null : new LexicalScope(this.environment.getStaticLexicalScope());
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(this.getSourceSection(moduleNode), newLexicalScope, Arity.NO_ARGUMENTS, methodName, 0, methodName, null, null);
        String modulePath = type == OpenModule.SINGLETON_CLASS ? moduleName : TranslatorEnvironment.composeModulePath(this.environment.modulePath, moduleName);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.environment, this.environment.getParseEnvironment(), ReturnID.MODULE_BODY, true, true, sharedMethodInfo, methodName, 0, null, null, modulePath);
        YARPTranslator moduleTranslator = new YARPTranslator(this.language, this, newEnvironment, this.sourceBytes, this.source, this.parserContext, this.currentNode, this.rubyWarnings);
        ModuleBodyDefinition definition = moduleTranslator.compileClassNode(moduleNode, bodyNode);
        return new RunModuleDefinitionNode(definition, defineOrGetNode);
    }

    private ModuleBodyDefinition compileClassNode(Nodes.Node moduleNode, Nodes.Node bodyNode) {
        RubyNode body = this.translateNodeOrNil(bodyNode);
        body = new InsideModuleDefinitionNode(body);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = YARPTranslator.sequence(Arrays.asList(YARPTranslator.initFlipFlopStates(this.environment), body));
        }
        RubyNode writeSelfNode = YARPTranslator.loadSelf(this.language);
        body = YARPTranslator.sequence(Arrays.asList(writeSelfNode, body));
        RubyRootNode rootNode = new RubyRootNode(this.language, this.getSourceSection(moduleNode), this.environment.computeFrameDescriptor(), this.environment.getSharedMethodInfo(), body, Split.NEVER, this.environment.getReturnID());
        return new ModuleBodyDefinition(this.environment.getSharedMethodInfo().getOriginalName(), this.environment.getSharedMethodInfo(), rootNode.getCallTarget(), this.environment.getStaticLexicalScopeOrNull());
    }

    private RubyNode translateCPath(Nodes.Node node) {
        RubyNode rubyNode;
        if (node instanceof Nodes.ConstantReadNode) {
            rubyNode = this.getLexicalScopeModuleNode("dynamic constant lookup", node);
        } else if (node instanceof Nodes.ConstantPathNode) {
            Nodes.ConstantPathNode pathNode = (Nodes.ConstantPathNode)node;
            rubyNode = pathNode.parent != null ? pathNode.parent.accept(this) : new ObjectClassLiteralNode();
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        return rubyNode;
    }

    private RubyNode getLexicalScopeModuleNode(String kind, Nodes.Node node) {
        if (this.environment.isDynamicConstantLookup()) {
            if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                RubyLanguage.LOGGER.info(() -> kind + " at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(node)));
            }
            return new DynamicLexicalScopeNode();
        }
        return new LexicalScopeNode(this.environment.getStaticLexicalScope());
    }

    protected static RubyNode initFlipFlopStates(TranslatorEnvironment environment) {
        RubyNode[] initNodes = YARPTranslator.createArray(environment.getFlipFlopStates().size());
        for (int n = 0; n < initNodes.length; ++n) {
            initNodes[n] = new InitFlipFlopSlotNode(environment.getFlipFlopStates().get(n));
        }
        return YARPTranslator.sequence(Arrays.asList(initNodes));
    }

    protected static RubyNode[] createArray(int size) {
        return size == 0 ? RubyNode.EMPTY_ARRAY : new RubyNode[size];
    }

    public static RubyNode loadSelf(RubyLanguage language) {
        return new WriteLocalVariableNode(0, YARPTranslator.profileArgument(language, new ReadSelfNode()));
    }

    public static RubyNode profileArgument(RubyLanguage language, RubyNode argumentNode) {
        RubyNode node = argumentNode;
        if (language.options.PROFILE_ARGUMENTS) {
            node = ProfileArgumentNodeGen.create(node);
        }
        if (language.options.CHAOS_DATA) {
            node = ChaosNode.create(node);
        }
        return node;
    }

    private boolean shouldUseDynamicConstantLookupForModuleBody(Nodes.Node node) {
        if (this.environment.isDynamicConstantLookup()) {
            return true;
        }
        if (this.environment.isModuleBody()) {
            return false;
        }
        if (this.environment.isTopLevelScope()) {
            return false;
        }
        if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
            RubyLanguage.LOGGER.info(() -> "start dynamic constant lookup at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(node)));
        }
        return true;
    }

    protected RubyNode translateNodeOrNil(Nodes.Node node) {
        RubyNode rubyNode = node == null ? new NilLiteralNode(false) : node.accept(this);
        return rubyNode;
    }

    protected RubyNode translateNodeOrDeadNode(Nodes.Node node, String label) {
        if (node != null) {
            return node.accept(this);
        }
        return new DeadNode(label);
    }

    private boolean isInvalidYield() {
        return this.environment.getSurroundingMethodEnvironment().isModuleBody();
    }

    private RubyNode translateControlFlowArguments(Nodes.ArgumentsNode node) {
        if (node == null) {
            return new NilLiteralNode(false);
        }
        Nodes.Node[] values = node.arguments;
        if (values.length == 1) {
            return values[0].accept(this);
        }
        RubyNode[] translatedValues = YARPTranslator.createArray(values.length);
        for (int n = 0; n < values.length; ++n) {
            translatedValues[n] = values[n].accept(this);
        }
        ArrayLiteralNode rubyNode = ArrayLiteralNode.create(this.language, translatedValues);
        YARPTranslator.assignNodePositionInSource(node, rubyNode);
        return rubyNode;
    }

    private RubyNode translateRescueException(Nodes.Node exception) {
        RubyNode writeNode = exception.accept(this);
        if (writeNode instanceof RubyCallNode) {
            RubyCallNode rubyNode = (RubyCallNode)writeNode;
            if (rubyNode.getName().equals("[]=")) {
                assert (rubyNode.getArguments().length == 1);
                RubyNode[] arguments = new RubyNode[]{rubyNode.getArguments()[0], new DeadNode("YARPTranslator#translateRescueException")};
                writeNode = rubyNode.cloneUninitializedWithArguments(arguments);
            } else if (rubyNode.getName().endsWith("=")) {
                assert (rubyNode.getArguments().length == 0);
                RubyNode[] arguments = new RubyNode[]{new DeadNode("YARPTranslator#translateRescueException")};
                writeNode = rubyNode.cloneUninitializedWithArguments(arguments);
            }
        }
        return new AssignRescueVariableNode((AssignableNode)((Object)writeNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateWhileNode(Nodes.Node node, Nodes.Node predicate, Nodes.StatementsNode statements, boolean conditionInversed) {
        RubyNode body;
        RubyNode condition = predicate.accept(this);
        if (conditionInversed) {
            condition = NotNodeGen.create(condition);
        }
        BreakID whileBreakID = this.environment.getParseEnvironment().allocateBreakID();
        boolean oldTranslatingWhile = this.translatingWhile;
        this.translatingWhile = true;
        BreakID oldBreakID = this.environment.getBreakID();
        this.environment.setBreakIDForWhile(whileBreakID);
        this.frameOnStackMarkerSlotStack.push(-1);
        try {
            body = this.translateNodeOrNil(statements);
        }
        finally {
            this.frameOnStackMarkerSlotStack.pop();
            this.environment.setBreakIDForWhile(oldBreakID);
            this.translatingWhile = oldTranslatingWhile;
        }
        boolean evaluateAtStart = statements == null || !(statements.body[0] instanceof Nodes.BeginNode);
        WhileNode loop = evaluateAtStart ? new WhileNode(WhileNodeFactory.WhileRepeatingNodeGen.create(condition, body)) : new WhileNode(WhileNodeFactory.DoWhileRepeatingNodeGen.create(condition, body));
        CatchBreakNode rubyNode = new CatchBreakNode(whileBreakID, loop, true);
        return rubyNode;
    }

    protected RubyContextSourceNode createCallNode(RubyNode receiver, String method, RubyNode ... arguments) {
        RubyCallNodeParameters parameters = new RubyCallNodeParameters(receiver, method, null, EmptyArgumentsDescriptor.INSTANCE, arguments, true);
        return this.language.coreMethodAssumptions.createCallNode(parameters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSideEffectFreeRescueExpression(Nodes.Node node) {
        if (node instanceof Nodes.InstanceVariableReadNode) return true;
        if (node instanceof Nodes.LocalVariableReadNode) return true;
        if (node instanceof Nodes.ClassVariableReadNode) return true;
        if (node instanceof Nodes.StringNode) return true;
        if (node instanceof Nodes.SymbolNode) return true;
        if (node instanceof Nodes.InterpolatedSymbolNode) {
            Nodes.InterpolatedSymbolNode isn = (Nodes.InterpolatedSymbolNode)node;
            if (isn.parts.length == 1) {
                if (isn.parts[0] instanceof Nodes.StringNode) return true;
            }
        }
        if (node instanceof Nodes.IntegerNode) return true;
        if (node instanceof Nodes.FloatNode) return true;
        if (node instanceof Nodes.ImaginaryNode) return true;
        if (node instanceof Nodes.RationalNode) return true;
        if (node instanceof Nodes.SelfNode) return true;
        if (node instanceof Nodes.TrueNode) return true;
        if (node instanceof Nodes.FalseNode) return true;
        if (!(node instanceof Nodes.NilNode)) return false;
        return true;
    }

    private String toString(Nodes.Location location) {
        return TStringUtils.toJavaStringOrThrow((AbstractTruffleString)TruffleString.fromByteArrayUncached((byte[])this.sourceBytes, (int)location.startOffset, (int)location.length, (TruffleString.Encoding)this.sourceEncoding.tencoding, (boolean)false), this.sourceEncoding);
    }

    private String toString(Nodes.Node node) {
        return TStringUtils.toJavaStringOrThrow((AbstractTruffleString)TruffleString.fromByteArrayUncached((byte[])this.sourceBytes, (int)node.startOffset, (int)node.length, (TruffleString.Encoding)this.sourceEncoding.tencoding, (boolean)false), this.sourceEncoding);
    }

    private SourceSection getSourceSection(Nodes.Node yarpNode) {
        return this.source.createSection(yarpNode.startOffset, yarpNode.length);
    }

    private static void assignNodePositionInSource(Nodes.Node yarpNode, RubyNode rubyNode) {
        rubyNode.unsafeSetSourceSection(yarpNode.startOffset, yarpNode.length);
        YARPTranslator.copyNewlineFlag(yarpNode, rubyNode);
    }

    private static void copyNewlineFlag(Nodes.Node yarpNode, RubyNode rubyNode) {
        if (yarpNode.hasNewLineFlag()) {
            rubyNode.unsafeSetIsNewLine();
        }
    }

    private static RubyNode sequence(Nodes.Node yarpNode, List<RubyNode> sequence) {
        assert (!yarpNode.hasNewLineFlag()) : "Expected node passed to sequence() to not have a newline flag";
        RubyNode sequenceNode = YARPTranslator.sequence(sequence);
        if (!sequenceNode.hasSource()) {
            YARPTranslator.assignNodePositionInSource(yarpNode, sequenceNode);
        }
        return sequenceNode;
    }

    private static RubyNode sequence(List<RubyNode> sequence) {
        List<RubyNode> flattened = Translator.flatten(sequence, true);
        if (flattened.isEmpty()) {
            NilLiteralNode nilNode = new NilLiteralNode(true);
            return nilNode;
        }
        if (flattened.size() == 1) {
            return flattened.get(0);
        }
        RubyNode[] flatSequence = flattened.toArray(RubyNode.EMPTY_ARRAY);
        SequenceNode sequenceNode = new SequenceNode(flatSequence);
        return sequenceNode;
    }

    private void assignNodePositionInSource(Nodes.Node[] nodes, RubyNode rubyNode) {
        Nodes.Node first = nodes[0];
        Nodes.Node last = nodes[nodes.length - 1];
        int length = last.startOffset - first.startOffset + last.length;
        rubyNode.unsafeSetSourceSection(first.startOffset, length);
    }
}

