/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.collections.EconomicMap;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.language.locals.LocalVariableType;
import org.truffleruby.language.locals.ReadDeclarationVariableNode;
import org.truffleruby.language.locals.ReadLocalNode;
import org.truffleruby.language.locals.ReadLocalVariableNode;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.SelfNode;
import org.truffleruby.parser.BlockDescriptorInfo;
import org.truffleruby.parser.ParseEnvironment;

public final class TranslatorEnvironment {
    public static final String METHOD_BLOCK_NAME = "%method_block_arg";
    private final ParseEnvironment parseEnvironment;
    private EconomicMap<Object, Integer> nameToIndex = EconomicMap.create();
    private FrameDescriptor.Builder frameDescriptorBuilder;
    private FrameDescriptor frameDescriptor;
    private final BlockDescriptorInfo descriptorInfoForChildren;
    private final List<Integer> flipFlopStates = new ArrayList<Integer>();
    private final ReturnID returnID;
    private final int blockDepth;
    private BreakID breakID;
    private final boolean ownScopeForAssignments;
    private final boolean isModuleBody;
    private final TranslatorEnvironment parent;
    private final SharedMethodInfo sharedMethodInfo;
    public final String modulePath;
    public final String methodName;
    private static final AtomicInteger tempIndex = new AtomicInteger();

    public TranslatorEnvironment(TranslatorEnvironment parent, ParseEnvironment parseEnvironment, ReturnID returnID, boolean ownScopeForAssignments, boolean isModuleBody, SharedMethodInfo sharedMethodInfo, String methodName, int blockDepth, BreakID breakID, FrameDescriptor descriptor, String modulePath) {
        this.parent = parent;
        if (descriptor == null) {
            if (blockDepth > 0) {
                BlockDescriptorInfo descriptorInfo = Objects.requireNonNull(parent.descriptorInfoForChildren);
                this.frameDescriptorBuilder = TranslatorEnvironment.newFrameDescriptorBuilderForBlock(descriptorInfo);
                this.descriptorInfoForChildren = new BlockDescriptorInfo(descriptorInfo.getSpecialVariableAssumption());
            } else {
                Assumption specialVariableAssumption = TranslatorEnvironment.createSpecialVariableAssumption();
                this.frameDescriptorBuilder = TranslatorEnvironment.newFrameDescriptorBuilderForMethod(specialVariableAssumption);
                this.descriptorInfoForChildren = new BlockDescriptorInfo(specialVariableAssumption);
            }
        } else {
            this.frameDescriptor = descriptor;
            this.descriptorInfoForChildren = new BlockDescriptorInfo(descriptor);
            assert (descriptor.getNumberOfAuxiliarySlots() == 0);
            int slots = descriptor.getNumberOfSlots();
            for (int slot = 0; slot < slots; ++slot) {
                Object identifier = descriptor.getSlotName(slot);
                if (BindingNodes.isHiddenVariable(identifier)) continue;
                this.nameToIndex.put(identifier, (Object)slot);
            }
        }
        this.parseEnvironment = parseEnvironment;
        this.returnID = returnID;
        this.ownScopeForAssignments = ownScopeForAssignments;
        this.isModuleBody = isModuleBody;
        this.sharedMethodInfo = sharedMethodInfo;
        this.methodName = methodName;
        this.blockDepth = blockDepth;
        this.breakID = breakID;
        this.modulePath = modulePath;
    }

    public static String composeModulePath(String modulePath, String name) {
        return modulePath != null ? modulePath + "::" + name : name;
    }

    public boolean isDynamicConstantLookup() {
        return this.sharedMethodInfo.getStaticLexicalScopeOrNull() == null;
    }

    public LexicalScope getStaticLexicalScope() {
        return this.sharedMethodInfo.getStaticLexicalScope();
    }

    public LexicalScope getStaticLexicalScopeOrNull() {
        return this.sharedMethodInfo.getStaticLexicalScopeOrNull();
    }

    public TranslatorEnvironment getParent() {
        return this.parent;
    }

    public boolean isTopLevelScope() {
        return this.parent == null && this.isModuleBody;
    }

    public boolean isTopLevelObjectScope() {
        return this.isTopLevelScope() && this.modulePath == null;
    }

    public static FrameDescriptor.Builder newFrameDescriptorBuilderForBlock(BlockDescriptorInfo descriptorInfo) {
        FrameDescriptor.Builder builder = FrameDescriptor.newBuilder().defaultValue((Object)Nil.INSTANCE);
        builder.info((Object)Objects.requireNonNull(descriptorInfo));
        int selfIndex = builder.addSlot(FrameSlotKind.Illegal, (Object)SelfNode.SELF_IDENTIFIER, null);
        if (selfIndex != 0) {
            throw CompilerDirectives.shouldNotReachHere((String)"(self) should be at index 0");
        }
        return builder;
    }

    private static Assumption createSpecialVariableAssumption() {
        return Assumption.create((String)"does not need SpecialVariableStorage");
    }

    private static FrameDescriptor.Builder newFrameDescriptorBuilderForMethod(Assumption specialVariableAssumption) {
        FrameDescriptor.Builder builder = FrameDescriptor.newBuilder().defaultValue((Object)Nil.INSTANCE);
        builder.info((Object)specialVariableAssumption);
        int selfIndex = builder.addSlot(FrameSlotKind.Illegal, (Object)SelfNode.SELF_IDENTIFIER, null);
        if (selfIndex != 0) {
            throw CompilerDirectives.shouldNotReachHere((String)"(self) should be at index 0");
        }
        int svarsSlot = builder.addSlot(FrameSlotKind.Illegal, (Object)"%$~_", null);
        if (svarsSlot != 1) {
            throw CompilerDirectives.shouldNotReachHere((String)"svars should be at index 1");
        }
        return builder;
    }

    public static FrameDescriptor.Builder newFrameDescriptorBuilderForMethod() {
        Assumption specialVariableAssumption = TranslatorEnvironment.createSpecialVariableAssumption();
        return TranslatorEnvironment.newFrameDescriptorBuilderForMethod(specialVariableAssumption);
    }

    public int declareVar(Object name) {
        assert (!(name == null || name instanceof String && ((String)name).isEmpty()));
        Integer existingSlot = (Integer)this.nameToIndex.get(name);
        if (existingSlot != null) {
            return existingSlot;
        }
        int index = this.addSlot(name);
        this.nameToIndex.put(name, (Object)index);
        return index;
    }

    private int addSlot(Object name) {
        return this.frameDescriptorBuilder.addSlot(FrameSlotKind.Illegal, name, null);
    }

    public String allocateLocalTemp(String indicator) {
        return "%" + indicator + "_" + tempIndex.getAndIncrement();
    }

    public int declareLocalTemp(String indicator) {
        String name = this.allocateLocalTemp(indicator);
        return this.declareVar(name);
    }

    public Integer findFrameSlotOrNull(Object name) {
        return (Integer)this.nameToIndex.get(name);
    }

    public int findFrameSlot(Object name) {
        Integer index = (Integer)this.nameToIndex.get(name);
        if (index == null) {
            throw CompilerDirectives.shouldNotReachHere((String)("Could not find slot " + name));
        }
        return index;
    }

    public ReadLocalNode findOrAddLocalVarNodeDangerous(String name, SourceIndexLength sourceSection) {
        ReadLocalNode localVar = this.findLocalVarNode(name, sourceSection);
        if (localVar == null) {
            this.declareVar(name);
            localVar = this.findLocalVarNode(name, sourceSection);
        }
        return localVar;
    }

    public ReadLocalVariableNode readNode(int slot, SourceIndexLength sourceSection) {
        ReadLocalVariableNode node = new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, slot);
        node.unsafeSetSourceSection(sourceSection);
        return node;
    }

    public RubyNode findLocalVarOrNilNode(String name, SourceIndexLength sourceSection) {
        RubyContextSourceNode node = this.findLocalVarNode(name, sourceSection);
        if (node == null) {
            node = new NilLiteralNode(true);
            node.unsafeSetSourceSection(sourceSection);
        }
        return node;
    }

    public ReadLocalNode findLocalVarNode(String name, SourceIndexLength sourceSection) {
        TranslatorEnvironment current = this;
        int level = 0;
        while (current != null) {
            Integer slot = current.findFrameSlotOrNull(name);
            if (slot != null) {
                ReadLocalNode node = level == 0 ? new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, slot) : new ReadDeclarationVariableNode(LocalVariableType.FRAME_LOCAL, level, slot);
                node.unsafeSetSourceSection(sourceSection);
                return node;
            }
            if (current.getNeverAssignInParentScope()) {
                return null;
            }
            current = current.parent;
            ++level;
        }
        return null;
    }

    public FrameDescriptor computeFrameDescriptor() {
        if (this.frameDescriptor != null) {
            return this.frameDescriptor;
        }
        this.frameDescriptor = this.frameDescriptorBuilder.build();
        this.descriptorInfoForChildren.setParentDescriptor(this.frameDescriptor);
        this.frameDescriptorBuilder = null;
        this.nameToIndex = null;
        return this.frameDescriptor;
    }

    public ReturnID getReturnID() {
        return this.returnID;
    }

    public ParseEnvironment getParseEnvironment() {
        return this.parseEnvironment;
    }

    public boolean hasOwnScopeForAssignments() {
        return this.ownScopeForAssignments;
    }

    public boolean getNeverAssignInParentScope() {
        return !this.isBlock();
    }

    public boolean isModuleBody() {
        return this.isModuleBody;
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public List<Integer> getFlipFlopStates() {
        return this.flipFlopStates;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isBlock() {
        return this.blockDepth > 0;
    }

    public int getBlockDepth() {
        return this.blockDepth;
    }

    public BreakID getBreakID() {
        return this.breakID;
    }

    public void setBreakIDForWhile(BreakID breakID) {
        this.breakID = breakID;
    }

    public TranslatorEnvironment getSurroundingMethodEnvironment() {
        TranslatorEnvironment methodParent = this;
        while (methodParent.isBlock()) {
            methodParent = methodParent.getParent();
        }
        return methodParent;
    }

    public static void resetTemporaryVariablesIndex() {
        tempIndex.set(0);
    }
}

