/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.debug.ChaosNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.arguments.EmptyArgumentsDescriptor;
import org.truffleruby.language.arguments.ProfileArgumentNodeGen;
import org.truffleruby.language.arguments.ReadSelfNode;
import org.truffleruby.language.control.SequenceNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.literal.IntegerFixnumLiteralNode;
import org.truffleruby.language.literal.LongFixnumLiteralNode;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.ast.NilImplicitParseNode;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.visitor.AbstractNodeVisitor;

public abstract class Translator
extends AbstractNodeVisitor<RubyNode> {
    protected final Source source;
    protected final ParserContext parserContext;
    protected final Node currentNode;
    protected final RubyLanguage language;

    public Translator(RubyLanguage language, Source source, ParserContext parserContext, Node currentNode) {
        this.language = language;
        this.source = source;
        this.parserContext = parserContext;
        this.currentNode = currentNode;
    }

    public static RubyNode sequence(SourceIndexLength sourceSection, List<RubyNode> sequence) {
        List<RubyNode> flattened = Translator.flatten(sequence, true);
        if (flattened.isEmpty()) {
            NilLiteralNode literal = new NilLiteralNode(true);
            literal.unsafeSetSourceSection(sourceSection);
            return literal;
        }
        if (flattened.size() == 1) {
            return flattened.get(0);
        }
        RubyNode[] flatSequence = flattened.toArray(RubyNode.EMPTY_ARRAY);
        SourceIndexLength enclosingSourceSection = Translator.enclosing(sourceSection, flatSequence);
        return Translator.withSourceSection(enclosingSourceSection, new SequenceNode(flatSequence));
    }

    public static SourceIndexLength enclosing(SourceIndexLength base, RubyNode ... sequence) {
        if (base == null) {
            return base;
        }
        int start = base.getCharIndex();
        int end = base.getCharEnd();
        for (RubyNode node : sequence) {
            SourceIndexLength sourceSection = node.getSourceIndexLength();
            if (sourceSection == null || !sourceSection.isAvailable()) continue;
            start = Integer.min(start, sourceSection.getCharIndex());
            end = Integer.max(end, sourceSection.getCharEnd());
        }
        return new SourceIndexLength(start, end - start);
    }

    static List<RubyNode> flatten(List<RubyNode> sequence, boolean allowTrailingNil) {
        return Translator.flattenFromN(sequence, allowTrailingNil, 0);
    }

    private static List<RubyNode> flattenFromN(List<RubyNode> sequence, boolean allowTrailingNil, int n) {
        ArrayList<RubyNode> flattened = new ArrayList<RubyNode>();
        while (n < sequence.size()) {
            boolean lastNode = n == sequence.size() - 1;
            RubyNode node = sequence.get(n);
            if (node instanceof NilLiteralNode && ((NilLiteralNode)node).isImplicit()) {
                if (allowTrailingNil && lastNode) {
                    flattened.add(node);
                }
            } else if (node instanceof SequenceNode) {
                flattened.addAll(Translator.flatten(Arrays.asList(((SequenceNode)node).getSequence()), lastNode));
            } else {
                if (node.canSubsumeFollowing() && !lastNode) {
                    List<RubyNode> rest = Translator.flattenFromN(sequence, allowTrailingNil, n + 1);
                    if (rest.size() == 1) {
                        flattened.add(node.subsumeFollowing(rest.get(0)));
                    } else {
                        flattened.add(node.subsumeFollowing(new SequenceNode(rest.toArray(RubyNode.EMPTY_ARRAY))));
                    }
                    return flattened;
                }
                flattened.add(node);
            }
            ++n;
        }
        return flattened;
    }

    protected RubyNode nilNode(SourceIndexLength sourceSection) {
        NilLiteralNode literal = new NilLiteralNode(false);
        literal.unsafeSetSourceSection(sourceSection);
        return literal;
    }

    protected RubyNode translateNodeOrNil(SourceIndexLength sourceSection, ParseNode node) {
        RubyNode rubyNode = node == null || node instanceof NilImplicitParseNode ? this.nilNode(sourceSection) : node.accept(this);
        return rubyNode;
    }

    public static SourceSection translateSourceSection(Source source, SourceIndexLength sourceSection) {
        if (sourceSection == null) {
            return null;
        }
        return sourceSection.toSourceSection(source);
    }

    public static RubyNode loadSelf(RubyLanguage language) {
        return new WriteLocalVariableNode(0, Translator.profileArgument(language, new ReadSelfNode()));
    }

    public static RubyNode profileArgument(RubyLanguage language, RubyNode argumentNode) {
        RubyNode node = argumentNode;
        if (language.options.PROFILE_ARGUMENTS) {
            node = ProfileArgumentNodeGen.create(node);
        }
        if (language.options.CHAOS_DATA) {
            node = ChaosNode.create(node);
        }
        return node;
    }

    public static <T extends RubyNode> T withSourceSection(SourceIndexLength sourceSection, T node) {
        if (sourceSection != null) {
            node.unsafeSetSourceSection(sourceSection);
        }
        return node;
    }

    public static RubyNode integerOrLongLiteralNode(long value) {
        if (CoreLibrary.fitsIntoInteger(value)) {
            return new IntegerFixnumLiteralNode((int)value);
        }
        return new LongFixnumLiteralNode(value);
    }

    protected static RubyNode[] createArray(int size) {
        return size == 0 ? RubyNode.EMPTY_ARRAY : new RubyNode[size];
    }

    protected RubyContextSourceNode createCallNode(RubyNode receiver, String method, RubyNode ... arguments) {
        RubyCallNodeParameters parameters = new RubyCallNodeParameters(receiver, method, null, EmptyArgumentsDescriptor.INSTANCE, arguments, true);
        return this.language.coreMethodAssumptions.createCallNode(parameters);
    }
}

