/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Objects;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.TStringWithEncoding;

public final class RubySource {
    private final Source source;
    private final String sourcePath;
    private final TruffleString code;
    private byte[] bytes;
    private final RubyEncoding encoding;
    private final boolean isEval;
    private final int lineOffset;

    public RubySource(Source source, String sourcePath) {
        this(source, sourcePath, null, false);
    }

    public RubySource(Source source, String sourcePath, TStringWithEncoding code) {
        this(source, sourcePath, code, false);
    }

    public RubySource(Source source, String sourcePath, TStringWithEncoding code, boolean isEval) {
        this(source, sourcePath, code, isEval, 0);
    }

    public RubySource(Source source, String sourcePath, TStringWithEncoding code, boolean isEval, int lineOffset) {
        assert (RubyLanguage.getPath(source).equals(sourcePath)) : RubyLanguage.getPath(source) + " vs " + sourcePath;
        this.source = Objects.requireNonNull(source);
        this.sourcePath = Objects.requireNonNull(sourcePath).intern();
        this.code = code != null ? code.tstring : null;
        this.encoding = code != null ? code.encoding : null;
        this.isEval = isEval;
        this.lineOffset = lineOffset;
    }

    public Source getSource() {
        return this.source;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public boolean hasTruffleString() {
        return this.code != null;
    }

    public TruffleString getTruffleString() {
        assert (this.hasTruffleString());
        return this.code;
    }

    public TStringWithEncoding getTStringWithEncoding() {
        assert (this.hasTruffleString());
        return new TStringWithEncoding(this.code, this.encoding);
    }

    public byte[] getBytes() {
        assert (this.hasTruffleString());
        if (this.bytes != null) {
            return this.bytes;
        }
        this.bytes = TStringUtils.getBytesOrCopy((AbstractTruffleString)this.code, this.encoding);
        return this.bytes;
    }

    public RubyEncoding getEncoding() {
        assert (this.hasTruffleString());
        return this.encoding;
    }

    public boolean isEval() {
        return this.isEval;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    @CompilerDirectives.TruffleBoundary
    public static int getStartLineAdjusted(RubyContext context, SourceSection sourceSection) {
        Integer lineOffset = context.getSourceLineOffsets().get(sourceSection.getSource());
        if (lineOffset != null) {
            return sourceSection.getStartLine() + lineOffset;
        }
        return sourceSection.getStartLine();
    }
}

