/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.function.Supplier;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.core.IsNilNode;
import org.truffleruby.core.cast.SplatCastNode;
import org.truffleruby.core.cast.SplatCastNodeGen;
import org.truffleruby.core.proc.ProcCallTargets;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.language.RubyLambdaRootNode;
import org.truffleruby.language.RubyMethodRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyProcRootNode;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.EmptyArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptorManager;
import org.truffleruby.language.arguments.MissingArgumentBehavior;
import org.truffleruby.language.arguments.ReadPreArgumentNode;
import org.truffleruby.language.arguments.ShouldDestructureNode;
import org.truffleruby.language.control.AndNode;
import org.truffleruby.language.control.AndNodeGen;
import org.truffleruby.language.control.DynamicReturnNode;
import org.truffleruby.language.control.IfElseNodeGen;
import org.truffleruby.language.control.InvalidReturnNode;
import org.truffleruby.language.control.NotNodeGen;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.locals.FindDeclarationVariableNodes;
import org.truffleruby.language.locals.LocalVariableType;
import org.truffleruby.language.locals.ReadLocalVariableNode;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.BlockDefinitionNode;
import org.truffleruby.language.methods.CachedLazyCallTargetSupplier;
import org.truffleruby.language.supercall.ReadSuperArgumentsNode;
import org.truffleruby.language.supercall.ReadZSuperArgumentsNode;
import org.truffleruby.language.supercall.SuperCallNode;
import org.truffleruby.language.supercall.ZSuperOutsideMethodNode;
import org.truffleruby.parser.BodyTranslator;
import org.truffleruby.parser.LoadArgumentsTranslator;
import org.truffleruby.parser.ParameterCollector;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.ReloadArgumentsTranslator;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.ast.ArgsParseNode;
import org.truffleruby.parser.ast.MethodDefParseNode;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.SuperParseNode;
import org.truffleruby.parser.ast.UnnamedRestArgParseNode;
import org.truffleruby.parser.ast.ZSuperParseNode;

public final class MethodTranslator
extends BodyTranslator {
    private final ArgsParseNode argsNode;
    private final boolean isBlock;
    private final boolean shouldLazyTranslate;
    private final String methodNameForBlock;

    public MethodTranslator(RubyLanguage language, BodyTranslator parent, TranslatorEnvironment environment, boolean isBlock, Source source, ParserContext parserContext, Node currentNode, ArgsParseNode argsNode, String methodNameForBlock, RubyDeferredWarnings rubyWarnings) {
        super(language, parent, environment, source, parserContext, currentNode, rubyWarnings);
        this.isBlock = isBlock;
        this.argsNode = argsNode;
        this.methodNameForBlock = methodNameForBlock;
        this.shouldLazyTranslate = parserContext.isEval() || environment.getParseEnvironment().isCoverageEnabled() ? false : (language.getSourcePath(source).startsWith(language.coreLoadPath) ? language.options.LAZY_TRANSLATION_CORE : language.options.LAZY_TRANSLATION_USER);
    }

    public BlockDefinitionNode compileBlockNode(SourceIndexLength sourceSection, ParseNode bodyNode, boolean isStabbyLambda, String[] variables) {
        ProcCallTargets callTargets;
        RubyNode preludeProc;
        this.declareArguments();
        Arity arity = this.argsNode.getArity();
        Arity arityForCheck = this.argsNode.getRestArgNode() instanceof UnnamedRestArgParseNode && !((UnnamedRestArgParseNode)this.argsNode.getRestArgNode()).isStar() ? arity.withRest(false) : arity;
        RubyNode loadArguments = new LoadArgumentsTranslator(this.currentNode, this.argsNode, this.language, this.source, this.parserContext, !isStabbyLambda, false, this).translate();
        RubyNode rubyNode = preludeProc = !isStabbyLambda ? this.preludeProc(sourceSection, isStabbyLambda, arity, loadArguments) : null;
        if (!this.translatingForStatement) {
            for (String var : variables) {
                this.environment.declareVar(var);
            }
        }
        RubyNode body = this.translateNodeOrNil(sourceSection, bodyNode).simplifyAsTailExpression();
        boolean methodCalledLambda = !isStabbyLambda && this.methodNameForBlock.equals("lambda");
        boolean emitLambda = isStabbyLambda || methodCalledLambda;
        Supplier<RootCallTarget> procCompiler = MethodTranslator.procCompiler(sourceSection, this.source, arityForCheck, preludeProc, body, methodCalledLambda, this.language, this.environment);
        Supplier<RootCallTarget> lambdaCompiler = MethodTranslator.lambdaCompiler(sourceSection, this.source, isStabbyLambda, arityForCheck, loadArguments, body, emitLambda, this.language, this.environment);
        int frameOnStackMarkerSlot = emitLambda || this.frameOnStackMarkerSlotStack.isEmpty() ? -1 : (Integer)this.frameOnStackMarkerSlotStack.peek();
        if (isStabbyLambda) {
            RootCallTarget callTarget = lambdaCompiler.get();
            callTargets = new ProcCallTargets(callTarget);
        } else {
            callTargets = this.methodNameForBlock.equals("lambda") ? new ProcCallTargets(null, lambdaCompiler.get(), procCompiler) : new ProcCallTargets(procCompiler.get(), null, lambdaCompiler);
        }
        BlockDefinitionNode ret = new BlockDefinitionNode(emitLambda ? ProcType.LAMBDA : ProcType.PROC, this.environment.getSharedMethodInfo(), callTargets, this.environment.getBreakID(), frameOnStackMarkerSlot);
        ret.unsafeSetSourceSection(sourceSection);
        return ret;
    }

    private RubyNode preludeProc(SourceIndexLength sourceSection, boolean isStabbyLambda, Arity arity, RubyNode loadArguments) {
        RubyNode preludeProc;
        if (this.shouldConsiderDestructuringArrayArg(arity)) {
            RubyNode readArrayNode = MethodTranslator.profileArgument(this.language, new ReadPreArgumentNode(0, this.argsNode.hasKwargs(), MissingArgumentBehavior.RUNTIME_ERROR));
            SplatCastNode castArrayNode = SplatCastNodeGen.create(this.language, SplatCastNode.NilBehavior.NIL, true, readArrayNode);
            castArrayNode.doNotCopy();
            int arraySlot = this.environment.declareLocalTemp("destructure");
            WriteLocalVariableNode writeArrayNode = new WriteLocalVariableNode(arraySlot, castArrayNode);
            LoadArgumentsTranslator destructureArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.argsNode, this.language, this.source, this.parserContext, !isStabbyLambda, false, this);
            destructureArgumentsTranslator.pushArraySlot(arraySlot);
            RubyNode newDestructureArguments = destructureArgumentsTranslator.translate();
            RubyNode arrayWasNotNil = MethodTranslator.sequence(sourceSection, Arrays.asList(new RubyNode[]{writeArrayNode, NotNodeGen.create(new IsNilNode(new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, arraySlot)))}));
            AndNode shouldDestructureAndArrayWasNotNil = AndNodeGen.create(new ShouldDestructureNode(arity.acceptsKeywords()), arrayWasNotNil);
            preludeProc = IfElseNodeGen.create(shouldDestructureAndArrayWasNotNil, newDestructureArguments, loadArguments);
        } else {
            preludeProc = loadArguments;
        }
        return preludeProc;
    }

    private static Supplier<RootCallTarget> procCompiler(SourceIndexLength sourceSection, Source source, Arity arityForCheck, RubyNode preludeProc, RubyNode body, boolean methodCalledLambda, RubyLanguage language, TranslatorEnvironment environment) {
        return () -> {
            RubyNode bodyForProc = methodCalledLambda ? (RubyNode)NodeUtil.cloneNode((Node)body) : body;
            RubyNode bodyProc = MethodTranslator.composeBody(environment, sourceSection, preludeProc, bodyForProc);
            RubyProcRootNode newRootNodeForProcs = new RubyProcRootNode(language, MethodTranslator.translateSourceSection(source, sourceSection), environment.computeFrameDescriptor(), environment.getSharedMethodInfo(), bodyProc, Split.HEURISTIC, environment.getReturnID(), arityForCheck);
            RootCallTarget callTarget = newRootNodeForProcs.getCallTarget();
            if (methodCalledLambda) {
                for (DynamicReturnNode returnNode : NodeUtil.findAllNodeInstances((Node)bodyForProc, DynamicReturnNode.class)) {
                    if (returnNode.returnID != ReturnID.MODULE_BODY) continue;
                    returnNode.replace(new InvalidReturnNode(returnNode.value));
                }
            }
            return callTarget;
        };
    }

    private static Supplier<RootCallTarget> lambdaCompiler(SourceIndexLength sourceSection, Source source, boolean isStabbyLambda, Arity arityForCheck, RubyNode loadArguments, RubyNode body, boolean emitLambda, RubyLanguage language, TranslatorEnvironment environment) {
        return () -> {
            RubyNode bodyForLambda = emitLambda ? body : (RubyNode)NodeUtil.cloneNode((Node)body);
            RubyNode preludeLambda = isStabbyLambda ? loadArguments : (RubyNode)NodeUtil.cloneNode((Node)loadArguments);
            RubyNode bodyLambda = MethodTranslator.composeBody(environment, sourceSection, preludeLambda, bodyForLambda);
            RubyLambdaRootNode newRootNodeForLambdas = new RubyLambdaRootNode(language, MethodTranslator.translateSourceSection(source, sourceSection), environment.computeFrameDescriptor(), environment.getSharedMethodInfo(), bodyLambda, Split.HEURISTIC, environment.getReturnID(), environment.getBreakID(), arityForCheck);
            RootCallTarget callTarget = newRootNodeForLambdas.getCallTarget();
            if (!isStabbyLambda) {
                for (InvalidReturnNode returnNode : NodeUtil.findAllNodeInstances((Node)bodyForLambda, InvalidReturnNode.class)) {
                    returnNode.replace(new DynamicReturnNode(environment.getReturnID(), returnNode.value));
                }
            }
            return callTarget;
        };
    }

    private boolean shouldConsiderDestructuringArrayArg(Arity arity) {
        if (arity.getRequired() == 1 && arity.getOptional() == 0 && !arity.hasRest() && arity.hasKeywordsRest()) {
            return true;
        }
        if (!arity.hasRest() && arity.getRequired() + arity.getOptional() <= 1) {
            return false;
        }
        return !arity.hasRest() || arity.getRequired() != 0;
    }

    private static RubyNode composeBody(TranslatorEnvironment environment, SourceIndexLength preludeSourceSection, RubyNode prelude, RubyNode body) {
        SourceIndexLength sourceSection = MethodTranslator.enclosing(preludeSourceSection, body);
        body = MethodTranslator.sequence(sourceSection, Arrays.asList(prelude, body));
        if (environment.getFlipFlopStates().size() > 0) {
            body = MethodTranslator.sequence(sourceSection, Arrays.asList(MethodTranslator.initFlipFlopStates(environment, sourceSection), body));
        }
        return body;
    }

    public RubyNode compileMethodBody(SourceIndexLength sourceSection, ParseNode bodyNode) {
        this.declareArguments();
        RubyNode loadArguments = new LoadArgumentsTranslator(this.currentNode, this.argsNode, this.language, this.source, this.parserContext, false, true, this).translate();
        RubyNode body = this.translateNodeOrNil(sourceSection, bodyNode).simplifyAsTailExpression();
        body = MethodTranslator.sequence(sourceSection, Arrays.asList(loadArguments, body));
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = MethodTranslator.sequence(sourceSection, Arrays.asList(MethodTranslator.initFlipFlopStates(this.environment, sourceSection), body));
        }
        return body;
    }

    private RubyMethodRootNode translateMethodNode(SourceIndexLength sourceSection, MethodDefParseNode defNode, ParseNode bodyNode) {
        SourceIndexLength sourceIndexLength = defNode.getPosition();
        SourceSection fullMethodSourceSection = sourceIndexLength.toSourceSection(this.source);
        RubyNode body = this.compileMethodBody(sourceSection, bodyNode);
        return new RubyMethodRootNode(this.language, fullMethodSourceSection, this.environment.computeFrameDescriptor(), this.environment.getSharedMethodInfo(), body, Split.HEURISTIC, this.environment.getReturnID(), this.argsNode.getArity());
    }

    public CachedLazyCallTargetSupplier buildMethodNodeCompiler(SourceIndexLength sourceSection, MethodDefParseNode defNode, ParseNode bodyNode) {
        if (this.shouldLazyTranslate) {
            return new CachedLazyCallTargetSupplier(() -> this.translateMethodNode(sourceSection, defNode, bodyNode).getCallTarget());
        }
        RubyMethodRootNode root = this.translateMethodNode(sourceSection, defNode, bodyNode);
        return new CachedLazyCallTargetSupplier(() -> root.getCallTarget());
    }

    private void declareArguments() {
        ParameterCollector parameterCollector = new ParameterCollector();
        this.argsNode.accept(parameterCollector);
        for (String parameter : parameterCollector.getParameters()) {
            this.environment.declareVar(parameter);
        }
    }

    @Override
    public RubyNode visitSuperNode(SuperParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        BodyTranslator.ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, node.getIterNode(), node.getArgsNode(), this.environment.getMethodName());
        ReadSuperArgumentsNode arguments = new ReadSuperArgumentsNode(argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted());
        RubyNode block = this.executeOrInheritBlock(argumentsAndBlock.getBlock(), node);
        RubyNode callNode = new SuperCallNode(argumentsAndBlock.isSplatted(), arguments, block, argumentsAndBlock.getArgumentsDescriptor());
        callNode = this.wrapCallWithLiteralBlock(argumentsAndBlock, callNode);
        return MethodTranslator.withSourceSection(sourceSection, callNode);
    }

    @Override
    public RubyNode visitZSuperNode(ZSuperParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        this.currentCallMethodName = this.environment.getMethodName();
        BodyTranslator.ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, node.getIterNode(), null, this.environment.getMethodName());
        boolean insideDefineMethod = false;
        MethodTranslator methodArgumentsTranslator = this;
        while (methodArgumentsTranslator.isBlock) {
            if (!(methodArgumentsTranslator.parent instanceof MethodTranslator)) {
                return MethodTranslator.withSourceSection(sourceSection, new ZSuperOutsideMethodNode(insideDefineMethod));
            }
            if (methodArgumentsTranslator.currentCallMethodName != null && methodArgumentsTranslator.currentCallMethodName.equals("define_method")) {
                insideDefineMethod = true;
            }
            methodArgumentsTranslator = (MethodTranslator)methodArgumentsTranslator.parent;
        }
        ArgsParseNode argsNode = methodArgumentsTranslator.argsNode;
        ReloadArgumentsTranslator reloadTranslator = new ReloadArgumentsTranslator(this.language, this.source, this.parserContext, this.currentNode, this, argsNode);
        RubyNode[] reloadSequence = reloadTranslator.reload(argsNode);
        ArgumentsDescriptor descriptor = argsNode.hasKwargs() ? KeywordArgumentsDescriptorManager.EMPTY : EmptyArgumentsDescriptor.INSTANCE;
        int restParamIndex = reloadTranslator.getRestParameterIndex();
        ReadZSuperArgumentsNode arguments = new ReadZSuperArgumentsNode(restParamIndex, reloadSequence);
        RubyNode block = this.executeOrInheritBlock(argumentsAndBlock.getBlock(), node);
        boolean isSplatted = reloadTranslator.getRestParameterIndex() != -1;
        RubyNode callNode = new SuperCallNode(isSplatted, arguments, block, descriptor);
        callNode = this.wrapCallWithLiteralBlock(argumentsAndBlock, callNode);
        return MethodTranslator.withSourceSection(sourceSection, callNode);
    }

    private RubyNode executeOrInheritBlock(RubyNode blockNode, ParseNode callNode) {
        if (blockNode != null) {
            return blockNode;
        }
        return this.environment.findLocalVarOrNilNode("%method_block_arg", callNode.getPosition());
    }

    @Override
    protected FindDeclarationVariableNodes.FrameSlotAndDepth createFlipFlopState(SourceIndexLength sourceSection, int depth) {
        if (this.isBlock) {
            return this.parent.createFlipFlopState(sourceSection, depth + 1);
        }
        return super.createFlipFlopState(sourceSection, depth);
    }
}

