/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.IsNilNode;
import org.truffleruby.core.array.ArrayIndexNodes;
import org.truffleruby.core.array.ArrayLiteralNode;
import org.truffleruby.core.array.ArraySliceNodeGen;
import org.truffleruby.core.cast.SplatCastNode;
import org.truffleruby.core.cast.SplatCastNodeGen;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.arguments.ArrayIsAtLeastAsLargeAsNode;
import org.truffleruby.language.arguments.CheckNoKeywordArgumentsNode;
import org.truffleruby.language.arguments.MissingArgumentBehavior;
import org.truffleruby.language.arguments.ReadKeywordArgumentNode;
import org.truffleruby.language.arguments.ReadKeywordRestArgumentNode;
import org.truffleruby.language.arguments.ReadOptionalArgumentNode;
import org.truffleruby.language.arguments.ReadPostArgumentNode;
import org.truffleruby.language.arguments.ReadPreArgumentNode;
import org.truffleruby.language.arguments.ReadRestArgumentNode;
import org.truffleruby.language.arguments.SaveMethodBlockNode;
import org.truffleruby.language.control.IfElseNodeGen;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.language.locals.LocalVariableType;
import org.truffleruby.language.locals.ReadLocalVariableNode;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.parser.BodyTranslator;
import org.truffleruby.parser.ParameterCollector;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.Translator;
import org.truffleruby.parser.ast.ArgsParseNode;
import org.truffleruby.parser.ast.ArgumentParseNode;
import org.truffleruby.parser.ast.ArrayParseNode;
import org.truffleruby.parser.ast.AssignableParseNode;
import org.truffleruby.parser.ast.BlockArgParseNode;
import org.truffleruby.parser.ast.DAsgnParseNode;
import org.truffleruby.parser.ast.KeywordArgParseNode;
import org.truffleruby.parser.ast.KeywordRestArgParseNode;
import org.truffleruby.parser.ast.LocalAsgnParseNode;
import org.truffleruby.parser.ast.MultipleAsgnParseNode;
import org.truffleruby.parser.ast.NilImplicitParseNode;
import org.truffleruby.parser.ast.NoKeywordsArgParseNode;
import org.truffleruby.parser.ast.OptArgParseNode;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.RequiredKeywordArgumentValueParseNode;
import org.truffleruby.parser.ast.RestArgParseNode;
import org.truffleruby.parser.ast.StarParseNode;
import org.truffleruby.parser.ast.VCallParseNode;
import org.truffleruby.parser.ast.types.INameNode;

public final class LoadArgumentsTranslator
extends Translator {
    private final boolean isProc;
    private final boolean isMethod;
    private final BodyTranslator methodBodyTranslator;
    private final Deque<ArraySlot> arraySlotStack = new ArrayDeque<ArraySlot>();
    private final ArgsParseNode argsNode;
    private final int required;
    private final boolean hasKeywordArguments;
    private int index;
    private int indexFromEnd = 1;
    private State state;

    public LoadArgumentsTranslator(Node currentNode, ArgsParseNode argsNode, RubyLanguage language, Source source, ParserContext parserContext, boolean isProc, boolean isMethod, BodyTranslator methodBodyTranslator) {
        super(language, source, parserContext, currentNode);
        this.isProc = isProc;
        this.isMethod = isMethod;
        this.methodBodyTranslator = methodBodyTranslator;
        this.argsNode = argsNode;
        this.required = argsNode.getRequiredCount();
        this.hasKeywordArguments = argsNode.hasKwargs();
    }

    public RubyNode translate() {
        int optArgCount;
        SourceIndexLength sourceSection = this.argsNode.getPosition();
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        sequence.add(LoadArgumentsTranslator.loadSelf(this.language));
        ParseNode[] args = this.argsNode.getArgs();
        int preCount = this.argsNode.getPreCount();
        if (preCount > 0) {
            this.state = State.PRE;
            this.index = 0;
            for (int i = 0; i < preCount; ++i) {
                sequence.add(args[i].accept(this));
                ++this.index;
            }
        }
        if (this.isMethod) {
            sequence.add(this.saveMethodBlockArg());
        }
        if ((optArgCount = this.argsNode.getOptionalArgsCount()) > 0) {
            this.state = State.OPT;
            this.index = this.argsNode.getPreCount();
            int optArgIndex = this.argsNode.getOptArgIndex();
            for (int i = 0; i < optArgCount; ++i) {
                sequence.add(args[optArgIndex + i].accept(this));
                ++this.index;
            }
        }
        if (this.argsNode.getRestArgNode() != null) {
            sequence.add(this.argsNode.getRestArgNode().accept(this));
        }
        int postCount = this.argsNode.getPostCount();
        ArrayList<RubyNode> notNilSmallerSequence = new ArrayList<RubyNode>();
        if (postCount > 0) {
            this.state = State.POST;
            ParseNode[] children = this.argsNode.getPost().children();
            this.index = this.argsNode.getPreCount();
            for (int i = 0; i < children.length; ++i) {
                notNilSmallerSequence.add(children[i].accept(this));
                ++this.index;
            }
        }
        RubyNode notNilSmaller = LoadArgumentsTranslator.sequence(sourceSection, notNilSmallerSequence);
        ArrayList<RubyNode> noRestSequence = new ArrayList<RubyNode>();
        if (postCount > 0) {
            this.state = State.POST;
            ParseNode[] children = this.argsNode.getPost().children();
            this.index = this.argsNode.getPreCount() + this.argsNode.getOptionalArgsCount();
            for (int i = 0; i < children.length; ++i) {
                noRestSequence.add(children[i].accept(this));
                ++this.index;
            }
        }
        RubyNode noRest = LoadArgumentsTranslator.sequence(sourceSection, noRestSequence);
        ArrayList<RubyNode> notNilAtLeastAsLargeSequence = new ArrayList<RubyNode>();
        if (postCount > 0) {
            this.state = State.POST;
            this.index = -1;
            int postIndex = this.argsNode.getPostIndex();
            for (int i = postCount - 1; i >= 0; --i) {
                notNilAtLeastAsLargeSequence.add(args[postIndex + i].accept(this));
                --this.index;
            }
        }
        RubyNode notNilAtLeastAsLarge = LoadArgumentsTranslator.sequence(sourceSection, notNilAtLeastAsLargeSequence);
        if (this.useArray()) {
            if (this.argsNode.getPreCount() == 0 || this.argsNode.hasRestArg()) {
                sequence.add(IfElseNodeGen.create(new ArrayIsAtLeastAsLargeAsNode(this.required, this.loadArray(sourceSection)), notNilAtLeastAsLarge, notNilSmaller));
            } else {
                sequence.add(noRest);
            }
        } else {
            sequence.add(notNilAtLeastAsLarge);
        }
        if (this.hasKeywordArguments) {
            int keywordIndex = this.argsNode.getKeywordsIndex();
            int keywordCount = this.argsNode.getKeywordCount();
            for (int i = 0; i < keywordCount; ++i) {
                sequence.add(args[keywordIndex + i].accept(this));
            }
        }
        if (this.argsNode.getKeyRest() != null) {
            sequence.add(this.argsNode.getKeyRest().accept(this));
        }
        if (this.argsNode.getBlock() != null) {
            sequence.add(this.argsNode.getBlock().accept(this));
        }
        return LoadArgumentsTranslator.sequence(sourceSection, sequence);
    }

    @Override
    public RubyNode visitKeywordRestArgNode(KeywordRestArgParseNode node) {
        ReadKeywordRestArgumentNode readNode = new ReadKeywordRestArgumentNode(this.language, this.argsNode.getArity());
        int slot = this.methodBodyTranslator.getEnvironment().declareVar(node.getName());
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitNoKeywordsArgNode(NoKeywordsArgParseNode node) {
        return new CheckNoKeywordArgumentsNode();
    }

    @Override
    public RubyNode visitKeywordArgNode(KeywordArgParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        AssignableParseNode asgnNode = node.getAssignable();
        String name = ((INameNode)((Object)asgnNode)).getName();
        int slot = this.methodBodyTranslator.getEnvironment().declareVar(name);
        RubyNode defaultValue = asgnNode.getValueNode() instanceof RequiredKeywordArgumentValueParseNode ? null : this.translateNodeOrNil(sourceSection, asgnNode.getValueNode());
        ReadKeywordArgumentNode readNode = ReadKeywordArgumentNode.create(this.language.getSymbol(name), defaultValue);
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitArgumentNode(ArgumentParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode readNode = this.readArgument(sourceSection);
        int slot = this.methodBodyTranslator.getEnvironment().findFrameSlot(node.getName());
        return new WriteLocalVariableNode(slot, readNode);
    }

    private RubyNode readArgument(SourceIndexLength sourceSection) {
        if (this.useArray()) {
            return ArrayIndexNodes.ReadConstantIndexNode.create(this.loadArray(sourceSection), this.index);
        }
        if (this.state == State.PRE) {
            return LoadArgumentsTranslator.profileArgument(this.language, new ReadPreArgumentNode(this.index, this.hasKeywordArguments, this.isProc ? MissingArgumentBehavior.NIL : MissingArgumentBehavior.RUNTIME_ERROR));
        }
        if (this.state == State.POST) {
            return new ReadPostArgumentNode(-this.index, this.hasKeywordArguments, this.required);
        }
        throw new IllegalStateException();
    }

    @Override
    public RubyNode visitRestArgNode(RestArgParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        if (this.argsNode == null) {
            throw new IllegalStateException("No arguments node visited");
        }
        int from = this.argsNode.getPreCount() + this.argsNode.getOptionalArgsCount();
        int to = -this.argsNode.getPostCount();
        RubyContextSourceNode readNode = this.useArray() ? ArraySliceNodeGen.create(from, to, this.loadArray(sourceSection)) : new ReadRestArgumentNode(from, -to, this.hasKeywordArguments);
        int slot = this.methodBodyTranslator.getEnvironment().findFrameSlot(node.getName());
        return new WriteLocalVariableNode(slot, readNode);
    }

    public RubyNode saveMethodBlockArg() {
        int slot = this.methodBodyTranslator.getEnvironment().declareVar("%method_block_arg");
        return new SaveMethodBlockNode(slot);
    }

    @Override
    public RubyNode visitBlockArgNode(BlockArgParseNode node) {
        int slot = this.methodBodyTranslator.getEnvironment().findFrameSlot(node.getName());
        return new SaveMethodBlockNode(slot);
    }

    @Override
    public RubyNode visitOptArgNode(OptArgParseNode node) {
        return node.getValue().accept(this);
    }

    @Override
    public RubyNode visitLocalAsgnNode(LocalAsgnParseNode node) {
        return this.translateLocalAssignment(node.getPosition(), node.getName(), node.getValueNode());
    }

    @Override
    public RubyNode visitDAsgnNode(DAsgnParseNode node) {
        return this.translateLocalAssignment(node.getPosition(), node.getName(), node.getValueNode());
    }

    private RubyNode translateLocalAssignment(SourceIndexLength sourcePosition, String name, ParseNode valueNode) {
        RubyNode readNode;
        SourceIndexLength sourceSection = sourcePosition;
        int slot = this.methodBodyTranslator.getEnvironment().declareVar(name);
        if (this.indexFromEnd == 1) {
            if (valueNode instanceof NilImplicitParseNode) {
                readNode = this.useArray() ? ArrayIndexNodes.ReadConstantIndexNode.create(this.loadArray(sourceSection), this.index) : this.readArgument(sourceSection);
            } else {
                RubyNode defaultValue;
                if (valueNode instanceof VCallParseNode) {
                    String calledName = ((VCallParseNode)valueNode).getName();
                    if (calledName.equals(name)) {
                        defaultValue = new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, slot);
                        defaultValue.unsafeSetSourceSection(sourceSection);
                    } else {
                        defaultValue = valueNode.accept(this);
                    }
                } else {
                    defaultValue = valueNode.accept(this);
                }
                if (this.argsNode == null) {
                    throw new IllegalStateException("No arguments node visited");
                }
                int minimum = this.index + 1 + this.argsNode.getPostCount();
                readNode = this.useArray() ? IfElseNodeGen.create(new ArrayIsAtLeastAsLargeAsNode(minimum, this.loadArray(sourceSection)), ArrayIndexNodes.ReadConstantIndexNode.create(this.loadArray(sourceSection), this.index), defaultValue) : new ReadOptionalArgumentNode(this.index, minimum, this.hasKeywordArguments, defaultValue);
            }
        } else {
            readNode = ArraySliceNodeGen.create(this.index, this.indexFromEnd, this.loadArray(sourceSection));
        }
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitArrayNode(ArrayParseNode node) {
        if (node.size() == 1 && node.get(0) instanceof MultipleAsgnParseNode) {
            return node.children()[0].accept(this);
        }
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitMultipleAsgnNode(MultipleAsgnParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        int arrayIndex = this.index;
        int arraySlot = this.methodBodyTranslator.getEnvironment().declareLocalTemp("destructure");
        this.pushArraySlot(arraySlot);
        ArrayList<RubyNode> notNilSmallerSequence = new ArrayList<RubyNode>();
        if (node.getPre() != null) {
            this.index = 0;
            for (ParseNode child : node.getPre().children()) {
                notNilSmallerSequence.add(child.accept(this));
                ++this.index;
            }
        }
        if (node.getRest() != null) {
            this.index = node.getPreCount();
            this.indexFromEnd = -node.getPostCount();
            notNilSmallerSequence.add(node.getRest().accept(this));
            this.indexFromEnd = 1;
        }
        if (node.getPost() != null) {
            ParseNode[] children = node.getPost().children();
            this.index = node.getPreCount();
            for (int i = 0; i < children.length; ++i) {
                notNilSmallerSequence.add(children[i].accept(this));
                ++this.index;
            }
        }
        RubyNode notNilSmaller = LoadArgumentsTranslator.sequence(sourceSection, notNilSmallerSequence);
        ArrayList<RubyNode> notNilAtLeastAsLargeSequence = new ArrayList<RubyNode>();
        if (node.getPre() != null) {
            this.index = 0;
            for (ParseNode parseNode : node.getPre().children()) {
                notNilAtLeastAsLargeSequence.add(parseNode.accept(this));
                ++this.index;
            }
        }
        if (node.getRest() != null) {
            this.index = node.getPreCount();
            this.indexFromEnd = -node.getPostCount();
            notNilAtLeastAsLargeSequence.add(node.getRest().accept(this));
            this.indexFromEnd = 1;
        }
        if (node.getPost() != null) {
            ParseNode[] children = node.getPost().children();
            this.index = -1;
            for (int i = children.length - 1; i >= 0; --i) {
                notNilAtLeastAsLargeSequence.add(children[i].accept(this));
                --this.index;
            }
        }
        RubyNode notNilAtLeastAsLarge = LoadArgumentsTranslator.sequence(sourceSection, notNilAtLeastAsLargeSequence);
        this.popArraySlot(arraySlot);
        ArrayList<RubyNode> nilSequence = new ArrayList<RubyNode>();
        ParameterCollector parametersToClearCollector = new ParameterCollector();
        if (node.getPre() != null) {
            for (ParseNode parseNode : node.getPre().children()) {
                parseNode.accept(parametersToClearCollector);
            }
        }
        if (node.getRest() != null) {
            if (node.getRest() instanceof INameNode) {
                String string = ((INameNode)((Object)node.getRest())).getName();
                if (node.getPreCount() == 0 && node.getPostCount() == 0) {
                    nilSequence.add(this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(string, sourceSection).makeWriteNode(ArrayLiteralNode.create(this.language, new RubyNode[]{new NilLiteralNode(true)})));
                } else {
                    nilSequence.add(this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(string, sourceSection).makeWriteNode(ArrayLiteralNode.create(this.language, null)));
                }
            } else if (!(node.getRest() instanceof StarParseNode)) {
                throw new UnsupportedOperationException("unsupported rest node " + node.getRest());
            }
        }
        if (node.getPost() != null) {
            for (ParseNode parseNode : node.getPost().children()) {
                parseNode.accept(parametersToClearCollector);
            }
        }
        for (String parameterToClear : parametersToClearCollector.getParameters()) {
            nilSequence.add(this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(parameterToClear, sourceSection).makeWriteNode(this.nilNode(sourceSection)));
        }
        if (node.getPre() != null) {
            this.index = arrayIndex;
            nilSequence.add(node.getPre().get(0).accept(this));
        }
        RubyNode rubyNode = LoadArgumentsTranslator.sequence(sourceSection, nilSequence);
        return LoadArgumentsTranslator.sequence(sourceSection, Arrays.asList(new RubyNode[]{new WriteLocalVariableNode(arraySlot, SplatCastNodeGen.create(this.language, SplatCastNode.NilBehavior.ARRAY_WITH_NIL, true, this.readArgument(sourceSection))), IfElseNodeGen.create(new IsNilNode(new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, arraySlot)), rubyNode, IfElseNodeGen.create(new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, arraySlot)), notNilAtLeastAsLarge, notNilSmaller))}));
    }

    @Override
    protected RubyNode defaultVisit(ParseNode node) {
        return node.accept(this.methodBodyTranslator);
    }

    public void pushArraySlot(int slot) {
        this.arraySlotStack.push(new ArraySlot(slot, this.index));
    }

    public void popArraySlot(int slot) {
        this.index = this.arraySlotStack.pop().getPreviousIndex();
    }

    protected boolean useArray() {
        return !this.arraySlotStack.isEmpty();
    }

    protected RubyNode loadArray(SourceIndexLength sourceSection) {
        ReadLocalVariableNode node = new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, this.arraySlotStack.peek().getArraySlot());
        node.unsafeSetSourceSection(sourceSection);
        return node;
    }

    private static enum State {
        PRE,
        OPT,
        POST;

    }

    private static final class ArraySlot {
        private int arraySlot;
        private int previousIndex;

        public ArraySlot(int arraySlot, int previousIndex) {
            this.arraySlot = arraySlot;
            this.previousIndex = previousIndex;
        }

        public int getArraySlot() {
            return this.arraySlot;
        }

        public int getPreviousIndex() {
            return this.previousIndex;
        }
    }
}

