/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jcodings.Encoding;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.builtins.PrimitiveNodeConstructor;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.IsNilNode;
import org.truffleruby.core.array.ArrayAppendOneNode;
import org.truffleruby.core.array.ArrayAppendOneNodeGen;
import org.truffleruby.core.array.ArrayConcatNode;
import org.truffleruby.core.array.ArrayLiteralNode;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.array.MultipleAssignmentNode;
import org.truffleruby.core.array.NoopAssignableNode;
import org.truffleruby.core.cast.HashCastNodeGen;
import org.truffleruby.core.cast.SplatCastNode;
import org.truffleruby.core.cast.SplatCastNodeGen;
import org.truffleruby.core.cast.StringToSymbolNode;
import org.truffleruby.core.cast.StringToSymbolNodeGen;
import org.truffleruby.core.cast.ToProcNodeGen;
import org.truffleruby.core.cast.ToSNode;
import org.truffleruby.core.cast.ToSNodeGen;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.hash.ConcatHashLiteralNode;
import org.truffleruby.core.hash.HashLiteralNode;
import org.truffleruby.core.kernel.KernelNodesFactory;
import org.truffleruby.core.module.ModuleNodes;
import org.truffleruby.core.numeric.BignumOperations;
import org.truffleruby.core.range.RangeNodes;
import org.truffleruby.core.range.RubyIntOrLongRange;
import org.truffleruby.core.range.RubyIntRange;
import org.truffleruby.core.range.RubyLongRange;
import org.truffleruby.core.regexp.ClassicRegexp;
import org.truffleruby.core.regexp.InterpolatedRegexpNode;
import org.truffleruby.core.regexp.MatchDataNodes;
import org.truffleruby.core.regexp.RegexWarnDeferredCallback;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.InterpolatedStringNode;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.EmptyArgumentsDescriptor;
import org.truffleruby.language.constants.OrAssignConstantNodeGen;
import org.truffleruby.language.constants.ReadConstantNode;
import org.truffleruby.language.constants.ReadConstantWithDynamicScopeNode;
import org.truffleruby.language.constants.ReadConstantWithLexicalScopeNode;
import org.truffleruby.language.constants.WriteConstantNode;
import org.truffleruby.language.control.AndNode;
import org.truffleruby.language.control.AndNodeGen;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.BreakNode;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.control.DynamicReturnNode;
import org.truffleruby.language.control.FrameOnStackNode;
import org.truffleruby.language.control.IfElseNode;
import org.truffleruby.language.control.IfElseNodeGen;
import org.truffleruby.language.control.IfNodeGen;
import org.truffleruby.language.control.InvalidReturnNode;
import org.truffleruby.language.control.LocalReturnNode;
import org.truffleruby.language.control.NextNode;
import org.truffleruby.language.control.NoMatchingPatternNodeGen;
import org.truffleruby.language.control.NotNodeGen;
import org.truffleruby.language.control.OnceNode;
import org.truffleruby.language.control.OrLazyValueDefinedNode;
import org.truffleruby.language.control.OrLazyValueDefinedNodeGen;
import org.truffleruby.language.control.OrNode;
import org.truffleruby.language.control.OrNodeGen;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.RedoNode;
import org.truffleruby.language.control.RetryNode;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.control.UnlessNodeGen;
import org.truffleruby.language.control.WhileNode;
import org.truffleruby.language.control.WhileNodeFactory;
import org.truffleruby.language.defined.DefinedNode;
import org.truffleruby.language.defined.DefinedWrapperNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.exceptions.EnsureNode;
import org.truffleruby.language.exceptions.EnsureNodeGen;
import org.truffleruby.language.exceptions.RescueClassesNode;
import org.truffleruby.language.exceptions.RescueNode;
import org.truffleruby.language.exceptions.RescueSplatNode;
import org.truffleruby.language.exceptions.RescueStandardErrorNode;
import org.truffleruby.language.exceptions.TryNode;
import org.truffleruby.language.exceptions.TryNodeGen;
import org.truffleruby.language.globals.AliasGlobalVarNode;
import org.truffleruby.language.globals.ReadGlobalVariableNode;
import org.truffleruby.language.globals.ReadGlobalVariableNodeGen;
import org.truffleruby.language.globals.ReadMatchReferenceNodes;
import org.truffleruby.language.globals.WriteGlobalVariableNode;
import org.truffleruby.language.globals.WriteGlobalVariableNodeGen;
import org.truffleruby.language.literal.BooleanLiteralNode;
import org.truffleruby.language.literal.FloatLiteralNode;
import org.truffleruby.language.literal.FrozenStringLiteralNode;
import org.truffleruby.language.literal.IntegerFixnumLiteralNode;
import org.truffleruby.language.literal.LongFixnumLiteralNode;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.language.literal.ObjectClassLiteralNode;
import org.truffleruby.language.literal.ObjectLiteralNode;
import org.truffleruby.language.literal.StringLiteralNode;
import org.truffleruby.language.literal.TruffleInternalModuleLiteralNode;
import org.truffleruby.language.literal.TruffleKernelOperationsModuleLiteralNode;
import org.truffleruby.language.locals.FindDeclarationVariableNodes;
import org.truffleruby.language.locals.FlipFlopNode;
import org.truffleruby.language.locals.FlipFlopNodeGen;
import org.truffleruby.language.locals.InitFlipFlopSlotNode;
import org.truffleruby.language.locals.ReadLocalNode;
import org.truffleruby.language.locals.ReadLocalVariableNode;
import org.truffleruby.language.locals.WriteLocalNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.BlockDefinitionNode;
import org.truffleruby.language.methods.CatchBreakNode;
import org.truffleruby.language.methods.LiteralMethodDefinitionNode;
import org.truffleruby.language.methods.ModuleBodyDefinition;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.DefineClassNode;
import org.truffleruby.language.objects.DefineModuleNode;
import org.truffleruby.language.objects.DefineModuleNodeGen;
import org.truffleruby.language.objects.DynamicLexicalScopeNode;
import org.truffleruby.language.objects.GetDynamicLexicalScopeNode;
import org.truffleruby.language.objects.InsideModuleDefinitionNode;
import org.truffleruby.language.objects.LexicalScopeNode;
import org.truffleruby.language.objects.ReadInstanceVariableNode;
import org.truffleruby.language.objects.RunModuleDefinitionNode;
import org.truffleruby.language.objects.SelfNode;
import org.truffleruby.language.objects.SingletonClassNode;
import org.truffleruby.language.objects.SingletonClassNodeGen;
import org.truffleruby.language.objects.WriteInstanceVariableNode;
import org.truffleruby.language.objects.WriteInstanceVariableNodeGen;
import org.truffleruby.language.objects.classvariables.ReadClassVariableNode;
import org.truffleruby.language.objects.classvariables.WriteClassVariableNode;
import org.truffleruby.language.yield.YieldExpressionNode;
import org.truffleruby.parser.ArgumentDescriptor;
import org.truffleruby.parser.BaseTranslator;
import org.truffleruby.parser.DeadNode;
import org.truffleruby.parser.Helpers;
import org.truffleruby.parser.MethodTranslator;
import org.truffleruby.parser.OpenModule;
import org.truffleruby.parser.ParseEnvironment;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.PatternMatchingTranslator;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.parser.Translator;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.ValueFromNode;
import org.truffleruby.parser.ast.AliasParseNode;
import org.truffleruby.parser.ast.AndParseNode;
import org.truffleruby.parser.ast.ArgsCatParseNode;
import org.truffleruby.parser.ast.ArgsParseNode;
import org.truffleruby.parser.ast.ArgsPushParseNode;
import org.truffleruby.parser.ast.ArgumentParseNode;
import org.truffleruby.parser.ast.ArrayParseNode;
import org.truffleruby.parser.ast.AssignableParseNode;
import org.truffleruby.parser.ast.AttrAssignParseNode;
import org.truffleruby.parser.ast.BackRefParseNode;
import org.truffleruby.parser.ast.BeginParseNode;
import org.truffleruby.parser.ast.BigRationalParseNode;
import org.truffleruby.parser.ast.BignumParseNode;
import org.truffleruby.parser.ast.BlockParseNode;
import org.truffleruby.parser.ast.BlockPassParseNode;
import org.truffleruby.parser.ast.BreakParseNode;
import org.truffleruby.parser.ast.CallParseNode;
import org.truffleruby.parser.ast.CaseInParseNode;
import org.truffleruby.parser.ast.CaseParseNode;
import org.truffleruby.parser.ast.ClassParseNode;
import org.truffleruby.parser.ast.ClassVarAsgnParseNode;
import org.truffleruby.parser.ast.ClassVarParseNode;
import org.truffleruby.parser.ast.Colon2ConstParseNode;
import org.truffleruby.parser.ast.Colon2ImplicitParseNode;
import org.truffleruby.parser.ast.Colon2ParseNode;
import org.truffleruby.parser.ast.Colon3ParseNode;
import org.truffleruby.parser.ast.ComplexParseNode;
import org.truffleruby.parser.ast.ConstDeclParseNode;
import org.truffleruby.parser.ast.ConstParseNode;
import org.truffleruby.parser.ast.DAsgnParseNode;
import org.truffleruby.parser.ast.DRegexpParseNode;
import org.truffleruby.parser.ast.DStrParseNode;
import org.truffleruby.parser.ast.DSymbolParseNode;
import org.truffleruby.parser.ast.DVarParseNode;
import org.truffleruby.parser.ast.DXStrParseNode;
import org.truffleruby.parser.ast.DefinedParseNode;
import org.truffleruby.parser.ast.DefnParseNode;
import org.truffleruby.parser.ast.DefsParseNode;
import org.truffleruby.parser.ast.DotParseNode;
import org.truffleruby.parser.ast.EncodingParseNode;
import org.truffleruby.parser.ast.EnsureParseNode;
import org.truffleruby.parser.ast.EvStrParseNode;
import org.truffleruby.parser.ast.FCallParseNode;
import org.truffleruby.parser.ast.FalseParseNode;
import org.truffleruby.parser.ast.FixnumParseNode;
import org.truffleruby.parser.ast.FlipParseNode;
import org.truffleruby.parser.ast.FloatParseNode;
import org.truffleruby.parser.ast.ForParseNode;
import org.truffleruby.parser.ast.GlobalAsgnParseNode;
import org.truffleruby.parser.ast.GlobalVarParseNode;
import org.truffleruby.parser.ast.HashParseNode;
import org.truffleruby.parser.ast.IArgumentNode;
import org.truffleruby.parser.ast.IfParseNode;
import org.truffleruby.parser.ast.InParseNode;
import org.truffleruby.parser.ast.InstAsgnParseNode;
import org.truffleruby.parser.ast.InstVarParseNode;
import org.truffleruby.parser.ast.IterParseNode;
import org.truffleruby.parser.ast.LambdaParseNode;
import org.truffleruby.parser.ast.ListParseNode;
import org.truffleruby.parser.ast.LiteralParseNode;
import org.truffleruby.parser.ast.LocalAsgnParseNode;
import org.truffleruby.parser.ast.LocalVarParseNode;
import org.truffleruby.parser.ast.Match2ParseNode;
import org.truffleruby.parser.ast.Match3ParseNode;
import org.truffleruby.parser.ast.MatchParseNode;
import org.truffleruby.parser.ast.MethodDefParseNode;
import org.truffleruby.parser.ast.ModuleParseNode;
import org.truffleruby.parser.ast.MultipleAsgnParseNode;
import org.truffleruby.parser.ast.NextParseNode;
import org.truffleruby.parser.ast.NilImplicitParseNode;
import org.truffleruby.parser.ast.NilParseNode;
import org.truffleruby.parser.ast.NthRefParseNode;
import org.truffleruby.parser.ast.OpAsgnAndParseNode;
import org.truffleruby.parser.ast.OpAsgnConstDeclParseNode;
import org.truffleruby.parser.ast.OpAsgnOrParseNode;
import org.truffleruby.parser.ast.OpAsgnParseNode;
import org.truffleruby.parser.ast.OpElementAsgnParseNode;
import org.truffleruby.parser.ast.OrParseNode;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.PostExeParseNode;
import org.truffleruby.parser.ast.PreExeParseNode;
import org.truffleruby.parser.ast.RationalParseNode;
import org.truffleruby.parser.ast.RedoParseNode;
import org.truffleruby.parser.ast.RegexpParseNode;
import org.truffleruby.parser.ast.RescueBodyParseNode;
import org.truffleruby.parser.ast.RescueParseNode;
import org.truffleruby.parser.ast.RetryParseNode;
import org.truffleruby.parser.ast.ReturnParseNode;
import org.truffleruby.parser.ast.SClassParseNode;
import org.truffleruby.parser.ast.SValueParseNode;
import org.truffleruby.parser.ast.SelfParseNode;
import org.truffleruby.parser.ast.SideEffectFree;
import org.truffleruby.parser.ast.SplatParseNode;
import org.truffleruby.parser.ast.StarParseNode;
import org.truffleruby.parser.ast.StrParseNode;
import org.truffleruby.parser.ast.SymbolParseNode;
import org.truffleruby.parser.ast.TrueParseNode;
import org.truffleruby.parser.ast.TruffleFragmentParseNode;
import org.truffleruby.parser.ast.UndefParseNode;
import org.truffleruby.parser.ast.UntilParseNode;
import org.truffleruby.parser.ast.VAliasParseNode;
import org.truffleruby.parser.ast.VCallParseNode;
import org.truffleruby.parser.ast.WhenOneArgParseNode;
import org.truffleruby.parser.ast.WhenParseNode;
import org.truffleruby.parser.ast.WhileParseNode;
import org.truffleruby.parser.ast.XStrParseNode;
import org.truffleruby.parser.ast.YieldParseNode;
import org.truffleruby.parser.ast.ZArrayParseNode;
import org.truffleruby.parser.parser.ParseNodeTuple;
import org.truffleruby.parser.parser.ParserSupport;
import org.truffleruby.parser.scope.StaticScope;

public class BodyTranslator
extends BaseTranslator {
    public static final ToSNode[] EMPTY_TO_S_NODE_ARRAY = new ToSNode[0];
    public static final RescueNode[] EMPTY_RESCUE_NODE_ARRAY = new RescueNode[0];
    protected final BodyTranslator parent;
    private final RubyDeferredWarnings rubyWarnings;
    public boolean translatingForStatement = false;
    private boolean translatingNextExpression = false;
    private boolean translatingWhile = false;
    protected String currentCallMethodName = null;
    public static final int NO_FRAME_ON_STACK_MARKER = -1;
    private static final ParseNode[] EMPTY_ARGUMENTS = ParseNode.EMPTY_ARRAY;
    public Deque<Integer> frameOnStackMarkerSlotStack = new ArrayDeque<Integer>();

    public BodyTranslator(RubyLanguage language, BodyTranslator parent, TranslatorEnvironment environment, Source source, ParserContext parserContext, Node currentNode, RubyDeferredWarnings rubyWarnings) {
        super(language, source, parserContext, currentNode, environment);
        this.parent = parent;
        this.rubyWarnings = rubyWarnings;
    }

    private RubyNode translateNameNode(ParseNode node) {
        if (node instanceof LiteralParseNode) {
            LiteralParseNode literal = (LiteralParseNode)node;
            String string = literal.getName();
            ObjectLiteralNode ret = new ObjectLiteralNode(this.language.getSymbol(string));
            ret.unsafeSetSourceSection(node.getPosition());
            return this.addNewlineIfNeeded(node, ret);
        }
        return node.accept(this);
    }

    @Override
    public RubyNode visitAliasNode(AliasParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode newName = this.translateNameNode(node.getNewName());
        RubyNode oldName = this.translateNameNode(node.getOldName());
        ModuleNodes.AliasKeywordNode ret = new ModuleNodes.AliasKeywordNode(newName, oldName);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitVAliasNode(VAliasParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        AliasGlobalVarNode ret = new AliasGlobalVarNode(node.getOldName(), node.getNewName());
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitAndNode(AndParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode x = this.translateNodeOrNil(sourceSection, node.getFirstNode());
        RubyNode y = this.translateNodeOrNil(sourceSection, node.getSecondNode());
        AndNode ret = AndNodeGen.create(x, y);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitArgsCatNode(ArgsCatParseNode node) {
        ArrayList<ParseNode> nodes = new ArrayList<ParseNode>();
        this.collectArgsCatNodes(nodes, node);
        ArrayList<RubyNode> translatedNodes = new ArrayList<RubyNode>();
        for (ParseNode catNode : nodes) {
            translatedNodes.add(catNode.accept(this));
        }
        ArrayConcatNode ret = new ArrayConcatNode(translatedNodes.toArray(RubyNode.EMPTY_ARRAY));
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    private void collectArgsCatNodes(List<ParseNode> nodes, ArgsCatParseNode node) {
        if (node.getFirstNode() instanceof ArgsCatParseNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatParseNode)node.getFirstNode());
        } else {
            nodes.add(node.getFirstNode());
        }
        if (node.getSecondNode() instanceof ArgsCatParseNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatParseNode)node.getSecondNode());
        } else {
            SplatParseNode secondNode = new SplatParseNode(node.getSecondNode().getPosition(), node.getSecondNode());
            nodes.add(secondNode);
        }
    }

    @Override
    public RubyNode visitArgsPushNode(ArgsPushParseNode node) {
        RubyNode args = node.getFirstNode().accept(this);
        RubyNode value = node.getSecondNode().accept(this);
        ArrayAppendOneNode ret = ArrayAppendOneNodeGen.create(KernelNodesFactory.DupASTNodeFactory.create(args), value);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitArrayNode(ArrayParseNode node) {
        ParseNode[] values = node.children();
        RubyNode[] translatedValues = BodyTranslator.createArray(values.length);
        for (int n = 0; n < values.length; ++n) {
            translatedValues[n] = values[n].accept(this);
        }
        ArrayLiteralNode ret = ArrayLiteralNode.create(this.language, translatedValues);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitAttrAssignNode(AttrAssignParseNode node) {
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getReceiverNode(), node.getName(), node.getArgsNode(), null, node.isLazy());
        this.copyNewline(node, callNode);
        RubyNode actualCall = this.translateCallNode(callNode, node.isSelf(), false, true);
        return this.addNewlineIfNeeded(node, actualCall);
    }

    @Override
    public RubyNode visitBeginNode(BeginParseNode node) {
        RubyNode ret = node.getBodyNode().accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitBignumNode(BignumParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        BigInteger value = node.getValue();
        RubyNode ret = this.bignumOrFixnumNode(value);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode bignumOrFixnumNode(BigInteger value) {
        if (value.bitLength() >= 64) {
            return new ObjectLiteralNode(BignumOperations.createBignum(value));
        }
        return new LongFixnumLiteralNode(value.longValue());
    }

    @Override
    public RubyNode visitBlockNode(BlockParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ArrayList<RubyNode> translatedChildren = new ArrayList<RubyNode>(node.size());
        for (ParseNode child : node.children()) {
            RubyNode translatedChild = this.translateNodeOrNil(sourceSection, child);
            if (translatedChild instanceof DeadNode) continue;
            translatedChildren.add(translatedChild);
        }
        RubyNode ret = translatedChildren.size() == 1 ? (RubyNode)((Object)translatedChildren.get(0)) : BodyTranslator.sequence(sourceSection, translatedChildren);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitBreakNode(BreakParseNode node) {
        assert (this.environment.isBlock() || this.translatingWhile) : "The parser did not see an invalid break";
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode resultNode = this.translateNodeOrNil(sourceSection, node.getValueNode());
        BreakNode ret = new BreakNode(this.environment.getBreakID(), this.translatingWhile, resultNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitCallNode(CallParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ParseNode receiver = node.getReceiverNode();
        String methodName = node.getName();
        if (receiver instanceof StrParseNode && (methodName.equals("freeze") || methodName.equals("-@") || methodName.equals("dedup"))) {
            StrParseNode strNode = (StrParseNode)receiver;
            TruffleString tstring = strNode.getValue();
            ImmutableRubyString frozenString = this.language.getFrozenStringLiteral(tstring, strNode.encoding);
            return this.addNewlineIfNeeded(node, BodyTranslator.withSourceSection(sourceSection, new FrozenStringLiteralNode(frozenString, FrozenStrings.METHOD)));
        }
        if (this.environment.getParseEnvironment().canUsePrimitives() && receiver instanceof ConstParseNode && ((ConstParseNode)receiver).getName().equals("Primitive")) {
            RubyNode ret = this.translateInvokePrimitive(sourceSection, node);
            return this.addNewlineIfNeeded(node, ret);
        }
        boolean ignoreVisibility = receiver instanceof SelfParseNode;
        RubyNode translated = this.translateCallNode(node, ignoreVisibility, false, false);
        if (!translated.hasSource()) {
            translated.unsafeSetSourceSection(sourceSection);
        }
        return this.addNewlineIfNeeded(node, translated);
    }

    private RubyNode translateInvokePrimitive(SourceIndexLength sourceSection, CallParseNode node) {
        String primitiveName = node.getName();
        PrimitiveNodeConstructor primitive = this.language.primitiveManager.getPrimitive(primitiveName);
        ArrayParseNode args = (ArrayParseNode)node.getArgsNode();
        int size = args != null ? args.size() : 0;
        RubyNode[] arguments = new RubyNode[size];
        for (int n = 0; n < size; ++n) {
            arguments[n] = args.get(n).accept(this);
        }
        return primitive.createInvokePrimitiveNode(this.source, sourceSection, arguments);
    }

    private RubyNode translateCallNode(CallParseNode node, boolean ignoreVisibility, boolean isVCall, boolean isAttrAssign) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode receiver = node.getReceiverNode().accept(this);
        ParseNode args = node.getArgsNode();
        ParseNode block = node.getIterNode();
        if (block == null && args instanceof IterParseNode) {
            block = args;
            args = null;
        }
        String methodName = node.getName();
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, block, args, methodName);
        ArrayList<RubyNode> children = new ArrayList<RubyNode>();
        if (argumentsAndBlock.getBlock() != null) {
            children.add(argumentsAndBlock.getBlock());
        }
        children.addAll(Arrays.asList(argumentsAndBlock.getArguments()));
        SourceIndexLength enclosingSourceSection = BodyTranslator.enclosing(sourceSection, children.toArray(RubyNode.EMPTY_ARRAY));
        RubyCallNodeParameters callParameters = new RubyCallNodeParameters(receiver, methodName, argumentsAndBlock.getBlock(), argumentsAndBlock.getArgumentsDescriptor(), argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted(), ignoreVisibility, isVCall, node.isLazy(), isAttrAssign);
        RubyNode translated = Translator.withSourceSection(enclosingSourceSection, this.language.coreMethodAssumptions.createCallNode(callParameters));
        translated = this.wrapCallWithLiteralBlock(argumentsAndBlock, translated);
        return this.addNewlineIfNeeded(node, translated);
    }

    protected RubyNode wrapCallWithLiteralBlock(ArgumentsAndBlockTranslation argumentsAndBlock, RubyNode callNode) {
        if (argumentsAndBlock.getBlock() instanceof BlockDefinitionNode) {
            callNode = new FrameOnStackNode(callNode, argumentsAndBlock.getFrameOnStackMarkerSlot());
            BlockDefinitionNode blockDef = (BlockDefinitionNode)argumentsAndBlock.getBlock();
            return new CatchBreakNode(blockDef.getBreakID(), callNode, false);
        }
        return callNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArgumentsAndBlockTranslation translateArgumentsAndBlock(SourceIndexLength sourceSection, ParseNode iterNode, ParseNode argsNode, String nameToSetWhenTranslatingBlock) {
        int frameOnStackMarkerSlot;
        RubyNode blockTranslated;
        ParseNode[] arguments;
        assert (!(argsNode instanceof IterParseNode));
        ArgumentsDescriptor keywordDescriptor = BodyTranslator.getKeywordArgumentsDescriptor(this.language, argsNode);
        boolean isSplatted = false;
        if (argsNode == null) {
            arguments = EMPTY_ARGUMENTS;
        } else if (argsNode instanceof ArrayParseNode) {
            arguments = ((ArrayParseNode)argsNode).children();
        } else if (argsNode instanceof SplatParseNode || argsNode instanceof ArgsCatParseNode || argsNode instanceof ArgsPushParseNode) {
            isSplatted = true;
            arguments = new ParseNode[]{argsNode};
        } else {
            throw CompilerDirectives.shouldNotReachHere((String)("Unknown argument node type: " + argsNode.getClass()));
        }
        RubyNode[] argumentsTranslated = BodyTranslator.createArray(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            argumentsTranslated[i] = arguments[i].accept(this);
        }
        if (isSplatted) {
            assert (argumentsTranslated.length == 1);
            if (argumentsTranslated[0] instanceof SplatCastNode) {
                ((SplatCastNode)argumentsTranslated[0]).doNotCopy();
            }
        }
        ParseNode blockPassNode = null;
        if (iterNode instanceof BlockPassParseNode) {
            blockPassNode = ((BlockPassParseNode)iterNode).getBodyNode();
        }
        this.currentCallMethodName = nameToSetWhenTranslatingBlock;
        if (blockPassNode != null) {
            blockTranslated = ToProcNodeGen.create(blockPassNode.accept(this));
            blockTranslated.unsafeSetSourceSection(sourceSection);
            frameOnStackMarkerSlot = -1;
        } else if (iterNode != null) {
            frameOnStackMarkerSlot = this.environment.declareLocalTemp("frame_on_stack_marker");
            this.frameOnStackMarkerSlotStack.push(frameOnStackMarkerSlot);
            try {
                blockTranslated = iterNode.accept(this);
            }
            finally {
                this.frameOnStackMarkerSlotStack.pop();
            }
            if (blockTranslated instanceof ObjectLiteralNode && ((ObjectLiteralNode)blockTranslated).getObject() == Nil.INSTANCE) {
                blockTranslated = null;
            }
        } else {
            blockTranslated = null;
            frameOnStackMarkerSlot = -1;
        }
        this.currentCallMethodName = null;
        return new ArgumentsAndBlockTranslation(blockTranslated, argumentsTranslated, isSplatted, keywordDescriptor, frameOnStackMarkerSlot);
    }

    @Override
    public RubyNode visitCaseNode(CaseParseNode node) {
        RubyNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode elseNode = this.translateNodeOrNil(sourceSection, node.getElseNode());
        if (node.getCaseNode() != null) {
            int tempSlot = this.environment.declareLocalTemp("case");
            ReadLocalVariableNode readTemp = this.environment.readNode(tempSlot, sourceSection);
            WriteLocalNode assignTemp = ((ReadLocalNode)readTemp).makeWriteNode(node.getCaseNode().accept(this));
            for (int n = node.getCases().size() - 1; n >= 0; --n) {
                RubyNode[] arguments;
                String method;
                RubyNode receiver;
                WhenParseNode when = (WhenParseNode)node.getCases().get(n);
                ParseNode expressionNode = when.getExpressionNodes();
                RubyNode rubyExpression = expressionNode.accept(this);
                if (when instanceof WhenOneArgParseNode) {
                    receiver = rubyExpression;
                    method = "===";
                    arguments = new RubyNode[]{(RubyNode)NodeUtil.cloneNode((Node)readTemp)};
                } else {
                    receiver = new TruffleInternalModuleLiteralNode();
                    receiver.unsafeSetSourceSection(sourceSection);
                    method = "when_splat";
                    arguments = new RubyNode[]{rubyExpression, (RubyNode)NodeUtil.cloneNode((Node)readTemp)};
                }
                RubyContextSourceNode conditionNode = this.createCallNode(receiver, method, arguments);
                RubyNode thenNode = this.translateNodeOrNil(sourceSection, when.getBodyNode());
                IfElseNode ifNode = IfElseNodeGen.create(conditionNode, thenNode, elseNode);
                elseNode = ifNode;
            }
            RubyNode ifNode = elseNode;
            ret = BodyTranslator.sequence(sourceSection, Arrays.asList(assignTemp, ifNode));
        } else {
            for (int n = node.getCases().size() - 1; n >= 0; --n) {
                WhenParseNode when = (WhenParseNode)node.getCases().get(n);
                ParseNode expressionNode = when.getExpressionNodes();
                RubyNode conditionNode = expressionNode.accept(this);
                RubyNode thenNode = when.getBodyNode().accept(this);
                IfElseNode ifNode = IfElseNodeGen.create(conditionNode, thenNode, elseNode);
                elseNode = ifNode;
            }
            ret = elseNode;
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitCaseInNode(CaseInParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        if (!RubyLanguage.getCurrentContext().getOptions().PATTERN_MATCHING) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("syntax error, unexpected keyword_in", this.currentNode, sourceSection.toSourceSection(this.source)));
        }
        PatternMatchingTranslator translator = new PatternMatchingTranslator(this.language, this.source, this.parserContext, this.currentNode, this.environment, this);
        int tempSlot = this.environment.declareLocalTemp("case in value");
        ReadLocalVariableNode readTemp = this.environment.readNode(tempSlot, sourceSection);
        WriteLocalNode assignTemp = ((ReadLocalNode)readTemp).makeWriteNode(node.getCaseNode().accept(this));
        RubyNode elseNode = node.getElseNode() == null ? NoMatchingPatternNodeGen.create(readTemp) : node.getElseNode().accept(this);
        for (int n = node.getCases().size() - 1; n >= 0; --n) {
            InParseNode in = (InParseNode)node.getCases().get(n);
            ParseNode patternNode = in.getExpressionNodes();
            RubyNode conditionNode = translator.translatePatternNode(patternNode, readTemp);
            RubyNode thenNode = this.translateNodeOrNil(sourceSection, in.getBodyNode());
            IfElseNode ifNode = IfElseNodeGen.create(conditionNode, thenNode, elseNode);
            elseNode = ifNode;
        }
        RubyNode ifNode = elseNode;
        RubyNode ret = BodyTranslator.sequence(sourceSection, Arrays.asList(assignTemp, ifNode));
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode openModule(SourceIndexLength sourceSection, RubyNode defineOrGetNode, String moduleName, ParseNode bodyNode, OpenModule type, boolean dynamicConstantLookup) {
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String methodName = type.format(moduleName);
        LexicalScope newLexicalScope = dynamicConstantLookup ? null : new LexicalScope(this.environment.getStaticLexicalScope());
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(fullSourceSection, newLexicalScope, Arity.NO_ARGUMENTS, methodName, 0, methodName, null, null);
        String modulePath = type == OpenModule.SINGLETON_CLASS ? moduleName : TranslatorEnvironment.composeModulePath(this.environment.modulePath, moduleName);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.environment, this.environment.getParseEnvironment(), ReturnID.MODULE_BODY, true, true, sharedMethodInfo, methodName, 0, null, null, modulePath);
        BodyTranslator moduleTranslator = new BodyTranslator(this.language, this, newEnvironment, this.source, this.parserContext, this.currentNode, this.rubyWarnings);
        ModuleBodyDefinition definition = moduleTranslator.compileClassNode(sourceSection, bodyNode);
        return Translator.withSourceSection(sourceSection, new RunModuleDefinitionNode(definition, defineOrGetNode));
    }

    private ModuleBodyDefinition compileClassNode(SourceIndexLength sourceSection, ParseNode bodyNode) {
        RubyNode body = this.translateNodeOrNil(sourceSection, bodyNode);
        body = new InsideModuleDefinitionNode(body);
        body.unsafeSetSourceSection(sourceSection);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = BodyTranslator.sequence(sourceSection, Arrays.asList(BodyTranslator.initFlipFlopStates(this.environment, sourceSection), body));
        }
        RubyNode writeSelfNode = BodyTranslator.loadSelf(this.language);
        body = BodyTranslator.sequence(sourceSection, Arrays.asList(writeSelfNode, body));
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyRootNode rootNode = new RubyRootNode(this.language, fullSourceSection, this.environment.computeFrameDescriptor(), this.environment.getSharedMethodInfo(), body, Split.NEVER, this.environment.getReturnID());
        return new ModuleBodyDefinition(this.environment.getSharedMethodInfo().getOriginalName(), this.environment.getSharedMethodInfo(), rootNode.getCallTarget(), this.environment.getStaticLexicalScopeOrNull());
    }

    @Override
    public RubyNode visitClassNode(ClassParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        RubyNode superClass = node.getSuperNode() != null ? node.getSuperNode().accept(this) : null;
        DefineClassNode defineOrGetClass = new DefineClassNode(name, lexicalParent, superClass);
        defineOrGetClass.unsafeSetSourceSection(sourceSection);
        RubyNode ret = this.openModule(sourceSection, defineOrGetClass, name, node.getBodyNode(), OpenModule.CLASS, this.shouldUseDynamicConstantLookupForModuleBody(sourceSection));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitClassVarAsgnNode(ClassVarAsgnParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode rhs = node.getValueNode().accept(this);
        WriteClassVariableNode ret = new WriteClassVariableNode(this.getLexicalScopeNode("set dynamic class variable", sourceSection), node.getName(), rhs);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitClassVarNode(ClassVarParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ReadClassVariableNode ret = new ReadClassVariableNode(this.getLexicalScopeNode("class variable lookup", sourceSection), node.getName());
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitColon2Node(Colon2ParseNode node) {
        if (!(node instanceof Colon2ConstParseNode)) {
            throw new UnsupportedOperationException(node.toString());
        }
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getName();
        RubyNode lhs = node.getLeftNode().accept(this);
        ReadConstantNode ret = new ReadConstantNode(lhs, name);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitColon3Node(Colon3ParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getName();
        ObjectClassLiteralNode root = new ObjectClassLiteralNode();
        root.unsafeSetSourceSection(sourceSection);
        ReadConstantNode ret = new ReadConstantNode(root, name);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode translateCPath(SourceIndexLength sourceSection, Colon3ParseNode node) {
        RubyNode ret;
        if (node instanceof Colon2ImplicitParseNode) {
            ret = this.getLexicalScopeModuleNode("dynamic constant lookup", sourceSection);
            ret.unsafeSetSourceSection(sourceSection);
        } else if (node instanceof Colon2ConstParseNode) {
            ret = ((Colon2ConstParseNode)node).getLeftNode().accept(this);
        } else {
            ret = new ObjectClassLiteralNode();
            ret.unsafeSetSourceSection(sourceSection);
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitComplexNode(ComplexParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode ret = this.translateRationalComplex(sourceSection, "Complex", new IntegerFixnumLiteralNode(0), node.getNumber().accept(this));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitConstDeclNode(ConstDeclParseNode node) {
        RubyNode moduleNode;
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode rhs = node.getValueNode().accept(this);
        ParseNode constNode = node.getConstNode();
        if (constNode == null || constNode instanceof Colon2ImplicitParseNode) {
            moduleNode = this.getLexicalScopeModuleNode("set dynamic constant", sourceSection);
            moduleNode.unsafeSetSourceSection(sourceSection);
        } else if (constNode instanceof Colon2ConstParseNode) {
            constNode = ((Colon2ParseNode)constNode).getLeftNode();
            moduleNode = constNode.accept(this);
        } else if (constNode instanceof Colon3ParseNode) {
            moduleNode = new ObjectClassLiteralNode();
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        WriteConstantNode ret = new WriteConstantNode(node.getName(), moduleNode, rhs);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode getLexicalScopeModuleNode(String kind, SourceIndexLength sourceSection) {
        if (this.environment.isDynamicConstantLookup()) {
            if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                RubyLanguage.LOGGER.info(() -> kind + " at " + RubyLanguage.getCurrentContext().fileLine(sourceSection.toSourceSection(this.source)));
            }
            return new DynamicLexicalScopeNode();
        }
        return new LexicalScopeNode(this.environment.getStaticLexicalScope());
    }

    private RubyNode getLexicalScopeNode(String kind, SourceIndexLength sourceSection) {
        if (this.environment.isDynamicConstantLookup()) {
            if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                RubyLanguage.LOGGER.info(() -> kind + " at " + RubyLanguage.getCurrentContext().fileLine(sourceSection.toSourceSection(this.source)));
            }
            return new GetDynamicLexicalScopeNode();
        }
        return new ObjectLiteralNode(this.environment.getStaticLexicalScope());
    }

    @Override
    public RubyNode visitConstNode(ConstParseNode node) {
        RubyContextSourceNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getName();
        if (this.environment.isDynamicConstantLookup()) {
            if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                RubyLanguage.LOGGER.info(() -> "dynamic constant lookup at " + RubyLanguage.getCurrentContext().fileLine(sourceSection.toSourceSection(this.source)));
            }
            ret = new ReadConstantWithDynamicScopeNode(name);
        } else {
            LexicalScope lexicalScope = this.environment.getStaticLexicalScope();
            ret = new ReadConstantWithLexicalScopeNode(lexicalScope, name);
        }
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public WriteLocalNode visitDAsgnNode(DAsgnParseNode node) {
        WriteLocalNode ret = this.visitLocalAsgnNode(new LocalAsgnParseNode(node.getPosition(), node.getName(), node.getDepth(), node.getValueNode()));
        this.addNewlineIfNeeded(node, ret);
        return ret;
    }

    @Override
    public RubyNode visitDRegxNode(DRegexpParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ArrayList<ToSNode> children = new ArrayList<ToSNode>();
        for (ParseNode child : node.children()) {
            children.add(ToSNodeGen.create(child.accept(this)));
        }
        InterpolatedRegexpNode i = new InterpolatedRegexpNode(children.toArray(EMPTY_TO_S_NODE_ARRAY), node.getOptions());
        i.unsafeSetSourceSection(sourceSection);
        if (node.getOptions().isOnce()) {
            OnceNode ret = new OnceNode(i);
            ret.unsafeSetSourceSection(sourceSection);
            return this.addNewlineIfNeeded(node, ret);
        }
        return this.addNewlineIfNeeded(node, i);
    }

    @Override
    public RubyNode visitDStrNode(DStrParseNode node) {
        RubyNode ret = this.translateInterpolatedString(node.getPosition(), node.getEncoding(), node.children());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDSymbolNode(DSymbolParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        if (node.size() == 1 && node.getLast() instanceof StrParseNode) {
            StrParseNode strParseNode = (StrParseNode)node.getLast();
            SymbolParseNode symbolParseNode = this.asSymbol(sourceSection, strParseNode);
            return this.visitSymbolNode(symbolParseNode);
        }
        RubyNode stringNode = this.translateInterpolatedString(sourceSection, node.getEncoding(), node.children());
        StringToSymbolNode ret = StringToSymbolNodeGen.create(stringNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    private SymbolParseNode asSymbol(SourceIndexLength position, StrParseNode value) {
        SymbolParseNode symbolParseNode = new SymbolParseNode(position, value.getValue(), value.encoding);
        if (!symbolParseNode.getTString().isValidUncached(symbolParseNode.getRubyEncoding().tencoding)) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(RubyLanguage.getCurrentContext(), context.getCoreExceptions().encodingError(symbolParseNode.getTString(), symbolParseNode.getRubyEncoding(), null));
        }
        return symbolParseNode;
    }

    private RubyNode translateInterpolatedString(SourceIndexLength sourceSection, Encoding encoding, ParseNode[] childNodes) {
        ToSNode[] children = new ToSNode[childNodes.length];
        for (int i = 0; i < childNodes.length; ++i) {
            children[i] = ToSNodeGen.create(childNodes[i].accept(this));
        }
        InterpolatedStringNode ret = new InterpolatedStringNode(children, encoding);
        ret.unsafeSetSourceSection(sourceSection);
        return ret;
    }

    @Override
    public RubyNode visitDVarNode(DVarParseNode node) {
        String name = node.getName();
        ReadLocalNode readNode = this.environment.findLocalVarNode(name, node.getPosition());
        if (readNode == null) {
            int depth = node.getDepth();
            TranslatorEnvironment e = this.environment;
            for (int n = 0; n < depth; ++n) {
                e = e.getParent();
            }
            e.declareVar(name);
            readNode = this.environment.findLocalVarNode(name, node.getPosition());
        }
        return this.addNewlineIfNeeded(node, readNode);
    }

    @Override
    public RubyNode visitDXStrNode(DXStrParseNode node) {
        DStrParseNode string = new DStrParseNode(node.getPosition(), node.getEncoding());
        string.addAll(node);
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), string, new ParseNode[0]);
        FCallParseNode callNode = new FCallParseNode(node.getPosition(), "`", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDefinedNode(DefinedParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ParseNode expressionNode = node.getExpressionNode();
        if (expressionNode instanceof YieldParseNode && this.isInvalidYield()) {
            return this.nilNode(sourceSection);
        }
        DefinedNode ret = new DefinedNode(expressionNode.accept(this));
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDefnNode(DefnParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode ret = this.translateMethodDefinition(sourceSection, null, node.getName(), node.getArgsNode(), node, node.getBodyNode(), false, false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDefsNode(DefsParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        boolean isReceiverSelf = node.getReceiverNode() instanceof SelfParseNode;
        RubyNode objectNode = node.getReceiverNode().accept(this);
        SingletonClassNode.SingletonClassASTNode singletonClassNode = SingletonClassNodeGen.SingletonClassASTNodeGen.create(objectNode);
        singletonClassNode.unsafeSetSourceSection(sourceSection);
        RubyNode ret = this.translateMethodDefinition(sourceSection, singletonClassNode, node.getName(), node.getArgsNode(), node, node.getBodyNode(), true, isReceiverSelf);
        return this.addNewlineIfNeeded(node, ret);
    }

    public String modulePathAndMethodName(String methodName, boolean onSingleton, boolean isReceiverSelf) {
        String modulePath = this.environment.modulePath;
        if (modulePath == null) {
            if (onSingleton) {
                if (this.environment.isTopLevelObjectScope() && isReceiverSelf) {
                    modulePath = "main";
                } else {
                    modulePath = "<singleton class>";
                    onSingleton = false;
                }
            } else {
                modulePath = this.environment.isTopLevelObjectScope() ? "Object" : "";
            }
        }
        if (modulePath.endsWith("::<singleton class>") && !onSingleton) {
            modulePath = modulePath.substring(0, modulePath.length() - "::<singleton class>".length());
            onSingleton = true;
        }
        return SharedMethodInfo.modulePathAndMethodName(modulePath, methodName, onSingleton);
    }

    protected RubyNode translateMethodDefinition(SourceIndexLength sourceSection, RubyNode moduleNode, String methodName, ArgsParseNode argsNode, MethodDefParseNode defNode, ParseNode bodyNode, boolean isDefs, boolean isReceiverSelf) {
        Arity arity = argsNode.getArity();
        ArgumentDescriptor[] argumentDescriptors = Helpers.argsNodeToArgumentDescriptors(argsNode);
        String parseName = this.modulePathAndMethodName(methodName, isDefs, isReceiverSelf);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection.toSourceSection(this.source), this.environment.getStaticLexicalScopeOrNull(), arity, methodName, 0, parseName, null, argumentDescriptors);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.environment, this.environment.getParseEnvironment(), this.environment.getParseEnvironment().allocateReturnID(), true, false, sharedMethodInfo, methodName, 0, null, null, this.environment.modulePath);
        MethodTranslator methodCompiler = new MethodTranslator(this.language, this, newEnvironment, false, this.source, this.parserContext, this.currentNode, argsNode, null, this.rubyWarnings);
        return BodyTranslator.withSourceSection(sourceSection, new LiteralMethodDefinitionNode(moduleNode, methodName, sharedMethodInfo, isDefs, methodCompiler.buildMethodNodeCompiler(sourceSection, defNode, bodyNode)));
    }

    @Override
    public RubyNode visitDotNode(DotParseNode node) {
        RubyContextSourceNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        if (node.getBeginNode() instanceof FixnumParseNode && node.getEndNode() instanceof FixnumParseNode) {
            long begin = ((FixnumParseNode)node.getBeginNode()).getValue();
            long end = ((FixnumParseNode)node.getEndNode()).getValue();
            RubyIntOrLongRange range = CoreLibrary.fitsIntoInteger(begin) && CoreLibrary.fitsIntoInteger(end) ? new RubyIntRange(node.isExclusive(), (int)begin, (int)end) : new RubyLongRange(node.isExclusive(), begin, end);
            ret = new ObjectLiteralNode(range);
        } else {
            RubyNode begin = node.getBeginNode().accept(this);
            RubyNode end = node.getEndNode().accept(this);
            ret = new RangeNodes.RangeLiteralNode(begin, end, node.isExclusive());
        }
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitEncodingNode(EncodingParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ObjectLiteralNode ret = new ObjectLiteralNode(Encodings.getBuiltInEncoding(node.getEncoding()));
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitEnsureNode(EnsureParseNode node) {
        RubyNode tryPart = node.getBodyNode().accept(this);
        RubyNode ensurePart = node.getEnsureNode().accept(this);
        EnsureNode ret = EnsureNodeGen.create(tryPart, ensurePart);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitEvStrNode(EvStrParseNode node) {
        RubyNode ret;
        if (node.getBody() == null) {
            SourceIndexLength sourceSection = node.getPosition();
            ret = new ObjectLiteralNode(this.language.getFrozenStringLiteral(TStringConstants.EMPTY_BINARY, Encodings.BINARY));
            ret.unsafeSetSourceSection(sourceSection);
        } else {
            ret = node.getBody().accept(this);
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitFCallNode(FCallParseNode node) {
        SelfParseNode receiver = new SelfParseNode(node.getPosition());
        CallParseNode callNode = new CallParseNode(node.getPosition(), receiver, node.getName(), node.getArgsNode(), node.getIterNode());
        this.copyNewline(node, callNode);
        return this.translateCallNode(callNode, true, false, false);
    }

    @Override
    public RubyNode visitFalseNode(FalseParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        BooleanLiteralNode ret = new BooleanLiteralNode(false);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitFixnumNode(FixnumParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        long value = node.getValue();
        RubyNode ret = BodyTranslator.integerOrLongLiteralNode(value);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitFlipNode(FlipParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode begin = node.getBeginNode().accept(this);
        RubyNode end = node.getEndNode().accept(this);
        FindDeclarationVariableNodes.FrameSlotAndDepth slotAndDepth = this.createFlipFlopState(sourceSection, 0);
        FlipFlopNode ret = FlipFlopNodeGen.create(begin, end, node.isExclusive(), slotAndDepth.depth, slotAndDepth.slot);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    protected FindDeclarationVariableNodes.FrameSlotAndDepth createFlipFlopState(SourceIndexLength sourceSection, int depth) {
        int frameSlot = this.environment.declareLocalTemp("flipflop");
        this.environment.getFlipFlopStates().add(frameSlot);
        if (depth == 0) {
            return new FindDeclarationVariableNodes.FrameSlotAndDepth(frameSlot, 0);
        }
        return new FindDeclarationVariableNodes.FrameSlotAndDepth(frameSlot, depth);
    }

    @Override
    public RubyNode visitFloatNode(FloatParseNode node) {
        FloatLiteralNode ret = new FloatLiteralNode(node.getValue());
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitForNode(ForParseNode node) {
        RubyNode translated;
        String temp = this.environment.allocateLocalTemp("for");
        this.environment.declareVar(temp);
        ParseNode receiver = node.getIterNode();
        LocalVarParseNode readTemp = new LocalVarParseNode(node.getPosition(), 0, temp);
        ParseNode forVar = node.getVarNode();
        ParseNode assignTemp = this.setRHS(forVar, readTemp);
        BlockParseNode bodyWithTempAssign = new BlockParseNode(node.getPosition());
        bodyWithTempAssign.add(assignTemp);
        bodyWithTempAssign.add(node.getBodyNode());
        ArgumentParseNode blockVar = new ArgumentParseNode(node.getPosition(), temp);
        ArrayParseNode blockArgsPre = new ArrayParseNode(node.getPosition(), blockVar);
        ArgsParseNode blockArgs = new ArgsParseNode(node.getPosition(), blockArgsPre, null, null, null, null, null, null);
        IterParseNode block = new IterParseNode(node.getPosition(), (ParseNode)blockArgs, node.getScope(), bodyWithTempAssign);
        CallParseNode callNode = new CallParseNode(node.getPosition(), receiver, "each", null, block);
        this.copyNewline(node, callNode);
        boolean translatingForStatement = this.translatingForStatement;
        this.translatingForStatement = true;
        try {
            translated = callNode.accept(this);
        }
        finally {
            this.translatingForStatement = translatingForStatement;
        }
        if (!translated.hasSource()) {
            translated.unsafeSetSourceSection(node.getPosition());
        }
        return this.addNewlineIfNeeded(node, translated);
    }

    protected AssignableNode[] toAssignableNodes(ListParseNode nodes) {
        if (nodes == null) {
            return AssignableNode.EMPTY_ARRAY;
        }
        AssignableNode[] assignableNodes = new AssignableNode[nodes.size()];
        for (int i = 0; i < assignableNodes.length; ++i) {
            assignableNodes[i] = this.toAssignableNode(nodes.get(i));
        }
        return assignableNodes;
    }

    protected AssignableNode toAssignableNode(ParseNode node) {
        if (node instanceof StarParseNode) {
            return new NoopAssignableNode();
        }
        if (node instanceof AssignableParseNode) {
            ParseNode valueNode;
            AssignableParseNode assignable = (AssignableParseNode)node;
            if (assignable instanceof MultipleAsgnParseNode && assignable.getValueNode() == null) {
                assignable.setValueNode(NilImplicitParseNode.NIL);
            }
            if ((valueNode = assignable.getValueNode()) != NilImplicitParseNode.NIL) {
                throw CompilerDirectives.shouldNotReachHere((String)("value of assignable node is not implicit nil: " + valueNode.getClass()));
            }
            RubyNode translated = node.accept(this);
            return ((AssignableNode)((Object)translated)).toAssignableNode();
        }
        if (node instanceof AttrAssignParseNode) {
            AttrAssignParseNode attrAssignParseNode = (AttrAssignParseNode)node;
            this.setRHS(attrAssignParseNode, NilImplicitParseNode.NIL);
            RubyNode translated = attrAssignParseNode.accept(this);
            return ((AssignableNode)((Object)translated)).toAssignableNode();
        }
        throw CompilerDirectives.shouldNotReachHere((String)("toAssignableNode() does not know how to convert " + node.getClass()));
    }

    private ParseNode setRHS(ParseNode lhs, ParseNode rhs) {
        if (lhs instanceof AssignableParseNode) {
            ((AssignableParseNode)lhs).setValueNode(rhs);
            return lhs;
        }
        if (lhs instanceof IArgumentNode) {
            IArgumentNode invokableNode = (IArgumentNode)((Object)lhs);
            return invokableNode.setArgsNode(ParserSupport.arg_add(lhs.getPosition(), invokableNode.getArgsNode(), rhs));
        }
        throw new UnsupportedOperationException("Don't know how to set the RHS of a " + lhs.getClass().getName());
    }

    @Override
    public RubyNode visitGlobalAsgnNode(GlobalAsgnParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode translatedValue = node.getValueNode().accept(this);
        WriteGlobalVariableNode writeGlobalVariableNode = WriteGlobalVariableNodeGen.create(node.getName(), translatedValue);
        return this.addNewlineIfNeeded(node, BodyTranslator.withSourceSection(sourceSection, writeGlobalVariableNode));
    }

    private static boolean isCaptureVariable(String name) {
        if (name.equals("$0")) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    public RubyNode visitGlobalVarNode(GlobalVarParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        assert (!BodyTranslator.isCaptureVariable(node.getName()));
        ReadGlobalVariableNode readGlobal = ReadGlobalVariableNodeGen.create(node.getName());
        readGlobal.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, readGlobal);
    }

    @Override
    public RubyNode visitHashNode(HashParseNode node) {
        RubyNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        if (node.isEmpty()) {
            HashLiteralNode ret2 = HashLiteralNode.create(RubyNode.EMPTY_ARRAY);
            ret2.unsafeSetSourceSection(sourceSection);
            return this.addNewlineIfNeeded(node, ret2);
        }
        ArrayList<RubyContextSourceNode> hashConcats = new ArrayList<RubyContextSourceNode>();
        ArrayList<RubyNode> keyValues = new ArrayList<RubyNode>();
        for (ParseNodeTuple pair : node.getPairs()) {
            if (pair.getKey() == null) {
                if (!keyValues.isEmpty()) {
                    HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(keyValues.toArray(RubyNode.EMPTY_ARRAY));
                    hashConcats.add(hashLiteralSoFar);
                }
                hashConcats.add(HashCastNodeGen.HashCastASTNodeGen.create(pair.getValue().accept(this)));
                keyValues.clear();
                continue;
            }
            keyValues.add(pair.getKey().accept(this));
            if (pair.getValue() == null) {
                keyValues.add(this.nilNode(sourceSection));
                continue;
            }
            keyValues.add(pair.getValue().accept(this));
        }
        if (!keyValues.isEmpty()) {
            HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(keyValues.toArray(RubyNode.EMPTY_ARRAY));
            hashConcats.add(hashLiteralSoFar);
        }
        if (hashConcats.size() == 1) {
            ret = (RubyNode)((Object)hashConcats.get(0));
            return this.addNewlineIfNeeded(node, ret);
        }
        ret = new ConcatHashLiteralNode(hashConcats.toArray(RubyNode.EMPTY_ARRAY));
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitIfNode(IfParseNode node) {
        RubyNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode condition = this.translateNodeOrNil(sourceSection, node.getCondition());
        ParseNode thenBody = node.getThenBody();
        ParseNode elseBody = node.getElseBody();
        if (thenBody != null && elseBody != null) {
            RubyNode thenBodyTranslated = thenBody.accept(this);
            RubyNode elseBodyTranslated = elseBody.accept(this);
            ret = IfElseNodeGen.create(condition, thenBodyTranslated, elseBodyTranslated);
            ret.unsafeSetSourceSection(sourceSection);
        } else if (thenBody != null) {
            RubyNode thenBodyTranslated = thenBody.accept(this);
            ret = IfNodeGen.create(condition, thenBodyTranslated);
            ret.unsafeSetSourceSection(sourceSection);
        } else if (elseBody != null) {
            RubyNode elseBodyTranslated = elseBody.accept(this);
            ret = UnlessNodeGen.create(condition, elseBodyTranslated);
            ret.unsafeSetSourceSection(sourceSection);
        } else {
            ret = BodyTranslator.sequence(sourceSection, Arrays.asList(new RubyNode[]{condition, new NilLiteralNode(true)}));
        }
        return ret;
    }

    @Override
    public RubyNode visitInstAsgnNode(InstAsgnParseNode node) {
        RubyNode rhs;
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getName();
        if (node.getValueNode() == null) {
            rhs = new DeadNode("null RHS of instance variable assignment");
            rhs.unsafeSetSourceSection(sourceSection);
        } else {
            rhs = node.getValueNode().accept(this);
        }
        WriteInstanceVariableNode ret = WriteInstanceVariableNodeGen.create(name, rhs);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitInstVarNode(InstVarParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getName();
        ReadInstanceVariableNode ret = new ReadInstanceVariableNode(name);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitIterNode(IterParseNode node) {
        return this.translateBlockLikeNode(node, false);
    }

    @Override
    public RubyNode visitLambdaNode(LambdaParseNode node) {
        return this.translateBlockLikeNode(node, true);
    }

    private RubyNode translateBlockLikeNode(IterParseNode node, boolean isStabbyLambda) {
        SourceIndexLength sourceSection = node.getPosition();
        ArgsParseNode argsNode = node.getArgsNode();
        boolean hasOwnScope = isStabbyLambda || !this.translatingForStatement;
        boolean isProc = !isStabbyLambda;
        TranslatorEnvironment methodParent = this.environment.getSurroundingMethodEnvironment();
        String methodName = methodParent.getMethodName();
        int blockDepth = this.environment.getBlockDepth() + 1;
        String originalName = SharedMethodInfo.getBlockName(blockDepth, methodName);
        String parseName = SharedMethodInfo.getBlockName(blockDepth, methodParent.getSharedMethodInfo().getParseName());
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection.toSourceSection(this.source), this.environment.getStaticLexicalScopeOrNull(), argsNode.getArity(), originalName, blockDepth, parseName, methodName, Helpers.argsNodeToArgumentDescriptors(argsNode));
        ParseEnvironment parseEnvironment = this.environment.getParseEnvironment();
        ReturnID returnID = isStabbyLambda ? parseEnvironment.allocateReturnID() : this.environment.getReturnID();
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.environment, parseEnvironment, returnID, hasOwnScope, false, sharedMethodInfo, this.environment.getMethodName(), blockDepth, parseEnvironment.allocateBreakID(), null, this.environment.modulePath);
        MethodTranslator methodCompiler = new MethodTranslator(this.language, this, newEnvironment, true, this.source, this.parserContext, this.currentNode, argsNode, this.currentCallMethodName, this.rubyWarnings);
        if (isProc) {
            methodCompiler.translatingForStatement = this.translatingForStatement;
        }
        methodCompiler.frameOnStackMarkerSlotStack = this.frameOnStackMarkerSlotStack;
        BlockDefinitionNode definitionNode = methodCompiler.compileBlockNode(sourceSection, node.getBodyNode(), isStabbyLambda, node.getScope().getVariables());
        return this.addNewlineIfNeeded(node, definitionNode);
    }

    @Override
    public WriteLocalNode visitLocalAsgnNode(LocalAsgnParseNode node) {
        RubyNode rhs;
        ReadLocalNode lhs;
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getName();
        if (this.environment.getNeverAssignInParentScope()) {
            this.environment.declareVar(name);
        }
        if ((lhs = this.environment.findLocalVarNode(name, sourceSection)) == null) {
            TranslatorEnvironment environmentToDeclareIn = this.environment;
            while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                environmentToDeclareIn = environmentToDeclareIn.getParent();
            }
            environmentToDeclareIn.declareVar(name);
            lhs = this.environment.findLocalVarNode(name, sourceSection);
            if (lhs == null) {
                throw new RuntimeException("shouldn't be here");
            }
        }
        if (node.getValueNode() == null) {
            rhs = new DeadNode("BodyTranslator#visitLocalAsgnNode");
            rhs.unsafeSetSourceSection(sourceSection);
        } else {
            rhs = node.getValueNode().accept(this);
        }
        WriteLocalNode ret = lhs.makeWriteNode(rhs);
        ret.unsafeSetSourceSection(sourceSection);
        this.addNewlineIfNeeded(node, ret);
        return ret;
    }

    @Override
    public RubyNode visitLocalVarNode(LocalVarParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getName();
        ReadLocalNode readNode = this.environment.findLocalVarNode(name, sourceSection);
        if (readNode == null) {
            this.environment.declareVar(name);
            readNode = this.environment.findLocalVarNode(name, sourceSection);
        }
        return this.addNewlineIfNeeded(node, readNode);
    }

    @Override
    public RubyNode visitMatchNode(MatchParseNode node) {
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), new GlobalVarParseNode(node.getPosition(), "$_"), new ParseNode[0]);
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getRegexpNode(), "=~", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitMatch2Node(Match2ParseNode node) {
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new ParseNode[0]);
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getReceiverNode(), "=~", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        if (node.getReceiverNode() instanceof RegexpParseNode) {
            Regex regex;
            RegexpParseNode regexpNode = (RegexpParseNode)node.getReceiverNode();
            TStringWithEncoding source = regexpNode.getValue();
            InternalByteArray sourceByteArray = source.getInternalByteArray();
            try {
                regex = new Regex(sourceByteArray.getArray(), sourceByteArray.getOffset(), sourceByteArray.getEnd(), regexpNode.getOptions().toOptions(), regexpNode.getRubyEncoding().jcoding, Syntax.RUBY, (WarnCallback)new RegexWarnDeferredCallback(this.rubyWarnings));
            }
            catch (Exception e) {
                String errorMessage = ClassicRegexp.getRegexErrorMessage((AbstractTruffleString)source.tstring, e, regexpNode.getOptions());
                RubyContext context = RubyLanguage.getCurrentContext();
                throw new RaiseException(context, context.getCoreExceptions().regexpError(errorMessage, this.currentNode));
            }
            int numberOfNames = regex.numberOfNames();
            if (numberOfNames > 0) {
                RubyNode[] setters = new RubyNode[numberOfNames];
                RubyNode[] nilSetters = new RubyNode[numberOfNames];
                int tempSlot = this.environment.declareLocalTemp("match_data");
                int n = 0;
                Iterator i = regex.namedBackrefIterator();
                while (i.hasNext()) {
                    NameEntry e = (NameEntry)i.next();
                    String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                    TranslatorEnvironment environmentToDeclareIn = this.environment;
                    while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                        environmentToDeclareIn = environmentToDeclareIn.getParent();
                    }
                    environmentToDeclareIn.declareVar(name);
                    nilSetters[n] = this.match2NilSetter(node, name);
                    setters[n] = this.match2NonNilSetter(node, name, tempSlot);
                    ++n;
                }
                ReadGlobalVariableNode readNode = ReadGlobalVariableNodeGen.create("$~");
                ReadLocalVariableNode tempVarReadNode = this.environment.readNode(tempSlot, node.getPosition());
                WriteLocalNode readMatchNode = ((ReadLocalNode)tempVarReadNode).makeWriteNode(readNode);
                ret = new ReadMatchReferenceNodes.SetNamedVariablesMatchNode(ret, readMatchNode, setters, nilSetters);
            }
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode match2NilSetter(ParseNode node, String name) {
        return this.environment.findLocalVarNode(name, node.getPosition()).makeWriteNode(new NilLiteralNode(true));
    }

    private RubyNode match2NonNilSetter(ParseNode node, String name, int tempSlot) {
        ReadLocalNode varNode = this.environment.findLocalVarNode(name, node.getPosition());
        ReadLocalVariableNode tempVarNode = this.environment.readNode(tempSlot, node.getPosition());
        MatchDataNodes.GetFixedNameMatchNode getIndexNode = new MatchDataNodes.GetFixedNameMatchNode(tempVarNode, this.language.getSymbol(name));
        return varNode.makeWriteNode(getIndexNode);
    }

    @Override
    public RubyNode visitMatch3Node(Match3ParseNode node) {
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new ParseNode[0]);
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getReceiverNode(), "=~", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitModuleNode(ModuleParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        DefineModuleNode defineModuleNode = DefineModuleNodeGen.create(name, lexicalParent);
        defineModuleNode.unsafeSetSourceSection(sourceSection);
        RubyNode ret = this.openModule(sourceSection, defineModuleNode, name, node.getBodyNode(), OpenModule.MODULE, this.shouldUseDynamicConstantLookupForModuleBody(sourceSection));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitMultipleAsgnNode(MultipleAsgnParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ParseNode rhs = node.getValueNode();
        if (rhs == null) {
            throw CompilerDirectives.shouldNotReachHere((String)"null rhs");
        }
        RubyNode rhsTranslated = rhs.accept(this);
        AssignableNode[] preNodes = this.toAssignableNodes(node.getPre());
        AssignableNode restNode = node.getRest() == null ? null : this.toAssignableNode(node.getRest());
        AssignableNode[] postNodes = this.toAssignableNodes(node.getPost());
        SplatCastNode splatCastNode = SplatCastNodeGen.create(this.language, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, true, null);
        MultipleAssignmentNode ret = new MultipleAssignmentNode(preNodes, restNode, postNodes, splatCastNode, rhsTranslated);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitNextNode(NextParseNode node) {
        RubyNode resultNode;
        SourceIndexLength sourceSection = node.getPosition();
        if (!this.environment.isBlock() && !this.translatingWhile) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("Invalid next", this.currentNode, sourceSection.toSourceSection(this.source)));
        }
        boolean t = this.translatingNextExpression;
        this.translatingNextExpression = true;
        try {
            resultNode = this.translateNodeOrNil(sourceSection, node.getValueNode());
        }
        finally {
            this.translatingNextExpression = t;
        }
        NextNode ret = new NextNode(resultNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitNilNode(NilParseNode node) {
        if (node instanceof NilImplicitParseNode) {
            NilLiteralNode ret = new NilLiteralNode(true);
            ret.unsafeSetSourceSection(node.getPosition());
            return this.addNewlineIfNeeded(node, ret);
        }
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode ret = this.nilNode(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitNthRefNode(NthRefParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ReadGlobalVariableNode readMatchNode = ReadGlobalVariableNodeGen.create("$~");
        ReadMatchReferenceNodes.ReadNthMatchNode readGlobal = new ReadMatchReferenceNodes.ReadNthMatchNode(readMatchNode, node.getMatchNumber());
        readGlobal.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, readGlobal);
    }

    @Override
    public RubyNode visitOpAsgnAndNode(OpAsgnAndParseNode node) {
        return this.translateOpAsgnAndNode(node, node.getFirstNode().accept(this), node.getSecondNode().accept(this));
    }

    private RubyNode translateOpAsgnAndNode(ParseNode node, RubyNode lhs, RubyNode rhs) {
        SourceIndexLength sourceSection = node.getPosition();
        AndNode andNode = AndNodeGen.create(lhs, rhs);
        andNode.unsafeSetSourceSection(sourceSection);
        DefinedWrapperNode ret = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, andNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpAsgnConstDeclNode(OpAsgnConstDeclParseNode node) {
        ReadConstantNode lhs = (ReadConstantNode)node.getFirstNode().accept(this);
        RubyNode rhs = node.getSecondNode().accept(this);
        if (!(rhs instanceof WriteConstantNode)) {
            rhs = lhs.makeWriteNode(rhs);
        }
        switch (node.getOperator()) {
            case "&&": {
                return this.translateOpAsgnAndNode(node, lhs, rhs);
            }
            case "||": {
                return OrAssignConstantNodeGen.create(lhs, (WriteConstantNode)rhs);
            }
        }
        SourceIndexLength sourceSection = node.getPosition();
        RubyContextSourceNode opNode = this.createCallNode(lhs, node.getOperator(), rhs);
        RubyNode ret = lhs.makeWriteNode(opNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpAsgnNode(OpAsgnParseNode node) {
        SourceIndexLength pos = node.getPosition();
        ValueFromNode receiverValue = ValueFromNode.valueFromNode(this, node.getReceiverNode());
        boolean isOrOperator = node.getOperatorName().equals("||");
        if (isOrOperator || node.getOperatorName().equals("&&")) {
            CallParseNode readMethod = new CallParseNode(pos, receiverValue.get(pos), node.getVariableName(), null, null);
            AttrAssignParseNode writeMethod = new AttrAssignParseNode(pos, receiverValue.get(pos), node.getVariableName() + "=", BodyTranslator.buildArrayNode(pos, node.getValueNode(), new ParseNode[0]), false, node.getReceiverNode() instanceof SelfParseNode);
            SourceIndexLength sourceSection = pos;
            RubyNode lhs = ((ParseNode)readMethod).accept(this);
            RubyNode rhs = ((ParseNode)writeMethod).accept(this);
            RubyContextSourceNode controlNode = isOrOperator ? OrNodeGen.create(lhs, rhs) : AndNodeGen.create(lhs, rhs);
            DefinedWrapperNode ret = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, receiverValue.prepareAndThen(sourceSection, controlNode));
            ret.unsafeSetSourceSection(sourceSection);
            return this.addNewlineIfNeeded(node, ret);
        }
        CallParseNode readMethod = new CallParseNode(pos, receiverValue.get(pos), node.getVariableName(), null, null);
        CallParseNode operation = new CallParseNode(pos, readMethod, node.getOperatorName(), BodyTranslator.buildArrayNode(pos, node.getValueNode(), new ParseNode[0]), null);
        CallParseNode writeMethod = new CallParseNode(pos, receiverValue.get(pos), node.getVariableName() + "=", BodyTranslator.buildArrayNode(pos, operation, new ParseNode[0]), null);
        RubyNode body = ((ParseNode)writeMethod).accept(this);
        SourceIndexLength sourceSection = pos;
        if (node.isLazy()) {
            body = IfNodeGen.create(NotNodeGen.create(new IsNilNode(receiverValue.get(sourceSection).accept(this))), body);
            body.unsafeSetSourceSection(sourceSection);
        }
        RubyNode ret = receiverValue.prepareAndThen(sourceSection, body);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpAsgnOrNode(OpAsgnOrParseNode node) {
        RubyNode lhs = node.getFirstNode().accept(this);
        RubyNode rhs = node.getSecondNode().accept(this);
        if (node.getFirstNode().needsDefinitionCheck()) {
            DefinedNode defined = new DefinedNode(lhs);
            lhs = AndNodeGen.create(defined, lhs);
        }
        return this.translateOpAsgOrNode(node, lhs, rhs);
    }

    private RubyNode translateOpAsgOrNode(ParseNode node, RubyNode lhs, RubyNode rhs) {
        SourceIndexLength sourceSection = node.getPosition();
        OrLazyValueDefinedNode ret = OrLazyValueDefinedNodeGen.create(lhs, rhs);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpElementAsgnNode(OpElementAsgnParseNode node) {
        boolean logicalOperation;
        String tempName = this.environment.allocateLocalTemp("opelementassign");
        this.environment.declareVar(tempName);
        ParseNode value = node.getValueNode();
        LocalVarParseNode readReceiverFromTemp = new LocalVarParseNode(node.getPosition(), 0, tempName);
        LocalAsgnParseNode writeReceiverToTemp = new LocalAsgnParseNode(node.getPosition(), tempName, 0, node.getReceiverNode());
        ArrayList<ValueFromNode> argValues = this.argsToTemp(node);
        String op = node.getOperatorName();
        boolean bl = logicalOperation = op.equals("&&") || op.equals("||");
        if (logicalOperation) {
            ParseNode write = this.write(node, readReceiverFromTemp, argValues, value);
            ParseNode operation = this.operation(node, readReceiverFromTemp, argValues, op, write);
            return this.block(node, writeReceiverToTemp, argValues, operation);
        }
        ParseNode operation = this.operation(node, readReceiverFromTemp, argValues, op, value);
        ParseNode write = this.write(node, readReceiverFromTemp, argValues, operation);
        return this.block(node, writeReceiverToTemp, argValues, write);
    }

    private RubyNode block(OpElementAsgnParseNode node, ParseNode writeReceiverToTemp, ArrayList<ValueFromNode> argValues, ParseNode main) {
        BlockParseNode block = new BlockParseNode(node.getPosition());
        block.add(writeReceiverToTemp);
        block.add(main);
        RubyNode ret = block.accept(this);
        ListIterator<ValueFromNode> listIterator = argValues.listIterator(argValues.size());
        while (listIterator.hasPrevious()) {
            ret = listIterator.previous().prepareAndThen(node.getPosition(), ret);
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    private ParseNode write(OpElementAsgnParseNode node, ParseNode readReceiverFromTemp, ArrayList<ValueFromNode> argValues, ParseNode value) {
        ParseNode writeArguments;
        if (node.getArgsNode() instanceof ArrayParseNode) {
            ArrayParseNode readArgsCopy = new ArrayParseNode(node.getPosition());
            for (ValueFromNode arg : argValues) {
                readArgsCopy.add(arg.get(node.getPosition()));
            }
            readArgsCopy.add(value);
            writeArguments = readArgsCopy;
        } else {
            writeArguments = new ArgsPushParseNode(node.getPosition(), argValues.get(0).get(node.getPosition()), value);
        }
        return new AttrAssignParseNode(node.getPosition(), readReceiverFromTemp, "[]=", writeArguments, false);
    }

    private ArrayList<ValueFromNode> argsToTemp(OpElementAsgnParseNode node) {
        ArrayList<ValueFromNode> argValues = new ArrayList<ValueFromNode>();
        ParseNode readArguments = node.getArgsNode();
        if (readArguments instanceof ArrayParseNode) {
            for (ParseNode child : ((ArrayParseNode)readArguments).children()) {
                argValues.add(ValueFromNode.valueFromNode(this, child));
            }
        } else {
            argValues.add(ValueFromNode.valueFromNode(this, readArguments));
        }
        return argValues;
    }

    private ParseNode operation(OpElementAsgnParseNode node, ParseNode readReceiverFromTemp, ArrayList<ValueFromNode> argValues, String op, ParseNode right) {
        ParseNode readArguments;
        if (node.getArgsNode() instanceof ArrayParseNode) {
            ArrayParseNode readArgsArray = new ArrayParseNode(node.getPosition());
            for (ValueFromNode arg : argValues) {
                readArgsArray.add(arg.get(node.getPosition()));
            }
            readArguments = readArgsArray;
        } else {
            readArguments = argValues.get(0).get(node.getPosition());
        }
        CallParseNode read = new CallParseNode(node.getPosition(), readReceiverFromTemp, "[]", readArguments, null);
        ParseNode operation = switch (op) {
            case "||" -> new OrParseNode(node.getPosition(), read, right);
            case "&&" -> new AndParseNode(node.getPosition(), read, right);
            default -> new CallParseNode(node.getPosition(), read, node.getOperatorName(), BodyTranslator.buildArrayNode(node.getPosition(), right, new ParseNode[0]), null);
        };
        this.copyNewline(node, operation);
        return operation;
    }

    private static ArrayParseNode buildArrayNode(SourceIndexLength sourcePosition, ParseNode first, ParseNode ... rest) {
        if (first == null) {
            return new ArrayParseNode(sourcePosition);
        }
        ArrayParseNode array = new ArrayParseNode(sourcePosition, first);
        for (ParseNode node : rest) {
            array.add(node);
        }
        return array;
    }

    @Override
    public RubyNode visitOrNode(OrParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode x = this.translateNodeOrNil(sourceSection, node.getFirstNode());
        RubyNode y = this.translateNodeOrNil(sourceSection, node.getSecondNode());
        OrNode ret = OrNodeGen.create(x, y);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitPreExeNode(PreExeParseNode node) {
        RubyNode ret = node.getBodyNode().accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitPostExeNode(PostExeParseNode node) {
        StaticScope scope = new StaticScope(StaticScope.Type.BLOCK, null);
        SourceIndexLength position = node.getPosition();
        return new OnceNode(this.translateCallNode(new CallParseNode(position, new TruffleFragmentParseNode(position, new TruffleKernelOperationsModuleLiteralNode()), "at_exit", new ArrayParseNode(position, new FalseParseNode(position)), new IterParseNode(position, (ParseNode)node.getArgsNode(), scope, node.getBodyNode())), false, false, false));
    }

    @Override
    public RubyNode visitRationalNode(RationalParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        long numerator = node.getNumerator();
        RubyNode numeratorNode = BodyTranslator.integerOrLongLiteralNode(numerator);
        long denominator = node.getDenominator();
        RubyNode denominatorNode = BodyTranslator.integerOrLongLiteralNode(denominator);
        RubyNode ret = this.translateRationalComplex(sourceSection, "Rational", numeratorNode, denominatorNode);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitBigRationalNode(BigRationalParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode ret = this.translateRationalComplex(sourceSection, "Rational", this.bignumOrFixnumNode(node.getNumerator()), this.bignumOrFixnumNode(node.getDenominator()));
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode translateRationalComplex(SourceIndexLength sourceSection, String name, RubyNode a, RubyNode b) {
        ObjectClassLiteralNode moduleNode = new ObjectClassLiteralNode();
        ReadConstantNode receiver = new ReadConstantNode(moduleNode, name);
        RubyNode[] arguments = new RubyNode[]{a, b};
        RubyContextSourceNode callNode = this.createCallNode(receiver, "convert", arguments);
        return BodyTranslator.withSourceSection(sourceSection, callNode);
    }

    @Override
    public RubyNode visitRedoNode(RedoParseNode node) {
        if (!this.environment.isBlock() && !this.translatingWhile) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("Invalid redo", this.currentNode, node.getPosition().toSourceSection(this.source)));
        }
        RedoNode ret = new RedoNode();
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitRegexpNode(RegexpParseNode node) {
        TStringWithEncoding source = node.getValue();
        RegexpOptions options = node.getOptions().setLiteral(true);
        try {
            RubyRegexp regexp = RubyRegexp.create(this.language, source.tstring, source.encoding, options, this.currentNode);
            ObjectLiteralNode literalNode = new ObjectLiteralNode(regexp);
            literalNode.unsafeSetSourceSection(node.getPosition());
            return this.addNewlineIfNeeded(node, literalNode);
        }
        catch (DeferredRaiseException dre) {
            throw dre.getException(RubyLanguage.getCurrentContext());
        }
    }

    @Override
    public RubyNode visitRescueNode(RescueParseNode node) {
        RubyNode tryPart = this.translateNodeOrNil(node.getPosition(), node.getBodyNode());
        ArrayList<RescueNode> rescueNodes = new ArrayList<RescueNode>();
        RescueBodyParseNode rescueClause = node.getRescueNode();
        boolean canOmitBacktrace = false;
        if (this.language.options.BACKTRACES_OMIT_UNUSED && rescueClause != null && rescueClause.getBodyNode() instanceof SideEffectFree && rescueClause.getOptRescueNode() == null) {
            canOmitBacktrace = true;
        }
        while (rescueClause != null) {
            if (rescueClause.getExceptionNodes() != null) {
                ArrayDeque<ParseNode> exceptionNodes = new ArrayDeque<ParseNode>();
                exceptionNodes.push(rescueClause.getExceptionNodes());
                while (!exceptionNodes.isEmpty()) {
                    RescueNode rescueNode;
                    ParseNode exceptionNode = (ParseNode)exceptionNodes.pop();
                    if (exceptionNode instanceof ArrayParseNode) {
                        rescueNode = this.translateRescueArrayParseNode((ArrayParseNode)exceptionNode, rescueClause);
                        rescueNodes.add(rescueNode);
                        continue;
                    }
                    if (exceptionNode instanceof SplatParseNode) {
                        rescueNode = this.translateRescueSplatParseNode((SplatParseNode)exceptionNode, rescueClause);
                        rescueNodes.add(rescueNode);
                        continue;
                    }
                    if (exceptionNode instanceof ArgsCatParseNode) {
                        ArgsCatParseNode argsCat = (ArgsCatParseNode)exceptionNode;
                        exceptionNodes.push(new SplatParseNode(argsCat.getSecondNode().getPosition(), argsCat.getSecondNode()));
                        exceptionNodes.push(argsCat.getFirstNode());
                        continue;
                    }
                    if (exceptionNode instanceof ArgsPushParseNode) {
                        ArgsPushParseNode argsPush = (ArgsPushParseNode)exceptionNode;
                        exceptionNodes.push(new ArrayParseNode(argsPush.getSecondNode().getPosition(), argsPush.getSecondNode()));
                        exceptionNodes.push(argsPush.getFirstNode());
                        continue;
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
            } else {
                RubyNode bodyNode = this.translateNodeOrNil(rescueClause.getPosition(), rescueClause.getBodyNode());
                RescueStandardErrorNode rescueNode = BodyTranslator.withSourceSection(rescueClause.getPosition(), new RescueStandardErrorNode(bodyNode));
                rescueNodes.add(rescueNode);
            }
            rescueClause = rescueClause.getOptRescueNode();
        }
        RubyNode elsePart = node.getElseNode() == null ? null : node.getElseNode().accept(this);
        TryNode ret = TryNodeGen.create(tryPart, rescueNodes.toArray(EMPTY_RESCUE_NODE_ARRAY), elsePart, canOmitBacktrace);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    private RescueNode translateRescueArrayParseNode(ArrayParseNode arrayParse, RescueBodyParseNode rescueClause) {
        ParseNode[] exceptionNodes = arrayParse.children();
        RubyNode[] handlingClasses = BodyTranslator.createArray(exceptionNodes.length);
        for (int n = 0; n < handlingClasses.length; ++n) {
            handlingClasses[n] = exceptionNodes[n].accept(this);
        }
        RubyNode translatedBody = this.translateNodeOrNil(rescueClause.getPosition(), rescueClause.getBodyNode());
        return BodyTranslator.withSourceSection(arrayParse.getPosition(), new RescueClassesNode(handlingClasses, translatedBody));
    }

    private RescueNode translateRescueSplatParseNode(SplatParseNode splat, RescueBodyParseNode rescueClause) {
        RubyNode splatTranslated = this.translateNodeOrNil(rescueClause.getPosition(), splat.getValue());
        RubyNode translatedBody = this.translateNodeOrNil(rescueClause.getPosition(), rescueClause.getBodyNode());
        return BodyTranslator.withSourceSection(splat.getPosition(), new RescueSplatNode(this.language, splatTranslated, translatedBody));
    }

    @Override
    public RubyNode visitRetryNode(RetryParseNode node) {
        RetryNode ret = new RetryNode();
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitReturnNode(ReturnParseNode node) {
        ReturnID returnID;
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode translatedChild = this.translateNodeOrNil(sourceSection, node.getValueNode());
        RubyContextSourceNode ret = this.environment.isBlock() ? ((returnID = this.environment.getReturnID()) == ReturnID.MODULE_BODY ? new InvalidReturnNode(translatedChild) : new DynamicReturnNode(returnID, translatedChild)) : new LocalReturnNode(translatedChild);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    private boolean shouldUseDynamicConstantLookupForModuleBody(SourceIndexLength sourceSection) {
        if (this.environment.isDynamicConstantLookup()) {
            return true;
        }
        if (this.environment.isModuleBody()) {
            return false;
        }
        if (this.environment.isTopLevelScope()) {
            return false;
        }
        if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
            RubyLanguage.LOGGER.info(() -> "start dynamic constant lookup at " + RubyLanguage.getCurrentContext().fileLine(sourceSection.toSourceSection(this.source)));
        }
        return true;
    }

    @Override
    public RubyNode visitSClassNode(SClassParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode receiverNode = node.getReceiverNode().accept(this);
        SingletonClassNode.SingletonClassASTNode singletonClassNode = SingletonClassNodeGen.SingletonClassASTNodeGen.create(receiverNode);
        singletonClassNode.unsafeSetSourceSection(sourceSection);
        boolean dynamicConstantLookup = this.environment.isDynamicConstantLookup();
        String modulePath = "<singleton class>";
        if (!dynamicConstantLookup) {
            if (this.environment.isModuleBody() && node.getReceiverNode() instanceof SelfParseNode) {
                modulePath = this.environment.isTopLevelObjectScope() ? "main::<singleton class>" : TranslatorEnvironment.composeModulePath(this.environment.modulePath, "<singleton class>");
            } else if (!this.environment.isTopLevelScope()) {
                dynamicConstantLookup = true;
                if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                    RubyLanguage.LOGGER.info(() -> "start dynamic constant lookup at " + RubyLanguage.getCurrentContext().fileLine(sourceSection.toSourceSection(this.source)));
                }
            }
        }
        RubyNode ret = this.openModule(sourceSection, singletonClassNode, modulePath, node.getBodyNode(), OpenModule.SINGLETON_CLASS, dynamicConstantLookup);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSValueNode(SValueParseNode node) {
        RubyNode ret = node.getValue().accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSelfNode(SelfParseNode node) {
        SelfNode ret = new SelfNode();
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSplatNode(SplatParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode value = this.translateNodeOrNil(sourceSection, node.getValue());
        SplatCastNode ret = SplatCastNodeGen.create(this.language, SplatCastNode.NilBehavior.CONVERT, false, value);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitStrNode(StrParseNode node) {
        RubyContextSourceNode ret;
        if (node.isFrozen()) {
            ImmutableRubyString frozenString = this.language.getFrozenStringLiteral(node.getValue(), node.encoding);
            ret = new FrozenStringLiteralNode(frozenString, FrozenStrings.EXPRESSION);
        } else {
            TruffleString cachedTString = this.language.tstringCache.getTString(node.getValue(), node.encoding);
            ret = new StringLiteralNode(cachedTString, node.encoding);
        }
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSymbolNode(SymbolParseNode node) {
        RubyEncoding encoding = Encodings.getBuiltInEncoding(node.getEncoding());
        ObjectLiteralNode ret = new ObjectLiteralNode(this.language.getSymbol((AbstractTruffleString)node.getTString(), encoding));
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitTrueNode(TrueParseNode node) {
        BooleanLiteralNode ret = new BooleanLiteralNode(true);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitUndefNode(UndefParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode name = this.translateNameNode(node.getName());
        ModuleNodes.UndefNode ret = new ModuleNodes.UndefNode(new RubyNode[]{name});
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitUntilNode(UntilParseNode node) {
        WhileParseNode whileNode = new WhileParseNode(node.getPosition(), node.getConditionNode(), node.getBodyNode(), node.evaluateAtStart());
        this.copyNewline(node, whileNode);
        RubyNode ret = this.translateWhileNode(whileNode, true);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitVCallNode(VCallParseNode node) {
        if (this.environment.getParseEnvironment().inCore() && node.getName().equals("undefined")) {
            ObjectLiteralNode ret = new ObjectLiteralNode(NotProvided.INSTANCE);
            ret.unsafeSetSourceSection(node.getPosition());
            return this.addNewlineIfNeeded(node, ret);
        }
        SelfParseNode receiver = new SelfParseNode(node.getPosition());
        CallParseNode callNode = new CallParseNode(node.getPosition(), receiver, node.getName(), null, null);
        this.copyNewline(node, callNode);
        RubyNode ret = this.translateCallNode(callNode, true, true, false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitWhileNode(WhileParseNode node) {
        RubyNode ret = this.translateWhileNode(node, false);
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateWhileNode(WhileParseNode node, boolean conditionInversed) {
        RubyNode body;
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode condition = node.getConditionNode().accept(this);
        if (conditionInversed) {
            condition = NotNodeGen.create(condition);
        }
        BreakID whileBreakID = this.environment.getParseEnvironment().allocateBreakID();
        boolean oldTranslatingWhile = this.translatingWhile;
        this.translatingWhile = true;
        BreakID oldBreakID = this.environment.getBreakID();
        this.environment.setBreakIDForWhile(whileBreakID);
        this.frameOnStackMarkerSlotStack.push(-1);
        try {
            body = this.translateNodeOrNil(sourceSection, node.getBodyNode());
        }
        finally {
            this.frameOnStackMarkerSlotStack.pop();
            this.environment.setBreakIDForWhile(oldBreakID);
            this.translatingWhile = oldTranslatingWhile;
        }
        WhileNode loop = node.evaluateAtStart() ? new WhileNode(WhileNodeFactory.WhileRepeatingNodeGen.create(condition, body)) : new WhileNode(WhileNodeFactory.DoWhileRepeatingNodeGen.create(condition, body));
        CatchBreakNode ret = new CatchBreakNode(whileBreakID, loop, true);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitXStrNode(XStrParseNode node) {
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), new StrParseNode(node.getPosition(), node.getValue(), node.encoding), new ParseNode[0]);
        FCallParseNode callNode = new FCallParseNode(node.getPosition(), "`", argsNode, null);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitYieldNode(YieldParseNode node) {
        if (this.isInvalidYield()) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("Invalid yield", this.currentNode, node.getPosition().toSourceSection(this.source)));
        }
        ParseNode argsNode = node.getArgsNode();
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(node.getPosition(), null, argsNode, "<yield>");
        RubyNode[] argumentsTranslated = argumentsAndBlock.getArguments();
        RubyNode readBlock = this.environment.findLocalVarOrNilNode("%method_block_arg", node.getPosition());
        YieldExpressionNode ret = new YieldExpressionNode(argumentsAndBlock.isSplatted(), argumentsAndBlock.getArgumentsDescriptor(), argumentsTranslated, readBlock);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    private boolean isInvalidYield() {
        return this.environment.getSurroundingMethodEnvironment().isModuleBody();
    }

    @Override
    public RubyNode visitZArrayNode(ZArrayParseNode node) {
        ArrayLiteralNode ret = ArrayLiteralNode.create(this.language, RubyNode.EMPTY_ARRAY);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitBackRefNode(BackRefParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ReadGlobalVariableNode readGlobal = ReadGlobalVariableNodeGen.create("$" + node.getType());
        readGlobal.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, readGlobal);
    }

    @Override
    public RubyNode visitStarNode(StarParseNode star) {
        return this.nilNode(star.getPosition());
    }

    protected static RubyNode initFlipFlopStates(TranslatorEnvironment environment, SourceIndexLength sourceSection) {
        RubyNode[] initNodes = BodyTranslator.createArray(environment.getFlipFlopStates().size());
        for (int n = 0; n < initNodes.length; ++n) {
            initNodes[n] = new InitFlipFlopSlotNode(environment.getFlipFlopStates().get(n));
        }
        return BodyTranslator.sequence(sourceSection, Arrays.asList(initNodes));
    }

    @Override
    protected RubyNode defaultVisit(ParseNode node) {
        throw new UnsupportedOperationException(node.toString() + " " + node.getPosition());
    }

    public TranslatorEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public RubyNode visitTruffleFragmentNode(TruffleFragmentParseNode node) {
        return this.addNewlineIfNeeded(node, node.getFragment());
    }

    @Override
    public RubyNode visitOther(ParseNode node) {
        throw new UnsupportedOperationException();
    }

    private void copyNewline(ParseNode from, ParseNode to) {
        if (from.isNewline()) {
            to.setNewline();
        }
    }

    private static ArgumentsDescriptor getKeywordArgumentsDescriptor(RubyLanguage language, ParseNode argsNode) {
        ParseNode lastNode = BodyTranslator.findLastNode(argsNode);
        HashParseNode keywordHashArgumentNode = null;
        if (lastNode instanceof HashParseNode) {
            keywordHashArgumentNode = (HashParseNode)lastNode;
        }
        if (keywordHashArgumentNode == null || !keywordHashArgumentNode.isKeywordArguments()) {
            return EmptyArgumentsDescriptor.INSTANCE;
        }
        ArrayList<String> keywords = new ArrayList<String>();
        boolean splat = false;
        boolean nonKeywordKeys = false;
        for (ParseNodeTuple pair : keywordHashArgumentNode.getPairs()) {
            ParseNode key = pair.getKey();
            ParseNode value = pair.getValue();
            if (key instanceof SymbolParseNode && ((SymbolParseNode)key).getName() != null) {
                keywords.add(((SymbolParseNode)key).getName());
                continue;
            }
            if (key == null && value != null) {
                splat = true;
                continue;
            }
            nonKeywordKeys = true;
        }
        if (splat || nonKeywordKeys || !keywords.isEmpty()) {
            return language.keywordArgumentsDescriptorManager.getArgumentsDescriptor(keywords.toArray(StringUtils.EMPTY_STRING_ARRAY));
        }
        return EmptyArgumentsDescriptor.INSTANCE;
    }

    private static ParseNode findLastNode(ParseNode argsNode) {
        if (argsNode instanceof ArrayParseNode) {
            return ((ArrayParseNode)argsNode).getLast();
        }
        return BodyTranslator.findLastNodeRecursive(argsNode);
    }

    private static ParseNode findLastNodeRecursive(ParseNode node) {
        if (node instanceof ArgsPushParseNode) {
            return BodyTranslator.findLastNodeRecursive(((ArgsPushParseNode)node).getSecondNode());
        }
        if (node instanceof ArgsCatParseNode) {
            ParseNode rhs = ((ArgsCatParseNode)node).getSecondNode();
            if (rhs instanceof ArrayParseNode && !((ArrayParseNode)rhs).isEmpty()) {
                return BodyTranslator.findLastNodeRecursive(((ArrayParseNode)rhs).getLast());
            }
            return node;
        }
        return node;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.environment.getSharedMethodInfo();
    }

    protected static final class ArgumentsAndBlockTranslation {
        private final RubyNode block;
        private final RubyNode[] arguments;
        private final ArgumentsDescriptor argumentsDescriptor;
        private final boolean isSplatted;
        private final int frameOnStackMarkerSlot;

        public ArgumentsAndBlockTranslation(RubyNode block, RubyNode[] arguments, boolean isSplatted, ArgumentsDescriptor argumentsDescriptor, int frameOnStackMarkerSlot) {
            this.block = block;
            this.arguments = arguments;
            this.argumentsDescriptor = argumentsDescriptor;
            this.isSplatted = isSplatted;
            this.frameOnStackMarkerSlot = frameOnStackMarkerSlot;
        }

        public RubyNode getBlock() {
            return this.block;
        }

        public RubyNode[] getArguments() {
            return this.arguments;
        }

        public boolean isSplatted() {
            return this.isSplatted;
        }

        public int getFrameOnStackMarkerSlot() {
            return this.frameOnStackMarkerSlot;
        }

        public ArgumentsDescriptor getArgumentsDescriptor() {
            return this.argumentsDescriptor;
        }
    }
}

