/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.DummyNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.Translator;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.ast.ParseNode;

public abstract class BaseTranslator
extends Translator {
    protected final TranslatorEnvironment environment;

    public BaseTranslator(RubyLanguage language, Source source, ParserContext parserContext, Node currentNode, TranslatorEnvironment environment) {
        super(language, source, parserContext, currentNode);
        this.environment = environment;
    }

    protected RubyNode addNewlineIfNeeded(ParseNode jrubyNode, RubyNode node) {
        if (jrubyNode.isNewline()) {
            TruffleSafepoint.poll((Node)DummyNode.INSTANCE);
            SourceIndexLength current = node.getEncapsulatingSourceIndexLength();
            if (current == null) {
                return node;
            }
            if (this.environment.getParseEnvironment().isCoverageEnabled()) {
                node.unsafeSetIsCoverageLine();
                this.language.coverageManager.setLineHasCode(this.source, current.toSourceSection(this.source).getStartLine());
            }
            node.unsafeSetIsNewLine();
        }
        return node;
    }
}

