/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.threadlocal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.language.Nil;

public final class ThreadAndFrameLocalStorage {
    private final long originalThreadId;
    private Object originalThreadValue;
    private volatile ThreadLocal<Object> otherThreadValues = null;

    public ThreadAndFrameLocalStorage(RubyContext context) {
        this.originalThreadId = context.isPreInitializing() ? 0L : RubyLanguage.getThreadId(Thread.currentThread());
        this.originalThreadValue = Nil.INSTANCE;
    }

    public Object get(Node node, InlinedConditionProfile sameThreadProfile) {
        if (sameThreadProfile.profile(node, RubyLanguage.getThreadId(Thread.currentThread()) == this.originalThreadId)) {
            return this.originalThreadValue;
        }
        return this.fallbackGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private ThreadLocal<Object> getOtherThreadValues() {
        if (this.otherThreadValues != null) {
            return this.otherThreadValues;
        }
        ThreadAndFrameLocalStorage threadAndFrameLocalStorage = this;
        synchronized (threadAndFrameLocalStorage) {
            if (this.otherThreadValues != null) {
                return this.otherThreadValues;
            }
            this.otherThreadValues = ThreadLocal.withInitial(() -> Nil.INSTANCE);
            return this.otherThreadValues;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private Object fallbackGet() {
        return this.getOtherThreadValues().get();
    }

    public void set(Node node, Object value, InlinedConditionProfile sameThreadProfile) {
        if (sameThreadProfile.profile(node, RubyLanguage.getThreadId(Thread.currentThread()) == this.originalThreadId)) {
            this.originalThreadValue = value;
        } else {
            this.fallbackSet(value);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void fallbackSet(Object value) {
        this.getOtherThreadValues().set(value);
    }
}

