/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.supercall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.EmptyArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptorManager;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.dispatch.LiteralCallNode;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.supercall.CallSuperMethodNode;
import org.truffleruby.language.supercall.LookupSuperMethodNode;
import org.truffleruby.language.supercall.LookupSuperMethodNodeGen;

public final class SuperCallNode
extends LiteralCallNode {
    @Node.Child
    private RubyNode arguments;
    @Node.Child
    private RubyNode block;
    @Node.Child
    private LookupSuperMethodNode lookupSuperMethodNode;
    @Node.Child
    private CallSuperMethodNode callSuperMethodNode;

    public SuperCallNode(boolean isSplatted, RubyNode arguments, RubyNode block, ArgumentsDescriptor descriptor) {
        super(isSplatted, descriptor);
        this.arguments = arguments;
        this.block = block;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        Object self = RubyArguments.getSelf((Frame)frame);
        Object[] superArguments = (Object[])this.arguments.execute(frame);
        ArgumentsDescriptor descriptor = this.descriptor;
        boolean ruby2KeywordsHash = false;
        if (this.isSplatted && (ruby2KeywordsHash = this.isRuby2KeywordsHash(superArguments, superArguments.length))) {
            descriptor = KeywordArgumentsDescriptorManager.EMPTY;
        }
        if (descriptor instanceof KeywordArgumentsDescriptor && this.emptyKeywordArguments(superArguments)) {
            superArguments = SuperCallNode.removeEmptyKeywordArguments(superArguments);
            descriptor = EmptyArgumentsDescriptor.INSTANCE;
        }
        Object blockObject = this.block.execute(frame);
        InternalMethod superMethod = this.executeLookupSuperMethod(frame, self);
        if (this.callSuperMethodNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callSuperMethodNode = (CallSuperMethodNode)this.insert(CallSuperMethodNode.create());
        }
        return this.callSuperMethodNode.execute(frame, self, superMethod, descriptor, superArguments, blockObject, ruby2KeywordsHash ? this : null);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        Object self = RubyArguments.getSelf((Frame)frame);
        InternalMethod superMethod = this.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            return nil;
        }
        return FrozenStrings.SUPER;
    }

    private InternalMethod executeLookupSuperMethod(VirtualFrame frame, Object self) {
        if (this.lookupSuperMethodNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupSuperMethodNode = (LookupSuperMethodNode)this.insert(LookupSuperMethodNodeGen.create());
        }
        return this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
    }

    @Override
    public RubyNode cloneUninitialized() {
        SuperCallNode copy = new SuperCallNode(this.isSplatted, this.arguments.cloneUninitialized(), this.block.cloneUninitialized(), this.descriptor);
        return copy.copyFlags(this);
    }
}

