/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.supercall;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.kernel.TruffleKernelNodes;
import org.truffleruby.language.SpecialVariablesSendingNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.LiteralCallNode;
import org.truffleruby.language.methods.CallInternalMethodNode;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;

public final class CallSuperMethodNode
extends SpecialVariablesSendingNode {
    private final ConditionProfile missingProfile = ConditionProfile.create();
    @Node.Child
    private CallInternalMethodNode callMethodNode;
    @Node.Child
    private DispatchNode callMethodMissingNode;
    @Node.Child
    private TruffleKernelNodes.GetSpecialVariableStorage readingNode;
    @CompilerDirectives.CompilationFinal
    private Assumption specialVariableAssumption;

    public static CallSuperMethodNode create() {
        return new CallSuperMethodNode();
    }

    private CallSuperMethodNode() {
    }

    public Object execute(VirtualFrame frame, Object self, InternalMethod superMethod, ArgumentsDescriptor descriptor, Object[] arguments, Object block, LiteralCallNode literalCallNode) {
        if (this.missingProfile.profile(superMethod == null)) {
            String name = RubyArguments.getMethod((Frame)frame).getSharedMethodInfo().getMethodNameForNotBlock();
            Object[] methodMissingArguments = ArrayUtils.unshift(arguments, this.getSymbol(name));
            return this.callMethodMissing(self, block, descriptor, methodMissingArguments, literalCallNode);
        }
        SpecialVariableStorage callerSpecialVariables = null;
        if (!this.getSpecialVariableStorageAssumption((Frame)frame).isValid()) {
            callerSpecialVariables = this.getReadingNode().executeCached((Frame)frame);
        }
        Object[] rubyArgs = RubyArguments.pack(null, callerSpecialVariables, superMethod, null, self, block, descriptor, arguments);
        return this.getCallMethodNode().execute((Frame)frame, superMethod, self, rubyArgs, literalCallNode);
    }

    private CallInternalMethodNode getCallMethodNode() {
        if (this.callMethodNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callMethodNode = (CallInternalMethodNode)this.insert(CallInternalMethodNode.create());
        }
        return this.callMethodNode;
    }

    private TruffleKernelNodes.GetSpecialVariableStorage getReadingNode() {
        if (this.readingNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readingNode = (TruffleKernelNodes.GetSpecialVariableStorage)this.insert(TruffleKernelNodes.GetSpecialVariableStorage.create());
        }
        return this.readingNode;
    }

    private Assumption getSpecialVariableStorageAssumption(Frame frame) {
        if (this.specialVariableAssumption == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.specialVariableAssumption = this.getSpecialVariableAssumption(frame);
        }
        return this.specialVariableAssumption;
    }

    private Object callMethodMissing(Object receiver, Object block, ArgumentsDescriptor descriptor, Object[] arguments, LiteralCallNode literalCallNode) {
        if (this.callMethodMissingNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callMethodMissingNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        return this.callMethodMissingNode.callWithDescriptor(receiver, "method_missing", block, descriptor, arguments, literalCallNode);
    }
}

