/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.shared;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import java.util.ArrayList;
import org.truffleruby.core.DataObjectFinalizerReference;
import org.truffleruby.core.FinalizerReference;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ShapeCachingGuards;
import org.truffleruby.language.objects.shared.ShareObjectNode;
import org.truffleruby.language.objects.shared.SharedObjects;

@ImportStatic(value={ShapeCachingGuards.class})
@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class WriteBarrierNode
extends RubyBaseNode {
    public static final WriteBarrierNode[] EMPTY_ARRAY = new WriteBarrierNode[0];
    protected static final int MAX_DEPTH = 3;

    protected final void execute(Node node, Object value, int depth) {
        CompilerAsserts.partialEvaluationConstant((int)depth);
        this.executeInternal(node, value, depth);
    }

    public final void execute(Node node, Object value) {
        this.execute(node, value, 0);
    }

    public final void executeCached(Object value, int depth) {
        this.execute(this, value, depth);
    }

    protected abstract void executeInternal(Node var1, Object var2, int var3);

    @Specialization(guards={"!isRubyDynamicObject(value)", "!isFinalizer(value)"})
    static void noWriteBarrier(Node node, Object value, int depth) {
    }

    @Specialization(guards={"value.getShape() == cachedShape", "cachedShape.isShared()"}, limit="1")
    static void alreadySharedCached(RubyDynamicObject value, int depth, @Cached(value="value.getShape()") Shape cachedShape) {
    }

    @Specialization(guards={"value.getShape().isShared()"}, replaces={"alreadySharedCached"})
    static void alreadySharedUncached(RubyDynamicObject value, int depth) {
    }

    @Specialization(guards={"depth < MAX_DEPTH", "value.getShape() == cachedShape", "!cachedShape.isShared()"}, assumptions={"cachedShape.getValidAssumption()"}, limit="1")
    static void writeBarrierCached(Node node, RubyDynamicObject value, int depth, @Cached(value="value.getShape()") Shape cachedShape, @Cached(inline=false) ShareObjectNode shareObjectNode) {
        shareObjectNode.executeCached(value, depth + 1);
    }

    @Specialization(guards={"updateShape(value)"})
    static void updateShapeAndWriteBarrier(RubyDynamicObject value, int depth, @Cached(inline=false) WriteBarrierNode writeBarrierNode) {
        writeBarrierNode.executeCached((Object)value, depth);
    }

    @Specialization(guards={"!value.getShape().isShared()"}, replaces={"writeBarrierCached", "updateShapeAndWriteBarrier"})
    static void writeBarrierUncached(Node node, RubyDynamicObject value, int depth) {
        SharedObjects.writeBarrier(WriteBarrierNode.getLanguage(node), (Object)value);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    static void writeBarrierFinalizer(Node node, FinalizerReference ref, int depth) {
        ArrayList<Object> roots = new ArrayList<Object>();
        ref.collectRoots(roots);
        for (Object root : roots) {
            SharedObjects.writeBarrier(WriteBarrierNode.getLanguage(node), root);
        }
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    static void writeBarrierDataFinalizer(Node node, DataObjectFinalizerReference ref, int depth) {
        SharedObjects.writeBarrier(WriteBarrierNode.getLanguage(node), ref.dataHolder);
    }

    protected static boolean isFinalizer(Object object) {
        return object instanceof FinalizerReference || object instanceof DataObjectFinalizerReference;
    }
}

