/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.shared;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ShapeCachingGuards;
import org.truffleruby.language.objects.shared.SharedObjects;

@ImportStatic(value={ShapeCachingGuards.class})
@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class IsSharedNode
extends RubyBaseNode {
    protected static final int CACHE_LIMIT = 8;

    public abstract boolean executeIsShared(Node var1, RubyDynamicObject var2);

    @Specialization(guards={"object.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="CACHE_LIMIT")
    static boolean isShareCached(RubyDynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="cachedShape.isShared()") boolean shared) {
        return shared;
    }

    @Specialization(guards={"updateShape(object)"})
    static boolean updateShapeAndIsShared(Node node, RubyDynamicObject object, @Cached(inline=false) IsSharedNode isSharedNode) {
        return isSharedNode.executeIsShared(node, object);
    }

    @Specialization(replaces={"isShareCached", "updateShapeAndIsShared"})
    static boolean isSharedUncached(Node node, RubyDynamicObject object) {
        return IsSharedNode.getLanguage((Node)node).options.SHARED_OBJECTS_ENABLED && SharedObjects.isShared(object);
    }
}

