/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.classvariables;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.objects.classvariables.ClassVariableStorage;

public abstract class LookupClassVariableStorageNode
extends RubyBaseNode {
    public abstract ClassVariableStorage execute(RubyModule var1, String var2);

    @Specialization(guards={"objectLibrary.containsKey(classVariableStorage, name)"})
    ClassVariableStorage lookupClassVariable(RubyModule module, String name, @Bind(value="module.fields.getClassVariables()") ClassVariableStorage classVariableStorage, @CachedLibrary(limit="getDynamicObjectCacheLimit()") DynamicObjectLibrary objectLibrary) {
        return classVariableStorage;
    }

    @Specialization(replaces={"lookupClassVariable"})
    @CompilerDirectives.TruffleBoundary
    ClassVariableStorage uncachedLookupClassVariable(RubyModule module, String name) {
        return ModuleOperations.classVariableLookup(module, true, m -> {
            ClassVariableStorage classVariables = m.fields.getClassVariables();
            if (classVariables.getShape().hasProperty((Object)name)) {
                return classVariables;
            }
            return null;
        });
    }
}

