/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.locals.ReadFrameSlotNode;
import org.truffleruby.language.objects.SelfNode;

public final class ReadInstanceVariableNode
extends RubyContextSourceNode {
    private final String name;
    @Node.Child
    private ReadFrameSlotNode readSelfSlotNode;
    @Node.Child
    private DynamicObjectLibrary objectLibrary;
    private final ConditionProfile objectProfile = ConditionProfile.create();

    public ReadInstanceVariableNode(String name) {
        this.name = name;
        this.readSelfSlotNode = SelfNode.createReadSelfFrameSlotNode();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object self = SelfNode.readSelf(frame, this.readSelfSlotNode);
        if (this.objectProfile.profile(self instanceof RubyDynamicObject)) {
            DynamicObjectLibrary objectLibrary = this.getObjectLibrary();
            RubyDynamicObject dynamicObject = (RubyDynamicObject)((Object)self);
            return objectLibrary.getOrDefault((DynamicObject)dynamicObject, (Object)this.name, (Object)nil);
        }
        return nil;
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        Object self = SelfNode.readSelf(frame, this.readSelfSlotNode);
        if (this.objectProfile.profile(self instanceof RubyDynamicObject)) {
            RubyDynamicObject dynamicObject;
            DynamicObjectLibrary objectLibrary = this.getObjectLibrary();
            if (objectLibrary.containsKey((DynamicObject)(dynamicObject = (RubyDynamicObject)((Object)self)), (Object)this.name)) {
                return FrozenStrings.INSTANCE_VARIABLE;
            }
            return nil;
        }
        return false;
    }

    private DynamicObjectLibrary getObjectLibrary() {
        if (this.objectLibrary == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.objectLibrary = (DynamicObjectLibrary)this.insert((Node)((DynamicObjectLibrary)DynamicObjectLibrary.getFactory().createDispatched(this.getLanguage().options.INSTANCE_VARIABLE_CACHE)));
        }
        return this.objectLibrary;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadInstanceVariableNode copy = new ReadInstanceVariableNode(this.name);
        return copy.copyFlags(this);
    }
}

