/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.ImmutableRubyObject;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.SafepointAction;
import org.truffleruby.language.SafepointPredicate;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.objects.ObjectGraphNode;

public abstract class ObjectGraph {
    public static Set<Object> newObjectSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    @CompilerDirectives.TruffleBoundary
    public static Set<Object> stopAndGetAllObjects(String reason, final RubyContext context, Node currentNode) {
        final Set<Object> visited = ObjectGraph.newObjectSet();
        final Thread initiatingJavaThread = Thread.currentThread();
        context.getSafepointManager().pauseAllThreadsAndExecute(currentNode, new SafepointAction(reason, SafepointPredicate.ALL_THREADS_AND_FIBERS, false, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RubyThread rubyThread, Node currentNode) {
                Set set = visited;
                synchronized (set) {
                    Set<Object> reachable = ObjectGraph.newObjectSet();
                    reachable.add(rubyThread);
                    reachable.add(rubyThread.getCurrentFiber());
                    if (Thread.currentThread() == initiatingJavaThread) {
                        ObjectGraph.visitContextRoots(context, reachable);
                    }
                    Truffle.getRuntime().iterateFrames(frameInstance -> {
                        Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                        ObjectGraph.getObjectsInFrame(frame, reachable);
                        return null;
                    });
                    ArrayDeque<Object> stack = new ArrayDeque<Object>(reachable);
                    while (!stack.isEmpty()) {
                        Object object = stack.pop();
                        if (!visited.add(object) || !(object instanceof RubyDynamicObject)) continue;
                        stack.addAll(ObjectGraph.getAdjacentObjects((RubyDynamicObject)((Object)object)));
                    }
                }
            }
        });
        return visited;
    }

    @CompilerDirectives.TruffleBoundary
    public static Set<Object> stopAndGetRootObjects(String reason, final RubyContext context, Node currentNode) {
        final Set<Object> visited = ObjectGraph.newObjectSet();
        final Thread initiatingJavaThread = Thread.currentThread();
        context.getSafepointManager().pauseAllThreadsAndExecute(currentNode, new SafepointAction(reason, SafepointPredicate.ALL_THREADS_AND_FIBERS, false, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RubyThread rubyThread, Node currentNode) {
                Set set = visited;
                synchronized (set) {
                    visited.add(rubyThread);
                    if (Thread.currentThread() == initiatingJavaThread) {
                        ObjectGraph.visitContextRoots(context, visited);
                    }
                }
            }
        });
        return visited;
    }

    public static void visitContextRoots(RubyContext context, Set<Object> roots) {
        RubyLanguage language = context.getLanguageSlow();
        roots.addAll(language.symbolTable.allSymbols());
        roots.addAll(language.frozenStringLiterals.allFrozenStrings());
        roots.addAll(context.getCoreLibrary().globalVariables.objectGraphValues());
        roots.addAll(context.getAtExitManager().getHandlers());
        context.getFinalizationService().collectRoots(roots);
    }

    public static boolean isRubyObject(Object value) {
        return value instanceof RubyDynamicObject || value instanceof ImmutableRubyObject;
    }

    public static Set<Object> getAdjacentObjects(RubyDynamicObject object) {
        Set<Object> reachable = ObjectGraph.newObjectSet();
        reachable.add(object.getLogicalClass());
        reachable.add(object.getMetaClass());
        if (object instanceof ObjectGraphNode) {
            ((ObjectGraphNode)((Object)object)).getAdjacentObjects(reachable);
        }
        for (Property property : object.getShape().getPropertyListInternal(false)) {
            Object value = DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)object, property.getKey(), null);
            ObjectGraph.addProperty(reachable, value);
        }
        return reachable;
    }

    public static void addProperty(Set<Object> reachable, Object value) {
        assert (!(value instanceof Frame)) : "Frame should be handled directly with ObjectGraphNode";
        assert (!(value instanceof Collection)) : "Collection should be handled directly with ObjectGraphNode";
        if (ObjectGraph.isRubyObject(value)) {
            reachable.add(value);
        } else if (value instanceof Object[]) {
            for (Object element : (Object[])value) {
                if (!ObjectGraph.isRubyObject(element)) continue;
                reachable.add(element);
            }
        } else if (value instanceof ObjectGraphNode) {
            ((ObjectGraphNode)value).getAdjacentObjects(reachable);
        }
    }

    public static void getObjectsInFrame(Frame frame, Set<Object> reachable) {
        RubyProc block;
        Object self;
        MaterializedFrame lexicalParentFrame = RubyArguments.tryGetDeclarationFrame(frame);
        if (lexicalParentFrame != null) {
            ObjectGraph.getObjectsInFrame((Frame)lexicalParentFrame, reachable);
        }
        if (ObjectGraph.isRubyObject(self = RubyArguments.tryGetSelf(frame))) {
            reachable.add(self);
        }
        if ((block = RubyArguments.tryGetBlock(frame)) != null) {
            reachable.add(block);
        }
        FrameDescriptor descriptor = frame.getFrameDescriptor();
        assert (descriptor.getNumberOfAuxiliarySlots() == 0);
        int slots = descriptor.getNumberOfSlots();
        for (int slot = 0; slot < slots; ++slot) {
            Object slotValue = frame.getValue(slot);
            if (!ObjectGraph.isRubyObject(slotValue)) continue;
            reachable.add(slotValue);
        }
    }
}

