/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ModuleNodes;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.DefineModuleNodeGen;
import org.truffleruby.language.objects.LookupForExistingModuleNode;

@NodeChild(value="lexicalParentModuleNode", type=RubyNode.class)
public abstract class DefineModuleNode
extends RubyContextSourceNode {
    private final String name;
    @Node.Child
    LookupForExistingModuleNode lookupForExistingModuleNode;
    private final ConditionProfile needToDefineProfile = ConditionProfile.create();
    private final BranchProfile errorProfile = BranchProfile.create();

    public DefineModuleNode(String name) {
        this.name = name;
    }

    @Specialization
    RubyModule defineModule(VirtualFrame frame, RubyModule lexicalParentModule) {
        RubyModule definingModule;
        Object existing = this.lookupForExistingModule(frame, this.name, lexicalParentModule);
        if (this.needToDefineProfile.profile(existing == null)) {
            definingModule = ModuleNodes.createModule(this.getContext(), this.getEncapsulatingSourceSection(), this.coreLibrary().moduleClass, lexicalParentModule, this.name, this);
        } else {
            if (!(existing instanceof RubyModule) || existing instanceof RubyClass) {
                this.errorProfile.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorIsNotA(this.name, "module", (Node)this));
            }
            definingModule = (RubyModule)existing;
        }
        return definingModule;
    }

    @Specialization(guards={"!isRubyModule(lexicalParentObject)"})
    RubyModule defineModuleWrongParent(VirtualFrame frame, Object lexicalParentObject) {
        throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorIsNotA(lexicalParentObject, "module", (Node)this));
    }

    private Object lookupForExistingModule(VirtualFrame frame, String name, RubyModule lexicalParent) {
        if (this.lookupForExistingModuleNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupForExistingModuleNode = (LookupForExistingModuleNode)this.insert(new LookupForExistingModuleNode());
        }
        return this.lookupForExistingModuleNode.lookupForExistingModule(frame, name, lexicalParent);
    }

    abstract RubyNode getLexicalParentModuleNode();

    @Override
    public RubyNode cloneUninitialized() {
        DefineModuleNode copy = DefineModuleNodeGen.create(this.name, this.getLexicalParentModuleNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

