/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.parser.IdentifierType;
import org.truffleruby.parser.Identifiers;

@ImportStatic(value={Identifiers.class})
public abstract class CheckIVarNameNode
extends RubyBaseNode {
    public abstract void execute(Object var1, String var2, Object var3);

    @Specialization
    void checkSymbol(Object object, String name, RubySymbol originalName, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
        if (originalName.getType() != IdentifierType.INSTANCE) {
            errorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), (RubyException)this.getContext().getCoreExceptions().nameErrorInstanceNameNotAllowable(name, object, this));
        }
    }

    @Specialization(guards={"name == cachedName", "isValidInstanceVariableName(cachedName)", "!isRubySymbol(originalName)"}, limit="getDynamicObjectCacheLimit()")
    void cached(Object object, String name, Object originalName, @Cached(value="name") String cachedName) {
    }

    @Specialization(replaces={"cached"}, guards={"!isRubySymbol(originalName)"})
    void uncached(Object object, String name, Object originalName, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
        if (!Identifiers.isValidInstanceVariableName(name)) {
            errorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorInstanceNameNotAllowable(name, object, this));
        }
    }
}

