/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.methods.DeclarationContext;

public abstract class UsingNode
extends AlwaysInlinedMethodNode {
    protected void using(Frame callerFrame, Object refinementModule, InlinedBranchProfile errorProfile) {
        if (refinementModule.getClass() != RubyModule.class) {
            errorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorWrongArgumentType(refinementModule, "Module", this));
        }
        RubyModule module = (RubyModule)refinementModule;
        DeclarationContext declarationContext = RubyArguments.getDeclarationContext(callerFrame);
        Map<RubyModule, RubyModule[]> newRefinements = UsingNode.usingModule(declarationContext, module);
        if (newRefinements != null) {
            DeclarationContext.setRefinements(callerFrame, declarationContext, newRefinements);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Map<RubyModule, RubyModule[]> usingModule(DeclarationContext declarationContext, RubyModule module) {
        HashMap<RubyModule, RubyModule[]> newRefinements = new HashMap<RubyModule, RubyModule[]>(declarationContext.getRefinements());
        ArrayDeque<RubyModule> reverseAncestors = new ArrayDeque<RubyModule>();
        for (RubyModule ancestor : module.fields.ancestors()) {
            reverseAncestors.addFirst(ancestor);
        }
        for (RubyModule ancestor : reverseAncestors) {
            ConcurrentMap<RubyModule, RubyModule> refinements = ancestor.fields.getRefinements();
            for (Map.Entry entry : refinements.entrySet()) {
                UsingNode.applyRefinements((RubyModule)entry.getKey(), (RubyModule)entry.getValue(), newRefinements);
            }
        }
        return newRefinements.isEmpty() ? null : newRefinements;
    }

    private static void applyRefinements(RubyModule refinedModule, RubyModule refinementModule, Map<RubyModule, RubyModule[]> newRefinements) {
        RubyModule[] refinements = newRefinements.get(refinedModule);
        if (refinements == null) {
            newRefinements.put(refinedModule, new RubyModule[]{refinementModule});
        } else if (!ArrayUtils.contains(refinements, refinementModule)) {
            newRefinements.put(refinedModule, UsingNode.unshift(refinements, refinementModule));
        }
    }

    private static RubyModule[] unshift(RubyModule[] array, RubyModule element) {
        RubyModule[] newArray = new RubyModule[1 + array.length];
        newArray[0] = element;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }
}

