/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.support.DetailedInspectingSupport;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.parser.ArgumentDescriptor;
import org.truffleruby.parser.OpenModule;
import org.truffleruby.parser.ParserContext;

public final class SharedMethodInfo
implements DetailedInspectingSupport {
    private final SourceSection sourceSection;
    private final LexicalScope staticLexicalScope;
    private final Arity arity;
    private final String originalName;
    private final String parseName;
    private final int blockDepth;
    private final String notes;
    private final ArgumentDescriptor[] argumentDescriptors;
    private String descriptiveNameAndSource;

    public SharedMethodInfo(SourceSection sourceSection, LexicalScope staticLexicalScope, Arity arity, String originalName, int blockDepth, String parseName, String notes, ArgumentDescriptor[] argumentDescriptors) {
        assert (blockDepth == 0 || originalName.startsWith("block ")) : originalName;
        this.sourceSection = sourceSection;
        this.staticLexicalScope = staticLexicalScope;
        this.arity = arity;
        this.originalName = originalName;
        this.blockDepth = blockDepth;
        this.parseName = parseName;
        this.notes = notes;
        this.argumentDescriptors = argumentDescriptors;
    }

    public SharedMethodInfo forDefineMethod(RubyModule declaringModule, String methodName, RubyProc proc) {
        return new SharedMethodInfo(this.sourceSection, this.staticLexicalScope, proc.arity, methodName, 0, SharedMethodInfo.moduleAndMethodName(declaringModule, methodName), null, proc.argumentDescriptors);
    }

    public SharedMethodInfo convertMethodMissingToMethod(RubyModule declaringModule, String methodName) {
        return new SharedMethodInfo(this.sourceSection, this.staticLexicalScope, this.arity.consumingFirstRequired(), methodName, this.blockDepth, SharedMethodInfo.moduleAndMethodName(declaringModule, methodName), this.notes, ArgumentDescriptor.ANY);
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public LexicalScope getStaticLexicalScope() {
        assert (this.staticLexicalScope != null);
        return this.staticLexicalScope;
    }

    public LexicalScope getStaticLexicalScopeOrNull() {
        return this.staticLexicalScope;
    }

    public Arity getArity() {
        return this.arity;
    }

    public ArgumentDescriptor[] getRawArgumentDescriptors() {
        return this.argumentDescriptors;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argumentDescriptors == null ? this.arity.toAnonymousArgumentDescriptors() : this.argumentDescriptors;
    }

    public boolean isBlock() {
        return this.blockDepth > 0;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isModuleBody() {
        boolean isModuleBody = SharedMethodInfo.isModuleBody(this.getOriginalName());
        assert (!isModuleBody || !this.isBlock()) : this;
        return isModuleBody;
    }

    public static boolean isModuleBody(String name) {
        if (name.startsWith("<")) {
            assert (name.equals(ParserContext.TOP_LEVEL_FIRST.getTopLevelName()) || name.equals(ParserContext.TOP_LEVEL.getTopLevelName()) || name.startsWith(OpenModule.MODULE.getPrefix()) || name.startsWith(OpenModule.CLASS.getPrefix()) || name.startsWith(OpenModule.SINGLETON_CLASS.getPrefix())) : name;
            return true;
        }
        return false;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getMethodName() {
        return this.blockDepth == 0 ? this.originalName : this.notes;
    }

    public String getMethodNameForNotBlock() {
        assert (this.blockDepth == 0);
        return this.originalName;
    }

    public String getParseName() {
        return this.parseName;
    }

    public static String moduleAndConstantName(RubyModule module, String constantName) {
        return module.fields.getName() + "::" + constantName;
    }

    public static String moduleAndMethodName(RubyModule module, String methodName) {
        assert (module != null && methodName != null);
        if (RubyGuards.isMetaClass(module)) {
            RubyDynamicObject attached = ((RubyClass)module).attached;
            return ((RubyModule)attached).getName() + "." + methodName;
        }
        return module.getName() + "#" + methodName;
    }

    public static String modulePathAndMethodName(String modulePath, String methodName, boolean onSingleton) {
        assert (modulePath != null && methodName != null);
        if (onSingleton) {
            return modulePath + "." + methodName;
        }
        return modulePath + "#" + methodName;
    }

    public static String getBlockName(int blockDepth, String methodName) {
        assert (blockDepth > 0);
        if (blockDepth > 1) {
            return "block (" + blockDepth + " levels) in " + methodName;
        }
        return "block in " + methodName;
    }

    public String getDescriptiveNameAndSource() {
        if (this.descriptiveNameAndSource == null) {
            Object descriptiveName = this.parseName;
            if (this.hasNotes()) {
                descriptiveName = ((String)descriptiveName).length() > 0 ? (String)descriptiveName + " (" + this.notes + ")" : (String)descriptiveName + this.notes;
            }
            this.descriptiveNameAndSource = !BacktraceFormatter.isAvailable(this.sourceSection) ? descriptiveName : (String)descriptiveName + " " + RubyLanguage.fileLineRange(this.sourceSection);
        }
        return this.descriptiveNameAndSource;
    }

    private boolean hasNotes() {
        return this.notes != null && this.blockDepth == 0;
    }

    public String getNotes() {
        assert (this.hasNotes());
        return this.notes;
    }

    public String toString() {
        return this.getDescriptiveNameAndSource();
    }

    @Override
    public String toStringWithDetails() {
        String string = Arrays.deepToString(this.argumentDescriptors);
        return StringUtils.format("SharedMethodInfo(sourceSection = %s, staticLexicalScope = %s, arity = %s, originName = %s, blockDepth = %s, parseName = %s, notes = %s, argumentDescriptors = %s)", this.sourceSection, this.staticLexicalScope, this.arity, this.originalName, this.blockDepth, this.parseName, this.notes, string);
    }
}

