/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.MethodLookupResult;
import org.truffleruby.core.module.ModuleFields;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.LookupMethodNodeGen;
import org.truffleruby.language.objects.MetaClassNode;

@ReportPolymorphism
@GenerateUncached
public abstract class LookupMethodNode
extends RubyBaseNode {
    @NeverDefault
    public static LookupMethodNode create() {
        return LookupMethodNodeGen.create();
    }

    public abstract InternalMethod execute(Frame var1, RubyClass var2, String var3, DispatchConfiguration var4);

    @Specialization(guards={"isSingleContext()", "metaClass == cachedMetaClass", "name == cachedName", "config == cachedConfig"}, assumptions={"methodLookupResult.getAssumptions()"}, limit="getCacheLimit()")
    InternalMethod lookupMethodCached(Frame frame, RubyClass metaClass, String name, DispatchConfiguration config, @Cached(value="metaClass") RubyClass cachedMetaClass, @Cached(value="name") String cachedName, @Cached(value="config") DispatchConfiguration cachedConfig, @Cached(value="lookupCached(getContext(), frame, cachedMetaClass, cachedName, config)") MethodLookupResult methodLookupResult) {
        return methodLookupResult.getMethod();
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"lookupMethodCached"})
    InternalMethod lookupMethodUncached(Frame frame, RubyClass metaClass, String name, DispatchConfiguration config, @Cached MetaClassNode metaClassNode, @Cached InlinedConditionProfile noCallerMethodProfile, @Cached InlinedConditionProfile noPrependedModulesProfile, @Cached InlinedConditionProfile onMetaClassProfile, @Cached InlinedConditionProfile hasRefinementsProfile, @Cached InlinedConditionProfile notFoundProfile, @Cached InlinedConditionProfile publicProfile, @Cached InlinedConditionProfile privateProfile, @Cached InlinedConditionProfile isVisibleProfile) {
        InternalMethod topMethod;
        CompilerAsserts.partialEvaluationConstant((Object)((Object)config));
        DeclarationContext declarationContext = LookupMethodNode.getDeclarationContext(frame, config);
        ModuleFields fields = metaClass.fields;
        InternalMethod method = noPrependedModulesProfile.profile((Node)this, !fields.hasPrependedModules()) && onMetaClassProfile.profile((Node)this, (topMethod = fields.getMethod(name)) != null) && !hasRefinementsProfile.profile((Node)this, declarationContext != null && declarationContext.hasRefinements()) ? topMethod : ModuleOperations.lookupMethodUncached(metaClass, name, declarationContext);
        if (notFoundProfile.profile((Node)this, method == null || method.isUndefined())) {
            return null;
        }
        if (!config.ignoreVisibility) {
            Visibility visibility = method.getVisibility();
            if (publicProfile.profile((Node)this, visibility == Visibility.PUBLIC)) {
                return method;
            }
            if (config.onlyLookupPublic) {
                return null;
            }
            if (privateProfile.profile((Node)this, visibility == Visibility.PRIVATE)) {
                return null;
            }
            InternalMethod callerMethod = RubyArguments.tryGetMethod(frame);
            RubyClass callerClass = noCallerMethodProfile.profile((Node)this, callerMethod == null) ? this.coreLibrary().objectClass : metaClassNode.execute(this, RubyArguments.getSelf(frame));
            if (!isVisibleProfile.profile((Node)this, method.isProtectedMethodVisibleTo(callerClass))) {
                return null;
            }
        }
        return method;
    }

    protected static MethodLookupResult lookupCached(RubyContext context, Frame callingFrame, RubyClass metaClass, String name, DispatchConfiguration config) {
        CompilerAsserts.neverPartOfCompilation((String)"slow-path method lookup should not be compiled");
        DeclarationContext declarationContext = LookupMethodNode.getDeclarationContext(callingFrame, config);
        MethodLookupResult method = ModuleOperations.lookupMethodCached(metaClass, name, declarationContext);
        if (!method.isDefined()) {
            return method.withNoMethod();
        }
        if (!config.ignoreVisibility) {
            Visibility visibility = method.getMethod().getVisibility();
            if (visibility == Visibility.PUBLIC) {
                return method;
            }
            if (config.onlyLookupPublic) {
                return method.withNoMethod();
            }
            if (visibility == Visibility.PRIVATE) {
                return method.withNoMethod();
            }
            RubyClass callerClass = LookupMethodNode.getCallerClass(context, callingFrame);
            if (!method.getMethod().isProtectedMethodVisibleTo(callerClass)) {
                return method.withNoMethod();
            }
        }
        return method;
    }

    private static DeclarationContext getDeclarationContext(Frame frame, DispatchConfiguration config) {
        return config.ignoreRefinements ? null : RubyArguments.tryGetDeclarationContext(frame);
    }

    private static RubyClass getCallerClass(RubyContext context, Frame callingFrame) {
        InternalMethod callerMethod = RubyArguments.tryGetMethod(callingFrame);
        if (callerMethod == null) {
            return context.getCoreLibrary().objectClass;
        }
        return MetaClassNode.executeUncached(RubyArguments.getSelf(callingFrame));
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.METHOD_LOOKUP_CACHE;
    }
}

