/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.methods.CachedLazyCallTargetSupplier;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.ObjectGraphNode;

public final class InternalMethod
implements ObjectGraphNode {
    private final SharedMethodInfo sharedMethodInfo;
    private final LexicalScope lexicalScope;
    private final DeclarationContext declarationContext;
    private final DeclarationContext activeRefinements;
    private final String name;
    private final RubyModule declaringModule;
    private final RubyModule owner;
    private final Visibility visibility;
    private final boolean undefined;
    private final boolean unimplemented;
    private final boolean builtIn;
    public final NodeFactory<? extends RubyBaseNode> alwaysInlinedNodeFactory;
    private final RubyProc proc;
    private final CachedLazyCallTargetSupplier callTargetSupplier;
    @CompilerDirectives.CompilationFinal
    private RootCallTarget callTarget;

    public static InternalMethod fromProc(RubyContext context, SharedMethodInfo sharedMethodInfo, DeclarationContext declarationContext, String name, RubyModule declaringModule, Visibility visibility, RubyProc proc, RootCallTarget callTarget) {
        return new InternalMethod(context, sharedMethodInfo, proc.declaringMethod.getLexicalScope(), declarationContext, name, declaringModule, visibility, false, null, proc, callTarget, null);
    }

    public InternalMethod(RubyContext context, SharedMethodInfo sharedMethodInfo, LexicalScope lexicalScope, DeclarationContext declarationContext, String name, RubyModule declaringModule, Visibility visibility, RootCallTarget callTarget) {
        this(context, sharedMethodInfo, lexicalScope, declarationContext, name, declaringModule, visibility, false, null, null, callTarget, null);
    }

    public InternalMethod(RubyContext context, SharedMethodInfo sharedMethodInfo, LexicalScope lexicalScope, DeclarationContext declarationContext, String name, RubyModule declaringModule, Visibility visibility, boolean undefined, NodeFactory<? extends RubyBaseNode> alwaysInlined, RubyProc proc, RootCallTarget callTarget, CachedLazyCallTargetSupplier callTargetSupplier) {
        this(sharedMethodInfo, lexicalScope, declarationContext, name, declaringModule, declaringModule, visibility, undefined, false, !context.getCoreLibrary().isLoaded(), alwaysInlined, null, proc, callTarget, callTargetSupplier);
    }

    private InternalMethod(SharedMethodInfo sharedMethodInfo, LexicalScope lexicalScope, DeclarationContext declarationContext, String name, RubyModule declaringModule, RubyModule owner, Visibility visibility, boolean undefined, boolean unimplemented, boolean builtIn, NodeFactory<? extends RubyBaseNode> alwaysInlined, DeclarationContext activeRefinements, RubyProc proc, RootCallTarget callTarget, CachedLazyCallTargetSupplier callTargetSupplier) {
        assert (declaringModule != null);
        assert (lexicalScope != null);
        assert (!sharedMethodInfo.isBlock()) : sharedMethodInfo;
        assert (callTarget == null || RubyRootNode.of(callTarget).getSharedMethodInfo() == sharedMethodInfo);
        this.sharedMethodInfo = sharedMethodInfo;
        this.lexicalScope = lexicalScope;
        this.declarationContext = declarationContext;
        this.declaringModule = declaringModule;
        this.owner = owner;
        this.name = name;
        this.visibility = visibility;
        this.undefined = undefined;
        this.unimplemented = unimplemented;
        this.builtIn = builtIn;
        this.alwaysInlinedNodeFactory = alwaysInlined;
        this.activeRefinements = activeRefinements;
        this.proc = proc;
        this.callTarget = callTarget;
        this.callTargetSupplier = callTargetSupplier;
        if (callTarget == null && callTargetSupplier != null) {
            this.callTarget = callTargetSupplier.getWhenAvailable();
        }
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public RubyModule getDeclaringModule() {
        return this.declaringModule;
    }

    public RubyModule getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.sharedMethodInfo.getOriginalName();
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isDefined() {
        return !this.undefined;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public boolean isImplemented() {
        return !this.unimplemented;
    }

    public boolean isUnimplemented() {
        return this.unimplemented;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    @Idempotent
    public boolean alwaysInlined() {
        return this.alwaysInlinedNodeFactory != null;
    }

    public int getArityNumber() {
        return this.sharedMethodInfo.getArity().getMethodArityNumber();
    }

    public RubyProc getProc() {
        return this.proc;
    }

    public RootCallTarget getCallTarget() {
        if (this.callTarget == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callTarget = this.callTargetSupplier.get();
            assert (RubyRootNode.of(this.callTarget).getSharedMethodInfo() == this.sharedMethodInfo);
        }
        return this.callTarget;
    }

    public InternalMethod withDeclaringModule(RubyModule newDeclaringModule) {
        if (newDeclaringModule == this.declaringModule) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, this.declarationContext, this.name, newDeclaringModule, this.owner, this.visibility, this.undefined, this.unimplemented, this.builtIn, this.alwaysInlinedNodeFactory, this.activeRefinements, this.proc, this.callTarget, this.callTargetSupplier);
    }

    public InternalMethod withOwner(RubyModule newOwner) {
        if (newOwner == this.owner) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, this.declarationContext, this.name, this.declaringModule, newOwner, this.visibility, this.undefined, this.unimplemented, this.builtIn, this.alwaysInlinedNodeFactory, this.activeRefinements, this.proc, this.callTarget, this.callTargetSupplier);
    }

    public InternalMethod withName(String newName) {
        if (newName.equals(this.name)) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, this.declarationContext, newName, this.declaringModule, this.owner, this.visibility, this.undefined, this.unimplemented, this.builtIn, this.alwaysInlinedNodeFactory, this.activeRefinements, this.proc, this.callTarget, this.callTargetSupplier);
    }

    public InternalMethod withVisibility(Visibility newVisibility) {
        if (newVisibility == this.visibility) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, this.declarationContext, this.name, this.declaringModule, this.owner, newVisibility, this.undefined, this.unimplemented, this.builtIn, this.alwaysInlinedNodeFactory, this.activeRefinements, this.proc, this.callTarget, this.callTargetSupplier);
    }

    public InternalMethod withActiveRefinements(DeclarationContext context) {
        if (context == this.activeRefinements) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, this.declarationContext, this.name, this.declaringModule, this.owner, this.visibility, this.undefined, this.unimplemented, this.builtIn, this.alwaysInlinedNodeFactory, context, this.proc, this.callTarget, this.callTargetSupplier);
    }

    public InternalMethod withDeclarationContext(DeclarationContext newDeclarationContext) {
        if (newDeclarationContext == this.declarationContext) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, newDeclarationContext, this.name, this.declaringModule, this.owner, this.visibility, this.undefined, this.unimplemented, this.builtIn, this.alwaysInlinedNodeFactory, this.activeRefinements, this.proc, this.callTarget, this.callTargetSupplier);
    }

    public InternalMethod withCallTargetAndDeclarationContextAndDeclarationModule(RootCallTarget rootCallTarget, DeclarationContext newDeclarationContext, RubyModule newDeclaringModule) {
        if (rootCallTarget == this.callTarget && newDeclarationContext == this.declarationContext && newDeclaringModule == this.declaringModule) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, newDeclarationContext, this.name, newDeclaringModule, this.owner, this.visibility, this.undefined, this.unimplemented, this.builtIn, this.alwaysInlinedNodeFactory, this.activeRefinements, this.proc, rootCallTarget, this.callTargetSupplier);
    }

    public InternalMethod undefined() {
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, this.declarationContext, this.name, this.declaringModule, this.owner, this.visibility, true, this.unimplemented, this.builtIn, this.alwaysInlinedNodeFactory, this.activeRefinements, this.proc, this.callTarget, this.callTargetSupplier);
    }

    public InternalMethod unimplemented() {
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, this.declarationContext, this.name, this.declaringModule, this.owner, this.visibility, this.undefined, true, this.builtIn, this.alwaysInlinedNodeFactory, this.activeRefinements, this.proc, this.callTarget, this.callTargetSupplier);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isProtectedMethodVisibleTo(RubyClass callerClass) {
        assert (this.visibility == Visibility.PROTECTED);
        for (RubyModule ancestor : callerClass.fields.ancestors()) {
            if (ancestor != this.declaringModule && ancestor.getMetaClass() != this.declaringModule) continue;
            return true;
        }
        return false;
    }

    public boolean isPublic() {
        return this.visibility == Visibility.PUBLIC;
    }

    public boolean isPrivate() {
        return this.visibility == Visibility.PRIVATE;
    }

    public boolean isProtected() {
        return this.visibility == Visibility.PROTECTED;
    }

    public String toString() {
        return this.sharedMethodInfo.toString();
    }

    @Override
    public void getAdjacentObjects(Set<Object> adjacent) {
        if (this.declaringModule != null) {
            adjacent.add(this.declaringModule);
        }
        if (this.proc != null) {
            adjacent.add(this.proc);
        }
    }

    public LexicalScope getLexicalScope() {
        return this.lexicalScope;
    }

    public DeclarationContext getDeclarationContext() {
        return this.declarationContext;
    }

    public DeclarationContext getActiveRefinements() {
        return this.activeRefinements;
    }

    public boolean isDefinedInRuby(RubyLanguage language) {
        SourceSection sourceSection = this.sharedMethodInfo.getSourceSection();
        if (!sourceSection.isAvailable()) {
            return false;
        }
        String path = sourceSection.getSource().getPath();
        boolean isCExtension = path != null && path.equals(language.cextPath);
        return !isCExtension;
    }
}

