/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.methods.InternalMethod;

public abstract class CanBindMethodToModuleNode
extends RubyBaseNode {
    public abstract boolean executeCanBindMethodToModule(InternalMethod var1, RubyModule var2);

    @Specialization(guards={"method.getDeclaringModule() == declaringModule", "module == cachedModule"}, limit="getCacheLimit()")
    boolean canBindMethodToCached(InternalMethod method, RubyModule module, @Cached(value="method.getDeclaringModule()") RubyModule declaringModule, @Cached(value="module") RubyModule cachedModule, @Cached(value="canBindMethodTo(method, cachedModule)") boolean canBindMethodTo) {
        return canBindMethodTo;
    }

    @Specialization
    boolean canBindMethodToUncached(InternalMethod method, RubyModule module) {
        return this.canBindMethodTo(method, module);
    }

    protected boolean canBindMethodTo(InternalMethod method, RubyModule module) {
        return ModuleOperations.canBindMethodTo(method, module);
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.BIND_CACHE;
    }
}

