/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.builtins.CoreMethodNodeManager;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyCheckArityRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.LiteralCallNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.CallInternalMethodNodeGen;
import org.truffleruby.language.methods.InternalMethod;

@ReportPolymorphism
@GenerateUncached
@ImportStatic(value={RubyArguments.class})
public abstract class CallInternalMethodNode
extends RubyBaseNode {
    @NeverDefault
    public static CallInternalMethodNode create() {
        return CallInternalMethodNodeGen.create();
    }

    public abstract Object execute(Frame var1, InternalMethod var2, Object var3, Object[] var4, LiteralCallNode var5);

    @Specialization(guards={"isSingleContext()", "method.getCallTarget() == cachedCallTarget", "!cachedMethod.alwaysInlined()"}, assumptions={"getMethodAssumption(cachedMethod)"}, limit="getCacheLimit()")
    Object callCached(InternalMethod method, Object receiver, Object[] rubyArgs, LiteralCallNode literalCallNode, @Cached(value="method.getCallTarget()") RootCallTarget cachedCallTarget, @Cached(value="method") InternalMethod cachedMethod, @Cached(value="createCall(cachedMethod.getName(), cachedCallTarget)") DirectCallNode callNode) {
        if (literalCallNode != null) {
            literalCallNode.copyRuby2KeywordsHash(rubyArgs, cachedMethod.getSharedMethodInfo());
        }
        return callNode.call(RubyArguments.repackForCall(rubyArgs));
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"!method.alwaysInlined()"}, replaces={"callCached"})
    Object callUncached(InternalMethod method, Object receiver, Object[] rubyArgs, LiteralCallNode literalCallNode, @Cached IndirectCallNode indirectCallNode) {
        if (literalCallNode != null) {
            literalCallNode.copyRuby2KeywordsHash(rubyArgs, method.getSharedMethodInfo());
        }
        return indirectCallNode.call((CallTarget)method.getCallTarget(), RubyArguments.repackForCall(rubyArgs));
    }

    @Specialization(guards={"isSingleContext()", "method.getCallTarget() == cachedCallTarget", "cachedMethod.alwaysInlined()"}, assumptions={"getMethodAssumption(cachedMethod)"}, limit="getCacheLimit()")
    static Object alwaysInlined(Frame frame, InternalMethod method, Object receiver, Object[] rubyArgs, LiteralCallNode literalCallNode, @Cached(value="method.getCallTarget()") RootCallTarget cachedCallTarget, @Cached(value="method") InternalMethod cachedMethod, @Cached(value="createAlwaysInlinedMethodNode(cachedMethod)") AlwaysInlinedMethodNode alwaysInlinedNode, @Cached(value="cachedMethod.getSharedMethodInfo().getArity()") Arity cachedArity, @Cached InlinedBranchProfile checkArityProfile, @Cached InlinedBranchProfile exceptionProfile, @Bind(value="this") Node node) {
        assert (!cachedArity.acceptsKeywords()) : "AlwaysInlinedMethodNodes are currently assumed to not use keyword arguments, the arity check depends on this";
        assert (RubyArguments.getSelf(rubyArgs) == receiver);
        if (literalCallNode != null) {
            literalCallNode.copyRuby2KeywordsHash(rubyArgs, cachedMethod.getSharedMethodInfo());
        }
        try {
            int given = RubyArguments.getPositionalArgumentsCount(rubyArgs);
            if (!cachedArity.checkPositionalArguments(given)) {
                checkArityProfile.enter(node);
                throw RubyCheckArityRootNode.checkArityError(cachedArity, given, alwaysInlinedNode);
            }
            return alwaysInlinedNode.execute(frame, receiver, RubyArguments.repackForCall(rubyArgs), cachedCallTarget);
        }
        catch (RaiseException e) {
            exceptionProfile.enter(node);
            return CallInternalMethodNode.alwaysInlinedException(node, e, alwaysInlinedNode, cachedCallTarget);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private static Object alwaysInlinedException(Node node, RaiseException e, AlwaysInlinedMethodNode alwaysInlinedNode, RootCallTarget cachedCallTarget) {
        boolean isErrorFromInlineNode;
        Node location = e.getLocation();
        Node adoptedInlinedNode = CallInternalMethodNode.getAdoptedNode(alwaysInlinedNode);
        boolean bl = isErrorFromInlineNode = location != null && adoptedInlinedNode != null && location.getRootNode() == adoptedInlinedNode.getRootNode();
        if (isErrorFromInlineNode) {
            return RubyContext.indirectCallWithCallNode(node, cachedCallTarget, e);
        }
        throw e;
    }

    @Specialization(guards={"method.alwaysInlined()"}, replaces={"alwaysInlined"})
    Object alwaysInlinedUncached(Frame frame, InternalMethod method, Object receiver, Object[] rubyArgs, LiteralCallNode literalCallNode) {
        return this.alwaysInlinedBoundary(frame == null ? null : frame.materialize(), method, receiver, rubyArgs, literalCallNode, this.isAdoptable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object alwaysInlinedBoundary(MaterializedFrame frame, InternalMethod method, Object receiver, Object[] rubyArgs, LiteralCallNode literalCallNode, boolean cachedToUncached) {
        EncapsulatingNodeReference encapsulating = null;
        Node prev = null;
        if (cachedToUncached) {
            encapsulating = EncapsulatingNodeReference.getCurrent();
            prev = encapsulating.set((Node)this);
        }
        try {
            Object object = CallInternalMethodNode.alwaysInlined((Frame)frame, method, receiver, rubyArgs, literalCallNode, method.getCallTarget(), method, this.getUncachedAlwaysInlinedMethodNode(method), method.getSharedMethodInfo().getArity(), InlinedBranchProfile.getUncached(), InlinedBranchProfile.getUncached(), this);
            return object;
        }
        finally {
            if (cachedToUncached) {
                encapsulating.set(prev);
            }
        }
    }

    protected AlwaysInlinedMethodNode createAlwaysInlinedMethodNode(InternalMethod method) {
        return (AlwaysInlinedMethodNode)CoreMethodNodeManager.createNodeFromFactory(method.alwaysInlinedNodeFactory, RubyNode.EMPTY_ARRAY);
    }

    protected AlwaysInlinedMethodNode getUncachedAlwaysInlinedMethodNode(InternalMethod method) {
        return (AlwaysInlinedMethodNode)((Object)method.alwaysInlinedNodeFactory.getUncachedInstance());
    }

    protected Assumption getMethodAssumption(InternalMethod method) {
        return this.isSingleContext() ? method.getDeclaringModule().fields.getOrCreateMethodAssumption(method.getName()) : Assumption.ALWAYS_VALID;
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.DISPATCH_CACHE;
    }

    protected DirectCallNode createCall(String methodName, RootCallTarget callTarget) {
        DirectCallNode callNode = DirectCallNode.create((CallTarget)callTarget);
        DispatchNode dispatch = (DispatchNode)((Object)NodeUtil.findParent((Node)this, DispatchNode.class));
        if (dispatch != null) {
            dispatch.applySplittingInliningStrategy(callTarget, methodName, callNode);
        }
        return callNode;
    }
}

